// services/network/public/mojom/referrer_policy.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/referrer_policy.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/referrer_policy.mojom-params-data.h"
namespace network {
namespace mojom {

static NOINLINE const char* ReferrerPolicyToStringHelper(ReferrerPolicy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ReferrerPolicy::kAlways:
      return "kAlways";
    case ReferrerPolicy::kDefault:
      return "kDefault";
    case ReferrerPolicy::kNoReferrerWhenDowngrade:
      return "kNoReferrerWhenDowngrade";
    case ReferrerPolicy::kNever:
      return "kNever";
    case ReferrerPolicy::kOrigin:
      return "kOrigin";
    case ReferrerPolicy::kOriginWhenCrossOrigin:
      return "kOriginWhenCrossOrigin";
    case ReferrerPolicy::kStrictOriginWhenCrossOrigin:
      return "kStrictOriginWhenCrossOrigin";
    case ReferrerPolicy::kSameOrigin:
      return "kSameOrigin";
    case ReferrerPolicy::kStrictOrigin:
      return "kStrictOrigin";
    default:
      return nullptr;
  }
}

std::string ReferrerPolicyToString(ReferrerPolicy value) {
  const char *str = ReferrerPolicyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ReferrerPolicy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ReferrerPolicy value) {
  return os << ReferrerPolicyToString(value);
}

static NOINLINE const char* URLRequestReferrerPolicyToStringHelper(URLRequestReferrerPolicy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case URLRequestReferrerPolicy::kClearReferrerOnTransitionFromSecureToInsecure:
      return "kClearReferrerOnTransitionFromSecureToInsecure";
    case URLRequestReferrerPolicy::kReduceReferrerGranularityOnTransitionCrossOrigin:
      return "kReduceReferrerGranularityOnTransitionCrossOrigin";
    case URLRequestReferrerPolicy::kOriginOnlyOnTransitionCrossOrigin:
      return "kOriginOnlyOnTransitionCrossOrigin";
    case URLRequestReferrerPolicy::kNeverClearReferrer:
      return "kNeverClearReferrer";
    case URLRequestReferrerPolicy::kOrigin:
      return "kOrigin";
    case URLRequestReferrerPolicy::kClearReferrerOnTransitionCrossOrigin:
      return "kClearReferrerOnTransitionCrossOrigin";
    case URLRequestReferrerPolicy::kOriginClearOnTransitionFromSecureToInsecure:
      return "kOriginClearOnTransitionFromSecureToInsecure";
    case URLRequestReferrerPolicy::kNoReferrer:
      return "kNoReferrer";
    default:
      return nullptr;
  }
}

std::string URLRequestReferrerPolicyToString(URLRequestReferrerPolicy value) {
  const char *str = URLRequestReferrerPolicyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown URLRequestReferrerPolicy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, URLRequestReferrerPolicy value) {
  return os << URLRequestReferrerPolicyToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ReferrerPolicy>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ReferrerPolicy value) {
  return std::move(context).WriteString(::network::mojom::ReferrerPolicyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::URLRequestReferrerPolicy>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::URLRequestReferrerPolicy value) {
  return std::move(context).WriteString(::network::mojom::URLRequestReferrerPolicyToString(value));
}

} // namespace perfetto
