// services/network/public/mojom/restricted_cookie_manager.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/network/public/mojom/restricted_cookie_manager.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "services/network/public/mojom/cookie_manager.mojom.h"
#include "services/network/public/mojom/site_for_cookies.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include "url/mojom/origin.mojom.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_JUMBO_H_
#endif


namespace network {
namespace mojom {


void RestrictedCookieManagerInterceptorForTesting::GetAllForUrl(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, CookieManagerGetOptionsPtr options, GetAllForUrlCallback callback) {
  GetForwardingInterface()->GetAllForUrl(std::move(url), std::move(site_for_cookies), std::move(top_frame_origin), std::move(options), std::move(callback));
}
void RestrictedCookieManagerInterceptorForTesting::SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, SetCanonicalCookieCallback callback) {
  GetForwardingInterface()->SetCanonicalCookie(std::move(cookie), std::move(url), std::move(site_for_cookies), std::move(top_frame_origin), std::move(callback));
}
void RestrictedCookieManagerInterceptorForTesting::AddChangeListener(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::mojo::PendingRemote<::network::mojom::CookieChangeListener> listener, AddChangeListenerCallback callback) {
  GetForwardingInterface()->AddChangeListener(std::move(url), std::move(site_for_cookies), std::move(top_frame_origin), std::move(listener), std::move(callback));
}
void RestrictedCookieManagerInterceptorForTesting::SetCookieFromString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, const std::string& cookie, SetCookieFromStringCallback callback) {
  GetForwardingInterface()->SetCookieFromString(std::move(url), std::move(site_for_cookies), std::move(top_frame_origin), std::move(cookie), std::move(callback));
}
void RestrictedCookieManagerInterceptorForTesting::GetCookiesString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, GetCookiesStringCallback callback) {
  GetForwardingInterface()->GetCookiesString(std::move(url), std::move(site_for_cookies), std::move(top_frame_origin), std::move(callback));
}
void RestrictedCookieManagerInterceptorForTesting::CookiesEnabledFor(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, CookiesEnabledForCallback callback) {
  GetForwardingInterface()->CookiesEnabledFor(std::move(url), std::move(site_for_cookies), std::move(top_frame_origin), std::move(callback));
}
RestrictedCookieManagerAsyncWaiter::RestrictedCookieManagerAsyncWaiter(
    RestrictedCookieManager* proxy) : proxy_(proxy) {}

RestrictedCookieManagerAsyncWaiter::~RestrictedCookieManagerAsyncWaiter() = default;

void RestrictedCookieManagerAsyncWaiter::GetAllForUrl(
    const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, CookieManagerGetOptionsPtr options, std::vector<::net::CookieWithAccessResult>* out_cookies) {
  base::RunLoop loop;
  proxy_->GetAllForUrl(std::move(url),std::move(site_for_cookies),std::move(top_frame_origin),std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::net::CookieWithAccessResult>* out_cookies
,
             const std::vector<::net::CookieWithAccessResult>& cookies) {*out_cookies = std::move(cookies);
            loop->Quit();
          },
          &loop,
          out_cookies));
  loop.Run();
}
void RestrictedCookieManagerAsyncWaiter::SetCanonicalCookie(
    const ::net::CanonicalCookie& cookie, const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetCanonicalCookie(std::move(cookie),std::move(url),std::move(site_for_cookies),std::move(top_frame_origin),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void RestrictedCookieManagerAsyncWaiter::AddChangeListener(
    const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::mojo::PendingRemote<::network::mojom::CookieChangeListener> listener) {
  base::RunLoop loop;
  proxy_->AddChangeListener(std::move(url),std::move(site_for_cookies),std::move(top_frame_origin),std::move(listener),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void RestrictedCookieManagerAsyncWaiter::SetCookieFromString(
    const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, const std::string& cookie) {
  base::RunLoop loop;
  proxy_->SetCookieFromString(std::move(url),std::move(site_for_cookies),std::move(top_frame_origin),std::move(cookie),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void RestrictedCookieManagerAsyncWaiter::GetCookiesString(
    const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, std::string* out_cookies) {
  base::RunLoop loop;
  proxy_->GetCookiesString(std::move(url),std::move(site_for_cookies),std::move(top_frame_origin),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_cookies
,
             const std::string& cookies) {*out_cookies = std::move(cookies);
            loop->Quit();
          },
          &loop,
          out_cookies));
  loop.Run();
}
void RestrictedCookieManagerAsyncWaiter::CookiesEnabledFor(
    const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, bool* out_cookies_enabled) {
  base::RunLoop loop;
  proxy_->CookiesEnabledFor(std::move(url),std::move(site_for_cookies),std::move(top_frame_origin),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_cookies_enabled
,
             bool cookies_enabled) {*out_cookies_enabled = std::move(cookies_enabled);
            loop->Quit();
          },
          &loop,
          out_cookies_enabled));
  loop.Run();
}





}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif