// services/network/public/mojom/site_for_cookies.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/site_for_cookies.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/site_for_cookies.mojom-params-data.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared-message-ids.h"

#include "services/network/public/mojom/site_for_cookies.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SITE_FOR_COOKIES_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SITE_FOR_COOKIES_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
SiteForCookies::SiteForCookies()
    : site(),
      schemefully_same(),
      first_party_url() {}

SiteForCookies::SiteForCookies(
    const ::net::SchemefulSite& site_in,
    bool schemefully_same_in,
    const std::string& first_party_url_in)
    : site(std::move(site_in)),
      schemefully_same(std::move(schemefully_same_in)),
      first_party_url(std::move(first_party_url_in)) {}

SiteForCookies::~SiteForCookies() = default;

void SiteForCookies::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site"), this->site,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::SchemefulSite&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "schemefully_same"), this->schemefully_same,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_party_url"), this->first_party_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SiteForCookies::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::SiteForCookies::DataView, ::network::mojom::SiteForCookiesPtr>::Read(
    ::network::mojom::SiteForCookies::DataView input,
    ::network::mojom::SiteForCookiesPtr* output) {
  bool success = true;
  ::network::mojom::SiteForCookiesPtr result(::network::mojom::SiteForCookies::New());
  
      if (success && !input.ReadSite(&result->site))
        success = false;
      if (success)
        result->schemefully_same = input.schemefully_same();
      if (success && !input.ReadFirstPartyUrl(&result->first_party_url))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif