// services/network/public/mojom/ssl_config.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/ssl_config.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/ssl_config.mojom-params-data.h"
#include "services/network/public/mojom/ssl_config.mojom-shared-message-ids.h"

#include "services/network/public/mojom/ssl_config.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
SSLConfig::SSLConfig()
    : rev_checking_enabled(false),
      rev_checking_required_local_anchors(false),
      sha1_local_anchors_enabled(false),
      symantec_enforcement_disabled(false),
      version_min(SSLVersion::kTLS1),
      version_min_warn(SSLVersion::kTLS12),
      version_max(SSLVersion::kTLS13),
      disabled_cipher_suites(),
      client_cert_pooling_policy(),
      cecpq2_enabled(true),
      triple_des_enabled(true) {}

SSLConfig::SSLConfig(
    bool rev_checking_enabled_in,
    bool rev_checking_required_local_anchors_in,
    bool sha1_local_anchors_enabled_in,
    bool symantec_enforcement_disabled_in,
    SSLVersion version_min_in,
    SSLVersion version_min_warn_in,
    SSLVersion version_max_in,
    std::vector<uint16_t> disabled_cipher_suites_in,
    std::vector<std::string> client_cert_pooling_policy_in,
    bool cecpq2_enabled_in,
    bool triple_des_enabled_in)
    : rev_checking_enabled(std::move(rev_checking_enabled_in)),
      rev_checking_required_local_anchors(std::move(rev_checking_required_local_anchors_in)),
      sha1_local_anchors_enabled(std::move(sha1_local_anchors_enabled_in)),
      symantec_enforcement_disabled(std::move(symantec_enforcement_disabled_in)),
      version_min(std::move(version_min_in)),
      version_min_warn(std::move(version_min_warn_in)),
      version_max(std::move(version_max_in)),
      disabled_cipher_suites(std::move(disabled_cipher_suites_in)),
      client_cert_pooling_policy(std::move(client_cert_pooling_policy_in)),
      cecpq2_enabled(std::move(cecpq2_enabled_in)),
      triple_des_enabled(std::move(triple_des_enabled_in)) {}

SSLConfig::~SSLConfig() = default;

void SSLConfig::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rev_checking_enabled"), this->rev_checking_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rev_checking_required_local_anchors"), this->rev_checking_required_local_anchors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sha1_local_anchors_enabled"), this->sha1_local_anchors_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "symantec_enforcement_disabled"), this->symantec_enforcement_disabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_min"), this->version_min,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SSLVersion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_min_warn"), this->version_min_warn,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SSLVersion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_max"), this->version_max,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SSLVersion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disabled_cipher_suites"), this->disabled_cipher_suites,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_cert_pooling_policy"), this->client_cert_pooling_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cecpq2_enabled"), this->cecpq2_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "triple_des_enabled"), this->triple_des_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SSLConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SSLConfigClient::Name_[] = "network.mojom.SSLConfigClient";

SSLConfigClientProxy::SSLConfigClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SSLConfigClientProxy::OnSSLConfigUpdated(
    SSLConfigPtr in_ssl_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::SSLConfigClient::OnSSLConfigUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ssl_config"), in_ssl_config,
                        "<value of type SSLConfigPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSSLConfigClient_OnSSLConfigUpdated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SSLConfigClient_OnSSLConfigUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ssl_config)::BaseType> ssl_config_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SSLConfigDataView>(
      in_ssl_config, ssl_config_fragment);
  params->ssl_config.Set(
      ssl_config_fragment.is_null() ? nullptr : ssl_config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ssl_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ssl_config in SSLConfigClient.OnSSLConfigUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SSLConfigClient::Name_);
  message.set_method_name("OnSSLConfigUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SSLConfigClientStubDispatch::Accept(
    SSLConfigClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSSLConfigClient_OnSSLConfigUpdated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::SSLConfigClient::OnSSLConfigUpdated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::SSLConfigClient::OnSSLConfigUpdated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SSLConfigClient_OnSSLConfigUpdated_Params_Data* params =
          reinterpret_cast<internal::SSLConfigClient_OnSSLConfigUpdated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SSLConfigPtr p_ssl_config{};
      SSLConfigClient_OnSSLConfigUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSslConfig(&p_ssl_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SSLConfigClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSSLConfigUpdated(
std::move(p_ssl_config));
      return true;
    }
  }
  return false;
}

// static
bool SSLConfigClientStubDispatch::AcceptWithResponder(
    SSLConfigClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSSLConfigClient_OnSSLConfigUpdated_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSSLConfigClientValidationInfo[] = {
    {internal::kSSLConfigClient_OnSSLConfigUpdated_Name,
     {&internal::SSLConfigClient_OnSSLConfigUpdated_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SSLConfigClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::SSLConfigClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSSLConfigClientValidationInfo);
}

}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::SSLConfig::DataView, ::network::mojom::SSLConfigPtr>::Read(
    ::network::mojom::SSLConfig::DataView input,
    ::network::mojom::SSLConfigPtr* output) {
  bool success = true;
  ::network::mojom::SSLConfigPtr result(::network::mojom::SSLConfig::New());
  
      if (success)
        result->rev_checking_enabled = input.rev_checking_enabled();
      if (success)
        result->rev_checking_required_local_anchors = input.rev_checking_required_local_anchors();
      if (success)
        result->sha1_local_anchors_enabled = input.sha1_local_anchors_enabled();
      if (success)
        result->symantec_enforcement_disabled = input.symantec_enforcement_disabled();
      if (success && !input.ReadVersionMin(&result->version_min))
        success = false;
      if (success && !input.ReadVersionMinWarn(&result->version_min_warn))
        success = false;
      if (success && !input.ReadVersionMax(&result->version_max))
        success = false;
      if (success && !input.ReadDisabledCipherSuites(&result->disabled_cipher_suites))
        success = false;
      if (success && !input.ReadClientCertPoolingPolicy(&result->client_cert_pooling_policy))
        success = false;
      if (success)
        result->cecpq2_enabled = input.cecpq2_enabled();
      if (success)
        result->triple_des_enabled = input.triple_des_enabled();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif