// services/network/public/mojom/timing_allow_origin.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/timing_allow_origin.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/timing_allow_origin.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {
// static
bool TimingAllowOrigin_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TimingAllowOrigin_Data* object = static_cast<const TimingAllowOrigin_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TimingAllowOrigin_Tag::SERIALIZED_ORIGINS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_serialized_origins, 1, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams serialized_origins_validate_params(
          0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
      if (!mojo::internal::ValidateContainer(object->data.f_serialized_origins, validation_context,
                                             &serialized_origins_validate_params)) {
        return false;
      }
      return true;
    }
    case TimingAllowOrigin_Tag::ALL: {

      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TimingAllowOrigin");
      return false;
    }
  }
}

}  // namespace internal
}  // namespace mojom
}  // namespace network
