// services/network/public/mojom/tls_socket.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/tls_socket.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/tls_socket.mojom-params-data.h"
#include "services/network/public/mojom/tls_socket.mojom-shared-message-ids.h"

#include "services/network/public/mojom/tls_socket.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TLS_SOCKET_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TLS_SOCKET_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
TLSClientSocketOptions::TLSClientSocketOptions()
    : version_min(::network::mojom::blink::SSLVersion::kTLS1),
      version_max(::network::mojom::blink::SSLVersion::kTLS13),
      send_ssl_info(false),
      unsafely_skip_cert_verification(false) {}

TLSClientSocketOptions::TLSClientSocketOptions(
    ::network::mojom::blink::SSLVersion version_min_in,
    ::network::mojom::blink::SSLVersion version_max_in,
    bool send_ssl_info_in,
    bool unsafely_skip_cert_verification_in)
    : version_min(std::move(version_min_in)),
      version_max(std::move(version_max_in)),
      send_ssl_info(std::move(send_ssl_info_in)),
      unsafely_skip_cert_verification(std::move(unsafely_skip_cert_verification_in)) {}

TLSClientSocketOptions::~TLSClientSocketOptions() = default;
size_t TLSClientSocketOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->version_min);
  seed = mojo::internal::WTFHash(seed, this->version_max);
  seed = mojo::internal::WTFHash(seed, this->send_ssl_info);
  seed = mojo::internal::WTFHash(seed, this->unsafely_skip_cert_verification);
  return seed;
}

void TLSClientSocketOptions::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_min"), this->version_min,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::SSLVersion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_max"), this->version_max,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::SSLVersion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_ssl_info"), this->send_ssl_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unsafely_skip_cert_verification"), this->unsafely_skip_cert_verification,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TLSClientSocketOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char TLSClientSocket::Name_[] = "network.mojom.TLSClientSocket";

TLSClientSocketProxy::TLSClientSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool TLSClientSocketStubDispatch::Accept(
    TLSClientSocket* impl,
    mojo::Message* message) {
  return false;
}

// static
bool TLSClientSocketStubDispatch::AcceptWithResponder(
    TLSClientSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}



bool TLSClientSocketRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::TLSClientSocket::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}

}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::TLSClientSocketOptions::DataView, ::network::mojom::blink::TLSClientSocketOptionsPtr>::Read(
    ::network::mojom::blink::TLSClientSocketOptions::DataView input,
    ::network::mojom::blink::TLSClientSocketOptionsPtr* output) {
  bool success = true;
  ::network::mojom::blink::TLSClientSocketOptionsPtr result(::network::mojom::blink::TLSClientSocketOptions::New());
  
      if (success && !input.ReadVersionMin(&result->version_min))
        success = false;
      if (success && !input.ReadVersionMax(&result->version_max))
        success = false;
      if (success)
        result->send_ssl_info = input.send_ssl_info();
      if (success)
        result->unsafely_skip_cert_verification = input.unsafely_skip_cert_verification();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif