// services/network/public/mojom/url_loader_network_service_observer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/url_loader_network_service_observer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/url_loader_network_service_observer.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {


// static
bool LoadInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LoadInfo_Data* object = static_cast<const LoadInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams host_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state_param, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state_param, validation_context))
    return false;

  return true;
}

LoadInfo_Data::LoadInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClientCertificateResponder_ContinueWithCertificate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ClientCertificateResponder_ContinueWithCertificate_Params_Data* object = static_cast<const ClientCertificateResponder_ContinueWithCertificate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->x509_certificate, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->x509_certificate, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->provider_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams provider_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->provider_name, validation_context,
                                         &provider_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->algorithm_preferences, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams algorithm_preferences_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->algorithm_preferences, validation_context,
                                         &algorithm_preferences_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->ssl_private_key, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->ssl_private_key,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ClientCertificateResponder_ContinueWithCertificate_Params_Data::ClientCertificateResponder_ContinueWithCertificate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClientCertificateResponder_ContinueWithoutCertificate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ClientCertificateResponder_ContinueWithoutCertificate_Params_Data* object = static_cast<const ClientCertificateResponder_ContinueWithoutCertificate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ClientCertificateResponder_ContinueWithoutCertificate_Params_Data::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClientCertificateResponder_CancelRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ClientCertificateResponder_CancelRequest_Params_Data* object = static_cast<const ClientCertificateResponder_CancelRequest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ClientCertificateResponder_CancelRequest_Params_Data::ClientCertificateResponder_CancelRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SSLPrivateKey_Sign_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SSLPrivateKey_Sign_Params_Data* object = static_cast<const SSLPrivateKey_Sign_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams input_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->input, validation_context,
                                         &input_validate_params)) {
    return false;
  }

  return true;
}

SSLPrivateKey_Sign_Params_Data::SSLPrivateKey_Sign_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SSLPrivateKey_Sign_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SSLPrivateKey_Sign_ResponseParams_Data* object = static_cast<const SSLPrivateKey_Sign_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams signature_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->signature, validation_context,
                                         &signature_validate_params)) {
    return false;
  }

  return true;
}

SSLPrivateKey_Sign_ResponseParams_Data::SSLPrivateKey_Sign_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuthChallengeResponder_OnAuthCredentials_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AuthChallengeResponder_OnAuthCredentials_Params_Data* object = static_cast<const AuthChallengeResponder_OnAuthCredentials_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->credentials, validation_context))
    return false;

  return true;
}

AuthChallengeResponder_OnAuthCredentials_Params_Data::AuthChallengeResponder_OnAuthCredentials_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data* object = static_cast<const URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ssl_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ssl_info, validation_context))
    return false;

  return true;
}

URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data::URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data* object = static_cast<const URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data::URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data* object = static_cast<const URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->window_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cert_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cert_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->cert_responder, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->cert_responder,
                                                 validation_context)) {
    return false;
  }

  return true;
}

URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data::URLLoaderNetworkServiceObserver_OnCertificateRequested_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data* object = static_cast<const URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->window_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->auth_info, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->auth_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->head_headers, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->auth_challenge_responder, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->auth_challenge_responder,
                                                 validation_context)) {
    return false;
  }

  return true;
}

URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data::URLLoaderNetworkServiceObserver_OnAuthRequired_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data* object = static_cast<const URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->header_value, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams header_value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->header_value, validation_context,
                                         &header_value_validate_params)) {
    return false;
  }

  return true;
}

URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data::URLLoaderNetworkServiceObserver_OnClearSiteData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data* object = static_cast<const URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data::URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data* object = static_cast<const URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data* object = static_cast<const URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data::URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data* object = static_cast<const URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data::URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderNetworkServiceObserver_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLLoaderNetworkServiceObserver_Clone_Params_Data* object = static_cast<const URLLoaderNetworkServiceObserver_Clone_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

URLLoaderNetworkServiceObserver_Clone_Params_Data::URLLoaderNetworkServiceObserver_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network
