// services/network/public/mojom/web_client_hints_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/web_client_hints_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/web_client_hints_types.mojom-params-data.h"
namespace network {
namespace mojom {

static NOINLINE const char* WebClientHintsTypeToStringHelper(WebClientHintsType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebClientHintsType::kDeviceMemory:
      return "kDeviceMemory";
    case WebClientHintsType::kDpr:
      return "kDpr";
    case WebClientHintsType::kResourceWidth:
      return "kResourceWidth";
    case WebClientHintsType::kViewportWidth:
      return "kViewportWidth";
    case WebClientHintsType::kRtt:
      return "kRtt";
    case WebClientHintsType::kDownlink:
      return "kDownlink";
    case WebClientHintsType::kEct:
      return "kEct";
    case WebClientHintsType::kLang:
      return "kLang";
    case WebClientHintsType::kUA:
      return "kUA";
    case WebClientHintsType::kUAArch:
      return "kUAArch";
    case WebClientHintsType::kUAPlatform:
      return "kUAPlatform";
    case WebClientHintsType::kUAModel:
      return "kUAModel";
    case WebClientHintsType::kUAMobile:
      return "kUAMobile";
    case WebClientHintsType::kUAFullVersion:
      return "kUAFullVersion";
    case WebClientHintsType::kUAPlatformVersion:
      return "kUAPlatformVersion";
    case WebClientHintsType::kPrefersColorScheme:
      return "kPrefersColorScheme";
    case WebClientHintsType::kUABitness:
      return "kUABitness";
    case WebClientHintsType::kUAReduced:
      return "kUAReduced";
    default:
      return nullptr;
  }
}

std::string WebClientHintsTypeToString(WebClientHintsType value) {
  const char *str = WebClientHintsTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebClientHintsType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebClientHintsType value) {
  return os << WebClientHintsTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::WebClientHintsType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::WebClientHintsType value) {
  return std::move(context).WriteString(::network::mojom::WebClientHintsTypeToString(value));
}

} // namespace perfetto
