// services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-params-data.h"
namespace proxy_resolver {
namespace mojom {

static NOINLINE const char* HostResolveOperationToStringHelper(HostResolveOperation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HostResolveOperation::DNS_RESOLVE:
      return "DNS_RESOLVE";
    case HostResolveOperation::DNS_RESOLVE_EX:
      return "DNS_RESOLVE_EX";
    case HostResolveOperation::MY_IP_ADDRESS:
      return "MY_IP_ADDRESS";
    case HostResolveOperation::MY_IP_ADDRESS_EX:
      return "MY_IP_ADDRESS_EX";
    default:
      return nullptr;
  }
}

std::string HostResolveOperationToString(HostResolveOperation value) {
  const char *str = HostResolveOperationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HostResolveOperation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HostResolveOperation value) {
  return os << HostResolveOperationToString(value);
}

static NOINLINE const char* ProxySchemeToStringHelper(ProxyScheme value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ProxyScheme::INVALID:
      return "INVALID";
    case ProxyScheme::DIRECT:
      return "DIRECT";
    case ProxyScheme::HTTP:
      return "HTTP";
    case ProxyScheme::SOCKS4:
      return "SOCKS4";
    case ProxyScheme::SOCKS5:
      return "SOCKS5";
    case ProxyScheme::HTTPS:
      return "HTTPS";
    case ProxyScheme::QUIC:
      return "QUIC";
    default:
      return nullptr;
  }
}

std::string ProxySchemeToString(ProxyScheme value) {
  const char *str = ProxySchemeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ProxyScheme value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ProxyScheme value) {
  return os << ProxySchemeToString(value);
}

namespace internal {


// static
bool ProxyServer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProxyServer_Data* object = static_cast<const ProxyServer_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::proxy_resolver::mojom::internal::ProxyScheme_Data
        ::Validate(object->scheme, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams host_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  return true;
}

ProxyServer_Data::ProxyServer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProxyInfo_Data* object = static_cast<const ProxyInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->proxy_servers, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams proxy_servers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->proxy_servers, validation_context,
                                         &proxy_servers_validate_params)) {
    return false;
  }

  return true;
}

ProxyInfo_Data::ProxyInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HostResolverRequestClient_ReportResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HostResolverRequestClient_ReportResult_Params_Data* object = static_cast<const HostResolverRequestClient_ReportResult_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams result_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->result, validation_context,
                                         &result_validate_params)) {
    return false;
  }

  return true;
}

HostResolverRequestClient_ReportResult_Params_Data::HostResolverRequestClient_ReportResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyResolver_GetProxyForUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProxyResolver_GetProxyForUrl_Params_Data* object = static_cast<const ProxyResolver_GetProxyForUrl_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->network_isolation_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->network_isolation_key, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ProxyResolver_GetProxyForUrl_Params_Data::ProxyResolver_GetProxyForUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyResolverRequestClient_ReportResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProxyResolverRequestClient_ReportResult_Params_Data* object = static_cast<const ProxyResolverRequestClient_ReportResult_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->proxy_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->proxy_info, validation_context))
    return false;

  return true;
}

ProxyResolverRequestClient_ReportResult_Params_Data::ProxyResolverRequestClient_ReportResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyResolverRequestClient_Alert_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProxyResolverRequestClient_Alert_Params_Data* object = static_cast<const ProxyResolverRequestClient_Alert_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams error_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  return true;
}

ProxyResolverRequestClient_Alert_Params_Data::ProxyResolverRequestClient_Alert_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyResolverRequestClient_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProxyResolverRequestClient_OnError_Params_Data* object = static_cast<const ProxyResolverRequestClient_OnError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams error_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  return true;
}

ProxyResolverRequestClient_OnError_Params_Data::ProxyResolverRequestClient_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyResolverRequestClient_ResolveDns_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProxyResolverRequestClient_ResolveDns_Params_Data* object = static_cast<const ProxyResolverRequestClient_ResolveDns_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams host_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }


  if (!::proxy_resolver::mojom::internal::HostResolveOperation_Data
        ::Validate(object->operation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->network_isolation_key, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->network_isolation_key, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ProxyResolverRequestClient_ResolveDns_Params_Data::ProxyResolverRequestClient_ResolveDns_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyResolverFactory_CreateResolver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProxyResolverFactory_CreateResolver_Params_Data* object = static_cast<const ProxyResolverFactory_CreateResolver_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pac_script, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams pac_script_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->pac_script, validation_context,
                                         &pac_script_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ProxyResolverFactory_CreateResolver_Params_Data::ProxyResolverFactory_CreateResolver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyResolverFactoryRequestClient_ReportResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProxyResolverFactoryRequestClient_ReportResult_Params_Data* object = static_cast<const ProxyResolverFactoryRequestClient_ReportResult_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProxyResolverFactoryRequestClient_ReportResult_Params_Data::ProxyResolverFactoryRequestClient_ReportResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyResolverFactoryRequestClient_Alert_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProxyResolverFactoryRequestClient_Alert_Params_Data* object = static_cast<const ProxyResolverFactoryRequestClient_Alert_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams error_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  return true;
}

ProxyResolverFactoryRequestClient_Alert_Params_Data::ProxyResolverFactoryRequestClient_Alert_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyResolverFactoryRequestClient_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProxyResolverFactoryRequestClient_OnError_Params_Data* object = static_cast<const ProxyResolverFactoryRequestClient_OnError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams error_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  return true;
}

ProxyResolverFactoryRequestClient_OnError_Params_Data::ProxyResolverFactoryRequestClient_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyResolverFactoryRequestClient_ResolveDns_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProxyResolverFactoryRequestClient_ResolveDns_Params_Data* object = static_cast<const ProxyResolverFactoryRequestClient_ResolveDns_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams host_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }


  if (!::proxy_resolver::mojom::internal::HostResolveOperation_Data
        ::Validate(object->operation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->network_isolation_key, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->network_isolation_key, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ProxyResolverFactoryRequestClient_ResolveDns_Params_Data::ProxyResolverFactoryRequestClient_ResolveDns_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace proxy_resolver

namespace perfetto {

// static
void TraceFormatTraits<::proxy_resolver::mojom::HostResolveOperation>::WriteIntoTrace(
   perfetto::TracedValue context, ::proxy_resolver::mojom::HostResolveOperation value) {
  return std::move(context).WriteString(::proxy_resolver::mojom::HostResolveOperationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::proxy_resolver::mojom::ProxyScheme>::WriteIntoTrace(
   perfetto::TracedValue context, ::proxy_resolver::mojom::ProxyScheme value) {
  return std::move(context).WriteString(::proxy_resolver::mojom::ProxySchemeToString(value));
}

} // namespace perfetto
