// services/service_manager/public/mojom/connector.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/service_manager/public/mojom/connector.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/service_manager/public/mojom/connector.mojom-params-data.h"
#include "services/service_manager/public/mojom/connector.mojom-shared-message-ids.h"

#include "services/service_manager/public/mojom/connector.mojom-import-headers.h"


#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_CONNECTOR_MOJOM_JUMBO_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_CONNECTOR_MOJOM_JUMBO_H_
#endif
namespace service_manager {
namespace mojom {
Identity::Identity()
    : name(),
      instance_group(),
      instance_id(),
      globally_unique_id() {}

Identity::Identity(
    const std::string& name_in,
    const ::base::Token& instance_group_in,
    const ::base::Token& instance_id_in,
    const ::base::Token& globally_unique_id_in)
    : name(std::move(name_in)),
      instance_group(std::move(instance_group_in)),
      instance_id(std::move(instance_id_in)),
      globally_unique_id(std::move(globally_unique_id_in)) {}

Identity::~Identity() = default;

void Identity::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instance_group"), this->instance_group,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Token&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instance_id"), this->instance_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Token&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "globally_unique_id"), this->globally_unique_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Token&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Identity::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceInfo::ServiceInfo()
    : sandbox_type() {}

ServiceInfo::ServiceInfo(
    const std::string& sandbox_type_in)
    : sandbox_type(std::move(sandbox_type_in)) {}

ServiceInfo::~ServiceInfo() = default;
size_t ServiceInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->sandbox_type);
  return seed;
}

void ServiceInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sandbox_type"), this->sandbox_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ProcessMetadata::Name_[] = "service_manager.mojom.ProcessMetadata";

ProcessMetadataProxy::ProcessMetadataProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProcessMetadataProxy::SetPID(
    ::base::ProcessId in_pid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "service_manager::mojom::ProcessMetadata::SetPID", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pid"), in_pid,
                        "<value of type ::base::ProcessId>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProcessMetadata_SetPID_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::ProcessMetadata_SetPID_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pid)::BaseType> pid_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
      in_pid, pid_fragment);
  params->pid.Set(
      pid_fragment.is_null() ? nullptr : pid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->pid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pid in ProcessMetadata.SetPID request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessMetadata::Name_);
  message.set_method_name("SetPID");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ProcessMetadataStubDispatch::Accept(
    ProcessMetadata* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kProcessMetadata_SetPID_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)service_manager::mojom::ProcessMetadata::SetPID",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)service_manager::mojom::ProcessMetadata::SetPID");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProcessMetadata_SetPID_Params_Data* params =
          reinterpret_cast<internal::ProcessMetadata_SetPID_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::ProcessId p_pid{};
      ProcessMetadata_SetPID_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPid(&p_pid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessMetadata::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPID(
std::move(p_pid));
      return true;
    }
  }
  return false;
}

// static
bool ProcessMetadataStubDispatch::AcceptWithResponder(
    ProcessMetadata* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kProcessMetadata_SetPID_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProcessMetadataValidationInfo[] = {
    {internal::kProcessMetadata_SetPID_Name,
     {&internal::ProcessMetadata_SetPID_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProcessMetadataRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::service_manager::mojom::ProcessMetadata::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProcessMetadataValidationInfo);
}

const char Connector::Name_[] = "service_manager.mojom.Connector";

class Connector_BindInterface_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Connector_BindInterface_ForwardToCallback(
      Connector::BindInterfaceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Connector::BindInterfaceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Connector_BindInterface_ForwardToCallback);
};

class Connector_QueryService_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Connector_QueryService_ForwardToCallback(
      Connector::QueryServiceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Connector::QueryServiceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Connector_QueryService_ForwardToCallback);
};

class Connector_WarmService_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Connector_WarmService_ForwardToCallback(
      Connector::WarmServiceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Connector::WarmServiceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Connector_WarmService_ForwardToCallback);
};

class Connector_RegisterServiceInstance_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Connector_RegisterServiceInstance_ForwardToCallback(
      Connector::RegisterServiceInstanceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Connector::RegisterServiceInstanceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Connector_RegisterServiceInstance_ForwardToCallback);
};

ConnectorProxy::ConnectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ConnectorProxy::BindInterface(
    const ::service_manager::ServiceFilter& in_filter, const std::string& in_interface_name, ::mojo::ScopedMessagePipeHandle in_interface_pipe, BindInterfacePriority in_priority, BindInterfaceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "service_manager::mojom::Connector::BindInterface", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type const ::service_manager::ServiceFilter&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_name"), in_interface_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_pipe"), in_interface_pipe,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type BindInterfacePriority>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kConnector_BindInterface_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_BindInterface_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  mojo::internal::Serialize<::service_manager::mojom::ServiceFilterDataView>(
      in_filter, filter_fragment);
  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->filter.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filter in Connector.BindInterface request");
  mojo::internal::MessageFragment<
      typename decltype(params->interface_name)::BaseType> interface_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_interface_name, interface_name_fragment);
  params->interface_name.Set(
      interface_name_fragment.is_null() ? nullptr : interface_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->interface_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null interface_name in Connector.BindInterface request");
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
      in_interface_pipe, &params->interface_pipe, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->interface_pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid interface_pipe in Connector.BindInterface request");
  mojo::internal::Serialize<::service_manager::mojom::BindInterfacePriority>(
      in_priority, &params->priority);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("BindInterface");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Connector_BindInterface_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ConnectorProxy::QueryService(
    const std::string& in_service_name, QueryServiceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "service_manager::mojom::Connector::QueryService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_name"), in_service_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kConnector_QueryService_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_QueryService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_name)::BaseType> service_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_service_name, service_name_fragment);
  params->service_name.Set(
      service_name_fragment.is_null() ? nullptr : service_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->service_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null service_name in Connector.QueryService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("QueryService");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Connector_QueryService_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ConnectorProxy::WarmService(
    const ::service_manager::ServiceFilter& in_filter, WarmServiceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "service_manager::mojom::Connector::WarmService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type const ::service_manager::ServiceFilter&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kConnector_WarmService_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_WarmService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  mojo::internal::Serialize<::service_manager::mojom::ServiceFilterDataView>(
      in_filter, filter_fragment);
  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->filter.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filter in Connector.WarmService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("WarmService");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Connector_WarmService_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ConnectorProxy::RegisterServiceInstance(
    const ::service_manager::Identity& in_identity, ::mojo::ScopedMessagePipeHandle in_service, ::mojo::PendingReceiver<ProcessMetadata> in_metadata_receiver, RegisterServiceInstanceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "service_manager::mojom::Connector::RegisterServiceInstance", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identity"), in_identity,
                        "<value of type const ::service_manager::Identity&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service"), in_service,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata_receiver"), in_metadata_receiver,
                        "<value of type ::mojo::PendingReceiver<ProcessMetadata>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kConnector_RegisterServiceInstance_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_RegisterServiceInstance_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->identity)::BaseType> identity_fragment(
          params.message());
  mojo::internal::Serialize<::service_manager::mojom::IdentityDataView>(
      in_identity, identity_fragment);
  params->identity.Set(
      identity_fragment.is_null() ? nullptr : identity_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->identity.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null identity in Connector.RegisterServiceInstance request");
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
      in_service, &params->service, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->service),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid service in Connector.RegisterServiceInstance request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::service_manager::mojom::ProcessMetadataInterfaceBase>>(
      in_metadata_receiver, &params->metadata_receiver, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("RegisterServiceInstance");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Connector_RegisterServiceInstance_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ConnectorProxy::Clone(
    ::mojo::PendingReceiver<Connector> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "service_manager::mojom::Connector::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<Connector>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kConnector_Clone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::service_manager::mojom::ConnectorInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in Connector.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class Connector_BindInterface_ProxyToResponder {
 public:
  static Connector::BindInterfaceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Connector_BindInterface_ProxyToResponder> proxy(
        new Connector_BindInterface_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Connector_BindInterface_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Connector_BindInterface_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Connector_BindInterface_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Connector::BindInterfaceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ConnectResult in_result, const absl::optional<::service_manager::Identity>& in_identity);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Connector_BindInterface_ProxyToResponder);
};

bool Connector_BindInterface_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "service_manager::mojom::Connector::BindInterfaceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Connector_BindInterface_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Connector_BindInterface_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ConnectResult p_result{};
  absl::optional<::service_manager::Identity> p_identity{};
  Connector_BindInterface_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadIdentity(&p_identity))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Connector::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_identity));
  return true;
}

void Connector_BindInterface_ProxyToResponder::Run(
    ConnectResult in_result, const absl::optional<::service_manager::Identity>& in_identity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)service_manager::mojom::Connector::BindInterfaceCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ConnectResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identity"), in_identity,
                        "<value of type const absl::optional<::service_manager::Identity>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kConnector_BindInterface_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_BindInterface_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::service_manager::mojom::ConnectResult>(
      in_result, &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->identity)::BaseType> identity_fragment(
          params.message());
  mojo::internal::Serialize<::service_manager::mojom::IdentityDataView>(
      in_identity, identity_fragment);
  params->identity.Set(
      identity_fragment.is_null() ? nullptr : identity_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)service_manager::mojom::Connector::BindInterfaceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("BindInterface");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Connector_QueryService_ProxyToResponder {
 public:
  static Connector::QueryServiceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Connector_QueryService_ProxyToResponder> proxy(
        new Connector_QueryService_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Connector_QueryService_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Connector_QueryService_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Connector_QueryService_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Connector::QueryServiceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ServiceInfoPtr in_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Connector_QueryService_ProxyToResponder);
};

bool Connector_QueryService_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "service_manager::mojom::Connector::QueryServiceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Connector_QueryService_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Connector_QueryService_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ServiceInfoPtr p_info{};
  Connector_QueryService_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Connector::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_info));
  return true;
}

void Connector_QueryService_ProxyToResponder::Run(
    ServiceInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)service_manager::mojom::Connector::QueryServiceCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type ServiceInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kConnector_QueryService_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_QueryService_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::service_manager::mojom::ServiceInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)service_manager::mojom::Connector::QueryServiceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("QueryService");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Connector_WarmService_ProxyToResponder {
 public:
  static Connector::WarmServiceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Connector_WarmService_ProxyToResponder> proxy(
        new Connector_WarmService_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Connector_WarmService_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Connector_WarmService_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Connector_WarmService_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Connector::WarmServiceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ConnectResult in_result, const absl::optional<::service_manager::Identity>& in_identity);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Connector_WarmService_ProxyToResponder);
};

bool Connector_WarmService_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "service_manager::mojom::Connector::WarmServiceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Connector_WarmService_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Connector_WarmService_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ConnectResult p_result{};
  absl::optional<::service_manager::Identity> p_identity{};
  Connector_WarmService_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadIdentity(&p_identity))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Connector::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_identity));
  return true;
}

void Connector_WarmService_ProxyToResponder::Run(
    ConnectResult in_result, const absl::optional<::service_manager::Identity>& in_identity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)service_manager::mojom::Connector::WarmServiceCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ConnectResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identity"), in_identity,
                        "<value of type const absl::optional<::service_manager::Identity>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kConnector_WarmService_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_WarmService_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::service_manager::mojom::ConnectResult>(
      in_result, &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->identity)::BaseType> identity_fragment(
          params.message());
  mojo::internal::Serialize<::service_manager::mojom::IdentityDataView>(
      in_identity, identity_fragment);
  params->identity.Set(
      identity_fragment.is_null() ? nullptr : identity_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)service_manager::mojom::Connector::WarmServiceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("WarmService");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Connector_RegisterServiceInstance_ProxyToResponder {
 public:
  static Connector::RegisterServiceInstanceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Connector_RegisterServiceInstance_ProxyToResponder> proxy(
        new Connector_RegisterServiceInstance_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Connector_RegisterServiceInstance_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Connector_RegisterServiceInstance_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Connector_RegisterServiceInstance_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Connector::RegisterServiceInstanceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ConnectResult in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Connector_RegisterServiceInstance_ProxyToResponder);
};

bool Connector_RegisterServiceInstance_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "service_manager::mojom::Connector::RegisterServiceInstanceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Connector_RegisterServiceInstance_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Connector_RegisterServiceInstance_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ConnectResult p_result{};
  Connector_RegisterServiceInstance_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Connector::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void Connector_RegisterServiceInstance_ProxyToResponder::Run(
    ConnectResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)service_manager::mojom::Connector::RegisterServiceInstanceCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ConnectResult>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kConnector_RegisterServiceInstance_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_RegisterServiceInstance_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::service_manager::mojom::ConnectResult>(
      in_result, &params->result);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)service_manager::mojom::Connector::RegisterServiceInstanceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("RegisterServiceInstance");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ConnectorStubDispatch::Accept(
    Connector* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kConnector_BindInterface_Name: {
      break;
    }
    case internal::kConnector_QueryService_Name: {
      break;
    }
    case internal::kConnector_WarmService_Name: {
      break;
    }
    case internal::kConnector_RegisterServiceInstance_Name: {
      break;
    }
    case internal::kConnector_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)service_manager::mojom::Connector::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)service_manager::mojom::Connector::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Connector_Clone_Params_Data* params =
          reinterpret_cast<internal::Connector_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<Connector> p_receiver{};
      Connector_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Connector::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool ConnectorStubDispatch::AcceptWithResponder(
    Connector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kConnector_BindInterface_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)service_manager::mojom::Connector::BindInterface",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)service_manager::mojom::Connector::BindInterface");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Connector_BindInterface_Params_Data* params =
          reinterpret_cast<
              internal::Connector_BindInterface_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::service_manager::ServiceFilter p_filter{};
      std::string p_interface_name{};
      ::mojo::ScopedMessagePipeHandle p_interface_pipe{};
      BindInterfacePriority p_priority{};
      Connector_BindInterface_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (success && !input_data_view.ReadInterfaceName(&p_interface_name))
        success = false;
      if (success)
        p_interface_pipe = input_data_view.TakeInterfacePipe();
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Connector::Name_, 0, false);
        return false;
      }
      Connector::BindInterfaceCallback callback =
          Connector_BindInterface_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindInterface(
std::move(p_filter), 
std::move(p_interface_name), 
std::move(p_interface_pipe), 
std::move(p_priority), std::move(callback));
      return true;
    }
    case internal::kConnector_QueryService_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)service_manager::mojom::Connector::QueryService",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)service_manager::mojom::Connector::QueryService");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Connector_QueryService_Params_Data* params =
          reinterpret_cast<
              internal::Connector_QueryService_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_service_name{};
      Connector_QueryService_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceName(&p_service_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Connector::Name_, 1, false);
        return false;
      }
      Connector::QueryServiceCallback callback =
          Connector_QueryService_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryService(
std::move(p_service_name), std::move(callback));
      return true;
    }
    case internal::kConnector_WarmService_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)service_manager::mojom::Connector::WarmService",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)service_manager::mojom::Connector::WarmService");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Connector_WarmService_Params_Data* params =
          reinterpret_cast<
              internal::Connector_WarmService_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::service_manager::ServiceFilter p_filter{};
      Connector_WarmService_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Connector::Name_, 2, false);
        return false;
      }
      Connector::WarmServiceCallback callback =
          Connector_WarmService_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WarmService(
std::move(p_filter), std::move(callback));
      return true;
    }
    case internal::kConnector_RegisterServiceInstance_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)service_manager::mojom::Connector::RegisterServiceInstance",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)service_manager::mojom::Connector::RegisterServiceInstance");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Connector_RegisterServiceInstance_Params_Data* params =
          reinterpret_cast<
              internal::Connector_RegisterServiceInstance_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::service_manager::Identity p_identity{};
      ::mojo::ScopedMessagePipeHandle p_service{};
      ::mojo::PendingReceiver<ProcessMetadata> p_metadata_receiver{};
      Connector_RegisterServiceInstance_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdentity(&p_identity))
        success = false;
      if (success)
        p_service = input_data_view.TakeService();
      if (success) {
        p_metadata_receiver =
            input_data_view.TakeMetadataReceiver<decltype(p_metadata_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Connector::Name_, 3, false);
        return false;
      }
      Connector::RegisterServiceInstanceCallback callback =
          Connector_RegisterServiceInstance_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterServiceInstance(
std::move(p_identity), 
std::move(p_service), 
std::move(p_metadata_receiver), std::move(callback));
      return true;
    }
    case internal::kConnector_Clone_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kConnectorValidationInfo[] = {
    {internal::kConnector_BindInterface_Name,
     {&internal::Connector_BindInterface_Params_Data::Validate,
      &internal::Connector_BindInterface_ResponseParams_Data::Validate}},
    {internal::kConnector_QueryService_Name,
     {&internal::Connector_QueryService_Params_Data::Validate,
      &internal::Connector_QueryService_ResponseParams_Data::Validate}},
    {internal::kConnector_WarmService_Name,
     {&internal::Connector_WarmService_Params_Data::Validate,
      &internal::Connector_WarmService_ResponseParams_Data::Validate}},
    {internal::kConnector_RegisterServiceInstance_Name,
     {&internal::Connector_RegisterServiceInstance_Params_Data::Validate,
      &internal::Connector_RegisterServiceInstance_ResponseParams_Data::Validate}},
    {internal::kConnector_Clone_Name,
     {&internal::Connector_Clone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ConnectorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::service_manager::mojom::Connector::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kConnectorValidationInfo);
}

bool ConnectorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::service_manager::mojom::Connector::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kConnectorValidationInfo);

}
}  // namespace mojom
}  // namespace service_manager

namespace mojo {


// static
bool StructTraits<::service_manager::mojom::Identity::DataView, ::service_manager::mojom::IdentityPtr>::Read(
    ::service_manager::mojom::Identity::DataView input,
    ::service_manager::mojom::IdentityPtr* output) {
  bool success = true;
  ::service_manager::mojom::IdentityPtr result(::service_manager::mojom::Identity::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadInstanceGroup(&result->instance_group))
        success = false;
      if (success && !input.ReadInstanceId(&result->instance_id))
        success = false;
      if (success && !input.ReadGloballyUniqueId(&result->globally_unique_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::service_manager::mojom::ServiceInfo::DataView, ::service_manager::mojom::ServiceInfoPtr>::Read(
    ::service_manager::mojom::ServiceInfo::DataView input,
    ::service_manager::mojom::ServiceInfoPtr* output) {
  bool success = true;
  ::service_manager::mojom::ServiceInfoPtr result(::service_manager::mojom::ServiceInfo::New());
  
      if (success && !input.ReadSandboxType(&result->sandbox_type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif