// services/service_manager/public/mojom/service_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/service_manager/public/mojom/service_manager.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/service_manager/public/mojom/service_manager.mojom-params-data.h"
namespace service_manager {
namespace mojom {

static NOINLINE const char* InstanceStateToStringHelper(InstanceState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InstanceState::kCreated:
      return "kCreated";
    case InstanceState::kStarted:
      return "kStarted";
    case InstanceState::kUnreachable:
      return "kUnreachable";
    default:
      return nullptr;
  }
}

std::string InstanceStateToString(InstanceState value) {
  const char *str = InstanceStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InstanceState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InstanceState value) {
  return os << InstanceStateToString(value);
}

namespace internal {


// static
bool RunningServiceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RunningServiceInfo_Data* object = static_cast<const RunningServiceInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->identity, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->identity, validation_context))
    return false;


  if (!::service_manager::mojom::internal::InstanceState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

RunningServiceInfo_Data::RunningServiceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceManagerListener_OnInit_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceManagerListener_OnInit_Params_Data* object = static_cast<const ServiceManagerListener_OnInit_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->running_services, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams running_services_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->running_services, validation_context,
                                         &running_services_validate_params)) {
    return false;
  }

  return true;
}

ServiceManagerListener_OnInit_Params_Data::ServiceManagerListener_OnInit_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceManagerListener_OnServiceCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceManagerListener_OnServiceCreated_Params_Data* object = static_cast<const ServiceManagerListener_OnServiceCreated_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->service, validation_context))
    return false;

  return true;
}

ServiceManagerListener_OnServiceCreated_Params_Data::ServiceManagerListener_OnServiceCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceManagerListener_OnServiceStarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceManagerListener_OnServiceStarted_Params_Data* object = static_cast<const ServiceManagerListener_OnServiceStarted_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->identity, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->identity, validation_context))
    return false;

  return true;
}

ServiceManagerListener_OnServiceStarted_Params_Data::ServiceManagerListener_OnServiceStarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceManagerListener_OnServicePIDReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceManagerListener_OnServicePIDReceived_Params_Data* object = static_cast<const ServiceManagerListener_OnServicePIDReceived_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->identity, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->identity, validation_context))
    return false;

  return true;
}

ServiceManagerListener_OnServicePIDReceived_Params_Data::ServiceManagerListener_OnServicePIDReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceManagerListener_OnServiceFailedToStart_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceManagerListener_OnServiceFailedToStart_Params_Data* object = static_cast<const ServiceManagerListener_OnServiceFailedToStart_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->identity, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->identity, validation_context))
    return false;

  return true;
}

ServiceManagerListener_OnServiceFailedToStart_Params_Data::ServiceManagerListener_OnServiceFailedToStart_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceManagerListener_OnServiceStopped_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceManagerListener_OnServiceStopped_Params_Data* object = static_cast<const ServiceManagerListener_OnServiceStopped_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->identity, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->identity, validation_context))
    return false;

  return true;
}

ServiceManagerListener_OnServiceStopped_Params_Data::ServiceManagerListener_OnServiceStopped_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceManager_AddListener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceManager_AddListener_Params_Data* object = static_cast<const ServiceManager_AddListener_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ServiceManager_AddListener_Params_Data::ServiceManager_AddListener_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace service_manager

namespace perfetto {

// static
void TraceFormatTraits<::service_manager::mojom::InstanceState>::WriteIntoTrace(
   perfetto::TracedValue context, ::service_manager::mojom::InstanceState value) {
  return std::move(context).WriteString(::service_manager::mojom::InstanceStateToString(value));
}

} // namespace perfetto
