// services/shape_detection/public/mojom/barcodedetection.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/shape_detection/public/mojom/barcodedetection.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/shape_detection/public/mojom/barcodedetection.mojom-params-data.h"
#include "services/shape_detection/public/mojom/barcodedetection.mojom-shared-message-ids.h"

#include "services/shape_detection/public/mojom/barcodedetection.mojom-import-headers.h"


#ifndef SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_BARCODEDETECTION_MOJOM_JUMBO_H_
#define SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_BARCODEDETECTION_MOJOM_JUMBO_H_
#endif
namespace shape_detection {
namespace mojom {
BarcodeDetectionResult::BarcodeDetectionResult()
    : raw_value(),
      bounding_box(),
      format(),
      corner_points() {}

BarcodeDetectionResult::BarcodeDetectionResult(
    const std::string& raw_value_in,
    const ::gfx::RectF& bounding_box_in,
    BarcodeFormat format_in,
    std::vector<::gfx::PointF> corner_points_in)
    : raw_value(std::move(raw_value_in)),
      bounding_box(std::move(bounding_box_in)),
      format(std::move(format_in)),
      corner_points(std::move(corner_points_in)) {}

BarcodeDetectionResult::~BarcodeDetectionResult() = default;

void BarcodeDetectionResult::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_value"), this->raw_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounding_box"), this->bounding_box,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BarcodeFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "corner_points"), this->corner_points,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gfx::PointF>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BarcodeDetectionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char BarcodeDetection::Name_[] = "shape_detection.mojom.BarcodeDetection";

class BarcodeDetection_Detect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BarcodeDetection_Detect_ForwardToCallback(
      BarcodeDetection::DetectCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BarcodeDetection::DetectCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BarcodeDetection_Detect_ForwardToCallback);
};

BarcodeDetectionProxy::BarcodeDetectionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BarcodeDetectionProxy::Detect(
    const ::SkBitmap& in_bitmap_data, DetectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "shape_detection::mojom::BarcodeDetection::Detect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitmap_data"), in_bitmap_data,
                        "<value of type const ::SkBitmap&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBarcodeDetection_Detect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::shape_detection::mojom::internal::BarcodeDetection_Detect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bitmap_data)::BaseType> bitmap_data_fragment(
          params.message());
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
      in_bitmap_data, bitmap_data_fragment);
  params->bitmap_data.Set(
      bitmap_data_fragment.is_null() ? nullptr : bitmap_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bitmap_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bitmap_data in BarcodeDetection.Detect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BarcodeDetection::Name_);
  message.set_method_name("Detect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BarcodeDetection_Detect_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class BarcodeDetection_Detect_ProxyToResponder {
 public:
  static BarcodeDetection::DetectCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BarcodeDetection_Detect_ProxyToResponder> proxy(
        new BarcodeDetection_Detect_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BarcodeDetection_Detect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BarcodeDetection_Detect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BarcodeDetection_Detect_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BarcodeDetection::DetectCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<BarcodeDetectionResultPtr> in_results);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BarcodeDetection_Detect_ProxyToResponder);
};

bool BarcodeDetection_Detect_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "shape_detection::mojom::BarcodeDetection::DetectCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BarcodeDetection_Detect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BarcodeDetection_Detect_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<BarcodeDetectionResultPtr> p_results{};
  BarcodeDetection_Detect_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BarcodeDetection::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_results));
  return true;
}

void BarcodeDetection_Detect_ProxyToResponder::Run(
    std::vector<BarcodeDetectionResultPtr> in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)shape_detection::mojom::BarcodeDetection::DetectCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type std::vector<BarcodeDetectionResultPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBarcodeDetection_Detect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::shape_detection::mojom::internal::BarcodeDetection_Detect_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  const mojo::internal::ContainerValidateParams results_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::shape_detection::mojom::BarcodeDetectionResultDataView>>(
      in_results, results_fragment, &results_validate_params);
  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->results.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null results in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)shape_detection::mojom::BarcodeDetection::DetectCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BarcodeDetection::Name_);
  message.set_method_name("Detect");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BarcodeDetectionStubDispatch::Accept(
    BarcodeDetection* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBarcodeDetection_Detect_Name: {
      break;
    }
  }
  return false;
}

// static
bool BarcodeDetectionStubDispatch::AcceptWithResponder(
    BarcodeDetection* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBarcodeDetection_Detect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)shape_detection::mojom::BarcodeDetection::Detect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)shape_detection::mojom::BarcodeDetection::Detect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BarcodeDetection_Detect_Params_Data* params =
          reinterpret_cast<
              internal::BarcodeDetection_Detect_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::SkBitmap p_bitmap_data{};
      BarcodeDetection_Detect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBitmapData(&p_bitmap_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BarcodeDetection::Name_, 0, false);
        return false;
      }
      BarcodeDetection::DetectCallback callback =
          BarcodeDetection_Detect_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Detect(
std::move(p_bitmap_data), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBarcodeDetectionValidationInfo[] = {
    {internal::kBarcodeDetection_Detect_Name,
     {&internal::BarcodeDetection_Detect_Params_Data::Validate,
      &internal::BarcodeDetection_Detect_ResponseParams_Data::Validate}},
};

bool BarcodeDetectionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::shape_detection::mojom::BarcodeDetection::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBarcodeDetectionValidationInfo);
}

bool BarcodeDetectionResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::shape_detection::mojom::BarcodeDetection::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kBarcodeDetectionValidationInfo);

}
}  // namespace mojom
}  // namespace shape_detection

namespace mojo {


// static
bool StructTraits<::shape_detection::mojom::BarcodeDetectionResult::DataView, ::shape_detection::mojom::BarcodeDetectionResultPtr>::Read(
    ::shape_detection::mojom::BarcodeDetectionResult::DataView input,
    ::shape_detection::mojom::BarcodeDetectionResultPtr* output) {
  bool success = true;
  ::shape_detection::mojom::BarcodeDetectionResultPtr result(::shape_detection::mojom::BarcodeDetectionResult::New());
  
      if (success && !input.ReadRawValue(&result->raw_value))
        success = false;
      if (success && !input.ReadBoundingBox(&result->bounding_box))
        success = false;
      if (success && !input.ReadFormat(&result->format))
        success = false;
      if (success && !input.ReadCornerPoints(&result->corner_points))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif