// services/tracing/public/mojom/traced_process.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/tracing/public/mojom/traced_process.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/tracing/public/mojom/traced_process.mojom-params-data.h"
#include "services/tracing/public/mojom/traced_process.mojom-shared-message-ids.h"

#include "services/tracing/public/mojom/traced_process.mojom-import-headers.h"


#ifndef SERVICES_TRACING_PUBLIC_MOJOM_TRACED_PROCESS_MOJOM_JUMBO_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_TRACED_PROCESS_MOJOM_JUMBO_H_
#endif
namespace tracing {
namespace mojom {
ConnectToTracingRequest::ConnectToTracingRequest()
    : perfetto_service() {}

ConnectToTracingRequest::ConnectToTracingRequest(
    ::mojo::PendingRemote<::tracing::mojom::PerfettoService> perfetto_service_in)
    : perfetto_service(std::move(perfetto_service_in)) {}

ConnectToTracingRequest::~ConnectToTracingRequest() = default;

void ConnectToTracingRequest::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "perfetto_service"), this->perfetto_service,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::tracing::mojom::PerfettoService>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ConnectToTracingRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char TracedProcess::Name_[] = "tracing.mojom.TracedProcess";

class TracedProcess_ConnectToTracingService_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TracedProcess_ConnectToTracingService_ForwardToCallback(
      TracedProcess::ConnectToTracingServiceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TracedProcess::ConnectToTracingServiceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TracedProcess_ConnectToTracingService_ForwardToCallback);
};

TracedProcessProxy::TracedProcessProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TracedProcessProxy::ConnectToTracingService(
    ConnectToTracingRequestPtr in_request, ConnectToTracingServiceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::TracedProcess::ConnectToTracingService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ConnectToTracingRequestPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTracedProcess_ConnectToTracingService_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::TracedProcess_ConnectToTracingService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  mojo::internal::Serialize<::tracing::mojom::ConnectToTracingRequestDataView>(
      in_request, request_fragment);
  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request in TracedProcess.ConnectToTracingService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracedProcess::Name_);
  message.set_method_name("ConnectToTracingService");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TracedProcess_ConnectToTracingService_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class TracedProcess_ConnectToTracingService_ProxyToResponder {
 public:
  static TracedProcess::ConnectToTracingServiceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TracedProcess_ConnectToTracingService_ProxyToResponder> proxy(
        new TracedProcess_ConnectToTracingService_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TracedProcess_ConnectToTracingService_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TracedProcess_ConnectToTracingService_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TracedProcess_ConnectToTracingService_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TracedProcess::ConnectToTracingServiceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TracedProcess_ConnectToTracingService_ProxyToResponder);
};

bool TracedProcess_ConnectToTracingService_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "tracing::mojom::TracedProcess::ConnectToTracingServiceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TracedProcess_ConnectToTracingService_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TracedProcess_ConnectToTracingService_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  TracedProcess_ConnectToTracingService_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TracedProcess::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void TracedProcess_ConnectToTracingService_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)tracing::mojom::TracedProcess::ConnectToTracingServiceCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTracedProcess_ConnectToTracingService_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::TracedProcess_ConnectToTracingService_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)tracing::mojom::TracedProcess::ConnectToTracingServiceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracedProcess::Name_);
  message.set_method_name("ConnectToTracingService");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TracedProcessStubDispatch::Accept(
    TracedProcess* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kTracedProcess_ConnectToTracingService_Name: {
      break;
    }
  }
  return false;
}

// static
bool TracedProcessStubDispatch::AcceptWithResponder(
    TracedProcess* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTracedProcess_ConnectToTracingService_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::TracedProcess::ConnectToTracingService",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::TracedProcess::ConnectToTracingService");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TracedProcess_ConnectToTracingService_Params_Data* params =
          reinterpret_cast<
              internal::TracedProcess_ConnectToTracingService_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ConnectToTracingRequestPtr p_request{};
      TracedProcess_ConnectToTracingService_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TracedProcess::Name_, 0, false);
        return false;
      }
      TracedProcess::ConnectToTracingServiceCallback callback =
          TracedProcess_ConnectToTracingService_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectToTracingService(
std::move(p_request), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTracedProcessValidationInfo[] = {
    {internal::kTracedProcess_ConnectToTracingService_Name,
     {&internal::TracedProcess_ConnectToTracingService_Params_Data::Validate,
      &internal::TracedProcess_ConnectToTracingService_ResponseParams_Data::Validate}},
};

bool TracedProcessRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::TracedProcess::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTracedProcessValidationInfo);
}

bool TracedProcessResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::TracedProcess::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kTracedProcessValidationInfo);

}
}  // namespace mojom
}  // namespace tracing

namespace mojo {


// static
bool StructTraits<::tracing::mojom::ConnectToTracingRequest::DataView, ::tracing::mojom::ConnectToTracingRequestPtr>::Read(
    ::tracing::mojom::ConnectToTracingRequest::DataView input,
    ::tracing::mojom::ConnectToTracingRequestPtr* output) {
  bool success = true;
  ::tracing::mojom::ConnectToTracingRequestPtr result(::tracing::mojom::ConnectToTracingRequest::New());
  
      if (success) {
        result->perfetto_service =
            input.TakePerfettoService<decltype(result->perfetto_service)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif