// services/video_capture/public/mojom/device.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/video_capture/public/mojom/device.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "media/capture/mojom/video_capture_types.mojom.h"
#include "media/capture/mojom/image_capture.mojom.h"
#include "services/video_capture/public/mojom/video_frame_handler.mojom.h"


#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_MOJOM_JUMBO_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_MOJOM_JUMBO_H_
#endif


namespace video_capture {
namespace mojom {


void DeviceInterceptorForTesting::Start(const ::media::VideoCaptureParams& requested_settings, ::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> handler) {
  GetForwardingInterface()->Start(std::move(requested_settings), std::move(handler));
}
void DeviceInterceptorForTesting::MaybeSuspend() {
  GetForwardingInterface()->MaybeSuspend();
}
void DeviceInterceptorForTesting::Resume() {
  GetForwardingInterface()->Resume();
}
void DeviceInterceptorForTesting::GetPhotoState(GetPhotoStateCallback callback) {
  GetForwardingInterface()->GetPhotoState(std::move(callback));
}
void DeviceInterceptorForTesting::SetPhotoOptions(::media::mojom::PhotoSettingsPtr settings, SetPhotoOptionsCallback callback) {
  GetForwardingInterface()->SetPhotoOptions(std::move(settings), std::move(callback));
}
void DeviceInterceptorForTesting::TakePhoto(TakePhotoCallback callback) {
  GetForwardingInterface()->TakePhoto(std::move(callback));
}
void DeviceInterceptorForTesting::ProcessFeedback(const ::media::VideoCaptureFeedback& feedback) {
  GetForwardingInterface()->ProcessFeedback(std::move(feedback));
}
DeviceAsyncWaiter::DeviceAsyncWaiter(
    Device* proxy) : proxy_(proxy) {}

DeviceAsyncWaiter::~DeviceAsyncWaiter() = default;

void DeviceAsyncWaiter::GetPhotoState(
    ::media::mojom::PhotoStatePtr* out_capabilities) {
  base::RunLoop loop;
  proxy_->GetPhotoState(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::PhotoStatePtr* out_capabilities
,
             ::media::mojom::PhotoStatePtr capabilities) {*out_capabilities = std::move(capabilities);
            loop->Quit();
          },
          &loop,
          out_capabilities));
  loop.Run();
}
void DeviceAsyncWaiter::SetPhotoOptions(
    ::media::mojom::PhotoSettingsPtr settings, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetPhotoOptions(std::move(settings),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void DeviceAsyncWaiter::TakePhoto(
    ::media::mojom::BlobPtr* out_blob) {
  base::RunLoop loop;
  proxy_->TakePhoto(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::BlobPtr* out_blob
,
             ::media::mojom::BlobPtr blob) {*out_blob = std::move(blob);
            loop->Quit();
          },
          &loop,
          out_blob));
  loop.Run();
}





}  // namespace mojom
}  // namespace video_capture

#if defined(__clang__)
#pragma clang diagnostic pop
#endif