// services/video_capture/public/mojom/device.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_capture/public/mojom/device.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_capture/public/mojom/device.mojom-params-data.h"
#include "services/video_capture/public/mojom/device.mojom-shared-message-ids.h"

#include "services/video_capture/public/mojom/device.mojom-import-headers.h"


#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_MOJOM_JUMBO_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_MOJOM_JUMBO_H_
#endif
namespace video_capture {
namespace mojom {
const char Device::Name_[] = "video_capture.mojom.Device";

class Device_GetPhotoState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Device_GetPhotoState_ForwardToCallback(
      Device::GetPhotoStateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Device::GetPhotoStateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Device_GetPhotoState_ForwardToCallback);
};

class Device_SetPhotoOptions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Device_SetPhotoOptions_ForwardToCallback(
      Device::SetPhotoOptionsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Device::SetPhotoOptionsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Device_SetPhotoOptions_ForwardToCallback);
};

class Device_TakePhoto_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Device_TakePhoto_ForwardToCallback(
      Device::TakePhotoCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Device::TakePhotoCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Device_TakePhoto_ForwardToCallback);
};

DeviceProxy::DeviceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DeviceProxy::Start(
    const ::media::VideoCaptureParams& in_requested_settings, ::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::Device::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_settings"), in_requested_settings,
                        "<value of type const ::media::VideoCaptureParams&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevice_Start_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::Device_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requested_settings)::BaseType> requested_settings_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoCaptureParamsDataView>(
      in_requested_settings, requested_settings_fragment);
  params->requested_settings.Set(
      requested_settings_fragment.is_null() ? nullptr : requested_settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->requested_settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requested_settings in Device.Start request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::VideoFrameHandlerInterfaceBase>>(
      in_handler, &params->handler, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->handler),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid handler in Device.Start request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceProxy::MaybeSuspend(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::Device::MaybeSuspend");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevice_MaybeSuspend_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::Device_MaybeSuspend_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("MaybeSuspend");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceProxy::Resume(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::Device::Resume");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevice_Resume_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::Device_Resume_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("Resume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceProxy::GetPhotoState(
    GetPhotoStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::Device::GetPhotoState");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevice_GetPhotoState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::Device_GetPhotoState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("GetPhotoState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Device_GetPhotoState_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DeviceProxy::SetPhotoOptions(
    ::media::mojom::PhotoSettingsPtr in_settings, SetPhotoOptionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::Device::SetPhotoOptions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), in_settings,
                        "<value of type ::media::mojom::PhotoSettingsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevice_SetPhotoOptions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::Device_SetPhotoOptions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->settings)::BaseType> settings_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::PhotoSettingsDataView>(
      in_settings, settings_fragment);
  params->settings.Set(
      settings_fragment.is_null() ? nullptr : settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings in Device.SetPhotoOptions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("SetPhotoOptions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Device_SetPhotoOptions_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DeviceProxy::TakePhoto(
    TakePhotoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::Device::TakePhoto");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevice_TakePhoto_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::Device_TakePhoto_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("TakePhoto");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Device_TakePhoto_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DeviceProxy::ProcessFeedback(
    const ::media::VideoCaptureFeedback& in_feedback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::Device::ProcessFeedback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feedback"), in_feedback,
                        "<value of type const ::media::VideoCaptureFeedback&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevice_ProcessFeedback_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::Device_ProcessFeedback_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->feedback)::BaseType> feedback_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoCaptureFeedbackDataView>(
      in_feedback, feedback_fragment);
  params->feedback.Set(
      feedback_fragment.is_null() ? nullptr : feedback_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->feedback.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null feedback in Device.ProcessFeedback request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("ProcessFeedback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class Device_GetPhotoState_ProxyToResponder {
 public:
  static Device::GetPhotoStateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Device_GetPhotoState_ProxyToResponder> proxy(
        new Device_GetPhotoState_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Device_GetPhotoState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Device_GetPhotoState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Device_GetPhotoState_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Device::GetPhotoStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::PhotoStatePtr in_capabilities);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Device_GetPhotoState_ProxyToResponder);
};

bool Device_GetPhotoState_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "video_capture::mojom::Device::GetPhotoStateCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Device_GetPhotoState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Device_GetPhotoState_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::media::mojom::PhotoStatePtr p_capabilities{};
  Device_GetPhotoState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCapabilities(&p_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Device::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_capabilities));
  return true;
}

void Device_GetPhotoState_ProxyToResponder::Run(
    ::media::mojom::PhotoStatePtr in_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)video_capture::mojom::Device::GetPhotoStateCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capabilities"), in_capabilities,
                        "<value of type ::media::mojom::PhotoStatePtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevice_GetPhotoState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::Device_GetPhotoState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->capabilities)::BaseType> capabilities_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::PhotoStateDataView>(
      in_capabilities, capabilities_fragment);
  params->capabilities.Set(
      capabilities_fragment.is_null() ? nullptr : capabilities_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)video_capture::mojom::Device::GetPhotoStateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("GetPhotoState");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Device_SetPhotoOptions_ProxyToResponder {
 public:
  static Device::SetPhotoOptionsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Device_SetPhotoOptions_ProxyToResponder> proxy(
        new Device_SetPhotoOptions_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Device_SetPhotoOptions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Device_SetPhotoOptions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Device_SetPhotoOptions_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Device::SetPhotoOptionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Device_SetPhotoOptions_ProxyToResponder);
};

bool Device_SetPhotoOptions_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "video_capture::mojom::Device::SetPhotoOptionsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Device_SetPhotoOptions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Device_SetPhotoOptions_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  Device_SetPhotoOptions_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Device::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void Device_SetPhotoOptions_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)video_capture::mojom::Device::SetPhotoOptionsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevice_SetPhotoOptions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::Device_SetPhotoOptions_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)video_capture::mojom::Device::SetPhotoOptionsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("SetPhotoOptions");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Device_TakePhoto_ProxyToResponder {
 public:
  static Device::TakePhotoCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Device_TakePhoto_ProxyToResponder> proxy(
        new Device_TakePhoto_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Device_TakePhoto_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Device_TakePhoto_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Device_TakePhoto_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Device::TakePhotoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::BlobPtr in_blob);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Device_TakePhoto_ProxyToResponder);
};

bool Device_TakePhoto_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "video_capture::mojom::Device::TakePhotoCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Device_TakePhoto_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Device_TakePhoto_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::media::mojom::BlobPtr p_blob{};
  Device_TakePhoto_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBlob(&p_blob))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Device::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_blob));
  return true;
}

void Device_TakePhoto_ProxyToResponder::Run(
    ::media::mojom::BlobPtr in_blob) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)video_capture::mojom::Device::TakePhotoCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::media::mojom::BlobPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevice_TakePhoto_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::Device_TakePhoto_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->blob)::BaseType> blob_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::BlobDataView>(
      in_blob, blob_fragment);
  params->blob.Set(
      blob_fragment.is_null() ? nullptr : blob_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)video_capture::mojom::Device::TakePhotoCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Device::Name_);
  message.set_method_name("TakePhoto");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DeviceStubDispatch::Accept(
    Device* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDevice_Start_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::Device::Start",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::Device::Start");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Device_Start_Params_Data* params =
          reinterpret_cast<internal::Device_Start_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoCaptureParams p_requested_settings{};
      ::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> p_handler{};
      Device_Start_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestedSettings(&p_requested_settings))
        success = false;
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(
std::move(p_requested_settings), 
std::move(p_handler));
      return true;
    }
    case internal::kDevice_MaybeSuspend_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::Device::MaybeSuspend",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::Device::MaybeSuspend");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Device_MaybeSuspend_Params_Data* params =
          reinterpret_cast<internal::Device_MaybeSuspend_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      Device_MaybeSuspend_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MaybeSuspend();
      return true;
    }
    case internal::kDevice_Resume_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::Device::Resume",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::Device::Resume");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Device_Resume_Params_Data* params =
          reinterpret_cast<internal::Device_Resume_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      Device_Resume_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resume();
      return true;
    }
    case internal::kDevice_GetPhotoState_Name: {
      break;
    }
    case internal::kDevice_SetPhotoOptions_Name: {
      break;
    }
    case internal::kDevice_TakePhoto_Name: {
      break;
    }
    case internal::kDevice_ProcessFeedback_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::Device::ProcessFeedback",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::Device::ProcessFeedback");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Device_ProcessFeedback_Params_Data* params =
          reinterpret_cast<internal::Device_ProcessFeedback_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoCaptureFeedback p_feedback{};
      Device_ProcessFeedback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeedback(&p_feedback))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ProcessFeedback(
std::move(p_feedback));
      return true;
    }
  }
  return false;
}

// static
bool DeviceStubDispatch::AcceptWithResponder(
    Device* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDevice_Start_Name: {
      break;
    }
    case internal::kDevice_MaybeSuspend_Name: {
      break;
    }
    case internal::kDevice_Resume_Name: {
      break;
    }
    case internal::kDevice_GetPhotoState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::Device::GetPhotoState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::Device::GetPhotoState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Device_GetPhotoState_Params_Data* params =
          reinterpret_cast<
              internal::Device_GetPhotoState_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Device_GetPhotoState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 3, false);
        return false;
      }
      Device::GetPhotoStateCallback callback =
          Device_GetPhotoState_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPhotoState(std::move(callback));
      return true;
    }
    case internal::kDevice_SetPhotoOptions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::Device::SetPhotoOptions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::Device::SetPhotoOptions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Device_SetPhotoOptions_Params_Data* params =
          reinterpret_cast<
              internal::Device_SetPhotoOptions_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::media::mojom::PhotoSettingsPtr p_settings{};
      Device_SetPhotoOptions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 4, false);
        return false;
      }
      Device::SetPhotoOptionsCallback callback =
          Device_SetPhotoOptions_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPhotoOptions(
std::move(p_settings), std::move(callback));
      return true;
    }
    case internal::kDevice_TakePhoto_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::Device::TakePhoto",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::Device::TakePhoto");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Device_TakePhoto_Params_Data* params =
          reinterpret_cast<
              internal::Device_TakePhoto_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Device_TakePhoto_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Device::Name_, 5, false);
        return false;
      }
      Device::TakePhotoCallback callback =
          Device_TakePhoto_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TakePhoto(std::move(callback));
      return true;
    }
    case internal::kDevice_ProcessFeedback_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDeviceValidationInfo[] = {
    {internal::kDevice_Start_Name,
     {&internal::Device_Start_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDevice_MaybeSuspend_Name,
     {&internal::Device_MaybeSuspend_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDevice_Resume_Name,
     {&internal::Device_Resume_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDevice_GetPhotoState_Name,
     {&internal::Device_GetPhotoState_Params_Data::Validate,
      &internal::Device_GetPhotoState_ResponseParams_Data::Validate}},
    {internal::kDevice_SetPhotoOptions_Name,
     {&internal::Device_SetPhotoOptions_Params_Data::Validate,
      &internal::Device_SetPhotoOptions_ResponseParams_Data::Validate}},
    {internal::kDevice_TakePhoto_Name,
     {&internal::Device_TakePhoto_Params_Data::Validate,
      &internal::Device_TakePhoto_ResponseParams_Data::Validate}},
    {internal::kDevice_ProcessFeedback_Name,
     {&internal::Device_ProcessFeedback_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DeviceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::Device::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDeviceValidationInfo);
}

bool DeviceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::Device::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kDeviceValidationInfo);

}
}  // namespace mojom
}  // namespace video_capture

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif