// services/video_capture/public/mojom/device_factory.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/video_capture/public/mojom/device_factory.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "media/capture/mojom/video_capture_types.mojom.h"
#include "services/video_capture/public/mojom/device.mojom.h"
#include "services/video_capture/public/mojom/devices_changed_observer.mojom.h"
#include "services/video_capture/public/mojom/producer.mojom.h"
#include "services/video_capture/public/mojom/virtual_device.mojom.h"


#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_FACTORY_MOJOM_JUMBO_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_FACTORY_MOJOM_JUMBO_H_
#endif


namespace video_capture {
namespace mojom {


void DeviceFactoryInterceptorForTesting::GetDeviceInfos(GetDeviceInfosCallback callback) {
  GetForwardingInterface()->GetDeviceInfos(std::move(callback));
}
void DeviceFactoryInterceptorForTesting::CreateDevice(const std::string& device_id, ::mojo::PendingReceiver<::video_capture::mojom::Device> device_receiver, CreateDeviceCallback callback) {
  GetForwardingInterface()->CreateDevice(std::move(device_id), std::move(device_receiver), std::move(callback));
}
void DeviceFactoryInterceptorForTesting::AddSharedMemoryVirtualDevice(const ::media::VideoCaptureDeviceInfo& device_info, ::mojo::PendingRemote<::video_capture::mojom::Producer> producer, bool send_buffer_handles_to_producer_as_raw_file_descriptors, ::mojo::PendingReceiver<::video_capture::mojom::SharedMemoryVirtualDevice> virtual_device_receiver) {
  GetForwardingInterface()->AddSharedMemoryVirtualDevice(std::move(device_info), std::move(producer), std::move(send_buffer_handles_to_producer_as_raw_file_descriptors), std::move(virtual_device_receiver));
}
void DeviceFactoryInterceptorForTesting::AddTextureVirtualDevice(const ::media::VideoCaptureDeviceInfo& device_info, ::mojo::PendingReceiver<::video_capture::mojom::TextureVirtualDevice> virtual_device_receiver) {
  GetForwardingInterface()->AddTextureVirtualDevice(std::move(device_info), std::move(virtual_device_receiver));
}
void DeviceFactoryInterceptorForTesting::AddGpuMemoryBufferVirtualDevice(const ::media::VideoCaptureDeviceInfo& device_info, ::mojo::PendingReceiver<::video_capture::mojom::GpuMemoryBufferVirtualDevice> virtual_device_receiver) {
  GetForwardingInterface()->AddGpuMemoryBufferVirtualDevice(std::move(device_info), std::move(virtual_device_receiver));
}
void DeviceFactoryInterceptorForTesting::RegisterVirtualDevicesChangedObserver(::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> observer, bool raise_event_if_virtual_devices_already_present) {
  GetForwardingInterface()->RegisterVirtualDevicesChangedObserver(std::move(observer), std::move(raise_event_if_virtual_devices_already_present));
}
DeviceFactoryAsyncWaiter::DeviceFactoryAsyncWaiter(
    DeviceFactory* proxy) : proxy_(proxy) {}

DeviceFactoryAsyncWaiter::~DeviceFactoryAsyncWaiter() = default;

void DeviceFactoryAsyncWaiter::GetDeviceInfos(
    std::vector<::media::VideoCaptureDeviceInfo>* out_device_infos) {
  base::RunLoop loop;
  proxy_->GetDeviceInfos(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::media::VideoCaptureDeviceInfo>* out_device_infos
,
             const std::vector<::media::VideoCaptureDeviceInfo>& device_infos) {*out_device_infos = std::move(device_infos);
            loop->Quit();
          },
          &loop,
          out_device_infos));
  loop.Run();
}
void DeviceFactoryAsyncWaiter::CreateDevice(
    const std::string& device_id, ::mojo::PendingReceiver<::video_capture::mojom::Device> device_receiver, DeviceAccessResultCode* out_result_code) {
  base::RunLoop loop;
  proxy_->CreateDevice(std::move(device_id),std::move(device_receiver),
      base::BindOnce(
          [](base::RunLoop* loop,
             DeviceAccessResultCode* out_result_code
,
             DeviceAccessResultCode result_code) {*out_result_code = std::move(result_code);
            loop->Quit();
          },
          &loop,
          out_result_code));
  loop.Run();
}





}  // namespace mojom
}  // namespace video_capture

#if defined(__clang__)
#pragma clang diagnostic pop
#endif