// services/video_capture/public/mojom/producer.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/video_capture/public/mojom/producer.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "media/capture/mojom/video_capture_buffer.mojom.h"
#include "media/capture/mojom/video_capture_types.mojom.h"


#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_PRODUCER_MOJOM_JUMBO_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_PRODUCER_MOJOM_JUMBO_H_
#endif


namespace video_capture {
namespace mojom {


void ProducerInterceptorForTesting::OnNewBuffer(int32_t buffer_id, ::media::mojom::VideoBufferHandlePtr buffer_handle, OnNewBufferCallback callback) {
  GetForwardingInterface()->OnNewBuffer(std::move(buffer_id), std::move(buffer_handle), std::move(callback));
}
void ProducerInterceptorForTesting::OnBufferRetired(int32_t buffer_id) {
  GetForwardingInterface()->OnBufferRetired(std::move(buffer_id));
}
ProducerAsyncWaiter::ProducerAsyncWaiter(
    Producer* proxy) : proxy_(proxy) {}

ProducerAsyncWaiter::~ProducerAsyncWaiter() = default;

void ProducerAsyncWaiter::OnNewBuffer(
    int32_t buffer_id, ::media::mojom::VideoBufferHandlePtr buffer_handle) {
  base::RunLoop loop;
  proxy_->OnNewBuffer(std::move(buffer_id),std::move(buffer_handle),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}





}  // namespace mojom
}  // namespace video_capture

#if defined(__clang__)
#pragma clang diagnostic pop
#endif