// services/video_capture/public/mojom/video_source.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/video_capture/public/mojom/video_source.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_capture/public/mojom/video_source.mojom-params-data.h"
namespace video_capture {
namespace mojom {

static NOINLINE const char* CreatePushSubscriptionResultCodeToStringHelper(CreatePushSubscriptionResultCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CreatePushSubscriptionResultCode::kCreatedWithRequestedSettings:
      return "kCreatedWithRequestedSettings";
    case CreatePushSubscriptionResultCode::kCreatedWithDifferentSettings:
      return "kCreatedWithDifferentSettings";
    case CreatePushSubscriptionResultCode::kFailed:
      return "kFailed";
    default:
      return nullptr;
  }
}

std::string CreatePushSubscriptionResultCodeToString(CreatePushSubscriptionResultCode value) {
  const char *str = CreatePushSubscriptionResultCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CreatePushSubscriptionResultCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CreatePushSubscriptionResultCode value) {
  return os << CreatePushSubscriptionResultCodeToString(value);
}

namespace internal {


// static
bool PushVideoStreamSubscription_Activate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PushVideoStreamSubscription_Activate_Params_Data* object = static_cast<const PushVideoStreamSubscription_Activate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PushVideoStreamSubscription_Activate_Params_Data::PushVideoStreamSubscription_Activate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_Suspend_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PushVideoStreamSubscription_Suspend_Params_Data* object = static_cast<const PushVideoStreamSubscription_Suspend_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PushVideoStreamSubscription_Suspend_Params_Data::PushVideoStreamSubscription_Suspend_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_Suspend_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PushVideoStreamSubscription_Suspend_ResponseParams_Data* object = static_cast<const PushVideoStreamSubscription_Suspend_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PushVideoStreamSubscription_Suspend_ResponseParams_Data::PushVideoStreamSubscription_Suspend_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_Resume_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PushVideoStreamSubscription_Resume_Params_Data* object = static_cast<const PushVideoStreamSubscription_Resume_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PushVideoStreamSubscription_Resume_Params_Data::PushVideoStreamSubscription_Resume_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_GetPhotoState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PushVideoStreamSubscription_GetPhotoState_Params_Data* object = static_cast<const PushVideoStreamSubscription_GetPhotoState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PushVideoStreamSubscription_GetPhotoState_Params_Data::PushVideoStreamSubscription_GetPhotoState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data* object = static_cast<const PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->capabilities, validation_context))
    return false;

  return true;
}

PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data::PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_SetPhotoOptions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PushVideoStreamSubscription_SetPhotoOptions_Params_Data* object = static_cast<const PushVideoStreamSubscription_SetPhotoOptions_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->settings, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->settings, validation_context))
    return false;

  return true;
}

PushVideoStreamSubscription_SetPhotoOptions_Params_Data::PushVideoStreamSubscription_SetPhotoOptions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data* object = static_cast<const PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data::PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_TakePhoto_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PushVideoStreamSubscription_TakePhoto_Params_Data* object = static_cast<const PushVideoStreamSubscription_TakePhoto_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PushVideoStreamSubscription_TakePhoto_Params_Data::PushVideoStreamSubscription_TakePhoto_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_TakePhoto_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PushVideoStreamSubscription_TakePhoto_ResponseParams_Data* object = static_cast<const PushVideoStreamSubscription_TakePhoto_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->blob, validation_context))
    return false;

  return true;
}

PushVideoStreamSubscription_TakePhoto_ResponseParams_Data::PushVideoStreamSubscription_TakePhoto_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PushVideoStreamSubscription_Close_Params_Data* object = static_cast<const PushVideoStreamSubscription_Close_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PushVideoStreamSubscription_Close_Params_Data::PushVideoStreamSubscription_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_Close_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PushVideoStreamSubscription_Close_ResponseParams_Data* object = static_cast<const PushVideoStreamSubscription_Close_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PushVideoStreamSubscription_Close_ResponseParams_Data::PushVideoStreamSubscription_Close_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_ProcessFeedback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PushVideoStreamSubscription_ProcessFeedback_Params_Data* object = static_cast<const PushVideoStreamSubscription_ProcessFeedback_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->feedback, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->feedback, validation_context))
    return false;

  return true;
}

PushVideoStreamSubscription_ProcessFeedback_Params_Data::PushVideoStreamSubscription_ProcessFeedback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoSource_CreatePushSubscription_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoSource_CreatePushSubscription_Params_Data* object = static_cast<const VideoSource_CreatePushSubscription_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->subscriber, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->subscriber,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requested_settings, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->requested_settings, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->subscription, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->subscription,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoSource_CreatePushSubscription_Params_Data::VideoSource_CreatePushSubscription_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoSource_CreatePushSubscription_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoSource_CreatePushSubscription_ResponseParams_Data* object = static_cast<const VideoSource_CreatePushSubscription_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::video_capture::mojom::internal::CreatePushSubscriptionResultCode_Data
        ::Validate(object->result_code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->settings_source_was_opened_with, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->settings_source_was_opened_with, validation_context))
    return false;

  return true;
}

VideoSource_CreatePushSubscription_ResponseParams_Data::VideoSource_CreatePushSubscription_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace video_capture

namespace perfetto {

// static
void TraceFormatTraits<::video_capture::mojom::CreatePushSubscriptionResultCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::video_capture::mojom::CreatePushSubscriptionResultCode value) {
  return std::move(context).WriteString(::video_capture::mojom::CreatePushSubscriptionResultCodeToString(value));
}

} // namespace perfetto
