// services/viz/privileged/mojom/viz_main.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/viz_main.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/viz_main.mojom-params-data.h"
#include "services/viz/privileged/mojom/viz_main.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/viz_main.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
FrameSinkManagerParams::FrameSinkManagerParams()
    : restart_id(),
      use_activation_deadline(true),
      activation_deadline_in_frames(4U),
      frame_sink_manager(),
      frame_sink_manager_client(),
      debug_renderer_settings() {}

FrameSinkManagerParams::FrameSinkManagerParams(
    uint32_t restart_id_in,
    bool use_activation_deadline_in,
    uint32_t activation_deadline_in_frames_in,
    ::mojo::PendingReceiver<::viz::mojom::FrameSinkManager> frame_sink_manager_in,
    ::mojo::PendingRemote<::viz::mojom::FrameSinkManagerClient> frame_sink_manager_client_in,
    const ::viz::DebugRendererSettings& debug_renderer_settings_in)
    : restart_id(std::move(restart_id_in)),
      use_activation_deadline(std::move(use_activation_deadline_in)),
      activation_deadline_in_frames(std::move(activation_deadline_in_frames_in)),
      frame_sink_manager(std::move(frame_sink_manager_in)),
      frame_sink_manager_client(std::move(frame_sink_manager_client_in)),
      debug_renderer_settings(std::move(debug_renderer_settings_in)) {}

FrameSinkManagerParams::~FrameSinkManagerParams() = default;

void FrameSinkManagerParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "restart_id"), this->restart_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_activation_deadline"), this->use_activation_deadline,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "activation_deadline_in_frames"), this->activation_deadline_in_frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_sink_manager"), this->frame_sink_manager,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::viz::mojom::FrameSinkManager>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_sink_manager_client"), this->frame_sink_manager_client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::viz::mojom::FrameSinkManagerClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_renderer_settings"), this->debug_renderer_settings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::DebugRendererSettings&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FrameSinkManagerParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char VizMain::Name_[] = "viz.mojom.VizMain";

VizMainProxy::VizMainProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VizMainProxy::CreateFrameSinkManager(
    FrameSinkManagerParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::VizMain::CreateFrameSinkManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type FrameSinkManagerParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVizMain_CreateFrameSinkManager_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::VizMain_CreateFrameSinkManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::FrameSinkManagerParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in VizMain.CreateFrameSinkManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VizMain::Name_);
  message.set_method_name("CreateFrameSinkManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VizMainProxy::CreateGpuService(
    ::mojo::PendingReceiver<::viz::mojom::GpuService> in_gpu_service, ::mojo::PendingRemote<::viz::mojom::GpuHost> in_gpu_host, ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> in_discardable_memory_manager, ::mojo::ScopedSharedBufferHandle in_activity_flags, ::gfx::FontRenderParams::SubpixelRendering in_subpixel_rendering) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::VizMain::CreateGpuService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_service"), in_gpu_service,
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::GpuService>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_host"), in_gpu_host,
                        "<value of type ::mojo::PendingRemote<::viz::mojom::GpuHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("discardable_memory_manager"), in_discardable_memory_manager,
                        "<value of type ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("activity_flags"), in_activity_flags,
                        "<value of type ::mojo::ScopedSharedBufferHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subpixel_rendering"), in_subpixel_rendering,
                        "<value of type ::gfx::FontRenderParams::SubpixelRendering>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kVizMain_CreateGpuService_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::VizMain_CreateGpuService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::GpuServiceInterfaceBase>>(
      in_gpu_service, &params->gpu_service, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->gpu_service),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid gpu_service in VizMain.CreateGpuService request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::GpuHostInterfaceBase>>(
      in_gpu_host, &params->gpu_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->gpu_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid gpu_host in VizMain.CreateGpuService request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::discardable_memory::mojom::DiscardableSharedMemoryManagerInterfaceBase>>(
      in_discardable_memory_manager, &params->discardable_memory_manager, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->discardable_memory_manager),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid discardable_memory_manager in VizMain.CreateGpuService request");
  mojo::internal::Serialize<mojo::ScopedSharedBufferHandle>(
      in_activity_flags, &params->activity_flags, &params.message());
  mojo::internal::Serialize<::gfx::mojom::SubpixelRendering>(
      in_subpixel_rendering, &params->subpixel_rendering);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VizMain::Name_);
  message.set_method_name("CreateGpuService");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool VizMainStubDispatch::Accept(
    VizMain* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVizMain_CreateFrameSinkManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::VizMain::CreateFrameSinkManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::VizMain::CreateFrameSinkManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VizMain_CreateFrameSinkManager_Params_Data* params =
          reinterpret_cast<internal::VizMain_CreateFrameSinkManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameSinkManagerParamsPtr p_params{};
      VizMain_CreateFrameSinkManager_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VizMain::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFrameSinkManager(
std::move(p_params));
      return true;
    }
    case internal::kVizMain_CreateGpuService_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::VizMain::CreateGpuService",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::VizMain::CreateGpuService");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VizMain_CreateGpuService_Params_Data* params =
          reinterpret_cast<internal::VizMain_CreateGpuService_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::viz::mojom::GpuService> p_gpu_service{};
      ::mojo::PendingRemote<::viz::mojom::GpuHost> p_gpu_host{};
      ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> p_discardable_memory_manager{};
      ::mojo::ScopedSharedBufferHandle p_activity_flags{};
      ::gfx::FontRenderParams::SubpixelRendering p_subpixel_rendering{};
      VizMain_CreateGpuService_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_gpu_service =
            input_data_view.TakeGpuService<decltype(p_gpu_service)>();
      }
      if (success) {
        p_gpu_host =
            input_data_view.TakeGpuHost<decltype(p_gpu_host)>();
      }
      if (success) {
        p_discardable_memory_manager =
            input_data_view.TakeDiscardableMemoryManager<decltype(p_discardable_memory_manager)>();
      }
      if (success)
        p_activity_flags = input_data_view.TakeActivityFlags();
      if (success && !input_data_view.ReadSubpixelRendering(&p_subpixel_rendering))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VizMain::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateGpuService(
std::move(p_gpu_service), 
std::move(p_gpu_host), 
std::move(p_discardable_memory_manager), 
std::move(p_activity_flags), 
std::move(p_subpixel_rendering));
      return true;
    }
  }
  return false;
}

// static
bool VizMainStubDispatch::AcceptWithResponder(
    VizMain* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVizMain_CreateFrameSinkManager_Name: {
      break;
    }
    case internal::kVizMain_CreateGpuService_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVizMainValidationInfo[] = {
    {internal::kVizMain_CreateFrameSinkManager_Name,
     {&internal::VizMain_CreateFrameSinkManager_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVizMain_CreateGpuService_Name,
     {&internal::VizMain_CreateGpuService_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VizMainRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::VizMain::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVizMainValidationInfo);
}

}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::FrameSinkManagerParams::DataView, ::viz::mojom::FrameSinkManagerParamsPtr>::Read(
    ::viz::mojom::FrameSinkManagerParams::DataView input,
    ::viz::mojom::FrameSinkManagerParamsPtr* output) {
  bool success = true;
  ::viz::mojom::FrameSinkManagerParamsPtr result(::viz::mojom::FrameSinkManagerParams::New());
  
      if (success)
        result->restart_id = input.restart_id();
      if (success)
        result->use_activation_deadline = input.use_activation_deadline();
      if (success)
        result->activation_deadline_in_frames = input.activation_deadline_in_frames();
      if (success) {
        result->frame_sink_manager =
            input.TakeFrameSinkManager<decltype(result->frame_sink_manager)>();
      }
      if (success) {
        result->frame_sink_manager_client =
            input.TakeFrameSinkManagerClient<decltype(result->frame_sink_manager_client)>();
      }
      if (success && !input.ReadDebugRendererSettings(&result->debug_renderer_settings))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif