// third_party/blink/public/mojom/ad_tagging/ad_evidence.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/ad_tagging/ad_evidence.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/ad_tagging/ad_evidence.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* FilterListResultToStringHelper(FilterListResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FilterListResult::kNotChecked:
      return "kNotChecked";
    case FilterListResult::kMatchedAllowingRule:
      return "kMatchedAllowingRule";
    case FilterListResult::kMatchedNoRules:
      return "kMatchedNoRules";
    case FilterListResult::kMatchedBlockingRule:
      return "kMatchedBlockingRule";
    default:
      return nullptr;
  }
}

std::string FilterListResultToString(FilterListResult value) {
  const char *str = FilterListResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FilterListResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FilterListResult value) {
  return os << FilterListResultToString(value);
}

static NOINLINE const char* FrameCreationStackEvidenceToStringHelper(FrameCreationStackEvidence value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FrameCreationStackEvidence::kNotCreatedByAdScript:
      return "kNotCreatedByAdScript";
    case FrameCreationStackEvidence::kCreatedByAdScript:
      return "kCreatedByAdScript";
    default:
      return nullptr;
  }
}

std::string FrameCreationStackEvidenceToString(FrameCreationStackEvidence value) {
  const char *str = FrameCreationStackEvidenceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FrameCreationStackEvidence value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FrameCreationStackEvidence value) {
  return os << FrameCreationStackEvidenceToString(value);
}

namespace internal {


// static
bool FrameAdEvidence_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FrameAdEvidence_Data* object = static_cast<const FrameAdEvidence_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::FilterListResult_Data
        ::Validate(object->latest_filter_list_result, validation_context))
    return false;


  if (!::blink::mojom::internal::FilterListResult_Data
        ::Validate(object->most_restrictive_filter_list_result, validation_context))
    return false;


  if (!::blink::mojom::internal::FrameCreationStackEvidence_Data
        ::Validate(object->created_by_ad_script, validation_context))
    return false;

  return true;
}

FrameAdEvidence_Data::FrameAdEvidence_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FilterListResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::FilterListResult value) {
  return std::move(context).WriteString(::blink::mojom::FilterListResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FrameCreationStackEvidence>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::FrameCreationStackEvidence value) {
  return std::move(context).WriteString(::blink::mojom::FrameCreationStackEvidenceToString(value));
}

} // namespace perfetto
