// third_party/blink/public/mojom/appcache/appcache.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "third_party/blink/public/mojom/appcache/appcache.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/network/public/mojom/url_loader_factory.mojom-blink.h"
#include "third_party/blink/public/mojom/appcache/appcache_info.mojom-blink.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_APPCACHE_APPCACHE_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_APPCACHE_APPCACHE_MOJOM_BLINK_JUMBO_H_
#endif


namespace blink {
namespace mojom {
namespace blink {


void AppCacheBackendInterceptorForTesting::RegisterHost(::mojo::PendingReceiver<AppCacheHost> host_receiver, ::mojo::PendingRemote<AppCacheFrontend> frontend, const ::base::UnguessableToken& host_id) {
  GetForwardingInterface()->RegisterHost(std::move(host_receiver), std::move(frontend), std::move(host_id));
}
AppCacheBackendAsyncWaiter::AppCacheBackendAsyncWaiter(
    AppCacheBackend* proxy) : proxy_(proxy) {}

AppCacheBackendAsyncWaiter::~AppCacheBackendAsyncWaiter() = default;




void AppCacheHostInterceptorForTesting::SetSpawningHostId(const ::base::UnguessableToken& spawning_host_id) {
  GetForwardingInterface()->SetSpawningHostId(std::move(spawning_host_id));
}
void AppCacheHostInterceptorForTesting::SelectCache(const ::blink::KURL& document_url, int64_t appcache_document_was_loaded_from, const ::blink::KURL& opt_manifest_url) {
  GetForwardingInterface()->SelectCache(std::move(document_url), std::move(appcache_document_was_loaded_from), std::move(opt_manifest_url));
}
void AppCacheHostInterceptorForTesting::SelectCacheForWorker(int64_t appcache_id) {
  GetForwardingInterface()->SelectCacheForWorker(std::move(appcache_id));
}
void AppCacheHostInterceptorForTesting::MarkAsForeignEntry(const ::blink::KURL& document_url, int64_t appcache_document_was_loaded_from) {
  GetForwardingInterface()->MarkAsForeignEntry(std::move(document_url), std::move(appcache_document_was_loaded_from));
}
void AppCacheHostInterceptorForTesting::GetStatus(GetStatusCallback callback) {
  GetForwardingInterface()->GetStatus(std::move(callback));
}
void AppCacheHostInterceptorForTesting::StartUpdate(StartUpdateCallback callback) {
  GetForwardingInterface()->StartUpdate(std::move(callback));
}
void AppCacheHostInterceptorForTesting::SwapCache(SwapCacheCallback callback) {
  GetForwardingInterface()->SwapCache(std::move(callback));
}
void AppCacheHostInterceptorForTesting::GetResourceList(GetResourceListCallback callback) {
  GetForwardingInterface()->GetResourceList(std::move(callback));
}
AppCacheHostAsyncWaiter::AppCacheHostAsyncWaiter(
    AppCacheHost* proxy) : proxy_(proxy) {}

AppCacheHostAsyncWaiter::~AppCacheHostAsyncWaiter() = default;

void AppCacheHostAsyncWaiter::GetStatus(
    ::blink::mojom::blink::AppCacheStatus* out_status) {
  base::RunLoop loop;
  proxy_->GetStatus(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::AppCacheStatus* out_status
,
             ::blink::mojom::blink::AppCacheStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void AppCacheHostAsyncWaiter::StartUpdate(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->StartUpdate(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void AppCacheHostAsyncWaiter::SwapCache(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->SwapCache(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void AppCacheHostAsyncWaiter::GetResourceList(
    WTF::Vector<AppCacheResourceInfoPtr>* out_resources) {
  base::RunLoop loop;
  proxy_->GetResourceList(
      base::BindOnce(
          [](base::RunLoop* loop,
             WTF::Vector<AppCacheResourceInfoPtr>* out_resources
,
             WTF::Vector<AppCacheResourceInfoPtr> resources) {*out_resources = std::move(resources);
            loop->Quit();
          },
          &loop,
          out_resources));
  loop.Run();
}



void AppCacheFrontendInterceptorForTesting::CacheSelected(::blink::mojom::blink::AppCacheInfoPtr info) {
  GetForwardingInterface()->CacheSelected(std::move(info));
}
void AppCacheFrontendInterceptorForTesting::EventRaised(AppCacheEventID event_id) {
  GetForwardingInterface()->EventRaised(std::move(event_id));
}
void AppCacheFrontendInterceptorForTesting::ProgressEventRaised(const ::blink::KURL& url, int32_t total, int32_t complete) {
  GetForwardingInterface()->ProgressEventRaised(std::move(url), std::move(total), std::move(complete));
}
void AppCacheFrontendInterceptorForTesting::ErrorEventRaised(AppCacheErrorDetailsPtr error_details) {
  GetForwardingInterface()->ErrorEventRaised(std::move(error_details));
}
void AppCacheFrontendInterceptorForTesting::LogMessage(::blink::mojom::blink::ConsoleMessageLevel log_level, const WTF::String& message) {
  GetForwardingInterface()->LogMessage(std::move(log_level), std::move(message));
}
void AppCacheFrontendInterceptorForTesting::SetSubresourceFactory(::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> url_loader_factory) {
  GetForwardingInterface()->SetSubresourceFactory(std::move(url_loader_factory));
}
AppCacheFrontendAsyncWaiter::AppCacheFrontendAsyncWaiter(
    AppCacheFrontend* proxy) : proxy_(proxy) {}

AppCacheFrontendAsyncWaiter::~AppCacheFrontendAsyncWaiter() = default;






}  // namespace blink
}  // namespace mojom
}  // namespace blink

#if defined(__clang__)
#pragma clang diagnostic pop
#endif