// third_party/blink/public/mojom/blob/blob_registry.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/blob/blob_registry.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/blob/blob_registry.mojom-params-data.h"
#include "third_party/blink/public/mojom/blob/blob_registry.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/blob/blob_registry.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_BLOB_REGISTRY_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_BLOB_REGISTRY_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char ProgressClient::Name_[] = "blink.mojom.ProgressClient";

ProgressClientProxy::ProgressClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProgressClientProxy::OnProgress(
    uint64_t in_delta) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ProgressClient::OnProgress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delta"), in_delta,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProgressClient_OnProgress_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ProgressClient_OnProgress_Params_Data> params(
          message);
  params.Allocate();
  params->delta = in_delta;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProgressClient::Name_);
  message.set_method_name("OnProgress");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ProgressClientStubDispatch::Accept(
    ProgressClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kProgressClient_OnProgress_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ProgressClient::OnProgress",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ProgressClient::OnProgress");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProgressClient_OnProgress_Params_Data* params =
          reinterpret_cast<internal::ProgressClient_OnProgress_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_delta{};
      ProgressClient_OnProgress_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_delta = input_data_view.delta();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProgressClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnProgress(
std::move(p_delta));
      return true;
    }
  }
  return false;
}

// static
bool ProgressClientStubDispatch::AcceptWithResponder(
    ProgressClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kProgressClient_OnProgress_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kProgressClientValidationInfo[] = {
    {&internal::ProgressClient_OnProgress_Params_Data::Validate,
     nullptr /* no response */},
};

bool ProgressClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ProgressClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kProgressClientValidationInfo);
}

const char BlobRegistry::Name_[] = "blink.mojom.BlobRegistry";
bool BlobRegistry::Register(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid, const std::string& content_type, const std::string& content_disposition, std::vector<::blink::mojom::DataElementPtr> elements) {
  NOTREACHED();
  return false;
}
bool BlobRegistry::GetBlobFromUUID(::mojo::PendingReceiver<::blink::mojom::Blob> blob, const std::string& uuid) {
  NOTREACHED();
  return false;
}
class BlobRegistry_Register_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  BlobRegistry_Register_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(BlobRegistry_Register_HandleSyncResponse);
};

class BlobRegistry_Register_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobRegistry_Register_ForwardToCallback(
      BlobRegistry::RegisterCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BlobRegistry::RegisterCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BlobRegistry_Register_ForwardToCallback);
};

class BlobRegistry_RegisterFromStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobRegistry_RegisterFromStream_ForwardToCallback(
      BlobRegistry::RegisterFromStreamCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BlobRegistry::RegisterFromStreamCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BlobRegistry_RegisterFromStream_ForwardToCallback);
};
class BlobRegistry_GetBlobFromUUID_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  BlobRegistry_GetBlobFromUUID_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(BlobRegistry_GetBlobFromUUID_HandleSyncResponse);
};

class BlobRegistry_GetBlobFromUUID_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobRegistry_GetBlobFromUUID_ForwardToCallback(
      BlobRegistry::GetBlobFromUUIDCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BlobRegistry::GetBlobFromUUIDCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BlobRegistry_GetBlobFromUUID_ForwardToCallback);
};

BlobRegistryProxy::BlobRegistryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool BlobRegistryProxy::Register(
    ::mojo::PendingReceiver<::blink::mojom::Blob> param_blob, const std::string& param_uuid, const std::string& param_content_type, const std::string& param_content_disposition, std::vector<::blink::mojom::DataElementPtr> param_elements) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::BlobRegistry::Register", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), param_blob,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), param_uuid,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_type"), param_content_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_disposition"), param_content_disposition,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("elements"), param_elements,
                        "<value of type std::vector<::blink::mojom::DataElementPtr>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlobRegistry_Register_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobRegistry_Register_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
      param_blob, &params->blob, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blob),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_uuid, uuid_fragment);
  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_type)::BaseType> content_type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_content_type, content_type_fragment);
  params->content_type.Set(
      content_type_fragment.is_null() ? nullptr : content_type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_type in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_disposition)::BaseType> content_disposition_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_content_disposition, content_disposition_fragment);
  params->content_disposition.Set(
      content_disposition_fragment.is_null() ? nullptr : content_disposition_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content_disposition.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_disposition in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->elements)::BaseType>
      elements_fragment(params.message());
  const mojo::internal::ContainerValidateParams elements_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::DataElementDataView>>(
      param_elements, elements_fragment, &elements_validate_params);
  params->elements.Set(
      elements_fragment.is_null() ? nullptr : elements_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->elements.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null elements in BlobRegistry.Register request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobRegistry::Name_);
  message.set_method_name("Register");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobRegistry_Register_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "blink::mojom::BlobRegistry::Register");
#endif
  return result;
}

void BlobRegistryProxy::Register(
    ::mojo::PendingReceiver<::blink::mojom::Blob> in_blob, const std::string& in_uuid, const std::string& in_content_type, const std::string& in_content_disposition, std::vector<::blink::mojom::DataElementPtr> in_elements, RegisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BlobRegistry::Register", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_type"), in_content_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_disposition"), in_content_disposition,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("elements"), in_elements,
                        "<value of type std::vector<::blink::mojom::DataElementPtr>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlobRegistry_Register_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobRegistry_Register_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
      in_blob, &params->blob, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blob),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_uuid, uuid_fragment);
  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_type)::BaseType> content_type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_content_type, content_type_fragment);
  params->content_type.Set(
      content_type_fragment.is_null() ? nullptr : content_type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_type in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_disposition)::BaseType> content_disposition_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_content_disposition, content_disposition_fragment);
  params->content_disposition.Set(
      content_disposition_fragment.is_null() ? nullptr : content_disposition_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content_disposition.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_disposition in BlobRegistry.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->elements)::BaseType>
      elements_fragment(params.message());
  const mojo::internal::ContainerValidateParams elements_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::DataElementDataView>>(
      in_elements, elements_fragment, &elements_validate_params);
  params->elements.Set(
      elements_fragment.is_null() ? nullptr : elements_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->elements.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null elements in BlobRegistry.Register request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobRegistry::Name_);
  message.set_method_name("Register");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobRegistry_Register_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BlobRegistryProxy::RegisterFromStream(
    const std::string& in_content_type, const std::string& in_content_disposition, uint64_t in_length_hint, ::mojo::ScopedDataPipeConsumerHandle in_data, ::mojo::PendingAssociatedRemote<ProgressClient> in_progress_client, RegisterFromStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BlobRegistry::RegisterFromStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_type"), in_content_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_disposition"), in_content_disposition,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length_hint"), in_length_hint,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("progress_client"), in_progress_client,
                        "<value of type ::mojo::PendingAssociatedRemote<ProgressClient>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlobRegistry_RegisterFromStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobRegistry_RegisterFromStream_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->content_type)::BaseType> content_type_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_content_type, content_type_fragment);
  params->content_type.Set(
      content_type_fragment.is_null() ? nullptr : content_type_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_type in BlobRegistry.RegisterFromStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_disposition)::BaseType> content_disposition_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_content_disposition, content_disposition_fragment);
  params->content_disposition.Set(
      content_disposition_fragment.is_null() ? nullptr : content_disposition_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content_disposition.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_disposition in BlobRegistry.RegisterFromStream request");
  params->length_hint = in_length_hint;
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_data, &params->data, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->data),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid data in BlobRegistry.RegisterFromStream request");
  mojo::internal::Serialize<::blink::mojom::ProgressClientAssociatedPtrInfoDataView>(
      in_progress_client, &params->progress_client, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobRegistry::Name_);
  message.set_method_name("RegisterFromStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobRegistry_RegisterFromStream_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool BlobRegistryProxy::GetBlobFromUUID(
    ::mojo::PendingReceiver<::blink::mojom::Blob> param_blob, const std::string& param_uuid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::BlobRegistry::GetBlobFromUUID", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), param_blob,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), param_uuid,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlobRegistry_GetBlobFromUUID_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobRegistry_GetBlobFromUUID_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
      param_blob, &params->blob, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blob),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in BlobRegistry.GetBlobFromUUID request");
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_uuid, uuid_fragment);
  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in BlobRegistry.GetBlobFromUUID request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobRegistry::Name_);
  message.set_method_name("GetBlobFromUUID");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobRegistry_GetBlobFromUUID_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "blink::mojom::BlobRegistry::GetBlobFromUUID");
#endif
  return result;
}

void BlobRegistryProxy::GetBlobFromUUID(
    ::mojo::PendingReceiver<::blink::mojom::Blob> in_blob, const std::string& in_uuid, GetBlobFromUUIDCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BlobRegistry::GetBlobFromUUID", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlobRegistry_GetBlobFromUUID_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobRegistry_GetBlobFromUUID_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
      in_blob, &params->blob, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blob),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in BlobRegistry.GetBlobFromUUID request");
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_uuid, uuid_fragment);
  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->uuid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in BlobRegistry.GetBlobFromUUID request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobRegistry::Name_);
  message.set_method_name("GetBlobFromUUID");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobRegistry_GetBlobFromUUID_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void BlobRegistryProxy::URLStoreForOrigin(
    const ::url::Origin& in_origin, ::mojo::PendingAssociatedReceiver<::blink::mojom::BlobURLStore> in_url_store) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BlobRegistry::URLStoreForOrigin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_store"), in_url_store,
                        "<value of type ::mojo::PendingAssociatedReceiver<::blink::mojom::BlobURLStore>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlobRegistry_URLStoreForOrigin_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobRegistry_URLStoreForOrigin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in BlobRegistry.URLStoreForOrigin request");
  mojo::internal::Serialize<::blink::mojom::BlobURLStoreAssociatedRequestDataView>(
      in_url_store, &params->url_store, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->url_store),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid url_store in BlobRegistry.URLStoreForOrigin request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobRegistry::Name_);
  message.set_method_name("URLStoreForOrigin");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class BlobRegistry_Register_ProxyToResponder {
 public:
  static BlobRegistry::RegisterCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BlobRegistry_Register_ProxyToResponder> proxy(
        new BlobRegistry_Register_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BlobRegistry_Register_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobRegistry_Register_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BlobRegistry_Register_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobRegistry::RegisterCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BlobRegistry_Register_ProxyToResponder);
};

bool BlobRegistry_Register_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BlobRegistry::RegisterCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BlobRegistry_Register_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobRegistry_Register_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BlobRegistry_Register_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobRegistry::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void BlobRegistry_Register_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::BlobRegistry::RegisterCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlobRegistry_Register_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobRegistry_Register_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BlobRegistry::RegisterCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobRegistry::Name_);
  message.set_method_name("Register");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool BlobRegistry_Register_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::BlobRegistry_Register_ResponseParams_Data* params =
      reinterpret_cast<internal::BlobRegistry_Register_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  BlobRegistry_Register_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobRegistry::Name_, 0, true);
    return false;
  }
  *result_ = true;
  return true;
}
class BlobRegistry_RegisterFromStream_ProxyToResponder {
 public:
  static BlobRegistry::RegisterFromStreamCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BlobRegistry_RegisterFromStream_ProxyToResponder> proxy(
        new BlobRegistry_RegisterFromStream_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BlobRegistry_RegisterFromStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobRegistry_RegisterFromStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BlobRegistry_RegisterFromStream_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobRegistry::RegisterFromStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::SerializedBlobPtr in_blob);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BlobRegistry_RegisterFromStream_ProxyToResponder);
};

bool BlobRegistry_RegisterFromStream_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BlobRegistry::RegisterFromStreamCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BlobRegistry_RegisterFromStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobRegistry_RegisterFromStream_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::blink::mojom::SerializedBlobPtr p_blob{};
  BlobRegistry_RegisterFromStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBlob(&p_blob))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobRegistry::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_blob));
  return true;
}

void BlobRegistry_RegisterFromStream_ProxyToResponder::Run(
    ::blink::mojom::SerializedBlobPtr in_blob) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::BlobRegistry::RegisterFromStreamCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::blink::mojom::SerializedBlobPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlobRegistry_RegisterFromStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobRegistry_RegisterFromStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->blob)::BaseType> blob_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::SerializedBlobDataView>(
      in_blob, blob_fragment);
  params->blob.Set(
      blob_fragment.is_null() ? nullptr : blob_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BlobRegistry::RegisterFromStreamCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobRegistry::Name_);
  message.set_method_name("RegisterFromStream");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BlobRegistry_GetBlobFromUUID_ProxyToResponder {
 public:
  static BlobRegistry::GetBlobFromUUIDCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BlobRegistry_GetBlobFromUUID_ProxyToResponder> proxy(
        new BlobRegistry_GetBlobFromUUID_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BlobRegistry_GetBlobFromUUID_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobRegistry_GetBlobFromUUID_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BlobRegistry_GetBlobFromUUID_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobRegistry::GetBlobFromUUIDCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BlobRegistry_GetBlobFromUUID_ProxyToResponder);
};

bool BlobRegistry_GetBlobFromUUID_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::BlobRegistry::GetBlobFromUUIDCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BlobRegistry_GetBlobFromUUID_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobRegistry_GetBlobFromUUID_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BlobRegistry_GetBlobFromUUID_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobRegistry::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void BlobRegistry_GetBlobFromUUID_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::BlobRegistry::GetBlobFromUUIDCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBlobRegistry_GetBlobFromUUID_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobRegistry_GetBlobFromUUID_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::BlobRegistry::GetBlobFromUUIDCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobRegistry::Name_);
  message.set_method_name("GetBlobFromUUID");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool BlobRegistry_GetBlobFromUUID_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::BlobRegistry_GetBlobFromUUID_ResponseParams_Data* params =
      reinterpret_cast<internal::BlobRegistry_GetBlobFromUUID_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  BlobRegistry_GetBlobFromUUID_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobRegistry::Name_, 2, true);
    return false;
  }
  *result_ = true;
  return true;
}

// static
bool BlobRegistryStubDispatch::Accept(
    BlobRegistry* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBlobRegistry_Register_Name: {
      break;
    }
    case internal::kBlobRegistry_RegisterFromStream_Name: {
      break;
    }
    case internal::kBlobRegistry_GetBlobFromUUID_Name: {
      break;
    }
    case internal::kBlobRegistry_URLStoreForOrigin_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BlobRegistry::URLStoreForOrigin",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BlobRegistry::URLStoreForOrigin");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BlobRegistry_URLStoreForOrigin_Params_Data* params =
          reinterpret_cast<internal::BlobRegistry_URLStoreForOrigin_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      ::mojo::PendingAssociatedReceiver<::blink::mojom::BlobURLStore> p_url_store{};
      BlobRegistry_URLStoreForOrigin_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success) {
        p_url_store =
            input_data_view.TakeUrlStore<decltype(p_url_store)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobRegistry::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->URLStoreForOrigin(
std::move(p_origin), 
std::move(p_url_store));
      return true;
    }
  }
  return false;
}

// static
bool BlobRegistryStubDispatch::AcceptWithResponder(
    BlobRegistry* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBlobRegistry_Register_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BlobRegistry::Register",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BlobRegistry::Register");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BlobRegistry_Register_Params_Data* params =
          reinterpret_cast<
              internal::BlobRegistry_Register_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::Blob> p_blob{};
      std::string p_uuid{};
      std::string p_content_type{};
      std::string p_content_disposition{};
      std::vector<::blink::mojom::DataElementPtr> p_elements{};
      BlobRegistry_Register_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success && !input_data_view.ReadContentType(&p_content_type))
        success = false;
      if (success && !input_data_view.ReadContentDisposition(&p_content_disposition))
        success = false;
      if (success && !input_data_view.ReadElements(&p_elements))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobRegistry::Name_, 0, false);
        return false;
      }
      BlobRegistry::RegisterCallback callback =
          BlobRegistry_Register_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Register(
std::move(p_blob), 
std::move(p_uuid), 
std::move(p_content_type), 
std::move(p_content_disposition), 
std::move(p_elements), std::move(callback));
      return true;
    }
    case internal::kBlobRegistry_RegisterFromStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BlobRegistry::RegisterFromStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BlobRegistry::RegisterFromStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BlobRegistry_RegisterFromStream_Params_Data* params =
          reinterpret_cast<
              internal::BlobRegistry_RegisterFromStream_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_content_type{};
      std::string p_content_disposition{};
      uint64_t p_length_hint{};
      ::mojo::ScopedDataPipeConsumerHandle p_data{};
      ::mojo::PendingAssociatedRemote<ProgressClient> p_progress_client{};
      BlobRegistry_RegisterFromStream_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContentType(&p_content_type))
        success = false;
      if (success && !input_data_view.ReadContentDisposition(&p_content_disposition))
        success = false;
      if (success)
        p_length_hint = input_data_view.length_hint();
      if (success)
        p_data = input_data_view.TakeData();
      if (success) {
        p_progress_client =
            input_data_view.TakeProgressClient<decltype(p_progress_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobRegistry::Name_, 1, false);
        return false;
      }
      BlobRegistry::RegisterFromStreamCallback callback =
          BlobRegistry_RegisterFromStream_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterFromStream(
std::move(p_content_type), 
std::move(p_content_disposition), 
std::move(p_length_hint), 
std::move(p_data), 
std::move(p_progress_client), std::move(callback));
      return true;
    }
    case internal::kBlobRegistry_GetBlobFromUUID_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BlobRegistry::GetBlobFromUUID",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BlobRegistry::GetBlobFromUUID");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BlobRegistry_GetBlobFromUUID_Params_Data* params =
          reinterpret_cast<
              internal::BlobRegistry_GetBlobFromUUID_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::Blob> p_blob{};
      std::string p_uuid{};
      BlobRegistry_GetBlobFromUUID_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobRegistry::Name_, 2, false);
        return false;
      }
      BlobRegistry::GetBlobFromUUIDCallback callback =
          BlobRegistry_GetBlobFromUUID_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBlobFromUUID(
std::move(p_blob), 
std::move(p_uuid), std::move(callback));
      return true;
    }
    case internal::kBlobRegistry_URLStoreForOrigin_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kBlobRegistryValidationInfo[] = {
    {&internal::BlobRegistry_Register_Params_Data::Validate,
     &internal::BlobRegistry_Register_ResponseParams_Data::Validate},
    {&internal::BlobRegistry_RegisterFromStream_Params_Data::Validate,
     &internal::BlobRegistry_RegisterFromStream_ResponseParams_Data::Validate},
    {&internal::BlobRegistry_GetBlobFromUUID_Params_Data::Validate,
     &internal::BlobRegistry_GetBlobFromUUID_ResponseParams_Data::Validate},
    {&internal::BlobRegistry_URLStoreForOrigin_Params_Data::Validate,
     nullptr /* no response */},
};

bool BlobRegistryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::BlobRegistry::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kBlobRegistryValidationInfo);
}

bool BlobRegistryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::BlobRegistry::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kBlobRegistryValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif