// third_party/blink/public/mojom/choosers/color_chooser.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/choosers/color_chooser.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/choosers/color_chooser.mojom-params-data.h"
#include "third_party/blink/public/mojom/choosers/color_chooser.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/choosers/color_chooser.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_COLOR_CHOOSER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_COLOR_CHOOSER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
ColorSuggestion::ColorSuggestion()
    : color(),
      label() {}

ColorSuggestion::ColorSuggestion(
    uint32_t color_in,
    const std::string& label_in)
    : color(std::move(color_in)),
      label(std::move(label_in)) {}

ColorSuggestion::~ColorSuggestion() = default;
size_t ColorSuggestion::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->color);
  seed = mojo::internal::Hash(seed, this->label);
  return seed;
}

void ColorSuggestion::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ColorSuggestion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ColorChooserFactory::Name_[] = "blink.mojom.ColorChooserFactory";

ColorChooserFactoryProxy::ColorChooserFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ColorChooserFactoryProxy::OpenColorChooser(
    ::mojo::PendingReceiver<ColorChooser> in_chooser, ::mojo::PendingRemote<ColorChooserClient> in_client, uint32_t in_color, std::vector<ColorSuggestionPtr> in_suggestions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ColorChooserFactory::OpenColorChooser", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("chooser"), in_chooser,
                        "<value of type ::mojo::PendingReceiver<ColorChooser>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<ColorChooserClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color"), in_color,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suggestions"), in_suggestions,
                        "<value of type std::vector<ColorSuggestionPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kColorChooserFactory_OpenColorChooser_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ColorChooserFactory_OpenColorChooser_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ColorChooserInterfaceBase>>(
      in_chooser, &params->chooser, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->chooser),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid chooser in ColorChooserFactory.OpenColorChooser request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ColorChooserClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in ColorChooserFactory.OpenColorChooser request");
  params->color = in_color;
  mojo::internal::MessageFragment<
      typename decltype(params->suggestions)::BaseType>
      suggestions_fragment(params.message());
  const mojo::internal::ContainerValidateParams suggestions_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ColorSuggestionDataView>>(
      in_suggestions, suggestions_fragment, &suggestions_validate_params);
  params->suggestions.Set(
      suggestions_fragment.is_null() ? nullptr : suggestions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->suggestions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null suggestions in ColorChooserFactory.OpenColorChooser request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ColorChooserFactory::Name_);
  message.set_method_name("OpenColorChooser");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ColorChooserFactoryStubDispatch::Accept(
    ColorChooserFactory* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kColorChooserFactory_OpenColorChooser_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ColorChooserFactory::OpenColorChooser",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ColorChooserFactory::OpenColorChooser");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ColorChooserFactory_OpenColorChooser_Params_Data* params =
          reinterpret_cast<internal::ColorChooserFactory_OpenColorChooser_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<ColorChooser> p_chooser{};
      ::mojo::PendingRemote<ColorChooserClient> p_client{};
      uint32_t p_color{};
      std::vector<ColorSuggestionPtr> p_suggestions{};
      ColorChooserFactory_OpenColorChooser_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_chooser =
            input_data_view.TakeChooser<decltype(p_chooser)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success)
        p_color = input_data_view.color();
      if (success && !input_data_view.ReadSuggestions(&p_suggestions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ColorChooserFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenColorChooser(
std::move(p_chooser), 
std::move(p_client), 
std::move(p_color), 
std::move(p_suggestions));
      return true;
    }
  }
  return false;
}

// static
bool ColorChooserFactoryStubDispatch::AcceptWithResponder(
    ColorChooserFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kColorChooserFactory_OpenColorChooser_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kColorChooserFactoryValidationInfo[] = {
    {&internal::ColorChooserFactory_OpenColorChooser_Params_Data::Validate,
     nullptr /* no response */},
};

bool ColorChooserFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ColorChooserFactory::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kColorChooserFactoryValidationInfo);
}

const char ColorChooser::Name_[] = "blink.mojom.ColorChooser";

ColorChooserProxy::ColorChooserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ColorChooserProxy::SetSelectedColor(
    uint32_t in_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ColorChooser::SetSelectedColor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color"), in_color,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kColorChooser_SetSelectedColor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ColorChooser_SetSelectedColor_Params_Data> params(
          message);
  params.Allocate();
  params->color = in_color;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ColorChooser::Name_);
  message.set_method_name("SetSelectedColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ColorChooserStubDispatch::Accept(
    ColorChooser* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kColorChooser_SetSelectedColor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ColorChooser::SetSelectedColor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ColorChooser::SetSelectedColor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ColorChooser_SetSelectedColor_Params_Data* params =
          reinterpret_cast<internal::ColorChooser_SetSelectedColor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_color{};
      ColorChooser_SetSelectedColor_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_color = input_data_view.color();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ColorChooser::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSelectedColor(
std::move(p_color));
      return true;
    }
  }
  return false;
}

// static
bool ColorChooserStubDispatch::AcceptWithResponder(
    ColorChooser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kColorChooser_SetSelectedColor_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kColorChooserValidationInfo[] = {
    {&internal::ColorChooser_SetSelectedColor_Params_Data::Validate,
     nullptr /* no response */},
};

bool ColorChooserRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ColorChooser::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kColorChooserValidationInfo);
}

const char ColorChooserClient::Name_[] = "blink.mojom.ColorChooserClient";

ColorChooserClientProxy::ColorChooserClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ColorChooserClientProxy::DidChooseColor(
    uint32_t in_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ColorChooserClient::DidChooseColor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color"), in_color,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kColorChooserClient_DidChooseColor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ColorChooserClient_DidChooseColor_Params_Data> params(
          message);
  params.Allocate();
  params->color = in_color;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ColorChooserClient::Name_);
  message.set_method_name("DidChooseColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ColorChooserClientStubDispatch::Accept(
    ColorChooserClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kColorChooserClient_DidChooseColor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ColorChooserClient::DidChooseColor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ColorChooserClient::DidChooseColor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ColorChooserClient_DidChooseColor_Params_Data* params =
          reinterpret_cast<internal::ColorChooserClient_DidChooseColor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_color{};
      ColorChooserClient_DidChooseColor_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_color = input_data_view.color();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ColorChooserClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChooseColor(
std::move(p_color));
      return true;
    }
  }
  return false;
}

// static
bool ColorChooserClientStubDispatch::AcceptWithResponder(
    ColorChooserClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kColorChooserClient_DidChooseColor_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kColorChooserClientValidationInfo[] = {
    {&internal::ColorChooserClient_DidChooseColor_Params_Data::Validate,
     nullptr /* no response */},
};

bool ColorChooserClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ColorChooserClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kColorChooserClientValidationInfo);
}

const char EyeDropperChooser::Name_[] = "blink.mojom.EyeDropperChooser";

class EyeDropperChooser_Choose_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  EyeDropperChooser_Choose_ForwardToCallback(
      EyeDropperChooser::ChooseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  EyeDropperChooser::ChooseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(EyeDropperChooser_Choose_ForwardToCallback);
};

EyeDropperChooserProxy::EyeDropperChooserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EyeDropperChooserProxy::Choose(
    ChooseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::EyeDropperChooser::Choose");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kEyeDropperChooser_Choose_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EyeDropperChooser_Choose_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EyeDropperChooser::Name_);
  message.set_method_name("Choose");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new EyeDropperChooser_Choose_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class EyeDropperChooser_Choose_ProxyToResponder {
 public:
  static EyeDropperChooser::ChooseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<EyeDropperChooser_Choose_ProxyToResponder> proxy(
        new EyeDropperChooser_Choose_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&EyeDropperChooser_Choose_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~EyeDropperChooser_Choose_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  EyeDropperChooser_Choose_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "EyeDropperChooser::ChooseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, uint32_t in_color);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(EyeDropperChooser_Choose_ProxyToResponder);
};

bool EyeDropperChooser_Choose_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::EyeDropperChooser::ChooseCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::EyeDropperChooser_Choose_ResponseParams_Data* params =
      reinterpret_cast<
          internal::EyeDropperChooser_Choose_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  uint32_t p_color{};
  EyeDropperChooser_Choose_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success)
    p_color = input_data_view.color();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        EyeDropperChooser::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_color));
  return true;
}

void EyeDropperChooser_Choose_ProxyToResponder::Run(
    bool in_success, uint32_t in_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::EyeDropperChooser::ChooseCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color"), in_color,
                        "<value of type uint32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kEyeDropperChooser_Choose_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EyeDropperChooser_Choose_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  params->color = in_color;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::EyeDropperChooser::ChooseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EyeDropperChooser::Name_);
  message.set_method_name("Choose");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool EyeDropperChooserStubDispatch::Accept(
    EyeDropperChooser* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kEyeDropperChooser_Choose_Name: {
      break;
    }
  }
  return false;
}

// static
bool EyeDropperChooserStubDispatch::AcceptWithResponder(
    EyeDropperChooser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kEyeDropperChooser_Choose_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::EyeDropperChooser::Choose",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::EyeDropperChooser::Choose");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::EyeDropperChooser_Choose_Params_Data* params =
          reinterpret_cast<
              internal::EyeDropperChooser_Choose_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      EyeDropperChooser_Choose_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EyeDropperChooser::Name_, 0, false);
        return false;
      }
      EyeDropperChooser::ChooseCallback callback =
          EyeDropperChooser_Choose_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Choose(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kEyeDropperChooserValidationInfo[] = {
    {&internal::EyeDropperChooser_Choose_Params_Data::Validate,
     &internal::EyeDropperChooser_Choose_ResponseParams_Data::Validate},
};

bool EyeDropperChooserRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::EyeDropperChooser::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kEyeDropperChooserValidationInfo);
}

bool EyeDropperChooserResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::EyeDropperChooser::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kEyeDropperChooserValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::ColorSuggestion::DataView, ::blink::mojom::ColorSuggestionPtr>::Read(
    ::blink::mojom::ColorSuggestion::DataView input,
    ::blink::mojom::ColorSuggestionPtr* output) {
  bool success = true;
  ::blink::mojom::ColorSuggestionPtr result(::blink::mojom::ColorSuggestion::New());
  
      if (success)
        result->color = input.color();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif