// third_party/blink/public/mojom/contacts/contacts_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/contacts/contacts_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/contacts/contacts_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/contacts/contacts_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/contacts/contacts_manager.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTACTS_CONTACTS_MANAGER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTACTS_CONTACTS_MANAGER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
ContactIconBlob::ContactIconBlob()
    : mime_type(),
      data() {}

ContactIconBlob::ContactIconBlob(
    const std::string& mime_type_in,
    std::vector<uint8_t> data_in)
    : mime_type(std::move(mime_type_in)),
      data(std::move(data_in)) {}

ContactIconBlob::~ContactIconBlob() = default;

void ContactIconBlob::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ContactIconBlob::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ContactInfo::ContactInfo()
    : name(),
      email(),
      tel(),
      address(),
      icon() {}

ContactInfo::ContactInfo(
    absl::optional<std::vector<std::string>> name_in,
    absl::optional<std::vector<std::string>> email_in,
    absl::optional<std::vector<std::string>> tel_in,
    absl::optional<std::vector<::payments::mojom::PaymentAddressPtr>> address_in,
    absl::optional<std::vector<ContactIconBlobPtr>> icon_in)
    : name(std::move(name_in)),
      email(std::move(email_in)),
      tel(std::move(tel_in)),
      address(std::move(address_in)),
      icon(std::move(icon_in)) {}

ContactInfo::~ContactInfo() = default;

void ContactInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::vector<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "email"), this->email,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::vector<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tel"), this->tel,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::vector<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "address"), this->address,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<std::vector<::payments::mojom::PaymentAddressPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<std::vector<ContactIconBlobPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ContactInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ContactsManager::Name_[] = "blink.mojom.ContactsManager";

class ContactsManager_Select_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContactsManager_Select_ForwardToCallback(
      ContactsManager::SelectCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ContactsManager::SelectCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ContactsManager_Select_ForwardToCallback);
};

ContactsManagerProxy::ContactsManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContactsManagerProxy::Select(
    bool in_multiple, bool in_include_names, bool in_include_emails, bool in_include_tel, bool in_include_addresses, bool in_include_icons, SelectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ContactsManager::Select", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("multiple"), in_multiple,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("include_names"), in_include_names,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("include_emails"), in_include_emails,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("include_tel"), in_include_tel,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("include_addresses"), in_include_addresses,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("include_icons"), in_include_icons,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kContactsManager_Select_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ContactsManager_Select_Params_Data> params(
          message);
  params.Allocate();
  params->multiple = in_multiple;
  params->include_names = in_include_names;
  params->include_emails = in_include_emails;
  params->include_tel = in_include_tel;
  params->include_addresses = in_include_addresses;
  params->include_icons = in_include_icons;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContactsManager::Name_);
  message.set_method_name("Select");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContactsManager_Select_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ContactsManager_Select_ProxyToResponder {
 public:
  static ContactsManager::SelectCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ContactsManager_Select_ProxyToResponder> proxy(
        new ContactsManager_Select_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ContactsManager_Select_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContactsManager_Select_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ContactsManager_Select_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ContactsManager::SelectCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      absl::optional<std::vector<ContactInfoPtr>> in_contacts);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ContactsManager_Select_ProxyToResponder);
};

bool ContactsManager_Select_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ContactsManager::SelectCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ContactsManager_Select_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContactsManager_Select_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  absl::optional<std::vector<ContactInfoPtr>> p_contacts{};
  ContactsManager_Select_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadContacts(&p_contacts))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContactsManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_contacts));
  return true;
}

void ContactsManager_Select_ProxyToResponder::Run(
    absl::optional<std::vector<ContactInfoPtr>> in_contacts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ContactsManager::SelectCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("contacts"), in_contacts,
                        "<value of type absl::optional<std::vector<ContactInfoPtr>>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kContactsManager_Select_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ContactsManager_Select_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->contacts)::BaseType>
      contacts_fragment(params.message());
  const mojo::internal::ContainerValidateParams contacts_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ContactInfoDataView>>(
      in_contacts, contacts_fragment, &contacts_validate_params);
  params->contacts.Set(
      contacts_fragment.is_null() ? nullptr : contacts_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ContactsManager::SelectCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContactsManager::Name_);
  message.set_method_name("Select");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ContactsManagerStubDispatch::Accept(
    ContactsManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kContactsManager_Select_Name: {
      break;
    }
  }
  return false;
}

// static
bool ContactsManagerStubDispatch::AcceptWithResponder(
    ContactsManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kContactsManager_Select_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ContactsManager::Select",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ContactsManager::Select");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ContactsManager_Select_Params_Data* params =
          reinterpret_cast<
              internal::ContactsManager_Select_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_multiple{};
      bool p_include_names{};
      bool p_include_emails{};
      bool p_include_tel{};
      bool p_include_addresses{};
      bool p_include_icons{};
      ContactsManager_Select_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_multiple = input_data_view.multiple();
      if (success)
        p_include_names = input_data_view.include_names();
      if (success)
        p_include_emails = input_data_view.include_emails();
      if (success)
        p_include_tel = input_data_view.include_tel();
      if (success)
        p_include_addresses = input_data_view.include_addresses();
      if (success)
        p_include_icons = input_data_view.include_icons();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContactsManager::Name_, 0, false);
        return false;
      }
      ContactsManager::SelectCallback callback =
          ContactsManager_Select_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Select(
std::move(p_multiple), 
std::move(p_include_names), 
std::move(p_include_emails), 
std::move(p_include_tel), 
std::move(p_include_addresses), 
std::move(p_include_icons), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kContactsManagerValidationInfo[] = {
    {&internal::ContactsManager_Select_Params_Data::Validate,
     &internal::ContactsManager_Select_ResponseParams_Data::Validate},
};

bool ContactsManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ContactsManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kContactsManagerValidationInfo);
}

bool ContactsManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ContactsManager::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kContactsManagerValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::ContactIconBlob::DataView, ::blink::mojom::ContactIconBlobPtr>::Read(
    ::blink::mojom::ContactIconBlob::DataView input,
    ::blink::mojom::ContactIconBlobPtr* output) {
  bool success = true;
  ::blink::mojom::ContactIconBlobPtr result(::blink::mojom::ContactIconBlob::New());
  
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ContactInfo::DataView, ::blink::mojom::ContactInfoPtr>::Read(
    ::blink::mojom::ContactInfo::DataView input,
    ::blink::mojom::ContactInfoPtr* output) {
  bool success = true;
  ::blink::mojom::ContactInfoPtr result(::blink::mojom::ContactInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadEmail(&result->email))
        success = false;
      if (success && !input.ReadTel(&result->tel))
        success = false;
      if (success && !input.ReadAddress(&result->address))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif