// third_party/blink/public/mojom/conversions/conversions.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/conversions/conversions.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/conversions/conversions.mojom-params-data.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/conversions/conversions.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONVERSIONS_CONVERSIONS_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONVERSIONS_CONVERSIONS_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
DedupKey::DedupKey()
    : value() {}

DedupKey::DedupKey(
    int64_t value_in)
    : value(std::move(value_in)) {}

DedupKey::~DedupKey() = default;
size_t DedupKey::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void DedupKey::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DedupKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Conversion::Conversion()
    : reporting_origin(),
      conversion_data(0ULL),
      event_source_trigger_data(0ULL),
      priority(0),
      dedup_key() {}

Conversion::Conversion(
    const ::url::Origin& reporting_origin_in,
    uint64_t conversion_data_in,
    uint64_t event_source_trigger_data_in,
    int64_t priority_in,
    DedupKeyPtr dedup_key_in)
    : reporting_origin(std::move(reporting_origin_in)),
      conversion_data(std::move(conversion_data_in)),
      event_source_trigger_data(std::move(event_source_trigger_data_in)),
      priority(std::move(priority_in)),
      dedup_key(std::move(dedup_key_in)) {}

Conversion::~Conversion() = default;

void Conversion::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_origin"), this->reporting_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "conversion_data"), this->conversion_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_source_trigger_data"), this->event_source_trigger_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dedup_key"), this->dedup_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DedupKeyPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Conversion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Impression::Impression()
    : conversion_destination(),
      reporting_origin(),
      impression_data(),
      expiry(),
      priority(0) {}

Impression::Impression(
    const ::url::Origin& conversion_destination_in,
    const absl::optional<::url::Origin>& reporting_origin_in,
    uint64_t impression_data_in,
    absl::optional<::base::TimeDelta> expiry_in,
    int64_t priority_in)
    : conversion_destination(std::move(conversion_destination_in)),
      reporting_origin(std::move(reporting_origin_in)),
      impression_data(std::move(impression_data_in)),
      expiry(std::move(expiry_in)),
      priority(std::move(priority_in)) {}

Impression::~Impression() = default;

void Impression::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "conversion_destination"), this->conversion_destination,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_origin"), this->reporting_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "impression_data"), this->impression_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiry"), this->expiry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Impression::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ConversionHost::Name_[] = "blink.mojom.ConversionHost";

ConversionHostProxy::ConversionHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ConversionHostProxy::RegisterConversion(
    ConversionPtr in_conversion) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ConversionHost::RegisterConversion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("conversion"), in_conversion,
                        "<value of type ConversionPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kConversionHost_RegisterConversion_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ConversionHost_RegisterConversion_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->conversion)::BaseType> conversion_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ConversionDataView>(
      in_conversion, conversion_fragment);
  params->conversion.Set(
      conversion_fragment.is_null() ? nullptr : conversion_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->conversion.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null conversion in ConversionHost.RegisterConversion request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConversionHost::Name_);
  message.set_method_name("RegisterConversion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ConversionHostProxy::RegisterImpression(
    const ::blink::Impression& in_impression) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ConversionHost::RegisterImpression", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("impression"), in_impression,
                        "<value of type const ::blink::Impression&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kConversionHost_RegisterImpression_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ConversionHost_RegisterImpression_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->impression)::BaseType> impression_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ImpressionDataView>(
      in_impression, impression_fragment);
  params->impression.Set(
      impression_fragment.is_null() ? nullptr : impression_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->impression.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null impression in ConversionHost.RegisterImpression request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConversionHost::Name_);
  message.set_method_name("RegisterImpression");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ConversionHostStubDispatch::Accept(
    ConversionHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kConversionHost_RegisterConversion_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ConversionHost::RegisterConversion",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ConversionHost::RegisterConversion");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ConversionHost_RegisterConversion_Params_Data* params =
          reinterpret_cast<internal::ConversionHost_RegisterConversion_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ConversionPtr p_conversion{};
      ConversionHost_RegisterConversion_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConversion(&p_conversion))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ConversionHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterConversion(
std::move(p_conversion));
      return true;
    }
    case internal::kConversionHost_RegisterImpression_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ConversionHost::RegisterImpression",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ConversionHost::RegisterImpression");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ConversionHost_RegisterImpression_Params_Data* params =
          reinterpret_cast<internal::ConversionHost_RegisterImpression_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::Impression p_impression{};
      ConversionHost_RegisterImpression_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadImpression(&p_impression))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ConversionHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterImpression(
std::move(p_impression));
      return true;
    }
  }
  return false;
}

// static
bool ConversionHostStubDispatch::AcceptWithResponder(
    ConversionHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kConversionHost_RegisterConversion_Name: {
      break;
    }
    case internal::kConversionHost_RegisterImpression_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kConversionHostValidationInfo[] = {
    {&internal::ConversionHost_RegisterConversion_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ConversionHost_RegisterImpression_Params_Data::Validate,
     nullptr /* no response */},
};

bool ConversionHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ConversionHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kConversionHostValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::DedupKey::DataView, ::blink::mojom::DedupKeyPtr>::Read(
    ::blink::mojom::DedupKey::DataView input,
    ::blink::mojom::DedupKeyPtr* output) {
  bool success = true;
  ::blink::mojom::DedupKeyPtr result(::blink::mojom::DedupKey::New());
  
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::Conversion::DataView, ::blink::mojom::ConversionPtr>::Read(
    ::blink::mojom::Conversion::DataView input,
    ::blink::mojom::ConversionPtr* output) {
  bool success = true;
  ::blink::mojom::ConversionPtr result(::blink::mojom::Conversion::New());
  
      if (success && !input.ReadReportingOrigin(&result->reporting_origin))
        success = false;
      if (success)
        result->conversion_data = input.conversion_data();
      if (success)
        result->event_source_trigger_data = input.event_source_trigger_data();
      if (success)
        result->priority = input.priority();
      if (success && !input.ReadDedupKey(&result->dedup_key))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::Impression::DataView, ::blink::mojom::ImpressionPtr>::Read(
    ::blink::mojom::Impression::DataView input,
    ::blink::mojom::ImpressionPtr* output) {
  bool success = true;
  ::blink::mojom::ImpressionPtr result(::blink::mojom::Impression::New());
  
      if (success && !input.ReadConversionDestination(&result->conversion_destination))
        success = false;
      if (success && !input.ReadReportingOrigin(&result->reporting_origin))
        success = false;
      if (success)
        result->impression_data = input.impression_data();
      if (success && !input.ReadExpiry(&result->expiry))
        success = false;
      if (success)
        result->priority = input.priority();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif