// third_party/blink/public/mojom/devtools/devtools_frontend.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/devtools/devtools_frontend.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/devtools/devtools_frontend.mojom-params-data.h"
#include "third_party/blink/public/mojom/devtools/devtools_frontend.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/devtools/devtools_frontend.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_DEVTOOLS_FRONTEND_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_DEVTOOLS_FRONTEND_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char DevToolsFrontend::Name_[] = "blink.mojom.DevToolsFrontend";

DevToolsFrontendProxy::DevToolsFrontendProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevToolsFrontendProxy::SetupDevToolsFrontend(
    const WTF::String& in_api_script, ::mojo::PendingAssociatedRemote<DevToolsFrontendHost> in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::DevToolsFrontend::SetupDevToolsFrontend", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("api_script"), in_api_script,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingAssociatedRemote<DevToolsFrontendHost>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsFrontend_SetupDevToolsFrontend_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsFrontend_SetupDevToolsFrontend_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->api_script)::BaseType> api_script_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_api_script, api_script_fragment);
  params->api_script.Set(
      api_script_fragment.is_null() ? nullptr : api_script_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->api_script.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null api_script in DevToolsFrontend.SetupDevToolsFrontend request");
  mojo::internal::Serialize<::blink::mojom::DevToolsFrontendHostAssociatedPtrInfoDataView>(
      in_host, &params->host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid host in DevToolsFrontend.SetupDevToolsFrontend request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsFrontend::Name_);
  message.set_method_name("SetupDevToolsFrontend");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DevToolsFrontendProxy::SetupDevToolsExtensionAPI(
    const WTF::String& in_extension_api) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::DevToolsFrontend::SetupDevToolsExtensionAPI", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_api"), in_extension_api,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsFrontend_SetupDevToolsExtensionAPI_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsFrontend_SetupDevToolsExtensionAPI_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_api)::BaseType> extension_api_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_api, extension_api_fragment);
  params->extension_api.Set(
      extension_api_fragment.is_null() ? nullptr : extension_api_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_api.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_api in DevToolsFrontend.SetupDevToolsExtensionAPI request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsFrontend::Name_);
  message.set_method_name("SetupDevToolsExtensionAPI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DevToolsFrontendStubDispatch::Accept(
    DevToolsFrontend* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDevToolsFrontend_SetupDevToolsFrontend_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DevToolsFrontend::SetupDevToolsFrontend",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DevToolsFrontend::SetupDevToolsFrontend");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsFrontend_SetupDevToolsFrontend_Params_Data* params =
          reinterpret_cast<internal::DevToolsFrontend_SetupDevToolsFrontend_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_api_script{};
      ::mojo::PendingAssociatedRemote<DevToolsFrontendHost> p_host{};
      DevToolsFrontend_SetupDevToolsFrontend_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadApiScript(&p_api_script))
        success = false;
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsFrontend::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetupDevToolsFrontend(
std::move(p_api_script), 
std::move(p_host));
      return true;
    }
    case internal::kDevToolsFrontend_SetupDevToolsExtensionAPI_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DevToolsFrontend::SetupDevToolsExtensionAPI",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DevToolsFrontend::SetupDevToolsExtensionAPI");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsFrontend_SetupDevToolsExtensionAPI_Params_Data* params =
          reinterpret_cast<internal::DevToolsFrontend_SetupDevToolsExtensionAPI_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_extension_api{};
      DevToolsFrontend_SetupDevToolsExtensionAPI_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionApi(&p_extension_api))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsFrontend::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetupDevToolsExtensionAPI(
std::move(p_extension_api));
      return true;
    }
  }
  return false;
}

// static
bool DevToolsFrontendStubDispatch::AcceptWithResponder(
    DevToolsFrontend* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDevToolsFrontend_SetupDevToolsFrontend_Name: {
      break;
    }
    case internal::kDevToolsFrontend_SetupDevToolsExtensionAPI_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kDevToolsFrontendValidationInfo[] = {
    {&internal::DevToolsFrontend_SetupDevToolsFrontend_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::DevToolsFrontend_SetupDevToolsExtensionAPI_Params_Data::Validate,
     nullptr /* no response */},
};

bool DevToolsFrontendRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::DevToolsFrontend::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kDevToolsFrontendValidationInfo);
}

const char DevToolsFrontendHost::Name_[] = "blink.mojom.DevToolsFrontendHost";

DevToolsFrontendHostProxy::DevToolsFrontendHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevToolsFrontendHostProxy::DispatchEmbedderMessage(
    ::base::Value in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::DevToolsFrontendHost::DispatchEmbedderMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type ::base::Value>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDevToolsFrontendHost_DispatchEmbedderMessage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsFrontendHost_DispatchEmbedderMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in DevToolsFrontendHost.DispatchEmbedderMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsFrontendHost::Name_);
  message.set_method_name("DispatchEmbedderMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DevToolsFrontendHostStubDispatch::Accept(
    DevToolsFrontendHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDevToolsFrontendHost_DispatchEmbedderMessage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::DevToolsFrontendHost::DispatchEmbedderMessage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::DevToolsFrontendHost::DispatchEmbedderMessage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DevToolsFrontendHost_DispatchEmbedderMessage_Params_Data* params =
          reinterpret_cast<internal::DevToolsFrontendHost_DispatchEmbedderMessage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::Value p_message{};
      DevToolsFrontendHost_DispatchEmbedderMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsFrontendHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchEmbedderMessage(
std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool DevToolsFrontendHostStubDispatch::AcceptWithResponder(
    DevToolsFrontendHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDevToolsFrontendHost_DispatchEmbedderMessage_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kDevToolsFrontendHostValidationInfo[] = {
    {&internal::DevToolsFrontendHost_DispatchEmbedderMessage_Params_Data::Validate,
     nullptr /* no response */},
};

bool DevToolsFrontendHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::DevToolsFrontendHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kDevToolsFrontendHostValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif