// third_party/blink/public/mojom/devtools/inspector_issue.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-params-data.h"
#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
AffectedCookie::AffectedCookie()
    : name(),
      path(),
      domain() {}

AffectedCookie::AffectedCookie(
    const std::string& name_in,
    const std::string& path_in,
    const std::string& domain_in)
    : name(std::move(name_in)),
      path(std::move(path_in)),
      domain(std::move(domain_in)) {}

AffectedCookie::~AffectedCookie() = default;
size_t AffectedCookie::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->path);
  seed = mojo::internal::Hash(seed, this->domain);
  return seed;
}

void AffectedCookie::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "domain"), this->domain,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AffectedCookie::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AffectedRequest::AffectedRequest()
    : request_id(),
      url() {}

AffectedRequest::AffectedRequest(
    const std::string& request_id_in,
    const absl::optional<std::string>& url_in)
    : request_id(std::move(request_id_in)),
      url(std::move(url_in)) {}

AffectedRequest::~AffectedRequest() = default;

void AffectedRequest::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AffectedRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AffectedFrame::AffectedFrame()
    : frame_id() {}

AffectedFrame::AffectedFrame(
    const std::string& frame_id_in)
    : frame_id(std::move(frame_id_in)) {}

AffectedFrame::~AffectedFrame() = default;
size_t AffectedFrame::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->frame_id);
  return seed;
}

void AffectedFrame::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_id"), this->frame_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AffectedFrame::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AffectedLocation::AffectedLocation()
    : script_id(),
      url(),
      line(0U),
      column(0U) {}

AffectedLocation::AffectedLocation(
    const absl::optional<std::string>& script_id_in,
    const absl::optional<std::string>& url_in,
    uint32_t line_in,
    uint32_t column_in)
    : script_id(std::move(script_id_in)),
      url(std::move(url_in)),
      line(std::move(line_in)),
      column(std::move(column_in)) {}

AffectedLocation::~AffectedLocation() = default;

void AffectedLocation::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_id"), this->script_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "line"), this->line,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "column"), this->column,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AffectedLocation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BlockedByResponseIssueDetails::BlockedByResponseIssueDetails()
    : request(),
      parentFrame(),
      blockedFrame(),
      reason() {}

BlockedByResponseIssueDetails::BlockedByResponseIssueDetails(
    AffectedRequestPtr request_in,
    AffectedFramePtr parentFrame_in,
    AffectedFramePtr blockedFrame_in,
    ::network::mojom::BlockedByResponseReason reason_in)
    : request(std::move(request_in)),
      parentFrame(std::move(parentFrame_in)),
      blockedFrame(std::move(blockedFrame_in)),
      reason(std::move(reason_in)) {}

BlockedByResponseIssueDetails::~BlockedByResponseIssueDetails() = default;

void BlockedByResponseIssueDetails::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request"), this->request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AffectedRequestPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parentFrame"), this->parentFrame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AffectedFramePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blockedFrame"), this->blockedFrame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AffectedFramePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reason"), this->reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::BlockedByResponseReason>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BlockedByResponseIssueDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HeavyAdIssueDetails::HeavyAdIssueDetails()
    : resolution(),
      reason(),
      frame() {}

HeavyAdIssueDetails::HeavyAdIssueDetails(
    HeavyAdResolutionStatus resolution_in,
    HeavyAdReason reason_in,
    AffectedFramePtr frame_in)
    : resolution(std::move(resolution_in)),
      reason(std::move(reason_in)),
      frame(std::move(frame_in)) {}

HeavyAdIssueDetails::~HeavyAdIssueDetails() = default;
size_t HeavyAdIssueDetails::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->resolution);
  seed = mojo::internal::Hash(seed, this->reason);
  seed = mojo::internal::Hash(seed, this->frame);
  return seed;
}

void HeavyAdIssueDetails::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resolution"), this->resolution,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type HeavyAdResolutionStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reason"), this->reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type HeavyAdReason>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame"), this->frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AffectedFramePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HeavyAdIssueDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MixedContentIssueDetails::MixedContentIssueDetails()
    : request_context(),
      resolution_status(),
      insecure_url(),
      main_resource_url(),
      request(),
      frame() {}

MixedContentIssueDetails::MixedContentIssueDetails(
    ::blink::mojom::RequestContextType request_context_in,
    MixedContentResolutionStatus resolution_status_in,
    const std::string& insecure_url_in,
    const std::string& main_resource_url_in,
    AffectedRequestPtr request_in,
    AffectedFramePtr frame_in)
    : request_context(std::move(request_context_in)),
      resolution_status(std::move(resolution_status_in)),
      insecure_url(std::move(insecure_url_in)),
      main_resource_url(std::move(main_resource_url_in)),
      request(std::move(request_in)),
      frame(std::move(frame_in)) {}

MixedContentIssueDetails::~MixedContentIssueDetails() = default;

void MixedContentIssueDetails::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_context"), this->request_context,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::RequestContextType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resolution_status"), this->resolution_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MixedContentResolutionStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "insecure_url"), this->insecure_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_resource_url"), this->main_resource_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request"), this->request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AffectedRequestPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame"), this->frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AffectedFramePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MixedContentIssueDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetails()
    : blocked_url(),
      violated_directive(),
      is_report_only(),
      content_security_policy_violation_type(),
      frame_ancestor(),
      affected_location(),
      violating_node_id(0) {}

ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetails(
    const absl::optional<::GURL>& blocked_url_in,
    const std::string& violated_directive_in,
    bool is_report_only_in,
    ContentSecurityPolicyViolationType content_security_policy_violation_type_in,
    AffectedFramePtr frame_ancestor_in,
    AffectedLocationPtr affected_location_in,
    int32_t violating_node_id_in)
    : blocked_url(std::move(blocked_url_in)),
      violated_directive(std::move(violated_directive_in)),
      is_report_only(std::move(is_report_only_in)),
      content_security_policy_violation_type(std::move(content_security_policy_violation_type_in)),
      frame_ancestor(std::move(frame_ancestor_in)),
      affected_location(std::move(affected_location_in)),
      violating_node_id(std::move(violating_node_id_in)) {}

ContentSecurityPolicyIssueDetails::~ContentSecurityPolicyIssueDetails() = default;

void ContentSecurityPolicyIssueDetails::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blocked_url"), this->blocked_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "violated_directive"), this->violated_directive,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_report_only"), this->is_report_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_security_policy_violation_type"), this->content_security_policy_violation_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ContentSecurityPolicyViolationType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_ancestor"), this->frame_ancestor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AffectedFramePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "affected_location"), this->affected_location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AffectedLocationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "violating_node_id"), this->violating_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ContentSecurityPolicyIssueDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SameSiteCookieIssueDetails::SameSiteCookieIssueDetails()
    : cookie(),
      exclusion_reason(),
      warning_reason(),
      operation(),
      site_for_cookies(),
      cookie_url(),
      request() {}

SameSiteCookieIssueDetails::SameSiteCookieIssueDetails(
    AffectedCookiePtr cookie_in,
    std::vector<SameSiteCookieExclusionReason> exclusion_reason_in,
    std::vector<SameSiteCookieWarningReason> warning_reason_in,
    SameSiteCookieOperation operation_in,
    const absl::optional<::GURL>& site_for_cookies_in,
    const absl::optional<::GURL>& cookie_url_in,
    AffectedRequestPtr request_in)
    : cookie(std::move(cookie_in)),
      exclusion_reason(std::move(exclusion_reason_in)),
      warning_reason(std::move(warning_reason_in)),
      operation(std::move(operation_in)),
      site_for_cookies(std::move(site_for_cookies_in)),
      cookie_url(std::move(cookie_url_in)),
      request(std::move(request_in)) {}

SameSiteCookieIssueDetails::~SameSiteCookieIssueDetails() = default;

void SameSiteCookieIssueDetails::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie"), this->cookie,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AffectedCookiePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclusion_reason"), this->exclusion_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<SameSiteCookieExclusionReason>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "warning_reason"), this->warning_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<SameSiteCookieWarningReason>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "operation"), this->operation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SameSiteCookieOperation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_for_cookies"), this->site_for_cookies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_url"), this->cookie_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request"), this->request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AffectedRequestPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SameSiteCookieIssueDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetails()
    : affected_location(),
      is_warning(),
      type() {}

SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetails(
    AffectedLocationPtr affected_location_in,
    bool is_warning_in,
    SharedArrayBufferIssueType type_in)
    : affected_location(std::move(affected_location_in)),
      is_warning(std::move(is_warning_in)),
      type(std::move(type_in)) {}

SharedArrayBufferIssueDetails::~SharedArrayBufferIssueDetails() = default;

void SharedArrayBufferIssueDetails::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "affected_location"), this->affected_location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AffectedLocationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_warning"), this->is_warning,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SharedArrayBufferIssueType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedArrayBufferIssueDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrustedWebActivityIssueDetails::TrustedWebActivityIssueDetails()
    : url(),
      violation_type(),
      http_error_code(0),
      package_name(),
      signature() {}

TrustedWebActivityIssueDetails::TrustedWebActivityIssueDetails(
    const ::GURL& url_in,
    TwaQualityEnforcementViolationType violation_type_in,
    int32_t http_error_code_in,
    const absl::optional<std::string>& package_name_in,
    const absl::optional<std::string>& signature_in)
    : url(std::move(url_in)),
      violation_type(std::move(violation_type_in)),
      http_error_code(std::move(http_error_code_in)),
      package_name(std::move(package_name_in)),
      signature(std::move(signature_in)) {}

TrustedWebActivityIssueDetails::~TrustedWebActivityIssueDetails() = default;

void TrustedWebActivityIssueDetails::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "violation_type"), this->violation_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TwaQualityEnforcementViolationType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "http_error_code"), this->http_error_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "package_name"), this->package_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signature"), this->signature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustedWebActivityIssueDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LowTextContrastIssue::LowTextContrastIssue()
    : violating_node_id(),
      violating_node_selector(),
      contrast_ratio(),
      threshold_aa(),
      threshold_aaa(),
      font_size(),
      font_weight() {}

LowTextContrastIssue::LowTextContrastIssue(
    int32_t violating_node_id_in,
    const std::string& violating_node_selector_in,
    float contrast_ratio_in,
    float threshold_aa_in,
    float threshold_aaa_in,
    const std::string& font_size_in,
    const std::string& font_weight_in)
    : violating_node_id(std::move(violating_node_id_in)),
      violating_node_selector(std::move(violating_node_selector_in)),
      contrast_ratio(std::move(contrast_ratio_in)),
      threshold_aa(std::move(threshold_aa_in)),
      threshold_aaa(std::move(threshold_aaa_in)),
      font_size(std::move(font_size_in)),
      font_weight(std::move(font_weight_in)) {}

LowTextContrastIssue::~LowTextContrastIssue() = default;
size_t LowTextContrastIssue::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->violating_node_id);
  seed = mojo::internal::Hash(seed, this->violating_node_selector);
  seed = mojo::internal::Hash(seed, this->contrast_ratio);
  seed = mojo::internal::Hash(seed, this->threshold_aa);
  seed = mojo::internal::Hash(seed, this->threshold_aaa);
  seed = mojo::internal::Hash(seed, this->font_size);
  seed = mojo::internal::Hash(seed, this->font_weight);
  return seed;
}

void LowTextContrastIssue::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "violating_node_id"), this->violating_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "violating_node_selector"), this->violating_node_selector,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contrast_ratio"), this->contrast_ratio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "threshold_aa"), this->threshold_aa,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "threshold_aaa"), this->threshold_aaa,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "font_size"), this->font_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "font_weight"), this->font_weight,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LowTextContrastIssue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InspectorIssueDetails::InspectorIssueDetails()
    : samesite_cookie_issue_details(),
      mixed_content_issue_details(),
      blocked_by_response_issue_details(),
      csp_issue_details(),
      sab_issue_details(),
      twa_issue_details(),
      heavy_ad_issue_details(),
      low_text_contrast_details(),
      issue_id() {}

InspectorIssueDetails::InspectorIssueDetails(
    SameSiteCookieIssueDetailsPtr samesite_cookie_issue_details_in,
    MixedContentIssueDetailsPtr mixed_content_issue_details_in,
    BlockedByResponseIssueDetailsPtr blocked_by_response_issue_details_in,
    ContentSecurityPolicyIssueDetailsPtr csp_issue_details_in,
    SharedArrayBufferIssueDetailsPtr sab_issue_details_in,
    TrustedWebActivityIssueDetailsPtr twa_issue_details_in,
    HeavyAdIssueDetailsPtr heavy_ad_issue_details_in,
    LowTextContrastIssuePtr low_text_contrast_details_in,
    const absl::optional<::base::UnguessableToken>& issue_id_in)
    : samesite_cookie_issue_details(std::move(samesite_cookie_issue_details_in)),
      mixed_content_issue_details(std::move(mixed_content_issue_details_in)),
      blocked_by_response_issue_details(std::move(blocked_by_response_issue_details_in)),
      csp_issue_details(std::move(csp_issue_details_in)),
      sab_issue_details(std::move(sab_issue_details_in)),
      twa_issue_details(std::move(twa_issue_details_in)),
      heavy_ad_issue_details(std::move(heavy_ad_issue_details_in)),
      low_text_contrast_details(std::move(low_text_contrast_details_in)),
      issue_id(std::move(issue_id_in)) {}

InspectorIssueDetails::~InspectorIssueDetails() = default;

void InspectorIssueDetails::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "samesite_cookie_issue_details"), this->samesite_cookie_issue_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SameSiteCookieIssueDetailsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mixed_content_issue_details"), this->mixed_content_issue_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MixedContentIssueDetailsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blocked_by_response_issue_details"), this->blocked_by_response_issue_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BlockedByResponseIssueDetailsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "csp_issue_details"), this->csp_issue_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ContentSecurityPolicyIssueDetailsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sab_issue_details"), this->sab_issue_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SharedArrayBufferIssueDetailsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "twa_issue_details"), this->twa_issue_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustedWebActivityIssueDetailsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "heavy_ad_issue_details"), this->heavy_ad_issue_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type HeavyAdIssueDetailsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "low_text_contrast_details"), this->low_text_contrast_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LowTextContrastIssuePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issue_id"), this->issue_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InspectorIssueDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InspectorIssueInfo::InspectorIssueInfo()
    : code(),
      details() {}

InspectorIssueInfo::InspectorIssueInfo(
    InspectorIssueCode code_in,
    InspectorIssueDetailsPtr details_in)
    : code(std::move(code_in)),
      details(std::move(details_in)) {}

InspectorIssueInfo::~InspectorIssueInfo() = default;

void InspectorIssueInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code"), this->code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InspectorIssueCode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "details"), this->details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InspectorIssueDetailsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InspectorIssueInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::AffectedCookie::DataView, ::blink::mojom::AffectedCookiePtr>::Read(
    ::blink::mojom::AffectedCookie::DataView input,
    ::blink::mojom::AffectedCookiePtr* output) {
  bool success = true;
  ::blink::mojom::AffectedCookiePtr result(::blink::mojom::AffectedCookie::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadDomain(&result->domain))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AffectedRequest::DataView, ::blink::mojom::AffectedRequestPtr>::Read(
    ::blink::mojom::AffectedRequest::DataView input,
    ::blink::mojom::AffectedRequestPtr* output) {
  bool success = true;
  ::blink::mojom::AffectedRequestPtr result(::blink::mojom::AffectedRequest::New());
  
      if (success && !input.ReadRequestId(&result->request_id))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AffectedFrame::DataView, ::blink::mojom::AffectedFramePtr>::Read(
    ::blink::mojom::AffectedFrame::DataView input,
    ::blink::mojom::AffectedFramePtr* output) {
  bool success = true;
  ::blink::mojom::AffectedFramePtr result(::blink::mojom::AffectedFrame::New());
  
      if (success && !input.ReadFrameId(&result->frame_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AffectedLocation::DataView, ::blink::mojom::AffectedLocationPtr>::Read(
    ::blink::mojom::AffectedLocation::DataView input,
    ::blink::mojom::AffectedLocationPtr* output) {
  bool success = true;
  ::blink::mojom::AffectedLocationPtr result(::blink::mojom::AffectedLocation::New());
  
      if (success && !input.ReadScriptId(&result->script_id))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->line = input.line();
      if (success)
        result->column = input.column();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::BlockedByResponseIssueDetails::DataView, ::blink::mojom::BlockedByResponseIssueDetailsPtr>::Read(
    ::blink::mojom::BlockedByResponseIssueDetails::DataView input,
    ::blink::mojom::BlockedByResponseIssueDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::BlockedByResponseIssueDetailsPtr result(::blink::mojom::BlockedByResponseIssueDetails::New());
  
      if (success && !input.ReadRequest(&result->request))
        success = false;
      if (success && !input.ReadParentFrame(&result->parentFrame))
        success = false;
      if (success && !input.ReadBlockedFrame(&result->blockedFrame))
        success = false;
      if (success && !input.ReadReason(&result->reason))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::HeavyAdIssueDetails::DataView, ::blink::mojom::HeavyAdIssueDetailsPtr>::Read(
    ::blink::mojom::HeavyAdIssueDetails::DataView input,
    ::blink::mojom::HeavyAdIssueDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::HeavyAdIssueDetailsPtr result(::blink::mojom::HeavyAdIssueDetails::New());
  
      if (success && !input.ReadResolution(&result->resolution))
        success = false;
      if (success && !input.ReadReason(&result->reason))
        success = false;
      if (success && !input.ReadFrame(&result->frame))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::MixedContentIssueDetails::DataView, ::blink::mojom::MixedContentIssueDetailsPtr>::Read(
    ::blink::mojom::MixedContentIssueDetails::DataView input,
    ::blink::mojom::MixedContentIssueDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::MixedContentIssueDetailsPtr result(::blink::mojom::MixedContentIssueDetails::New());
  
      if (success && !input.ReadRequestContext(&result->request_context))
        success = false;
      if (success && !input.ReadResolutionStatus(&result->resolution_status))
        success = false;
      if (success && !input.ReadInsecureUrl(&result->insecure_url))
        success = false;
      if (success && !input.ReadMainResourceUrl(&result->main_resource_url))
        success = false;
      if (success && !input.ReadRequest(&result->request))
        success = false;
      if (success && !input.ReadFrame(&result->frame))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ContentSecurityPolicyIssueDetails::DataView, ::blink::mojom::ContentSecurityPolicyIssueDetailsPtr>::Read(
    ::blink::mojom::ContentSecurityPolicyIssueDetails::DataView input,
    ::blink::mojom::ContentSecurityPolicyIssueDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::ContentSecurityPolicyIssueDetailsPtr result(::blink::mojom::ContentSecurityPolicyIssueDetails::New());
  
      if (success && !input.ReadBlockedUrl(&result->blocked_url))
        success = false;
      if (success && !input.ReadViolatedDirective(&result->violated_directive))
        success = false;
      if (success)
        result->is_report_only = input.is_report_only();
      if (success && !input.ReadContentSecurityPolicyViolationType(&result->content_security_policy_violation_type))
        success = false;
      if (success && !input.ReadFrameAncestor(&result->frame_ancestor))
        success = false;
      if (success && !input.ReadAffectedLocation(&result->affected_location))
        success = false;
      if (success)
        result->violating_node_id = input.violating_node_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::SameSiteCookieIssueDetails::DataView, ::blink::mojom::SameSiteCookieIssueDetailsPtr>::Read(
    ::blink::mojom::SameSiteCookieIssueDetails::DataView input,
    ::blink::mojom::SameSiteCookieIssueDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::SameSiteCookieIssueDetailsPtr result(::blink::mojom::SameSiteCookieIssueDetails::New());
  
      if (success && !input.ReadCookie(&result->cookie))
        success = false;
      if (success && !input.ReadExclusionReason(&result->exclusion_reason))
        success = false;
      if (success && !input.ReadWarningReason(&result->warning_reason))
        success = false;
      if (success && !input.ReadOperation(&result->operation))
        success = false;
      if (success && !input.ReadSiteForCookies(&result->site_for_cookies))
        success = false;
      if (success && !input.ReadCookieUrl(&result->cookie_url))
        success = false;
      if (success && !input.ReadRequest(&result->request))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::SharedArrayBufferIssueDetails::DataView, ::blink::mojom::SharedArrayBufferIssueDetailsPtr>::Read(
    ::blink::mojom::SharedArrayBufferIssueDetails::DataView input,
    ::blink::mojom::SharedArrayBufferIssueDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::SharedArrayBufferIssueDetailsPtr result(::blink::mojom::SharedArrayBufferIssueDetails::New());
  
      if (success && !input.ReadAffectedLocation(&result->affected_location))
        success = false;
      if (success)
        result->is_warning = input.is_warning();
      if (success && !input.ReadType(&result->type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::TrustedWebActivityIssueDetails::DataView, ::blink::mojom::TrustedWebActivityIssueDetailsPtr>::Read(
    ::blink::mojom::TrustedWebActivityIssueDetails::DataView input,
    ::blink::mojom::TrustedWebActivityIssueDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::TrustedWebActivityIssueDetailsPtr result(::blink::mojom::TrustedWebActivityIssueDetails::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadViolationType(&result->violation_type))
        success = false;
      if (success)
        result->http_error_code = input.http_error_code();
      if (success && !input.ReadPackageName(&result->package_name))
        success = false;
      if (success && !input.ReadSignature(&result->signature))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::LowTextContrastIssue::DataView, ::blink::mojom::LowTextContrastIssuePtr>::Read(
    ::blink::mojom::LowTextContrastIssue::DataView input,
    ::blink::mojom::LowTextContrastIssuePtr* output) {
  bool success = true;
  ::blink::mojom::LowTextContrastIssuePtr result(::blink::mojom::LowTextContrastIssue::New());
  
      if (success)
        result->violating_node_id = input.violating_node_id();
      if (success && !input.ReadViolatingNodeSelector(&result->violating_node_selector))
        success = false;
      if (success)
        result->contrast_ratio = input.contrast_ratio();
      if (success)
        result->threshold_aa = input.threshold_aa();
      if (success)
        result->threshold_aaa = input.threshold_aaa();
      if (success && !input.ReadFontSize(&result->font_size))
        success = false;
      if (success && !input.ReadFontWeight(&result->font_weight))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::InspectorIssueDetails::DataView, ::blink::mojom::InspectorIssueDetailsPtr>::Read(
    ::blink::mojom::InspectorIssueDetails::DataView input,
    ::blink::mojom::InspectorIssueDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::InspectorIssueDetailsPtr result(::blink::mojom::InspectorIssueDetails::New());
  
      if (success && !input.ReadSamesiteCookieIssueDetails(&result->samesite_cookie_issue_details))
        success = false;
      if (success && !input.ReadMixedContentIssueDetails(&result->mixed_content_issue_details))
        success = false;
      if (success && !input.ReadBlockedByResponseIssueDetails(&result->blocked_by_response_issue_details))
        success = false;
      if (success && !input.ReadCspIssueDetails(&result->csp_issue_details))
        success = false;
      if (success && !input.ReadSabIssueDetails(&result->sab_issue_details))
        success = false;
      if (success && !input.ReadTwaIssueDetails(&result->twa_issue_details))
        success = false;
      if (success && !input.ReadHeavyAdIssueDetails(&result->heavy_ad_issue_details))
        success = false;
      if (success && !input.ReadLowTextContrastDetails(&result->low_text_contrast_details))
        success = false;
      if (success && !input.ReadIssueId(&result->issue_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::InspectorIssueInfo::DataView, ::blink::mojom::InspectorIssueInfoPtr>::Read(
    ::blink::mojom::InspectorIssueInfo::DataView input,
    ::blink::mojom::InspectorIssueInfoPtr* output) {
  bool success = true;
  ::blink::mojom::InspectorIssueInfoPtr result(::blink::mojom::InspectorIssueInfo::New());
  
      if (success && !input.ReadCode(&result->code))
        success = false;
      if (success && !input.ReadDetails(&result->details))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif