// third_party/blink/public/mojom/digital_goods/digital_goods.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-params-data.h"
#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIGITAL_GOODS_DIGITAL_GOODS_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIGITAL_GOODS_DIGITAL_GOODS_MOJOM_BLINK_JUMBO_H_
#endif
namespace payments {
namespace mojom {
namespace blink {
ItemDetails::ItemDetails()
    : item_id(),
      title(),
      description(),
      price(),
      subscription_period(),
      free_trial_period(),
      introductory_price(),
      introductory_price_period() {}

ItemDetails::ItemDetails(
    const WTF::String& item_id_in,
    const WTF::String& title_in,
    const WTF::String& description_in,
    ::payments::mojom::blink::PaymentCurrencyAmountPtr price_in,
    const WTF::String& subscription_period_in,
    const WTF::String& free_trial_period_in,
    ::payments::mojom::blink::PaymentCurrencyAmountPtr introductory_price_in,
    const WTF::String& introductory_price_period_in)
    : item_id(std::move(item_id_in)),
      title(std::move(title_in)),
      description(std::move(description_in)),
      price(std::move(price_in)),
      subscription_period(std::move(subscription_period_in)),
      free_trial_period(std::move(free_trial_period_in)),
      introductory_price(std::move(introductory_price_in)),
      introductory_price_period(std::move(introductory_price_period_in)) {}

ItemDetails::~ItemDetails() = default;

void ItemDetails::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "item_id"), this->item_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "price"), this->price,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::payments::mojom::blink::PaymentCurrencyAmountPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subscription_period"), this->subscription_period,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "free_trial_period"), this->free_trial_period,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "introductory_price"), this->introductory_price,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::payments::mojom::blink::PaymentCurrencyAmountPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "introductory_price_period"), this->introductory_price_period,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ItemDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PurchaseDetails::PurchaseDetails()
    : item_id(),
      purchase_token(),
      acknowledged(),
      purchase_state(),
      purchase_time(),
      will_auto_renew() {}

PurchaseDetails::PurchaseDetails(
    const WTF::String& item_id_in,
    const WTF::String& purchase_token_in,
    bool acknowledged_in,
    PurchaseState purchase_state_in,
    ::base::TimeDelta purchase_time_in,
    bool will_auto_renew_in)
    : item_id(std::move(item_id_in)),
      purchase_token(std::move(purchase_token_in)),
      acknowledged(std::move(acknowledged_in)),
      purchase_state(std::move(purchase_state_in)),
      purchase_time(std::move(purchase_time_in)),
      will_auto_renew(std::move(will_auto_renew_in)) {}

PurchaseDetails::~PurchaseDetails() = default;

void PurchaseDetails::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "item_id"), this->item_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "purchase_token"), this->purchase_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "acknowledged"), this->acknowledged,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "purchase_state"), this->purchase_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PurchaseState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "purchase_time"), this->purchase_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "will_auto_renew"), this->will_auto_renew,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PurchaseDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char DigitalGoods::Name_[] = "payments.mojom.DigitalGoods";

class DigitalGoods_GetDetails_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DigitalGoods_GetDetails_ForwardToCallback(
      DigitalGoods::GetDetailsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DigitalGoods::GetDetailsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DigitalGoods_GetDetails_ForwardToCallback);
};

class DigitalGoods_Acknowledge_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DigitalGoods_Acknowledge_ForwardToCallback(
      DigitalGoods::AcknowledgeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DigitalGoods::AcknowledgeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DigitalGoods_Acknowledge_ForwardToCallback);
};

class DigitalGoods_ListPurchases_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DigitalGoods_ListPurchases_ForwardToCallback(
      DigitalGoods::ListPurchasesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DigitalGoods::ListPurchasesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DigitalGoods_ListPurchases_ForwardToCallback);
};

DigitalGoodsProxy::DigitalGoodsProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DigitalGoodsProxy::GetDetails(
    const WTF::Vector<WTF::String>& in_item_ids, GetDetailsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::DigitalGoods::GetDetails", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("item_ids"), in_item_ids,
                        "<value of type const WTF::Vector<WTF::String>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDigitalGoods_GetDetails_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoods_GetDetails_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->item_ids)::BaseType>
      item_ids_fragment(params.message());
  const mojo::internal::ContainerValidateParams item_ids_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_item_ids, item_ids_fragment, &item_ids_validate_params);
  params->item_ids.Set(
      item_ids_fragment.is_null() ? nullptr : item_ids_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->item_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null item_ids in DigitalGoods.GetDetails request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("GetDetails");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DigitalGoods_GetDetails_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DigitalGoodsProxy::Acknowledge(
    const WTF::String& in_purchase_token, bool in_make_available_again, AcknowledgeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::DigitalGoods::Acknowledge", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("purchase_token"), in_purchase_token,
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("make_available_again"), in_make_available_again,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDigitalGoods_Acknowledge_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoods_Acknowledge_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->purchase_token)::BaseType> purchase_token_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_purchase_token, purchase_token_fragment);
  params->purchase_token.Set(
      purchase_token_fragment.is_null() ? nullptr : purchase_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->purchase_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null purchase_token in DigitalGoods.Acknowledge request");
  params->make_available_again = in_make_available_again;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("Acknowledge");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DigitalGoods_Acknowledge_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DigitalGoodsProxy::ListPurchases(
    ListPurchasesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::DigitalGoods::ListPurchases");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDigitalGoods_ListPurchases_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoods_ListPurchases_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("ListPurchases");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DigitalGoods_ListPurchases_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class DigitalGoods_GetDetails_ProxyToResponder {
 public:
  static DigitalGoods::GetDetailsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DigitalGoods_GetDetails_ProxyToResponder> proxy(
        new DigitalGoods_GetDetails_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DigitalGoods_GetDetails_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DigitalGoods_GetDetails_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DigitalGoods_GetDetails_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DigitalGoods::GetDetailsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BillingResponseCode in_code, WTF::Vector<ItemDetailsPtr> in_item_details_list);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DigitalGoods_GetDetails_ProxyToResponder);
};

bool DigitalGoods_GetDetails_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::DigitalGoods::GetDetailsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DigitalGoods_GetDetails_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DigitalGoods_GetDetails_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BillingResponseCode p_code{};
  WTF::Vector<ItemDetailsPtr> p_item_details_list{};
  DigitalGoods_GetDetails_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCode(&p_code))
    success = false;
  if (success && !input_data_view.ReadItemDetailsList(&p_item_details_list))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DigitalGoods::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_code), 
std::move(p_item_details_list));
  return true;
}

void DigitalGoods_GetDetails_ProxyToResponder::Run(
    BillingResponseCode in_code, WTF::Vector<ItemDetailsPtr> in_item_details_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::DigitalGoods::GetDetailsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type BillingResponseCode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("item_details_list"), in_item_details_list,
                        "<value of type WTF::Vector<ItemDetailsPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDigitalGoods_GetDetails_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoods_GetDetails_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::BillingResponseCode>(
      in_code, &params->code);
  mojo::internal::MessageFragment<
      typename decltype(params->item_details_list)::BaseType>
      item_details_list_fragment(params.message());
  const mojo::internal::ContainerValidateParams item_details_list_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::ItemDetailsDataView>>(
      in_item_details_list, item_details_list_fragment, &item_details_list_validate_params);
  params->item_details_list.Set(
      item_details_list_fragment.is_null() ? nullptr : item_details_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->item_details_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null item_details_list in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::DigitalGoods::GetDetailsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("GetDetails");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DigitalGoods_Acknowledge_ProxyToResponder {
 public:
  static DigitalGoods::AcknowledgeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DigitalGoods_Acknowledge_ProxyToResponder> proxy(
        new DigitalGoods_Acknowledge_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DigitalGoods_Acknowledge_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DigitalGoods_Acknowledge_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DigitalGoods_Acknowledge_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DigitalGoods::AcknowledgeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BillingResponseCode in_code);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DigitalGoods_Acknowledge_ProxyToResponder);
};

bool DigitalGoods_Acknowledge_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::DigitalGoods::AcknowledgeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DigitalGoods_Acknowledge_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DigitalGoods_Acknowledge_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BillingResponseCode p_code{};
  DigitalGoods_Acknowledge_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCode(&p_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DigitalGoods::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_code));
  return true;
}

void DigitalGoods_Acknowledge_ProxyToResponder::Run(
    BillingResponseCode in_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::DigitalGoods::AcknowledgeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type BillingResponseCode>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDigitalGoods_Acknowledge_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoods_Acknowledge_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::BillingResponseCode>(
      in_code, &params->code);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::DigitalGoods::AcknowledgeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("Acknowledge");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DigitalGoods_ListPurchases_ProxyToResponder {
 public:
  static DigitalGoods::ListPurchasesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DigitalGoods_ListPurchases_ProxyToResponder> proxy(
        new DigitalGoods_ListPurchases_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DigitalGoods_ListPurchases_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DigitalGoods_ListPurchases_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DigitalGoods_ListPurchases_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DigitalGoods::ListPurchasesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      BillingResponseCode in_code, WTF::Vector<PurchaseDetailsPtr> in_purchase_details_list);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DigitalGoods_ListPurchases_ProxyToResponder);
};

bool DigitalGoods_ListPurchases_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::DigitalGoods::ListPurchasesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DigitalGoods_ListPurchases_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DigitalGoods_ListPurchases_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  BillingResponseCode p_code{};
  WTF::Vector<PurchaseDetailsPtr> p_purchase_details_list{};
  DigitalGoods_ListPurchases_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCode(&p_code))
    success = false;
  if (success && !input_data_view.ReadPurchaseDetailsList(&p_purchase_details_list))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DigitalGoods::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_code), 
std::move(p_purchase_details_list));
  return true;
}

void DigitalGoods_ListPurchases_ProxyToResponder::Run(
    BillingResponseCode in_code, WTF::Vector<PurchaseDetailsPtr> in_purchase_details_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::DigitalGoods::ListPurchasesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type BillingResponseCode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("purchase_details_list"), in_purchase_details_list,
                        "<value of type WTF::Vector<PurchaseDetailsPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDigitalGoods_ListPurchases_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoods_ListPurchases_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::BillingResponseCode>(
      in_code, &params->code);
  mojo::internal::MessageFragment<
      typename decltype(params->purchase_details_list)::BaseType>
      purchase_details_list_fragment(params.message());
  const mojo::internal::ContainerValidateParams purchase_details_list_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PurchaseDetailsDataView>>(
      in_purchase_details_list, purchase_details_list_fragment, &purchase_details_list_validate_params);
  params->purchase_details_list.Set(
      purchase_details_list_fragment.is_null() ? nullptr : purchase_details_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->purchase_details_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null purchase_details_list in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::DigitalGoods::ListPurchasesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoods::Name_);
  message.set_method_name("ListPurchases");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DigitalGoodsStubDispatch::Accept(
    DigitalGoods* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDigitalGoods_GetDetails_Name: {
      break;
    }
    case internal::kDigitalGoods_Acknowledge_Name: {
      break;
    }
    case internal::kDigitalGoods_ListPurchases_Name: {
      break;
    }
  }
  return false;
}

// static
bool DigitalGoodsStubDispatch::AcceptWithResponder(
    DigitalGoods* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDigitalGoods_GetDetails_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::DigitalGoods::GetDetails",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::DigitalGoods::GetDetails");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DigitalGoods_GetDetails_Params_Data* params =
          reinterpret_cast<
              internal::DigitalGoods_GetDetails_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::Vector<WTF::String> p_item_ids{};
      DigitalGoods_GetDetails_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadItemIds(&p_item_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DigitalGoods::Name_, 0, false);
        return false;
      }
      DigitalGoods::GetDetailsCallback callback =
          DigitalGoods_GetDetails_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDetails(
std::move(p_item_ids), std::move(callback));
      return true;
    }
    case internal::kDigitalGoods_Acknowledge_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::DigitalGoods::Acknowledge",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::DigitalGoods::Acknowledge");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DigitalGoods_Acknowledge_Params_Data* params =
          reinterpret_cast<
              internal::DigitalGoods_Acknowledge_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_purchase_token{};
      bool p_make_available_again{};
      DigitalGoods_Acknowledge_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPurchaseToken(&p_purchase_token))
        success = false;
      if (success)
        p_make_available_again = input_data_view.make_available_again();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DigitalGoods::Name_, 1, false);
        return false;
      }
      DigitalGoods::AcknowledgeCallback callback =
          DigitalGoods_Acknowledge_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Acknowledge(
std::move(p_purchase_token), 
std::move(p_make_available_again), std::move(callback));
      return true;
    }
    case internal::kDigitalGoods_ListPurchases_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::DigitalGoods::ListPurchases",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::DigitalGoods::ListPurchases");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DigitalGoods_ListPurchases_Params_Data* params =
          reinterpret_cast<
              internal::DigitalGoods_ListPurchases_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      DigitalGoods_ListPurchases_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DigitalGoods::Name_, 2, false);
        return false;
      }
      DigitalGoods::ListPurchasesCallback callback =
          DigitalGoods_ListPurchases_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ListPurchases(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kDigitalGoodsValidationInfo[] = {
    {&internal::DigitalGoods_GetDetails_Params_Data::Validate,
     &internal::DigitalGoods_GetDetails_ResponseParams_Data::Validate},
    {&internal::DigitalGoods_Acknowledge_Params_Data::Validate,
     &internal::DigitalGoods_Acknowledge_ResponseParams_Data::Validate},
    {&internal::DigitalGoods_ListPurchases_Params_Data::Validate,
     &internal::DigitalGoods_ListPurchases_ResponseParams_Data::Validate},
};

bool DigitalGoodsRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::DigitalGoods::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kDigitalGoodsValidationInfo);
}

bool DigitalGoodsResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::DigitalGoods::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kDigitalGoodsValidationInfo);
}
const char DigitalGoodsFactory::Name_[] = "payments.mojom.DigitalGoodsFactory";

class DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback(
      DigitalGoodsFactory::CreateDigitalGoodsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DigitalGoodsFactory::CreateDigitalGoodsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback);
};

DigitalGoodsFactoryProxy::DigitalGoodsFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DigitalGoodsFactoryProxy::CreateDigitalGoods(
    const WTF::String& in_payment_method, CreateDigitalGoodsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::DigitalGoodsFactory::CreateDigitalGoods", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("payment_method"), in_payment_method,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDigitalGoodsFactory_CreateDigitalGoods_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoodsFactory_CreateDigitalGoods_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->payment_method)::BaseType> payment_method_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_payment_method, payment_method_fragment);
  params->payment_method.Set(
      payment_method_fragment.is_null() ? nullptr : payment_method_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->payment_method.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null payment_method in DigitalGoodsFactory.CreateDigitalGoods request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoodsFactory::Name_);
  message.set_method_name("CreateDigitalGoods");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder {
 public:
  static DigitalGoodsFactory::CreateDigitalGoodsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder> proxy(
        new DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DigitalGoodsFactory::CreateDigitalGoodsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateDigitalGoodsResponseCode in_code, ::mojo::PendingRemote<DigitalGoods> in_digital_goods);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder);
};

bool DigitalGoodsFactory_CreateDigitalGoods_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::DigitalGoodsFactory::CreateDigitalGoodsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  CreateDigitalGoodsResponseCode p_code{};
  ::mojo::PendingRemote<DigitalGoods> p_digital_goods{};
  DigitalGoodsFactory_CreateDigitalGoods_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCode(&p_code))
    success = false;
  if (success) {
    p_digital_goods =
        input_data_view.TakeDigitalGoods<decltype(p_digital_goods)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DigitalGoodsFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_code), 
std::move(p_digital_goods));
  return true;
}

void DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder::Run(
    CreateDigitalGoodsResponseCode in_code, ::mojo::PendingRemote<DigitalGoods> in_digital_goods) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::DigitalGoodsFactory::CreateDigitalGoodsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type CreateDigitalGoodsResponseCode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("digital_goods"), in_digital_goods,
                        "<value of type ::mojo::PendingRemote<DigitalGoods>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDigitalGoodsFactory_CreateDigitalGoods_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::CreateDigitalGoodsResponseCode>(
      in_code, &params->code);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::payments::mojom::DigitalGoodsInterfaceBase>>(
      in_digital_goods, &params->digital_goods, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::DigitalGoodsFactory::CreateDigitalGoodsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DigitalGoodsFactory::Name_);
  message.set_method_name("CreateDigitalGoods");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DigitalGoodsFactoryStubDispatch::Accept(
    DigitalGoodsFactory* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDigitalGoodsFactory_CreateDigitalGoods_Name: {
      break;
    }
  }
  return false;
}

// static
bool DigitalGoodsFactoryStubDispatch::AcceptWithResponder(
    DigitalGoodsFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDigitalGoodsFactory_CreateDigitalGoods_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::DigitalGoodsFactory::CreateDigitalGoods",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::DigitalGoodsFactory::CreateDigitalGoods");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DigitalGoodsFactory_CreateDigitalGoods_Params_Data* params =
          reinterpret_cast<
              internal::DigitalGoodsFactory_CreateDigitalGoods_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_payment_method{};
      DigitalGoodsFactory_CreateDigitalGoods_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPaymentMethod(&p_payment_method))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DigitalGoodsFactory::Name_, 0, false);
        return false;
      }
      DigitalGoodsFactory::CreateDigitalGoodsCallback callback =
          DigitalGoodsFactory_CreateDigitalGoods_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateDigitalGoods(
std::move(p_payment_method), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kDigitalGoodsFactoryValidationInfo[] = {
    {&internal::DigitalGoodsFactory_CreateDigitalGoods_Params_Data::Validate,
     &internal::DigitalGoodsFactory_CreateDigitalGoods_ResponseParams_Data::Validate},
};

bool DigitalGoodsFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::DigitalGoodsFactory::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kDigitalGoodsFactoryValidationInfo);
}

bool DigitalGoodsFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::blink::DigitalGoodsFactory::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kDigitalGoodsFactoryValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace payments

namespace mojo {


// static
bool StructTraits<::payments::mojom::blink::ItemDetails::DataView, ::payments::mojom::blink::ItemDetailsPtr>::Read(
    ::payments::mojom::blink::ItemDetails::DataView input,
    ::payments::mojom::blink::ItemDetailsPtr* output) {
  bool success = true;
  ::payments::mojom::blink::ItemDetailsPtr result(::payments::mojom::blink::ItemDetails::New());
  
      if (success && !input.ReadItemId(&result->item_id))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadPrice(&result->price))
        success = false;
      if (success && !input.ReadSubscriptionPeriod(&result->subscription_period))
        success = false;
      if (success && !input.ReadFreeTrialPeriod(&result->free_trial_period))
        success = false;
      if (success && !input.ReadIntroductoryPrice(&result->introductory_price))
        success = false;
      if (success && !input.ReadIntroductoryPricePeriod(&result->introductory_price_period))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::blink::PurchaseDetails::DataView, ::payments::mojom::blink::PurchaseDetailsPtr>::Read(
    ::payments::mojom::blink::PurchaseDetails::DataView input,
    ::payments::mojom::blink::PurchaseDetailsPtr* output) {
  bool success = true;
  ::payments::mojom::blink::PurchaseDetailsPtr result(::payments::mojom::blink::PurchaseDetails::New());
  
      if (success && !input.ReadItemId(&result->item_id))
        success = false;
      if (success && !input.ReadPurchaseToken(&result->purchase_token))
        success = false;
      if (success)
        result->acknowledged = input.acknowledged();
      if (success && !input.ReadPurchaseState(&result->purchase_state))
        success = false;
      if (success && !input.ReadPurchaseTime(&result->purchase_time))
        success = false;
      if (success)
        result->will_auto_renew = input.will_auto_renew();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif