// third_party/blink/public/mojom/dom_storage/storage_area.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-params-data.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_STORAGE_AREA_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_STORAGE_AREA_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
KeyValue::KeyValue()
    : key(),
      value() {}

KeyValue::KeyValue(
    std::vector<uint8_t> key_in,
    std::vector<uint8_t> value_in)
    : key(std::move(key_in)),
      value(std::move(value_in)) {}

KeyValue::~KeyValue() = default;

void KeyValue::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool KeyValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char StorageAreaObserver::Name_[] = "blink.mojom.StorageAreaObserver";

StorageAreaObserverProxy::StorageAreaObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void StorageAreaObserverProxy::KeyChanged(
    const std::vector<uint8_t>& in_key, const std::vector<uint8_t>& in_new_value, const absl::optional<std::vector<uint8_t>>& in_old_value, const std::string& in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::StorageAreaObserver::KeyChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_value"), in_new_value,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_value"), in_old_value,
                        "<value of type const absl::optional<std::vector<uint8_t>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageAreaObserver_KeyChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAreaObserver_KeyChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType>
      key_fragment(params.message());
  const mojo::internal::ContainerValidateParams key_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_key, key_fragment, &key_validate_params);
  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in StorageAreaObserver.KeyChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_value)::BaseType>
      new_value_fragment(params.message());
  const mojo::internal::ContainerValidateParams new_value_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_new_value, new_value_fragment, &new_value_validate_params);
  params->new_value.Set(
      new_value_fragment.is_null() ? nullptr : new_value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_value in StorageAreaObserver.KeyChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->old_value)::BaseType>
      old_value_fragment(params.message());
  const mojo::internal::ContainerValidateParams old_value_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_old_value, old_value_fragment, &old_value_validate_params);
  params->old_value.Set(
      old_value_fragment.is_null() ? nullptr : old_value_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_source, source_fragment);
  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source in StorageAreaObserver.KeyChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAreaObserver::Name_);
  message.set_method_name("KeyChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void StorageAreaObserverProxy::KeyChangeFailed(
    const std::vector<uint8_t>& in_key, const std::string& in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::StorageAreaObserver::KeyChangeFailed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageAreaObserver_KeyChangeFailed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAreaObserver_KeyChangeFailed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType>
      key_fragment(params.message());
  const mojo::internal::ContainerValidateParams key_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_key, key_fragment, &key_validate_params);
  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in StorageAreaObserver.KeyChangeFailed request");
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_source, source_fragment);
  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source in StorageAreaObserver.KeyChangeFailed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAreaObserver::Name_);
  message.set_method_name("KeyChangeFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void StorageAreaObserverProxy::KeyDeleted(
    const std::vector<uint8_t>& in_key, const absl::optional<std::vector<uint8_t>>& in_old_value, const std::string& in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::StorageAreaObserver::KeyDeleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_value"), in_old_value,
                        "<value of type const absl::optional<std::vector<uint8_t>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageAreaObserver_KeyDeleted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAreaObserver_KeyDeleted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType>
      key_fragment(params.message());
  const mojo::internal::ContainerValidateParams key_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_key, key_fragment, &key_validate_params);
  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in StorageAreaObserver.KeyDeleted request");
  mojo::internal::MessageFragment<
      typename decltype(params->old_value)::BaseType>
      old_value_fragment(params.message());
  const mojo::internal::ContainerValidateParams old_value_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_old_value, old_value_fragment, &old_value_validate_params);
  params->old_value.Set(
      old_value_fragment.is_null() ? nullptr : old_value_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_source, source_fragment);
  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source in StorageAreaObserver.KeyDeleted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAreaObserver::Name_);
  message.set_method_name("KeyDeleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void StorageAreaObserverProxy::AllDeleted(
    bool in_was_nonempty, const std::string& in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::StorageAreaObserver::AllDeleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("was_nonempty"), in_was_nonempty,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageAreaObserver_AllDeleted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAreaObserver_AllDeleted_Params_Data> params(
          message);
  params.Allocate();
  params->was_nonempty = in_was_nonempty;
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_source, source_fragment);
  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source in StorageAreaObserver.AllDeleted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAreaObserver::Name_);
  message.set_method_name("AllDeleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void StorageAreaObserverProxy::ShouldSendOldValueOnMutations(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::StorageAreaObserver::ShouldSendOldValueOnMutations", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageAreaObserver_ShouldSendOldValueOnMutations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageAreaObserver_ShouldSendOldValueOnMutations_Params_Data> params(
          message);
  params.Allocate();
  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageAreaObserver::Name_);
  message.set_method_name("ShouldSendOldValueOnMutations");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool StorageAreaObserverStubDispatch::Accept(
    StorageAreaObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kStorageAreaObserver_KeyChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::StorageAreaObserver::KeyChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::StorageAreaObserver::KeyChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::StorageAreaObserver_KeyChanged_Params_Data* params =
          reinterpret_cast<internal::StorageAreaObserver_KeyChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_key{};
      std::vector<uint8_t> p_new_value{};
      absl::optional<std::vector<uint8_t>> p_old_value{};
      std::string p_source{};
      StorageAreaObserver_KeyChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadNewValue(&p_new_value))
        success = false;
      if (success && !input_data_view.ReadOldValue(&p_old_value))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAreaObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->KeyChanged(
std::move(p_key), 
std::move(p_new_value), 
std::move(p_old_value), 
std::move(p_source));
      return true;
    }
    case internal::kStorageAreaObserver_KeyChangeFailed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::StorageAreaObserver::KeyChangeFailed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::StorageAreaObserver::KeyChangeFailed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::StorageAreaObserver_KeyChangeFailed_Params_Data* params =
          reinterpret_cast<internal::StorageAreaObserver_KeyChangeFailed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_key{};
      std::string p_source{};
      StorageAreaObserver_KeyChangeFailed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAreaObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->KeyChangeFailed(
std::move(p_key), 
std::move(p_source));
      return true;
    }
    case internal::kStorageAreaObserver_KeyDeleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::StorageAreaObserver::KeyDeleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::StorageAreaObserver::KeyDeleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::StorageAreaObserver_KeyDeleted_Params_Data* params =
          reinterpret_cast<internal::StorageAreaObserver_KeyDeleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_key{};
      absl::optional<std::vector<uint8_t>> p_old_value{};
      std::string p_source{};
      StorageAreaObserver_KeyDeleted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadOldValue(&p_old_value))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAreaObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->KeyDeleted(
std::move(p_key), 
std::move(p_old_value), 
std::move(p_source));
      return true;
    }
    case internal::kStorageAreaObserver_AllDeleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::StorageAreaObserver::AllDeleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::StorageAreaObserver::AllDeleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::StorageAreaObserver_AllDeleted_Params_Data* params =
          reinterpret_cast<internal::StorageAreaObserver_AllDeleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_was_nonempty{};
      std::string p_source{};
      StorageAreaObserver_AllDeleted_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_was_nonempty = input_data_view.was_nonempty();
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAreaObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllDeleted(
std::move(p_was_nonempty), 
std::move(p_source));
      return true;
    }
    case internal::kStorageAreaObserver_ShouldSendOldValueOnMutations_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::StorageAreaObserver::ShouldSendOldValueOnMutations",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::StorageAreaObserver::ShouldSendOldValueOnMutations");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::StorageAreaObserver_ShouldSendOldValueOnMutations_Params_Data* params =
          reinterpret_cast<internal::StorageAreaObserver_ShouldSendOldValueOnMutations_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_value{};
      StorageAreaObserver_ShouldSendOldValueOnMutations_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageAreaObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShouldSendOldValueOnMutations(
std::move(p_value));
      return true;
    }
  }
  return false;
}

// static
bool StorageAreaObserverStubDispatch::AcceptWithResponder(
    StorageAreaObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kStorageAreaObserver_KeyChanged_Name: {
      break;
    }
    case internal::kStorageAreaObserver_KeyChangeFailed_Name: {
      break;
    }
    case internal::kStorageAreaObserver_KeyDeleted_Name: {
      break;
    }
    case internal::kStorageAreaObserver_AllDeleted_Name: {
      break;
    }
    case internal::kStorageAreaObserver_ShouldSendOldValueOnMutations_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kStorageAreaObserverValidationInfo[] = {
    {internal::kStorageAreaObserver_KeyChanged_Name,
     {&internal::StorageAreaObserver_KeyChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kStorageAreaObserver_KeyChangeFailed_Name,
     {&internal::StorageAreaObserver_KeyChangeFailed_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kStorageAreaObserver_KeyDeleted_Name,
     {&internal::StorageAreaObserver_KeyDeleted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kStorageAreaObserver_AllDeleted_Name,
     {&internal::StorageAreaObserver_AllDeleted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kStorageAreaObserver_ShouldSendOldValueOnMutations_Name,
     {&internal::StorageAreaObserver_ShouldSendOldValueOnMutations_Params_Data::Validate,
      nullptr /* no response */}},
};

bool StorageAreaObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::StorageAreaObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kStorageAreaObserverValidationInfo);
}

const char StorageArea::Name_[] = "blink.mojom.StorageArea";
constexpr uint32_t StorageArea::kPerStorageAreaQuota;
constexpr uint32_t StorageArea::kPerStorageAreaOverQuotaAllowance;
bool StorageArea::GetAll(::mojo::PendingRemote<StorageAreaObserver> new_observer, std::vector<KeyValuePtr>* out_data) {
  NOTREACHED();
  return false;
}

class StorageArea_Put_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StorageArea_Put_ForwardToCallback(
      StorageArea::PutCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  StorageArea::PutCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(StorageArea_Put_ForwardToCallback);
};

class StorageArea_Delete_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StorageArea_Delete_ForwardToCallback(
      StorageArea::DeleteCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  StorageArea::DeleteCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(StorageArea_Delete_ForwardToCallback);
};

class StorageArea_DeleteAll_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StorageArea_DeleteAll_ForwardToCallback(
      StorageArea::DeleteAllCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  StorageArea::DeleteAllCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(StorageArea_DeleteAll_ForwardToCallback);
};

class StorageArea_Get_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StorageArea_Get_ForwardToCallback(
      StorageArea::GetCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  StorageArea::GetCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(StorageArea_Get_ForwardToCallback);
};
class StorageArea_GetAll_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  StorageArea_GetAll_HandleSyncResponse(
      bool* result, std::vector<KeyValuePtr>* out_data)
      : result_(result), out_data_(out_data) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::vector<KeyValuePtr>* out_data_;DISALLOW_COPY_AND_ASSIGN(StorageArea_GetAll_HandleSyncResponse);
};

class StorageArea_GetAll_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StorageArea_GetAll_ForwardToCallback(
      StorageArea::GetAllCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  StorageArea::GetAllCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(StorageArea_GetAll_ForwardToCallback);
};

StorageAreaProxy::StorageAreaProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void StorageAreaProxy::AddObserver(
    ::mojo::PendingRemote<StorageAreaObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::StorageArea::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<StorageAreaObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageArea_AddObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_AddObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::StorageAreaObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in StorageArea.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void StorageAreaProxy::Put(
    const std::vector<uint8_t>& in_key, const std::vector<uint8_t>& in_value, const absl::optional<std::vector<uint8_t>>& in_client_old_value, const std::string& in_source, PutCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::StorageArea::Put", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_old_value"), in_client_old_value,
                        "<value of type const absl::optional<std::vector<uint8_t>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageArea_Put_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_Put_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType>
      key_fragment(params.message());
  const mojo::internal::ContainerValidateParams key_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_key, key_fragment, &key_validate_params);
  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in StorageArea.Put request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType>
      value_fragment(params.message());
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_value, value_fragment, &value_validate_params);
  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in StorageArea.Put request");
  mojo::internal::MessageFragment<
      typename decltype(params->client_old_value)::BaseType>
      client_old_value_fragment(params.message());
  const mojo::internal::ContainerValidateParams client_old_value_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_client_old_value, client_old_value_fragment, &client_old_value_validate_params);
  params->client_old_value.Set(
      client_old_value_fragment.is_null() ? nullptr : client_old_value_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_source, source_fragment);
  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source in StorageArea.Put request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("Put");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StorageArea_Put_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void StorageAreaProxy::Delete(
    const std::vector<uint8_t>& in_key, const absl::optional<std::vector<uint8_t>>& in_client_old_value, const std::string& in_source, DeleteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::StorageArea::Delete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_old_value"), in_client_old_value,
                        "<value of type const absl::optional<std::vector<uint8_t>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageArea_Delete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_Delete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType>
      key_fragment(params.message());
  const mojo::internal::ContainerValidateParams key_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_key, key_fragment, &key_validate_params);
  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in StorageArea.Delete request");
  mojo::internal::MessageFragment<
      typename decltype(params->client_old_value)::BaseType>
      client_old_value_fragment(params.message());
  const mojo::internal::ContainerValidateParams client_old_value_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_client_old_value, client_old_value_fragment, &client_old_value_validate_params);
  params->client_old_value.Set(
      client_old_value_fragment.is_null() ? nullptr : client_old_value_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_source, source_fragment);
  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source in StorageArea.Delete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("Delete");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StorageArea_Delete_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void StorageAreaProxy::DeleteAll(
    const std::string& in_source, ::mojo::PendingRemote<StorageAreaObserver> in_new_observer, DeleteAllCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::StorageArea::DeleteAll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_observer"), in_new_observer,
                        "<value of type ::mojo::PendingRemote<StorageAreaObserver>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageArea_DeleteAll_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_DeleteAll_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_source, source_fragment);
  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source in StorageArea.DeleteAll request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::StorageAreaObserverInterfaceBase>>(
      in_new_observer, &params->new_observer, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("DeleteAll");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StorageArea_DeleteAll_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void StorageAreaProxy::Get(
    const std::vector<uint8_t>& in_key, GetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::StorageArea::Get", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageArea_Get_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_Get_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType>
      key_fragment(params.message());
  const mojo::internal::ContainerValidateParams key_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_key, key_fragment, &key_validate_params);
  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in StorageArea.Get request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("Get");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StorageArea_Get_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool StorageAreaProxy::GetAll(
    ::mojo::PendingRemote<StorageAreaObserver> param_new_observer, std::vector<KeyValuePtr>* out_param_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::StorageArea::GetAll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_observer"), param_new_observer,
                        "<value of type ::mojo::PendingRemote<StorageAreaObserver>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageArea_GetAll_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_GetAll_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::StorageAreaObserverInterfaceBase>>(
      param_new_observer, &params->new_observer, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("GetAll");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StorageArea_GetAll_HandleSyncResponse(
          &result, out_param_data));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::StorageArea::GetAll", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), out_param_data,
                        "<value of type std::vector<KeyValuePtr>>");
   });
#endif
  return result;
}

void StorageAreaProxy::GetAll(
    ::mojo::PendingRemote<StorageAreaObserver> in_new_observer, GetAllCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::StorageArea::GetAll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_observer"), in_new_observer,
                        "<value of type ::mojo::PendingRemote<StorageAreaObserver>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageArea_GetAll_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_GetAll_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::StorageAreaObserverInterfaceBase>>(
      in_new_observer, &params->new_observer, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("GetAll");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StorageArea_GetAll_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class StorageArea_Put_ProxyToResponder {
 public:
  static StorageArea::PutCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<StorageArea_Put_ProxyToResponder> proxy(
        new StorageArea_Put_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&StorageArea_Put_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StorageArea_Put_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  StorageArea_Put_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StorageArea::PutCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(StorageArea_Put_ProxyToResponder);
};

bool StorageArea_Put_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::StorageArea::PutCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::StorageArea_Put_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StorageArea_Put_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  StorageArea_Put_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StorageArea::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void StorageArea_Put_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::StorageArea::PutCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageArea_Put_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_Put_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::StorageArea::PutCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("Put");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StorageArea_Delete_ProxyToResponder {
 public:
  static StorageArea::DeleteCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<StorageArea_Delete_ProxyToResponder> proxy(
        new StorageArea_Delete_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&StorageArea_Delete_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StorageArea_Delete_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  StorageArea_Delete_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StorageArea::DeleteCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(StorageArea_Delete_ProxyToResponder);
};

bool StorageArea_Delete_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::StorageArea::DeleteCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::StorageArea_Delete_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StorageArea_Delete_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  StorageArea_Delete_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StorageArea::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void StorageArea_Delete_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::StorageArea::DeleteCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageArea_Delete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_Delete_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::StorageArea::DeleteCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("Delete");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StorageArea_DeleteAll_ProxyToResponder {
 public:
  static StorageArea::DeleteAllCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<StorageArea_DeleteAll_ProxyToResponder> proxy(
        new StorageArea_DeleteAll_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&StorageArea_DeleteAll_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StorageArea_DeleteAll_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  StorageArea_DeleteAll_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StorageArea::DeleteAllCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(StorageArea_DeleteAll_ProxyToResponder);
};

bool StorageArea_DeleteAll_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::StorageArea::DeleteAllCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::StorageArea_DeleteAll_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StorageArea_DeleteAll_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  StorageArea_DeleteAll_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StorageArea::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void StorageArea_DeleteAll_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::StorageArea::DeleteAllCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageArea_DeleteAll_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_DeleteAll_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::StorageArea::DeleteAllCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("DeleteAll");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StorageArea_Get_ProxyToResponder {
 public:
  static StorageArea::GetCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<StorageArea_Get_ProxyToResponder> proxy(
        new StorageArea_Get_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&StorageArea_Get_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StorageArea_Get_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  StorageArea_Get_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StorageArea::GetCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::vector<uint8_t>& in_value);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(StorageArea_Get_ProxyToResponder);
};

bool StorageArea_Get_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::StorageArea::GetCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::StorageArea_Get_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StorageArea_Get_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  std::vector<uint8_t> p_value{};
  StorageArea_Get_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StorageArea::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_value));
  return true;
}

void StorageArea_Get_ProxyToResponder::Run(
    bool in_success, const std::vector<uint8_t>& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::StorageArea::GetCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageArea_Get_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_Get_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType>
      value_fragment(params.message());
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_value, value_fragment, &value_validate_params);
  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::StorageArea::GetCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("Get");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StorageArea_GetAll_ProxyToResponder {
 public:
  static StorageArea::GetAllCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<StorageArea_GetAll_ProxyToResponder> proxy(
        new StorageArea_GetAll_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&StorageArea_GetAll_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StorageArea_GetAll_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  StorageArea_GetAll_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StorageArea::GetAllCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<KeyValuePtr> in_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(StorageArea_GetAll_ProxyToResponder);
};

bool StorageArea_GetAll_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::StorageArea::GetAllCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::StorageArea_GetAll_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StorageArea_GetAll_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<KeyValuePtr> p_data{};
  StorageArea_GetAll_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StorageArea::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_data));
  return true;
}

void StorageArea_GetAll_ProxyToResponder::Run(
    std::vector<KeyValuePtr> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::StorageArea::GetAllCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type std::vector<KeyValuePtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kStorageArea_GetAll_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::StorageArea_GetAll_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::KeyValueDataView>>(
      in_data, data_fragment, &data_validate_params);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::StorageArea::GetAllCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageArea::Name_);
  message.set_method_name("GetAll");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool StorageArea_GetAll_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::StorageArea_GetAll_ResponseParams_Data* params =
      reinterpret_cast<internal::StorageArea_GetAll_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  std::vector<KeyValuePtr> p_data{};
  StorageArea_GetAll_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StorageArea::Name_, 5, true);
    return false;
  }
  *out_data_ = std::move(p_data);
  *result_ = true;
  return true;
}

// static
bool StorageAreaStubDispatch::Accept(
    StorageArea* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kStorageArea_AddObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::StorageArea::AddObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::StorageArea::AddObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::StorageArea_AddObserver_Params_Data* params =
          reinterpret_cast<internal::StorageArea_AddObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<StorageAreaObserver> p_observer{};
      StorageArea_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageArea::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(
std::move(p_observer));
      return true;
    }
    case internal::kStorageArea_Put_Name: {
      break;
    }
    case internal::kStorageArea_Delete_Name: {
      break;
    }
    case internal::kStorageArea_DeleteAll_Name: {
      break;
    }
    case internal::kStorageArea_Get_Name: {
      break;
    }
    case internal::kStorageArea_GetAll_Name: {
      break;
    }
  }
  return false;
}

// static
bool StorageAreaStubDispatch::AcceptWithResponder(
    StorageArea* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kStorageArea_AddObserver_Name: {
      break;
    }
    case internal::kStorageArea_Put_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::StorageArea::Put",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::StorageArea::Put");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::StorageArea_Put_Params_Data* params =
          reinterpret_cast<
              internal::StorageArea_Put_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_key{};
      std::vector<uint8_t> p_value{};
      absl::optional<std::vector<uint8_t>> p_client_old_value{};
      std::string p_source{};
      StorageArea_Put_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (success && !input_data_view.ReadClientOldValue(&p_client_old_value))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageArea::Name_, 1, false);
        return false;
      }
      StorageArea::PutCallback callback =
          StorageArea_Put_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Put(
std::move(p_key), 
std::move(p_value), 
std::move(p_client_old_value), 
std::move(p_source), std::move(callback));
      return true;
    }
    case internal::kStorageArea_Delete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::StorageArea::Delete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::StorageArea::Delete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::StorageArea_Delete_Params_Data* params =
          reinterpret_cast<
              internal::StorageArea_Delete_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_key{};
      absl::optional<std::vector<uint8_t>> p_client_old_value{};
      std::string p_source{};
      StorageArea_Delete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadClientOldValue(&p_client_old_value))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageArea::Name_, 2, false);
        return false;
      }
      StorageArea::DeleteCallback callback =
          StorageArea_Delete_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Delete(
std::move(p_key), 
std::move(p_client_old_value), 
std::move(p_source), std::move(callback));
      return true;
    }
    case internal::kStorageArea_DeleteAll_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::StorageArea::DeleteAll",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::StorageArea::DeleteAll");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::StorageArea_DeleteAll_Params_Data* params =
          reinterpret_cast<
              internal::StorageArea_DeleteAll_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_source{};
      ::mojo::PendingRemote<StorageAreaObserver> p_new_observer{};
      StorageArea_DeleteAll_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success) {
        p_new_observer =
            input_data_view.TakeNewObserver<decltype(p_new_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageArea::Name_, 3, false);
        return false;
      }
      StorageArea::DeleteAllCallback callback =
          StorageArea_DeleteAll_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteAll(
std::move(p_source), 
std::move(p_new_observer), std::move(callback));
      return true;
    }
    case internal::kStorageArea_Get_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::StorageArea::Get",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::StorageArea::Get");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::StorageArea_Get_Params_Data* params =
          reinterpret_cast<
              internal::StorageArea_Get_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_key{};
      StorageArea_Get_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageArea::Name_, 4, false);
        return false;
      }
      StorageArea::GetCallback callback =
          StorageArea_Get_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Get(
std::move(p_key), std::move(callback));
      return true;
    }
    case internal::kStorageArea_GetAll_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::StorageArea::GetAll",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::StorageArea::GetAll");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::StorageArea_GetAll_Params_Data* params =
          reinterpret_cast<
              internal::StorageArea_GetAll_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<StorageAreaObserver> p_new_observer{};
      StorageArea_GetAll_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_new_observer =
            input_data_view.TakeNewObserver<decltype(p_new_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageArea::Name_, 5, false);
        return false;
      }
      StorageArea::GetAllCallback callback =
          StorageArea_GetAll_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAll(
std::move(p_new_observer), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kStorageAreaValidationInfo[] = {
    {internal::kStorageArea_AddObserver_Name,
     {&internal::StorageArea_AddObserver_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kStorageArea_Put_Name,
     {&internal::StorageArea_Put_Params_Data::Validate,
      &internal::StorageArea_Put_ResponseParams_Data::Validate}},
    {internal::kStorageArea_Delete_Name,
     {&internal::StorageArea_Delete_Params_Data::Validate,
      &internal::StorageArea_Delete_ResponseParams_Data::Validate}},
    {internal::kStorageArea_DeleteAll_Name,
     {&internal::StorageArea_DeleteAll_Params_Data::Validate,
      &internal::StorageArea_DeleteAll_ResponseParams_Data::Validate}},
    {internal::kStorageArea_Get_Name,
     {&internal::StorageArea_Get_Params_Data::Validate,
      &internal::StorageArea_Get_ResponseParams_Data::Validate}},
    {internal::kStorageArea_GetAll_Name,
     {&internal::StorageArea_GetAll_Params_Data::Validate,
      &internal::StorageArea_GetAll_ResponseParams_Data::Validate}},
};

bool StorageAreaRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::StorageArea::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kStorageAreaValidationInfo);
}

bool StorageAreaResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::StorageArea::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kStorageAreaValidationInfo);

}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::KeyValue::DataView, ::blink::mojom::KeyValuePtr>::Read(
    ::blink::mojom::KeyValue::DataView input,
    ::blink::mojom::KeyValuePtr* output) {
  bool success = true;
  ::blink::mojom::KeyValuePtr result(::blink::mojom::KeyValue::New());
  
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif