// third_party/blink/public/mojom/fetch/fetch_api_request.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-params-data.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_JUMBO_H_
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#endif
namespace blink {
namespace mojom {
FetchAPIRequestHeaders::FetchAPIRequestHeaders()
    : headers() {}

FetchAPIRequestHeaders::FetchAPIRequestHeaders(
    const base::flat_map<std::string, std::string>& headers_in)
    : headers(std::move(headers_in)) {}

FetchAPIRequestHeaders::~FetchAPIRequestHeaders() = default;

void FetchAPIRequestHeaders::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FetchAPIRequestHeaders::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FetchAPIRequestBody::FetchAPIRequestBody()
    : elements(),
      identifier(),
      contains_sensitive_info() {}

FetchAPIRequestBody::FetchAPIRequestBody(
    std::vector<::network::DataElement> elements_in,
    uint64_t identifier_in,
    bool contains_sensitive_info_in)
    : elements(std::move(elements_in)),
      identifier(std::move(identifier_in)),
      contains_sensitive_info(std::move(contains_sensitive_info_in)) {}

FetchAPIRequestBody::~FetchAPIRequestBody() = default;

void FetchAPIRequestBody::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "elements"), this->elements,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::network::DataElement>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "identifier"), this->identifier,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contains_sensitive_info"), this->contains_sensitive_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FetchAPIRequestBody::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FetchAPIRequest::FetchAPIRequest()
    : mode(::network::mojom::RequestMode::kNoCors),
      is_main_resource_load(false),
      destination(::network::mojom::RequestDestination::kEmpty),
      frame_type(::blink::mojom::RequestContextFrameType::kNone),
      url(),
      method(),
      headers(),
      blob(),
      body(),
      request_initiator(),
      navigation_redirect_chain(),
      referrer(),
      credentials_mode(::network::mojom::CredentialsMode::kOmit),
      cache_mode(FetchCacheMode::kDefault),
      redirect_mode(::network::mojom::RedirectMode::kFollow),
      integrity(),
      priority(mojo::internal::ConvertEnumValue<::network::mojom::RequestPriority, ::net::RequestPriority>(::network::mojom::RequestPriority::kIdle)),
      fetch_window_id(),
      keepalive(false),
      is_reload(false),
      is_history_navigation(false),
      devtools_stack_id() {}

FetchAPIRequest::FetchAPIRequest(
    ::network::mojom::RequestMode mode_in,
    bool is_main_resource_load_in,
    ::network::mojom::RequestDestination destination_in,
    ::blink::mojom::RequestContextFrameType frame_type_in,
    const ::GURL& url_in,
    const std::string& method_in,
    ::blink::FetchAPIRequestHeadersMap headers_in,
    ::blink::mojom::SerializedBlobPtr blob_in,
    ::scoped_refptr<::network::ResourceRequestBody> body_in,
    const absl::optional<::url::Origin>& request_initiator_in,
    std::vector<::GURL> navigation_redirect_chain_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    ::network::mojom::CredentialsMode credentials_mode_in,
    FetchCacheMode cache_mode_in,
    ::network::mojom::RedirectMode redirect_mode_in,
    const absl::optional<std::string>& integrity_in,
    ::net::RequestPriority priority_in,
    const absl::optional<::base::UnguessableToken>& fetch_window_id_in,
    bool keepalive_in,
    bool is_reload_in,
    bool is_history_navigation_in,
    const absl::optional<std::string>& devtools_stack_id_in)
    : mode(std::move(mode_in)),
      is_main_resource_load(std::move(is_main_resource_load_in)),
      destination(std::move(destination_in)),
      frame_type(std::move(frame_type_in)),
      url(std::move(url_in)),
      method(std::move(method_in)),
      headers(std::move(headers_in)),
      blob(std::move(blob_in)),
      body(std::move(body_in)),
      request_initiator(std::move(request_initiator_in)),
      navigation_redirect_chain(std::move(navigation_redirect_chain_in)),
      referrer(std::move(referrer_in)),
      credentials_mode(std::move(credentials_mode_in)),
      cache_mode(std::move(cache_mode_in)),
      redirect_mode(std::move(redirect_mode_in)),
      integrity(std::move(integrity_in)),
      priority(std::move(priority_in)),
      fetch_window_id(std::move(fetch_window_id_in)),
      keepalive(std::move(keepalive_in)),
      is_reload(std::move(is_reload_in)),
      is_history_navigation(std::move(is_history_navigation_in)),
      devtools_stack_id(std::move(devtools_stack_id_in)) {}

FetchAPIRequest::~FetchAPIRequest() = default;

void FetchAPIRequest::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::RequestMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_main_resource_load"), this->is_main_resource_load,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "destination"), this->destination,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::RequestDestination>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_type"), this->frame_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::RequestContextFrameType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::FetchAPIRequestHeadersMap>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blob"), this->blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::SerializedBlobPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body"), this->body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::scoped_refptr<::network::ResourceRequestBody>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_initiator"), this->request_initiator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_redirect_chain"), this->navigation_redirect_chain,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ReferrerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "credentials_mode"), this->credentials_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::CredentialsMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache_mode"), this->cache_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FetchCacheMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redirect_mode"), this->redirect_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::RedirectMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "integrity"), this->integrity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::RequestPriority>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fetch_window_id"), this->fetch_window_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keepalive"), this->keepalive,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_reload"), this->is_reload,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_history_navigation"), this->is_history_navigation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_stack_id"), this->devtools_stack_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FetchAPIRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::FetchAPIRequestHeaders::DataView, ::blink::mojom::FetchAPIRequestHeadersPtr>::Read(
    ::blink::mojom::FetchAPIRequestHeaders::DataView input,
    ::blink::mojom::FetchAPIRequestHeadersPtr* output) {
  bool success = true;
  ::blink::mojom::FetchAPIRequestHeadersPtr result(::blink::mojom::FetchAPIRequestHeaders::New());
  
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FetchAPIRequestBody::DataView, ::blink::mojom::FetchAPIRequestBodyPtr>::Read(
    ::blink::mojom::FetchAPIRequestBody::DataView input,
    ::blink::mojom::FetchAPIRequestBodyPtr* output) {
  bool success = true;
  ::blink::mojom::FetchAPIRequestBodyPtr result(::blink::mojom::FetchAPIRequestBody::New());
  
      if (success && !input.ReadElements(&result->elements))
        success = false;
      if (success)
        result->identifier = input.identifier();
      if (success)
        result->contains_sensitive_info = input.contains_sensitive_info();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FetchAPIRequest::DataView, ::blink::mojom::FetchAPIRequestPtr>::Read(
    ::blink::mojom::FetchAPIRequest::DataView input,
    ::blink::mojom::FetchAPIRequestPtr* output) {
  bool success = true;
  ::blink::mojom::FetchAPIRequestPtr result(::blink::mojom::FetchAPIRequest::New());
  
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success)
        result->is_main_resource_load = input.is_main_resource_load();
      if (success && !input.ReadDestination(&result->destination))
        success = false;
      if (success && !input.ReadFrameType(&result->frame_type))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadBlob(&result->blob))
        success = false;
      if (success && !input.ReadBody(&result->body))
        success = false;
      if (success && !input.ReadRequestInitiator(&result->request_initiator))
        success = false;
      if (success && !input.ReadNavigationRedirectChain(&result->navigation_redirect_chain))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadCredentialsMode(&result->credentials_mode))
        success = false;
      if (success && !input.ReadCacheMode(&result->cache_mode))
        success = false;
      if (success && !input.ReadRedirectMode(&result->redirect_mode))
        success = false;
      if (success && !input.ReadIntegrity(&result->integrity))
        success = false;
      if (success && !input.ReadPriority(&result->priority))
        success = false;
      if (success && !input.ReadFetchWindowId(&result->fetch_window_id))
        success = false;
      if (success)
        result->keepalive = input.keepalive();
      if (success)
        result->is_reload = input.is_reload();
      if (success)
        result->is_history_navigation = input.is_history_navigation();
      if (success && !input.ReadDevtoolsStackId(&result->devtools_stack_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif