// third_party/blink/public/mojom/file_system_access/file_system_access_access_handle_host.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/file_system_access_access_handle_host.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_access_handle_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_access_handle_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_access_handle_host.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_ACCESS_HANDLE_HOST_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_ACCESS_HANDLE_HOST_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char FileSystemAccessAccessHandleHost::Name_[] = "blink.mojom.FileSystemAccessAccessHandleHost";

class FileSystemAccessAccessHandleHost_Close_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessAccessHandleHost_Close_ForwardToCallback(
      FileSystemAccessAccessHandleHost::CloseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessAccessHandleHost::CloseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessAccessHandleHost_Close_ForwardToCallback);
};

FileSystemAccessAccessHandleHostProxy::FileSystemAccessAccessHandleHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessAccessHandleHostProxy::Close(
    CloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FileSystemAccessAccessHandleHost::Close");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessAccessHandleHost_Close_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessAccessHandleHost_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessAccessHandleHost::Name_);
  message.set_method_name("Close");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessAccessHandleHost_Close_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class FileSystemAccessAccessHandleHost_Close_ProxyToResponder {
 public:
  static FileSystemAccessAccessHandleHost::CloseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessAccessHandleHost_Close_ProxyToResponder> proxy(
        new FileSystemAccessAccessHandleHost_Close_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessAccessHandleHost_Close_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessAccessHandleHost_Close_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessAccessHandleHost_Close_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessAccessHandleHost::CloseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessAccessHandleHost_Close_ProxyToResponder);
};

bool FileSystemAccessAccessHandleHost_Close_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessAccessHandleHost::CloseCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessAccessHandleHost_Close_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessAccessHandleHost_Close_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  FileSystemAccessAccessHandleHost_Close_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessAccessHandleHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void FileSystemAccessAccessHandleHost_Close_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::FileSystemAccessAccessHandleHost::CloseCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessAccessHandleHost_Close_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessAccessHandleHost_Close_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessAccessHandleHost::CloseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessAccessHandleHost::Name_);
  message.set_method_name("Close");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileSystemAccessAccessHandleHostStubDispatch::Accept(
    FileSystemAccessAccessHandleHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFileSystemAccessAccessHandleHost_Close_Name: {
      break;
    }
  }
  return false;
}

// static
bool FileSystemAccessAccessHandleHostStubDispatch::AcceptWithResponder(
    FileSystemAccessAccessHandleHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFileSystemAccessAccessHandleHost_Close_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessAccessHandleHost::Close",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessAccessHandleHost::Close");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessAccessHandleHost_Close_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessAccessHandleHost_Close_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      FileSystemAccessAccessHandleHost_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessAccessHandleHost::Name_, 0, false);
        return false;
      }
      FileSystemAccessAccessHandleHost::CloseCallback callback =
          FileSystemAccessAccessHandleHost_Close_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFileSystemAccessAccessHandleHostValidationInfo[] = {
    {&internal::FileSystemAccessAccessHandleHost_Close_Params_Data::Validate,
     &internal::FileSystemAccessAccessHandleHost_Close_ResponseParams_Data::Validate},
};

bool FileSystemAccessAccessHandleHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::FileSystemAccessAccessHandleHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFileSystemAccessAccessHandleHostValidationInfo);
}

bool FileSystemAccessAccessHandleHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::FileSystemAccessAccessHandleHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kFileSystemAccessAccessHandleHostValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif