// third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_DELEGATE_HOST_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_DELEGATE_HOST_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char FileSystemAccessFileDelegateHost::Name_[] = "blink.mojom.FileSystemAccessFileDelegateHost";
bool FileSystemAccessFileDelegateHost::Read(uint64_t offset, uint64_t bytes_to_read, absl::optional<::mojo_base::BigBuffer>* out_data, ::base::File::Error* out_error, int32_t* out_bytes_read) {
  NOTREACHED();
  return false;
}
bool FileSystemAccessFileDelegateHost::Write(uint64_t offset, ::mojo::ScopedDataPipeConsumerHandle data, ::base::File::Error* out_error, int32_t* out_bytes_written) {
  NOTREACHED();
  return false;
}
class FileSystemAccessFileDelegateHost_Read_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileDelegateHost_Read_HandleSyncResponse(
      bool* result, absl::optional<::mojo_base::BigBuffer>* out_data, ::base::File::Error* out_error, int32_t* out_bytes_read)
      : result_(result), out_data_(out_data), out_error_(out_error), out_bytes_read_(out_bytes_read) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  absl::optional<::mojo_base::BigBuffer>* out_data_;
  ::base::File::Error* out_error_;
  int32_t* out_bytes_read_;DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileDelegateHost_Read_HandleSyncResponse);
};

class FileSystemAccessFileDelegateHost_Read_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileDelegateHost_Read_ForwardToCallback(
      FileSystemAccessFileDelegateHost::ReadCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileDelegateHost::ReadCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileDelegateHost_Read_ForwardToCallback);
};
class FileSystemAccessFileDelegateHost_Write_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileDelegateHost_Write_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, int32_t* out_bytes_written)
      : result_(result), out_error_(out_error), out_bytes_written_(out_bytes_written) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  int32_t* out_bytes_written_;DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileDelegateHost_Write_HandleSyncResponse);
};

class FileSystemAccessFileDelegateHost_Write_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileDelegateHost_Write_ForwardToCallback(
      FileSystemAccessFileDelegateHost::WriteCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileDelegateHost::WriteCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileDelegateHost_Write_ForwardToCallback);
};

class FileSystemAccessFileDelegateHost_GetLength_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileDelegateHost_GetLength_ForwardToCallback(
      FileSystemAccessFileDelegateHost::GetLengthCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileDelegateHost::GetLengthCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileDelegateHost_GetLength_ForwardToCallback);
};

class FileSystemAccessFileDelegateHost_SetLength_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileDelegateHost_SetLength_ForwardToCallback(
      FileSystemAccessFileDelegateHost::SetLengthCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileDelegateHost::SetLengthCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileDelegateHost_SetLength_ForwardToCallback);
};

FileSystemAccessFileDelegateHostProxy::FileSystemAccessFileDelegateHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool FileSystemAccessFileDelegateHostProxy::Read(
    uint64_t param_offset, uint64_t param_bytes_to_read, absl::optional<::mojo_base::BigBuffer>* out_param_data, ::base::File::Error* out_param_error, int32_t* out_param_bytes_read) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::FileSystemAccessFileDelegateHost::Read", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), param_offset,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes_to_read"), param_bytes_to_read,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessFileDelegateHost_Read_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_Read_Params_Data> params(
          message);
  params.Allocate();
  params->offset = param_offset;
  params->bytes_to_read = param_bytes_to_read;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("Read");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileDelegateHost_Read_HandleSyncResponse(
          &result, out_param_data, out_param_error, out_param_bytes_read));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::FileSystemAccessFileDelegateHost::Read", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), out_param_data,
                        "<value of type absl::optional<::mojo_base::BigBuffer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes_read"), out_param_bytes_read,
                        "<value of type int32_t>");
   });
#endif
  return result;
}

void FileSystemAccessFileDelegateHostProxy::Read(
    uint64_t in_offset, uint64_t in_bytes_to_read, ReadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessFileDelegateHost::Read", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes_to_read"), in_bytes_to_read,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessFileDelegateHost_Read_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_Read_Params_Data> params(
          message);
  params.Allocate();
  params->offset = in_offset;
  params->bytes_to_read = in_bytes_to_read;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("Read");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileDelegateHost_Read_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool FileSystemAccessFileDelegateHostProxy::Write(
    uint64_t param_offset, ::mojo::ScopedDataPipeConsumerHandle param_data, ::base::File::Error* out_param_error, int32_t* out_param_bytes_written) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::FileSystemAccessFileDelegateHost::Write", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), param_offset,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), param_data,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessFileDelegateHost_Write_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_Write_Params_Data> params(
          message);
  params.Allocate();
  params->offset = param_offset;
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      param_data, &params->data, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->data),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid data in FileSystemAccessFileDelegateHost.Write request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("Write");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileDelegateHost_Write_HandleSyncResponse(
          &result, out_param_error, out_param_bytes_written));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::FileSystemAccessFileDelegateHost::Write", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes_written"), out_param_bytes_written,
                        "<value of type int32_t>");
   });
#endif
  return result;
}

void FileSystemAccessFileDelegateHostProxy::Write(
    uint64_t in_offset, ::mojo::ScopedDataPipeConsumerHandle in_data, WriteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessFileDelegateHost::Write", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessFileDelegateHost_Write_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_Write_Params_Data> params(
          message);
  params.Allocate();
  params->offset = in_offset;
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_data, &params->data, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->data),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid data in FileSystemAccessFileDelegateHost.Write request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("Write");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileDelegateHost_Write_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessFileDelegateHostProxy::GetLength(
    GetLengthCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FileSystemAccessFileDelegateHost::GetLength");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessFileDelegateHost_GetLength_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_GetLength_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("GetLength");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileDelegateHost_GetLength_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FileSystemAccessFileDelegateHostProxy::SetLength(
    uint64_t in_length, SetLengthCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FileSystemAccessFileDelegateHost::SetLength", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessFileDelegateHost_SetLength_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_SetLength_Params_Data> params(
          message);
  params.Allocate();
  params->length = in_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("SetLength");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileDelegateHost_SetLength_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class FileSystemAccessFileDelegateHost_Read_ProxyToResponder {
 public:
  static FileSystemAccessFileDelegateHost::ReadCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessFileDelegateHost_Read_ProxyToResponder> proxy(
        new FileSystemAccessFileDelegateHost_Read_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessFileDelegateHost_Read_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileDelegateHost_Read_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessFileDelegateHost_Read_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessFileDelegateHost::ReadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      absl::optional<::mojo_base::BigBuffer> in_data, ::base::File::Error in_error, int32_t in_bytes_read);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileDelegateHost_Read_ProxyToResponder);
};

bool FileSystemAccessFileDelegateHost_Read_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessFileDelegateHost::ReadCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileDelegateHost_Read_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileDelegateHost_Read_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  absl::optional<::mojo_base::BigBuffer> p_data{};
  ::base::File::Error p_error{};
  int32_t p_bytes_read{};
  FileSystemAccessFileDelegateHost_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_bytes_read = input_data_view.bytes_read();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileDelegateHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_data), 
std::move(p_error), 
std::move(p_bytes_read));
  return true;
}

void FileSystemAccessFileDelegateHost_Read_ProxyToResponder::Run(
    absl::optional<::mojo_base::BigBuffer> in_data, ::base::File::Error in_error, int32_t in_bytes_read) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::ReadCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type absl::optional<::mojo_base::BigBuffer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes_read"), in_bytes_read,
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessFileDelegateHost_Read_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_Read_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, data_fragment, true);
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);
  params->bytes_read = in_bytes_read;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::ReadCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("Read");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemAccessFileDelegateHost_Read_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileDelegateHost_Read_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemAccessFileDelegateHost_Read_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  absl::optional<::mojo_base::BigBuffer> p_data{};
  ::base::File::Error p_error{};
  int32_t p_bytes_read{};
  FileSystemAccessFileDelegateHost_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_bytes_read = input_data_view.bytes_read();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileDelegateHost::Name_, 0, true);
    return false;
  }
  *out_data_ = std::move(p_data);
  *out_error_ = std::move(p_error);
  *out_bytes_read_ = std::move(p_bytes_read);
  *result_ = true;
  return true;
}
class FileSystemAccessFileDelegateHost_Write_ProxyToResponder {
 public:
  static FileSystemAccessFileDelegateHost::WriteCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessFileDelegateHost_Write_ProxyToResponder> proxy(
        new FileSystemAccessFileDelegateHost_Write_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessFileDelegateHost_Write_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileDelegateHost_Write_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessFileDelegateHost_Write_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessFileDelegateHost::WriteCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, int32_t in_bytes_written);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileDelegateHost_Write_ProxyToResponder);
};

bool FileSystemAccessFileDelegateHost_Write_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessFileDelegateHost::WriteCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileDelegateHost_Write_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileDelegateHost_Write_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  int32_t p_bytes_written{};
  FileSystemAccessFileDelegateHost_Write_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_bytes_written = input_data_view.bytes_written();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileDelegateHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_bytes_written));
  return true;
}

void FileSystemAccessFileDelegateHost_Write_ProxyToResponder::Run(
    ::base::File::Error in_error, int32_t in_bytes_written) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::WriteCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes_written"), in_bytes_written,
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessFileDelegateHost_Write_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_Write_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);
  params->bytes_written = in_bytes_written;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::WriteCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("Write");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemAccessFileDelegateHost_Write_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileDelegateHost_Write_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemAccessFileDelegateHost_Write_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  int32_t p_bytes_written{};
  FileSystemAccessFileDelegateHost_Write_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_bytes_written = input_data_view.bytes_written();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileDelegateHost::Name_, 1, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_bytes_written_ = std::move(p_bytes_written);
  *result_ = true;
  return true;
}
class FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder {
 public:
  static FileSystemAccessFileDelegateHost::GetLengthCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder> proxy(
        new FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessFileDelegateHost::GetLengthCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, uint64_t in_length);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder);
};

bool FileSystemAccessFileDelegateHost_GetLength_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessFileDelegateHost::GetLengthCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileDelegateHost_GetLength_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileDelegateHost_GetLength_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File::Error p_error{};
  uint64_t p_length{};
  FileSystemAccessFileDelegateHost_GetLength_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_length = input_data_view.length();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileDelegateHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_length));
  return true;
}

void FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder::Run(
    ::base::File::Error in_error, uint64_t in_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::GetLengthCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type uint64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessFileDelegateHost_GetLength_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_GetLength_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);
  params->length = in_length;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::GetLengthCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("GetLength");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder {
 public:
  static FileSystemAccessFileDelegateHost::SetLengthCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder> proxy(
        new FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileSystemAccessFileDelegateHost::SetLengthCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder);
};

bool FileSystemAccessFileDelegateHost_SetLength_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FileSystemAccessFileDelegateHost::SetLengthCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileDelegateHost_SetLength_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileDelegateHost_SetLength_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  FileSystemAccessFileDelegateHost_SetLength_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileDelegateHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::SetLengthCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kFileSystemAccessFileDelegateHost_SetLength_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileDelegateHost_SetLength_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::SetLengthCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileDelegateHost::Name_);
  message.set_method_name("SetLength");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileSystemAccessFileDelegateHostStubDispatch::Accept(
    FileSystemAccessFileDelegateHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kFileSystemAccessFileDelegateHost_Read_Name: {
      break;
    }
    case internal::kFileSystemAccessFileDelegateHost_Write_Name: {
      break;
    }
    case internal::kFileSystemAccessFileDelegateHost_GetLength_Name: {
      break;
    }
    case internal::kFileSystemAccessFileDelegateHost_SetLength_Name: {
      break;
    }
  }
  return false;
}

// static
bool FileSystemAccessFileDelegateHostStubDispatch::AcceptWithResponder(
    FileSystemAccessFileDelegateHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFileSystemAccessFileDelegateHost_Read_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::Read",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::Read");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessFileDelegateHost_Read_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileDelegateHost_Read_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_offset{};
      uint64_t p_bytes_to_read{};
      FileSystemAccessFileDelegateHost_Read_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_bytes_to_read = input_data_view.bytes_to_read();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileDelegateHost::Name_, 0, false);
        return false;
      }
      FileSystemAccessFileDelegateHost::ReadCallback callback =
          FileSystemAccessFileDelegateHost_Read_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Read(
std::move(p_offset), 
std::move(p_bytes_to_read), std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessFileDelegateHost_Write_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::Write",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::Write");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessFileDelegateHost_Write_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileDelegateHost_Write_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_offset{};
      ::mojo::ScopedDataPipeConsumerHandle p_data{};
      FileSystemAccessFileDelegateHost_Write_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_data = input_data_view.TakeData();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileDelegateHost::Name_, 1, false);
        return false;
      }
      FileSystemAccessFileDelegateHost::WriteCallback callback =
          FileSystemAccessFileDelegateHost_Write_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Write(
std::move(p_offset), 
std::move(p_data), std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessFileDelegateHost_GetLength_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::GetLength",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::GetLength");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessFileDelegateHost_GetLength_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileDelegateHost_GetLength_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      FileSystemAccessFileDelegateHost_GetLength_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileDelegateHost::Name_, 2, false);
        return false;
      }
      FileSystemAccessFileDelegateHost::GetLengthCallback callback =
          FileSystemAccessFileDelegateHost_GetLength_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetLength(std::move(callback));
      return true;
    }
    case internal::kFileSystemAccessFileDelegateHost_SetLength_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::SetLength",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FileSystemAccessFileDelegateHost::SetLength");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FileSystemAccessFileDelegateHost_SetLength_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileDelegateHost_SetLength_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_length{};
      FileSystemAccessFileDelegateHost_SetLength_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_length = input_data_view.length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileDelegateHost::Name_, 3, false);
        return false;
      }
      FileSystemAccessFileDelegateHost::SetLengthCallback callback =
          FileSystemAccessFileDelegateHost_SetLength_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLength(
std::move(p_length), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFileSystemAccessFileDelegateHostValidationInfo[] = {
    {&internal::FileSystemAccessFileDelegateHost_Read_Params_Data::Validate,
     &internal::FileSystemAccessFileDelegateHost_Read_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessFileDelegateHost_Write_Params_Data::Validate,
     &internal::FileSystemAccessFileDelegateHost_Write_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessFileDelegateHost_GetLength_Params_Data::Validate,
     &internal::FileSystemAccessFileDelegateHost_GetLength_ResponseParams_Data::Validate},
    {&internal::FileSystemAccessFileDelegateHost_SetLength_Params_Data::Validate,
     &internal::FileSystemAccessFileDelegateHost_SetLength_ResponseParams_Data::Validate},
};

bool FileSystemAccessFileDelegateHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FileSystemAccessFileDelegateHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFileSystemAccessFileDelegateHostValidationInfo);
}

bool FileSystemAccessFileDelegateHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FileSystemAccessFileDelegateHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kFileSystemAccessFileDelegateHostValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif