// third_party/blink/public/mojom/filesystem/file_system.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/filesystem/file_system.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/filesystem/file_system.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* FileSystemTypeToStringHelper(FileSystemType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FileSystemType::kTemporary:
      return "kTemporary";
    case FileSystemType::kPersistent:
      return "kPersistent";
    case FileSystemType::kIsolated:
      return "kIsolated";
    case FileSystemType::kExternal:
      return "kExternal";
    default:
      return nullptr;
  }
}

std::string FileSystemTypeToString(FileSystemType value) {
  const char *str = FileSystemTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FileSystemType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FileSystemType value) {
  return os << FileSystemTypeToString(value);
}

namespace internal {


// static
bool FileSystemInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemInfo_Data* object = static_cast<const FileSystemInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_url, validation_context))
    return false;


  if (!::blink::mojom::internal::FileSystemType_Data
        ::Validate(object->mount_type, validation_context))
    return false;

  return true;
}

FileSystemInfo_Data::FileSystemInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemCancellableOperation_Cancel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemCancellableOperation_Cancel_Params_Data* object = static_cast<const FileSystemCancellableOperation_Cancel_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FileSystemCancellableOperation_Cancel_Params_Data::FileSystemCancellableOperation_Cancel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemCancellableOperation_Cancel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemCancellableOperation_Cancel_ResponseParams_Data* object = static_cast<const FileSystemCancellableOperation_Cancel_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error_code, validation_context))
    return false;

  return true;
}

FileSystemCancellableOperation_Cancel_ResponseParams_Data::FileSystemCancellableOperation_Cancel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemOperationListener_ResultsRetrieved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemOperationListener_ResultsRetrieved_Params_Data* object = static_cast<const FileSystemOperationListener_ResultsRetrieved_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entries, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams entries_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->entries, validation_context,
                                         &entries_validate_params)) {
    return false;
  }

  return true;
}

FileSystemOperationListener_ResultsRetrieved_Params_Data::FileSystemOperationListener_ResultsRetrieved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemOperationListener_DidWrite_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemOperationListener_DidWrite_Params_Data* object = static_cast<const FileSystemOperationListener_DidWrite_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

FileSystemOperationListener_DidWrite_Params_Data::FileSystemOperationListener_DidWrite_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemOperationListener_ErrorOccurred_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemOperationListener_ErrorOccurred_Params_Data* object = static_cast<const FileSystemOperationListener_ErrorOccurred_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error_code, validation_context))
    return false;

  return true;
}

FileSystemOperationListener_ErrorOccurred_Params_Data::FileSystemOperationListener_ErrorOccurred_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data* object = static_cast<const ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data::ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_Open_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_Open_Params_Data* object = static_cast<const FileSystemManager_Open_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;


  if (!::blink::mojom::internal::FileSystemType_Data
        ::Validate(object->file_system_type, validation_context))
    return false;

  return true;
}

FileSystemManager_Open_Params_Data::FileSystemManager_Open_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_Open_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_Open_ResponseParams_Data* object = static_cast<const FileSystemManager_Open_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_url, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error_code, validation_context))
    return false;

  return true;
}

FileSystemManager_Open_ResponseParams_Data::FileSystemManager_Open_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_ResolveURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_ResolveURL_Params_Data* object = static_cast<const FileSystemManager_ResolveURL_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filesystem_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filesystem_url, validation_context))
    return false;

  return true;
}

FileSystemManager_ResolveURL_Params_Data::FileSystemManager_ResolveURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_ResolveURL_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_ResolveURL_ResponseParams_Data* object = static_cast<const FileSystemManager_ResolveURL_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_path, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_path, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error_code, validation_context))
    return false;

  return true;
}

FileSystemManager_ResolveURL_ResponseParams_Data::FileSystemManager_ResolveURL_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_Move_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_Move_Params_Data* object = static_cast<const FileSystemManager_Move_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->src_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->src_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dest_path, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dest_path, validation_context))
    return false;

  return true;
}

FileSystemManager_Move_Params_Data::FileSystemManager_Move_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_Move_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_Move_ResponseParams_Data* object = static_cast<const FileSystemManager_Move_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error_code, validation_context))
    return false;

  return true;
}

FileSystemManager_Move_ResponseParams_Data::FileSystemManager_Move_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_Copy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_Copy_Params_Data* object = static_cast<const FileSystemManager_Copy_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->src_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->src_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dest_path, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dest_path, validation_context))
    return false;

  return true;
}

FileSystemManager_Copy_Params_Data::FileSystemManager_Copy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_Copy_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_Copy_ResponseParams_Data* object = static_cast<const FileSystemManager_Copy_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error_code, validation_context))
    return false;

  return true;
}

FileSystemManager_Copy_ResponseParams_Data::FileSystemManager_Copy_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_Remove_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_Remove_Params_Data* object = static_cast<const FileSystemManager_Remove_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  return true;
}

FileSystemManager_Remove_Params_Data::FileSystemManager_Remove_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_Remove_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_Remove_ResponseParams_Data* object = static_cast<const FileSystemManager_Remove_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error_code, validation_context))
    return false;

  return true;
}

FileSystemManager_Remove_ResponseParams_Data::FileSystemManager_Remove_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_ReadMetadata_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_ReadMetadata_Params_Data* object = static_cast<const FileSystemManager_ReadMetadata_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  return true;
}

FileSystemManager_ReadMetadata_Params_Data::FileSystemManager_ReadMetadata_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_ReadMetadata_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_ReadMetadata_ResponseParams_Data* object = static_cast<const FileSystemManager_ReadMetadata_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_info, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error_code, validation_context))
    return false;

  return true;
}

FileSystemManager_ReadMetadata_ResponseParams_Data::FileSystemManager_ReadMetadata_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_Create_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_Create_Params_Data* object = static_cast<const FileSystemManager_Create_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  return true;
}

FileSystemManager_Create_Params_Data::FileSystemManager_Create_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_Create_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_Create_ResponseParams_Data* object = static_cast<const FileSystemManager_Create_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error_code, validation_context))
    return false;

  return true;
}

FileSystemManager_Create_ResponseParams_Data::FileSystemManager_Create_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_Exists_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_Exists_Params_Data* object = static_cast<const FileSystemManager_Exists_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  return true;
}

FileSystemManager_Exists_Params_Data::FileSystemManager_Exists_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_Exists_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_Exists_ResponseParams_Data* object = static_cast<const FileSystemManager_Exists_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error_code, validation_context))
    return false;

  return true;
}

FileSystemManager_Exists_ResponseParams_Data::FileSystemManager_Exists_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_ReadDirectory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_ReadDirectory_Params_Data* object = static_cast<const FileSystemManager_ReadDirectory_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemManager_ReadDirectory_Params_Data::FileSystemManager_ReadDirectory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_ReadDirectorySync_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_ReadDirectorySync_Params_Data* object = static_cast<const FileSystemManager_ReadDirectorySync_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  return true;
}

FileSystemManager_ReadDirectorySync_Params_Data::FileSystemManager_ReadDirectorySync_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_ReadDirectorySync_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_ReadDirectorySync_ResponseParams_Data* object = static_cast<const FileSystemManager_ReadDirectorySync_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entries, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams entries_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->entries, validation_context,
                                         &entries_validate_params)) {
    return false;
  }


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error_code, validation_context))
    return false;

  return true;
}

FileSystemManager_ReadDirectorySync_ResponseParams_Data::FileSystemManager_ReadDirectorySync_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_Write_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_Write_Params_Data* object = static_cast<const FileSystemManager_Write_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->blob_uuid, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams blob_uuid_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->blob_uuid, validation_context,
                                         &blob_uuid_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->op_receiver, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->op_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemManager_Write_Params_Data::FileSystemManager_Write_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_WriteSync_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_WriteSync_Params_Data* object = static_cast<const FileSystemManager_WriteSync_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->blob_uuid, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams blob_uuid_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->blob_uuid, validation_context,
                                         &blob_uuid_validate_params)) {
    return false;
  }

  return true;
}

FileSystemManager_WriteSync_Params_Data::FileSystemManager_WriteSync_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_WriteSync_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_WriteSync_ResponseParams_Data* object = static_cast<const FileSystemManager_WriteSync_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error_code, validation_context))
    return false;

  return true;
}

FileSystemManager_WriteSync_ResponseParams_Data::FileSystemManager_WriteSync_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_Truncate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_Truncate_Params_Data* object = static_cast<const FileSystemManager_Truncate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_path, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->op_receiver, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->op_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemManager_Truncate_Params_Data::FileSystemManager_Truncate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_Truncate_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_Truncate_ResponseParams_Data* object = static_cast<const FileSystemManager_Truncate_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error_code, validation_context))
    return false;

  return true;
}

FileSystemManager_Truncate_ResponseParams_Data::FileSystemManager_Truncate_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_TruncateSync_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_TruncateSync_Params_Data* object = static_cast<const FileSystemManager_TruncateSync_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_path, validation_context))
    return false;

  return true;
}

FileSystemManager_TruncateSync_Params_Data::FileSystemManager_TruncateSync_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_TruncateSync_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_TruncateSync_ResponseParams_Data* object = static_cast<const FileSystemManager_TruncateSync_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error_code, validation_context))
    return false;

  return true;
}

FileSystemManager_TruncateSync_ResponseParams_Data::FileSystemManager_TruncateSync_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_CreateSnapshotFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_CreateSnapshotFile_Params_Data* object = static_cast<const FileSystemManager_CreateSnapshotFile_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_path, validation_context))
    return false;

  return true;
}

FileSystemManager_CreateSnapshotFile_Params_Data::FileSystemManager_CreateSnapshotFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_CreateSnapshotFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_CreateSnapshotFile_ResponseParams_Data* object = static_cast<const FileSystemManager_CreateSnapshotFile_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->platform_path, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->platform_path, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::FileError_Data
        ::Validate(object->error_code, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->snapshot_listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FileSystemManager_CreateSnapshotFile_ResponseParams_Data::FileSystemManager_CreateSnapshotFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_GetPlatformPath_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_GetPlatformPath_Params_Data* object = static_cast<const FileSystemManager_GetPlatformPath_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_path, validation_context))
    return false;

  return true;
}

FileSystemManager_GetPlatformPath_Params_Data::FileSystemManager_GetPlatformPath_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemManager_GetPlatformPath_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FileSystemManager_GetPlatformPath_ResponseParams_Data* object = static_cast<const FileSystemManager_GetPlatformPath_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->platform_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->platform_path, validation_context))
    return false;

  return true;
}

FileSystemManager_GetPlatformPath_ResponseParams_Data::FileSystemManager_GetPlatformPath_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FileSystemType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::FileSystemType value) {
  return std::move(context).WriteString(::blink::mojom::FileSystemTypeToString(value));
}

} // namespace perfetto
