// third_party/blink/public/mojom/frame/reporting_observer.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/reporting_observer.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/reporting_observer.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/reporting_observer.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/reporting_observer.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_REPORTING_OBSERVER_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_REPORTING_OBSERVER_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
ReportBodyElement::ReportBodyElement()
    : name(),
      value() {}

ReportBodyElement::ReportBodyElement(
    const WTF::String& name_in,
    const WTF::String& value_in)
    : name(std::move(name_in)),
      value(std::move(value_in)) {}

ReportBodyElement::~ReportBodyElement() = default;
size_t ReportBodyElement::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->name);
  seed = mojo::internal::WTFHash(seed, this->value);
  return seed;
}

void ReportBodyElement::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReportBodyElement::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ReportBody::ReportBody()
    : body() {}

ReportBody::ReportBody(
    WTF::Vector<ReportBodyElementPtr> body_in)
    : body(std::move(body_in)) {}

ReportBody::~ReportBody() = default;

void ReportBody::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body"), this->body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<ReportBodyElementPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReportBody::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Report::Report()
    : type(),
      url(),
      body() {}

Report::Report(
    const WTF::String& type_in,
    const ::blink::KURL& url_in,
    ReportBodyPtr body_in)
    : type(std::move(type_in)),
      url(std::move(url_in)),
      body(std::move(body_in)) {}

Report::~Report() = default;

void Report::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body"), this->body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ReportBodyPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Report::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ReportingObserver::Name_[] = "blink.mojom.ReportingObserver";

ReportingObserverProxy::ReportingObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ReportingObserverProxy::Notify(
    ReportPtr in_report) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ReportingObserver::Notify", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report"), in_report,
                        "<value of type ReportPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kReportingObserver_Notify_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReportingObserver_Notify_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->report)::BaseType> report_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::ReportDataView>(
      in_report, report_fragment);
  params->report.Set(
      report_fragment.is_null() ? nullptr : report_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->report.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null report in ReportingObserver.Notify request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingObserver::Name_);
  message.set_method_name("Notify");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ReportingObserverStubDispatch::Accept(
    ReportingObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kReportingObserver_Notify_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ReportingObserver::Notify",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ReportingObserver::Notify");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ReportingObserver_Notify_Params_Data* params =
          reinterpret_cast<internal::ReportingObserver_Notify_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ReportPtr p_report{};
      ReportingObserver_Notify_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReport(&p_report))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Notify(
std::move(p_report));
      return true;
    }
  }
  return false;
}

// static
bool ReportingObserverStubDispatch::AcceptWithResponder(
    ReportingObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kReportingObserver_Notify_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kReportingObserverValidationInfo[] = {
    {internal::kReportingObserver_Notify_Name,
     {&internal::ReportingObserver_Notify_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ReportingObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::ReportingObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kReportingObserverValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::ReportBodyElement::DataView, ::blink::mojom::blink::ReportBodyElementPtr>::Read(
    ::blink::mojom::blink::ReportBodyElement::DataView input,
    ::blink::mojom::blink::ReportBodyElementPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ReportBodyElementPtr result(::blink::mojom::blink::ReportBodyElement::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::ReportBody::DataView, ::blink::mojom::blink::ReportBodyPtr>::Read(
    ::blink::mojom::blink::ReportBody::DataView input,
    ::blink::mojom::blink::ReportBodyPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ReportBodyPtr result(::blink::mojom::blink::ReportBody::New());
  
      if (success && !input.ReadBody(&result->body))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::Report::DataView, ::blink::mojom::blink::ReportPtr>::Read(
    ::blink::mojom::blink::Report::DataView input,
    ::blink::mojom::blink::ReportPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ReportPtr result(::blink::mojom::blink::Report::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadBody(&result->body))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif