// third_party/blink/public/mojom/interest_group/ad_auction_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/interest_group/ad_auction_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-params-data.h"
#include "third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_AUCTION_SERVICE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_AUCTION_SERVICE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char AdAuctionService::Name_[] = "blink.mojom.AdAuctionService";

class AdAuctionService_RunAdAuction_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AdAuctionService_RunAdAuction_ForwardToCallback(
      AdAuctionService::RunAdAuctionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AdAuctionService::RunAdAuctionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AdAuctionService_RunAdAuction_ForwardToCallback);
};

AdAuctionServiceProxy::AdAuctionServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AdAuctionServiceProxy::RunAdAuction(
    ::blink::mojom::AuctionAdConfigPtr in_config, RunAdAuctionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::AdAuctionService::RunAdAuction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type ::blink::mojom::AuctionAdConfigPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAdAuctionService_RunAdAuction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_RunAdAuction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::AuctionAdConfigDataView>(
      in_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in AdAuctionService.RunAdAuction request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("RunAdAuction");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AdAuctionService_RunAdAuction_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class AdAuctionService_RunAdAuction_ProxyToResponder {
 public:
  static AdAuctionService::RunAdAuctionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AdAuctionService_RunAdAuction_ProxyToResponder> proxy(
        new AdAuctionService_RunAdAuction_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AdAuctionService_RunAdAuction_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AdAuctionService_RunAdAuction_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AdAuctionService_RunAdAuction_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AdAuctionService::RunAdAuctionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const absl::optional<::GURL>& in_ad_display_url);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AdAuctionService_RunAdAuction_ProxyToResponder);
};

bool AdAuctionService_RunAdAuction_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::AdAuctionService::RunAdAuctionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::AdAuctionService_RunAdAuction_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AdAuctionService_RunAdAuction_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  absl::optional<::GURL> p_ad_display_url{};
  AdAuctionService_RunAdAuction_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAdDisplayUrl(&p_ad_display_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AdAuctionService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_ad_display_url));
  return true;
}

void AdAuctionService_RunAdAuction_ProxyToResponder::Run(
    const absl::optional<::GURL>& in_ad_display_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::AdAuctionService::RunAdAuctionCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ad_display_url"), in_ad_display_url,
                        "<value of type const absl::optional<::GURL>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAdAuctionService_RunAdAuction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AdAuctionService_RunAdAuction_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ad_display_url)::BaseType> ad_display_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_ad_display_url, ad_display_url_fragment);
  params->ad_display_url.Set(
      ad_display_url_fragment.is_null() ? nullptr : ad_display_url_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::AdAuctionService::RunAdAuctionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AdAuctionService::Name_);
  message.set_method_name("RunAdAuction");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AdAuctionServiceStubDispatch::Accept(
    AdAuctionService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAdAuctionService_RunAdAuction_Name: {
      break;
    }
  }
  return false;
}

// static
bool AdAuctionServiceStubDispatch::AcceptWithResponder(
    AdAuctionService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAdAuctionService_RunAdAuction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::AdAuctionService::RunAdAuction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::AdAuctionService::RunAdAuction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AdAuctionService_RunAdAuction_Params_Data* params =
          reinterpret_cast<
              internal::AdAuctionService_RunAdAuction_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::AuctionAdConfigPtr p_config{};
      AdAuctionService_RunAdAuction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AdAuctionService::Name_, 0, false);
        return false;
      }
      AdAuctionService::RunAdAuctionCallback callback =
          AdAuctionService_RunAdAuction_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunAdAuction(
std::move(p_config), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kAdAuctionServiceValidationInfo[] = {
    {&internal::AdAuctionService_RunAdAuction_Params_Data::Validate,
     &internal::AdAuctionService_RunAdAuction_ResponseParams_Data::Validate},
};

bool AdAuctionServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::AdAuctionService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kAdAuctionServiceValidationInfo);
}

bool AdAuctionServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::AdAuctionService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kAdAuctionServiceValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif