// third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-params-data.h"
#include "third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_KEYBOARD_LOCK_KEYBOARD_LOCK_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_KEYBOARD_LOCK_KEYBOARD_LOCK_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
GetKeyboardLayoutMapResult::GetKeyboardLayoutMapResult()
    : status(),
      layout_map() {}

GetKeyboardLayoutMapResult::GetKeyboardLayoutMapResult(
    GetKeyboardLayoutMapStatus status_in,
    const WTF::HashMap<WTF::String, WTF::String>& layout_map_in)
    : status(std::move(status_in)),
      layout_map(std::move(layout_map_in)) {}

GetKeyboardLayoutMapResult::~GetKeyboardLayoutMapResult() = default;

void GetKeyboardLayoutMapResult::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GetKeyboardLayoutMapStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layout_map"), this->layout_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::HashMap<WTF::String, WTF::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GetKeyboardLayoutMapResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char KeyboardLockService::Name_[] = "blink.mojom.KeyboardLockService";

class KeyboardLockService_RequestKeyboardLock_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  KeyboardLockService_RequestKeyboardLock_ForwardToCallback(
      KeyboardLockService::RequestKeyboardLockCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  KeyboardLockService::RequestKeyboardLockCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(KeyboardLockService_RequestKeyboardLock_ForwardToCallback);
};

class KeyboardLockService_GetKeyboardLayoutMap_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  KeyboardLockService_GetKeyboardLayoutMap_ForwardToCallback(
      KeyboardLockService::GetKeyboardLayoutMapCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  KeyboardLockService::GetKeyboardLayoutMapCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(KeyboardLockService_GetKeyboardLayoutMap_ForwardToCallback);
};

KeyboardLockServiceProxy::KeyboardLockServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void KeyboardLockServiceProxy::RequestKeyboardLock(
    const WTF::Vector<WTF::String>& in_key_codes, RequestKeyboardLockCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::KeyboardLockService::RequestKeyboardLock", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_codes"), in_key_codes,
                        "<value of type const WTF::Vector<WTF::String>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kKeyboardLockService_RequestKeyboardLock_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::KeyboardLockService_RequestKeyboardLock_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key_codes)::BaseType>
      key_codes_fragment(params.message());
  const mojo::internal::ContainerValidateParams key_codes_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_key_codes, key_codes_fragment, &key_codes_validate_params);
  params->key_codes.Set(
      key_codes_fragment.is_null() ? nullptr : key_codes_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_codes.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_codes in KeyboardLockService.RequestKeyboardLock request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(KeyboardLockService::Name_);
  message.set_method_name("RequestKeyboardLock");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new KeyboardLockService_RequestKeyboardLock_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void KeyboardLockServiceProxy::CancelKeyboardLock(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::KeyboardLockService::CancelKeyboardLock");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kKeyboardLockService_CancelKeyboardLock_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::KeyboardLockService_CancelKeyboardLock_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(KeyboardLockService::Name_);
  message.set_method_name("CancelKeyboardLock");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void KeyboardLockServiceProxy::GetKeyboardLayoutMap(
    GetKeyboardLayoutMapCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::KeyboardLockService::GetKeyboardLayoutMap");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kKeyboardLockService_GetKeyboardLayoutMap_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::KeyboardLockService_GetKeyboardLayoutMap_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(KeyboardLockService::Name_);
  message.set_method_name("GetKeyboardLayoutMap");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new KeyboardLockService_GetKeyboardLayoutMap_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class KeyboardLockService_RequestKeyboardLock_ProxyToResponder {
 public:
  static KeyboardLockService::RequestKeyboardLockCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<KeyboardLockService_RequestKeyboardLock_ProxyToResponder> proxy(
        new KeyboardLockService_RequestKeyboardLock_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&KeyboardLockService_RequestKeyboardLock_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~KeyboardLockService_RequestKeyboardLock_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  KeyboardLockService_RequestKeyboardLock_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "KeyboardLockService::RequestKeyboardLockCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      KeyboardLockRequestResult in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(KeyboardLockService_RequestKeyboardLock_ProxyToResponder);
};

bool KeyboardLockService_RequestKeyboardLock_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::KeyboardLockService::RequestKeyboardLockCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::KeyboardLockService_RequestKeyboardLock_ResponseParams_Data* params =
      reinterpret_cast<
          internal::KeyboardLockService_RequestKeyboardLock_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  KeyboardLockRequestResult p_result{};
  KeyboardLockService_RequestKeyboardLock_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        KeyboardLockService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void KeyboardLockService_RequestKeyboardLock_ProxyToResponder::Run(
    KeyboardLockRequestResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::KeyboardLockService::RequestKeyboardLockCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type KeyboardLockRequestResult>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kKeyboardLockService_RequestKeyboardLock_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::KeyboardLockService_RequestKeyboardLock_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::KeyboardLockRequestResult>(
      in_result, &params->result);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::KeyboardLockService::RequestKeyboardLockCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(KeyboardLockService::Name_);
  message.set_method_name("RequestKeyboardLock");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder {
 public:
  static KeyboardLockService::GetKeyboardLayoutMapCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder> proxy(
        new KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "KeyboardLockService::GetKeyboardLayoutMapCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetKeyboardLayoutMapResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder);
};

bool KeyboardLockService_GetKeyboardLayoutMap_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::KeyboardLockService::GetKeyboardLayoutMapCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::KeyboardLockService_GetKeyboardLayoutMap_ResponseParams_Data* params =
      reinterpret_cast<
          internal::KeyboardLockService_GetKeyboardLayoutMap_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  GetKeyboardLayoutMapResultPtr p_result{};
  KeyboardLockService_GetKeyboardLayoutMap_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        KeyboardLockService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder::Run(
    GetKeyboardLayoutMapResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::KeyboardLockService::GetKeyboardLayoutMapCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GetKeyboardLayoutMapResultPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kKeyboardLockService_GetKeyboardLayoutMap_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::KeyboardLockService_GetKeyboardLayoutMap_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::GetKeyboardLayoutMapResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::KeyboardLockService::GetKeyboardLayoutMapCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(KeyboardLockService::Name_);
  message.set_method_name("GetKeyboardLayoutMap");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool KeyboardLockServiceStubDispatch::Accept(
    KeyboardLockService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kKeyboardLockService_RequestKeyboardLock_Name: {
      break;
    }
    case internal::kKeyboardLockService_CancelKeyboardLock_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::KeyboardLockService::CancelKeyboardLock",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::KeyboardLockService::CancelKeyboardLock");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::KeyboardLockService_CancelKeyboardLock_Params_Data* params =
          reinterpret_cast<internal::KeyboardLockService_CancelKeyboardLock_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      KeyboardLockService_CancelKeyboardLock_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            KeyboardLockService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelKeyboardLock();
      return true;
    }
    case internal::kKeyboardLockService_GetKeyboardLayoutMap_Name: {
      break;
    }
  }
  return false;
}

// static
bool KeyboardLockServiceStubDispatch::AcceptWithResponder(
    KeyboardLockService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kKeyboardLockService_RequestKeyboardLock_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::KeyboardLockService::RequestKeyboardLock",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::KeyboardLockService::RequestKeyboardLock");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::KeyboardLockService_RequestKeyboardLock_Params_Data* params =
          reinterpret_cast<
              internal::KeyboardLockService_RequestKeyboardLock_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::Vector<WTF::String> p_key_codes{};
      KeyboardLockService_RequestKeyboardLock_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeyCodes(&p_key_codes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            KeyboardLockService::Name_, 0, false);
        return false;
      }
      KeyboardLockService::RequestKeyboardLockCallback callback =
          KeyboardLockService_RequestKeyboardLock_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestKeyboardLock(
std::move(p_key_codes), std::move(callback));
      return true;
    }
    case internal::kKeyboardLockService_CancelKeyboardLock_Name: {
      break;
    }
    case internal::kKeyboardLockService_GetKeyboardLayoutMap_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::KeyboardLockService::GetKeyboardLayoutMap",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::KeyboardLockService::GetKeyboardLayoutMap");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::KeyboardLockService_GetKeyboardLayoutMap_Params_Data* params =
          reinterpret_cast<
              internal::KeyboardLockService_GetKeyboardLayoutMap_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      KeyboardLockService_GetKeyboardLayoutMap_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            KeyboardLockService::Name_, 2, false);
        return false;
      }
      KeyboardLockService::GetKeyboardLayoutMapCallback callback =
          KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetKeyboardLayoutMap(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kKeyboardLockServiceValidationInfo[] = {
    {&internal::KeyboardLockService_RequestKeyboardLock_Params_Data::Validate,
     &internal::KeyboardLockService_RequestKeyboardLock_ResponseParams_Data::Validate},
    {&internal::KeyboardLockService_CancelKeyboardLock_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::KeyboardLockService_GetKeyboardLayoutMap_Params_Data::Validate,
     &internal::KeyboardLockService_GetKeyboardLayoutMap_ResponseParams_Data::Validate},
};

bool KeyboardLockServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::KeyboardLockService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kKeyboardLockServiceValidationInfo);
}

bool KeyboardLockServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::KeyboardLockService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kKeyboardLockServiceValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::GetKeyboardLayoutMapResult::DataView, ::blink::mojom::blink::GetKeyboardLayoutMapResultPtr>::Read(
    ::blink::mojom::blink::GetKeyboardLayoutMapResult::DataView input,
    ::blink::mojom::blink::GetKeyboardLayoutMapResultPtr* output) {
  bool success = true;
  ::blink::mojom::blink::GetKeyboardLayoutMapResultPtr result(::blink::mojom::blink::GetKeyboardLayoutMapResult::New());
  
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success && !input.ReadLayoutMap(&result->layout_map))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif