// third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* KeyboardLockRequestResultToStringHelper(KeyboardLockRequestResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case KeyboardLockRequestResult::kSuccess:
      return "kSuccess";
    case KeyboardLockRequestResult::kFrameDetachedError:
      return "kFrameDetachedError";
    case KeyboardLockRequestResult::kNoValidKeyCodesError:
      return "kNoValidKeyCodesError";
    case KeyboardLockRequestResult::kChildFrameError:
      return "kChildFrameError";
    case KeyboardLockRequestResult::kRequestFailedError:
      return "kRequestFailedError";
    default:
      return nullptr;
  }
}

std::string KeyboardLockRequestResultToString(KeyboardLockRequestResult value) {
  const char *str = KeyboardLockRequestResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown KeyboardLockRequestResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, KeyboardLockRequestResult value) {
  return os << KeyboardLockRequestResultToString(value);
}

static NOINLINE const char* GetKeyboardLayoutMapStatusToStringHelper(GetKeyboardLayoutMapStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GetKeyboardLayoutMapStatus::kSuccess:
      return "kSuccess";
    case GetKeyboardLayoutMapStatus::kFail:
      return "kFail";
    default:
      return nullptr;
  }
}

std::string GetKeyboardLayoutMapStatusToString(GetKeyboardLayoutMapStatus value) {
  const char *str = GetKeyboardLayoutMapStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GetKeyboardLayoutMapStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GetKeyboardLayoutMapStatus value) {
  return os << GetKeyboardLayoutMapStatusToString(value);
}

namespace internal {


// static
bool GetKeyboardLayoutMapResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GetKeyboardLayoutMapResult_Data* object = static_cast<const GetKeyboardLayoutMapResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::GetKeyboardLayoutMapStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->layout_map, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams layout_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->layout_map, validation_context,
                                         &layout_map_validate_params)) {
    return false;
  }

  return true;
}

GetKeyboardLayoutMapResult_Data::GetKeyboardLayoutMapResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool KeyboardLockService_RequestKeyboardLock_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const KeyboardLockService_RequestKeyboardLock_Params_Data* object = static_cast<const KeyboardLockService_RequestKeyboardLock_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_codes, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams key_codes_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->key_codes, validation_context,
                                         &key_codes_validate_params)) {
    return false;
  }

  return true;
}

KeyboardLockService_RequestKeyboardLock_Params_Data::KeyboardLockService_RequestKeyboardLock_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool KeyboardLockService_RequestKeyboardLock_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const KeyboardLockService_RequestKeyboardLock_ResponseParams_Data* object = static_cast<const KeyboardLockService_RequestKeyboardLock_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::KeyboardLockRequestResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

KeyboardLockService_RequestKeyboardLock_ResponseParams_Data::KeyboardLockService_RequestKeyboardLock_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool KeyboardLockService_CancelKeyboardLock_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const KeyboardLockService_CancelKeyboardLock_Params_Data* object = static_cast<const KeyboardLockService_CancelKeyboardLock_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

KeyboardLockService_CancelKeyboardLock_Params_Data::KeyboardLockService_CancelKeyboardLock_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool KeyboardLockService_GetKeyboardLayoutMap_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const KeyboardLockService_GetKeyboardLayoutMap_Params_Data* object = static_cast<const KeyboardLockService_GetKeyboardLayoutMap_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

KeyboardLockService_GetKeyboardLayoutMap_Params_Data::KeyboardLockService_GetKeyboardLayoutMap_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool KeyboardLockService_GetKeyboardLayoutMap_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const KeyboardLockService_GetKeyboardLayoutMap_ResponseParams_Data* object = static_cast<const KeyboardLockService_GetKeyboardLayoutMap_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

KeyboardLockService_GetKeyboardLayoutMap_ResponseParams_Data::KeyboardLockService_GetKeyboardLayoutMap_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::KeyboardLockRequestResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::KeyboardLockRequestResult value) {
  return std::move(context).WriteString(::blink::mojom::KeyboardLockRequestResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::GetKeyboardLayoutMapStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::GetKeyboardLayoutMapStatus value) {
  return std::move(context).WriteString(::blink::mojom::GetKeyboardLayoutMapStatusToString(value));
}

} // namespace perfetto
