// third_party/blink/public/mojom/link_to_text/link_to_text.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/link_to_text/link_to_text.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/link_to_text/link_to_text.mojom-params-data.h"
#include "third_party/blink/public/mojom/link_to_text/link_to_text.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/link_to_text/link_to_text.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LINK_TO_TEXT_LINK_TO_TEXT_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LINK_TO_TEXT_LINK_TO_TEXT_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char TextFragmentReceiver::Name_[] = "blink.mojom.TextFragmentReceiver";

class TextFragmentReceiver_RequestSelector_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextFragmentReceiver_RequestSelector_ForwardToCallback(
      TextFragmentReceiver::RequestSelectorCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TextFragmentReceiver::RequestSelectorCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TextFragmentReceiver_RequestSelector_ForwardToCallback);
};

class TextFragmentReceiver_ExtractTextFragmentsMatches_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextFragmentReceiver_ExtractTextFragmentsMatches_ForwardToCallback(
      TextFragmentReceiver::ExtractTextFragmentsMatchesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TextFragmentReceiver::ExtractTextFragmentsMatchesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TextFragmentReceiver_ExtractTextFragmentsMatches_ForwardToCallback);
};

class TextFragmentReceiver_GetExistingSelectors_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextFragmentReceiver_GetExistingSelectors_ForwardToCallback(
      TextFragmentReceiver::GetExistingSelectorsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TextFragmentReceiver::GetExistingSelectorsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TextFragmentReceiver_GetExistingSelectors_ForwardToCallback);
};

class TextFragmentReceiver_ExtractFirstFragmentRect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextFragmentReceiver_ExtractFirstFragmentRect_ForwardToCallback(
      TextFragmentReceiver::ExtractFirstFragmentRectCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TextFragmentReceiver::ExtractFirstFragmentRectCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TextFragmentReceiver_ExtractFirstFragmentRect_ForwardToCallback);
};

TextFragmentReceiverProxy::TextFragmentReceiverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TextFragmentReceiverProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::TextFragmentReceiver::Cancel");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextFragmentReceiver_Cancel_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void TextFragmentReceiverProxy::RequestSelector(
    RequestSelectorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::TextFragmentReceiver::RequestSelector");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextFragmentReceiver_RequestSelector_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_RequestSelector_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("RequestSelector");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextFragmentReceiver_RequestSelector_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void TextFragmentReceiverProxy::RemoveFragments(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::TextFragmentReceiver::RemoveFragments");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextFragmentReceiver_RemoveFragments_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_RemoveFragments_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("RemoveFragments");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void TextFragmentReceiverProxy::ExtractTextFragmentsMatches(
    ExtractTextFragmentsMatchesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::TextFragmentReceiver::ExtractTextFragmentsMatches");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextFragmentReceiver_ExtractTextFragmentsMatches_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_ExtractTextFragmentsMatches_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("ExtractTextFragmentsMatches");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextFragmentReceiver_ExtractTextFragmentsMatches_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void TextFragmentReceiverProxy::GetExistingSelectors(
    GetExistingSelectorsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::TextFragmentReceiver::GetExistingSelectors");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextFragmentReceiver_GetExistingSelectors_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_GetExistingSelectors_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("GetExistingSelectors");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextFragmentReceiver_GetExistingSelectors_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void TextFragmentReceiverProxy::ExtractFirstFragmentRect(
    ExtractFirstFragmentRectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::TextFragmentReceiver::ExtractFirstFragmentRect");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextFragmentReceiver_ExtractFirstFragmentRect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_ExtractFirstFragmentRect_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("ExtractFirstFragmentRect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextFragmentReceiver_ExtractFirstFragmentRect_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class TextFragmentReceiver_RequestSelector_ProxyToResponder {
 public:
  static TextFragmentReceiver::RequestSelectorCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TextFragmentReceiver_RequestSelector_ProxyToResponder> proxy(
        new TextFragmentReceiver_RequestSelector_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TextFragmentReceiver_RequestSelector_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextFragmentReceiver_RequestSelector_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TextFragmentReceiver_RequestSelector_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TextFragmentReceiver::RequestSelectorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_selector);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TextFragmentReceiver_RequestSelector_ProxyToResponder);
};

bool TextFragmentReceiver_RequestSelector_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::TextFragmentReceiver::RequestSelectorCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TextFragmentReceiver_RequestSelector_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextFragmentReceiver_RequestSelector_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::string p_selector{};
  TextFragmentReceiver_RequestSelector_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSelector(&p_selector))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextFragmentReceiver::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_selector));
  return true;
}

void TextFragmentReceiver_RequestSelector_ProxyToResponder::Run(
    const std::string& in_selector) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::TextFragmentReceiver::RequestSelectorCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selector"), in_selector,
                        "<value of type const std::string&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextFragmentReceiver_RequestSelector_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_RequestSelector_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->selector)::BaseType> selector_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_selector, selector_fragment);
  params->selector.Set(
      selector_fragment.is_null() ? nullptr : selector_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->selector.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selector in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::TextFragmentReceiver::RequestSelectorCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("RequestSelector");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder {
 public:
  static TextFragmentReceiver::ExtractTextFragmentsMatchesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder> proxy(
        new TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TextFragmentReceiver::ExtractTextFragmentsMatchesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_text);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder);
};

bool TextFragmentReceiver_ExtractTextFragmentsMatches_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::TextFragmentReceiver::ExtractTextFragmentsMatchesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<std::string> p_text{};
  TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadText(&p_text))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextFragmentReceiver::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_text));
  return true;
}

void TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder::Run(
    const std::vector<std::string>& in_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::TextFragmentReceiver::ExtractTextFragmentsMatchesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextFragmentReceiver_ExtractTextFragmentsMatches_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType>
      text_fragment(params.message());
  const mojo::internal::ContainerValidateParams text_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_text, text_fragment, &text_validate_params);
  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->text.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::TextFragmentReceiver::ExtractTextFragmentsMatchesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("ExtractTextFragmentsMatches");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TextFragmentReceiver_GetExistingSelectors_ProxyToResponder {
 public:
  static TextFragmentReceiver::GetExistingSelectorsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TextFragmentReceiver_GetExistingSelectors_ProxyToResponder> proxy(
        new TextFragmentReceiver_GetExistingSelectors_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TextFragmentReceiver_GetExistingSelectors_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextFragmentReceiver_GetExistingSelectors_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TextFragmentReceiver_GetExistingSelectors_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TextFragmentReceiver::GetExistingSelectorsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_selectors);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TextFragmentReceiver_GetExistingSelectors_ProxyToResponder);
};

bool TextFragmentReceiver_GetExistingSelectors_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::TextFragmentReceiver::GetExistingSelectorsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TextFragmentReceiver_GetExistingSelectors_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextFragmentReceiver_GetExistingSelectors_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<std::string> p_selectors{};
  TextFragmentReceiver_GetExistingSelectors_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSelectors(&p_selectors))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextFragmentReceiver::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_selectors));
  return true;
}

void TextFragmentReceiver_GetExistingSelectors_ProxyToResponder::Run(
    const std::vector<std::string>& in_selectors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::TextFragmentReceiver::GetExistingSelectorsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selectors"), in_selectors,
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextFragmentReceiver_GetExistingSelectors_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_GetExistingSelectors_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->selectors)::BaseType>
      selectors_fragment(params.message());
  const mojo::internal::ContainerValidateParams selectors_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_selectors, selectors_fragment, &selectors_validate_params);
  params->selectors.Set(
      selectors_fragment.is_null() ? nullptr : selectors_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->selectors.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selectors in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::TextFragmentReceiver::GetExistingSelectorsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("GetExistingSelectors");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder {
 public:
  static TextFragmentReceiver::ExtractFirstFragmentRectCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder> proxy(
        new TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TextFragmentReceiver::ExtractFirstFragmentRectCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gfx::Rect& in_bounds);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder);
};

bool TextFragmentReceiver_ExtractFirstFragmentRect_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::TextFragmentReceiver::ExtractFirstFragmentRectCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::gfx::Rect p_bounds{};
  TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBounds(&p_bounds))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextFragmentReceiver::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_bounds));
  return true;
}

void TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder::Run(
    const ::gfx::Rect& in_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::TextFragmentReceiver::ExtractFirstFragmentRectCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::gfx::Rect&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kTextFragmentReceiver_ExtractFirstFragmentRect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_bounds, bounds_fragment);
  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::TextFragmentReceiver::ExtractFirstFragmentRectCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("ExtractFirstFragmentRect");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TextFragmentReceiverStubDispatch::Accept(
    TextFragmentReceiver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kTextFragmentReceiver_Cancel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::TextFragmentReceiver::Cancel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::TextFragmentReceiver::Cancel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TextFragmentReceiver_Cancel_Params_Data* params =
          reinterpret_cast<internal::TextFragmentReceiver_Cancel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      TextFragmentReceiver_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextFragmentReceiver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel();
      return true;
    }
    case internal::kTextFragmentReceiver_RequestSelector_Name: {
      break;
    }
    case internal::kTextFragmentReceiver_RemoveFragments_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::TextFragmentReceiver::RemoveFragments",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::TextFragmentReceiver::RemoveFragments");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TextFragmentReceiver_RemoveFragments_Params_Data* params =
          reinterpret_cast<internal::TextFragmentReceiver_RemoveFragments_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      TextFragmentReceiver_RemoveFragments_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextFragmentReceiver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveFragments();
      return true;
    }
    case internal::kTextFragmentReceiver_ExtractTextFragmentsMatches_Name: {
      break;
    }
    case internal::kTextFragmentReceiver_GetExistingSelectors_Name: {
      break;
    }
    case internal::kTextFragmentReceiver_ExtractFirstFragmentRect_Name: {
      break;
    }
  }
  return false;
}

// static
bool TextFragmentReceiverStubDispatch::AcceptWithResponder(
    TextFragmentReceiver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTextFragmentReceiver_Cancel_Name: {
      break;
    }
    case internal::kTextFragmentReceiver_RequestSelector_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::TextFragmentReceiver::RequestSelector",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::TextFragmentReceiver::RequestSelector");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TextFragmentReceiver_RequestSelector_Params_Data* params =
          reinterpret_cast<
              internal::TextFragmentReceiver_RequestSelector_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      TextFragmentReceiver_RequestSelector_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextFragmentReceiver::Name_, 1, false);
        return false;
      }
      TextFragmentReceiver::RequestSelectorCallback callback =
          TextFragmentReceiver_RequestSelector_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestSelector(std::move(callback));
      return true;
    }
    case internal::kTextFragmentReceiver_RemoveFragments_Name: {
      break;
    }
    case internal::kTextFragmentReceiver_ExtractTextFragmentsMatches_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::TextFragmentReceiver::ExtractTextFragmentsMatches",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::TextFragmentReceiver::ExtractTextFragmentsMatches");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TextFragmentReceiver_ExtractTextFragmentsMatches_Params_Data* params =
          reinterpret_cast<
              internal::TextFragmentReceiver_ExtractTextFragmentsMatches_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      TextFragmentReceiver_ExtractTextFragmentsMatches_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextFragmentReceiver::Name_, 3, false);
        return false;
      }
      TextFragmentReceiver::ExtractTextFragmentsMatchesCallback callback =
          TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractTextFragmentsMatches(std::move(callback));
      return true;
    }
    case internal::kTextFragmentReceiver_GetExistingSelectors_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::TextFragmentReceiver::GetExistingSelectors",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::TextFragmentReceiver::GetExistingSelectors");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TextFragmentReceiver_GetExistingSelectors_Params_Data* params =
          reinterpret_cast<
              internal::TextFragmentReceiver_GetExistingSelectors_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      TextFragmentReceiver_GetExistingSelectors_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextFragmentReceiver::Name_, 4, false);
        return false;
      }
      TextFragmentReceiver::GetExistingSelectorsCallback callback =
          TextFragmentReceiver_GetExistingSelectors_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetExistingSelectors(std::move(callback));
      return true;
    }
    case internal::kTextFragmentReceiver_ExtractFirstFragmentRect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::TextFragmentReceiver::ExtractFirstFragmentRect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::TextFragmentReceiver::ExtractFirstFragmentRect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TextFragmentReceiver_ExtractFirstFragmentRect_Params_Data* params =
          reinterpret_cast<
              internal::TextFragmentReceiver_ExtractFirstFragmentRect_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      TextFragmentReceiver_ExtractFirstFragmentRect_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextFragmentReceiver::Name_, 5, false);
        return false;
      }
      TextFragmentReceiver::ExtractFirstFragmentRectCallback callback =
          TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractFirstFragmentRect(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kTextFragmentReceiverValidationInfo[] = {
    {&internal::TextFragmentReceiver_Cancel_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::TextFragmentReceiver_RequestSelector_Params_Data::Validate,
     &internal::TextFragmentReceiver_RequestSelector_ResponseParams_Data::Validate},
    {&internal::TextFragmentReceiver_RemoveFragments_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::TextFragmentReceiver_ExtractTextFragmentsMatches_Params_Data::Validate,
     &internal::TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams_Data::Validate},
    {&internal::TextFragmentReceiver_GetExistingSelectors_Params_Data::Validate,
     &internal::TextFragmentReceiver_GetExistingSelectors_ResponseParams_Data::Validate},
    {&internal::TextFragmentReceiver_ExtractFirstFragmentRect_Params_Data::Validate,
     &internal::TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams_Data::Validate},
};

bool TextFragmentReceiverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::TextFragmentReceiver::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kTextFragmentReceiverValidationInfo);
}

bool TextFragmentReceiverResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::TextFragmentReceiver::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kTextFragmentReceiverValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif