// third_party/blink/public/mojom/loader/navigation_predictor.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-params-data.h"
#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_NAVIGATION_PREDICTOR_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_NAVIGATION_PREDICTOR_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
AnchorElementMetrics::AnchorElementMetrics()
    : anchor_id(),
      ratio_area(),
      ratio_visible_area(),
      ratio_distance_top_to_visible_top(),
      ratio_distance_center_to_visible_top(),
      ratio_distance_root_top(),
      ratio_distance_root_bottom(),
      is_in_iframe(),
      contains_image(),
      is_same_host(),
      is_url_incremented_by_one(),
      has_text_sibling(),
      font_size_px(),
      font_weight(),
      source_url(),
      target_url(),
      viewport_size() {}

AnchorElementMetrics::AnchorElementMetrics(
    uint32_t anchor_id_in,
    float ratio_area_in,
    float ratio_visible_area_in,
    float ratio_distance_top_to_visible_top_in,
    float ratio_distance_center_to_visible_top_in,
    float ratio_distance_root_top_in,
    float ratio_distance_root_bottom_in,
    bool is_in_iframe_in,
    bool contains_image_in,
    bool is_same_host_in,
    bool is_url_incremented_by_one_in,
    bool has_text_sibling_in,
    uint32_t font_size_px_in,
    uint32_t font_weight_in,
    const ::GURL& source_url_in,
    const ::GURL& target_url_in,
    const ::gfx::Size& viewport_size_in)
    : anchor_id(std::move(anchor_id_in)),
      ratio_area(std::move(ratio_area_in)),
      ratio_visible_area(std::move(ratio_visible_area_in)),
      ratio_distance_top_to_visible_top(std::move(ratio_distance_top_to_visible_top_in)),
      ratio_distance_center_to_visible_top(std::move(ratio_distance_center_to_visible_top_in)),
      ratio_distance_root_top(std::move(ratio_distance_root_top_in)),
      ratio_distance_root_bottom(std::move(ratio_distance_root_bottom_in)),
      is_in_iframe(std::move(is_in_iframe_in)),
      contains_image(std::move(contains_image_in)),
      is_same_host(std::move(is_same_host_in)),
      is_url_incremented_by_one(std::move(is_url_incremented_by_one_in)),
      has_text_sibling(std::move(has_text_sibling_in)),
      font_size_px(std::move(font_size_px_in)),
      font_weight(std::move(font_weight_in)),
      source_url(std::move(source_url_in)),
      target_url(std::move(target_url_in)),
      viewport_size(std::move(viewport_size_in)) {}

AnchorElementMetrics::~AnchorElementMetrics() = default;

void AnchorElementMetrics::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_id"), this->anchor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ratio_area"), this->ratio_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ratio_visible_area"), this->ratio_visible_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ratio_distance_top_to_visible_top"), this->ratio_distance_top_to_visible_top,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ratio_distance_center_to_visible_top"), this->ratio_distance_center_to_visible_top,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ratio_distance_root_top"), this->ratio_distance_root_top,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ratio_distance_root_bottom"), this->ratio_distance_root_bottom,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_in_iframe"), this->is_in_iframe,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contains_image"), this->contains_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_same_host"), this->is_same_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_url_incremented_by_one"), this->is_url_incremented_by_one,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_text_sibling"), this->has_text_sibling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "font_size_px"), this->font_size_px,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "font_weight"), this->font_weight,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_url"), this->source_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_url"), this->target_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "viewport_size"), this->viewport_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorElementMetrics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnchorElementClick::AnchorElementClick()
    : anchor_id(),
      target_url() {}

AnchorElementClick::AnchorElementClick(
    uint32_t anchor_id_in,
    const ::GURL& target_url_in)
    : anchor_id(std::move(anchor_id_in)),
      target_url(std::move(target_url_in)) {}

AnchorElementClick::~AnchorElementClick() = default;

void AnchorElementClick::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_id"), this->anchor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_url"), this->target_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorElementClick::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnchorElementEnteredViewport::AnchorElementEnteredViewport()
    : anchor_id(),
      navigation_start_to_entered_viewport_ms() {}

AnchorElementEnteredViewport::AnchorElementEnteredViewport(
    uint32_t anchor_id_in,
    uint64_t navigation_start_to_entered_viewport_ms_in)
    : anchor_id(std::move(anchor_id_in)),
      navigation_start_to_entered_viewport_ms(std::move(navigation_start_to_entered_viewport_ms_in)) {}

AnchorElementEnteredViewport::~AnchorElementEnteredViewport() = default;
size_t AnchorElementEnteredViewport::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->anchor_id);
  seed = mojo::internal::Hash(seed, this->navigation_start_to_entered_viewport_ms);
  return seed;
}

void AnchorElementEnteredViewport::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_id"), this->anchor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_start_to_entered_viewport_ms"), this->navigation_start_to_entered_viewport_ms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorElementEnteredViewport::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char AnchorElementMetricsHost::Name_[] = "blink.mojom.AnchorElementMetricsHost";

AnchorElementMetricsHostProxy::AnchorElementMetricsHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AnchorElementMetricsHostProxy::ReportAnchorElementClick(
    AnchorElementClickPtr in_clicked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::AnchorElementMetricsHost::ReportAnchorElementClick", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clicked"), in_clicked,
                        "<value of type AnchorElementClickPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAnchorElementMetricsHost_ReportAnchorElementClick_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ReportAnchorElementClick_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->clicked)::BaseType> clicked_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::AnchorElementClickDataView>(
      in_clicked, clicked_fragment);
  params->clicked.Set(
      clicked_fragment.is_null() ? nullptr : clicked_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->clicked.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null clicked in AnchorElementMetricsHost.ReportAnchorElementClick request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ReportAnchorElementClick");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AnchorElementMetricsHostProxy::ReportNewAnchorElements(
    std::vector<AnchorElementMetricsPtr> in_metrics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::AnchorElementMetricsHost::ReportNewAnchorElements", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metrics"), in_metrics,
                        "<value of type std::vector<AnchorElementMetricsPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAnchorElementMetricsHost_ReportNewAnchorElements_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ReportNewAnchorElements_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metrics)::BaseType>
      metrics_fragment(params.message());
  const mojo::internal::ContainerValidateParams metrics_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AnchorElementMetricsDataView>>(
      in_metrics, metrics_fragment, &metrics_validate_params);
  params->metrics.Set(
      metrics_fragment.is_null() ? nullptr : metrics_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->metrics.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metrics in AnchorElementMetricsHost.ReportNewAnchorElements request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ReportNewAnchorElements");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AnchorElementMetricsHostProxy::ReportAnchorElementsEnteredViewport(
    std::vector<AnchorElementEnteredViewportPtr> in_elements) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::AnchorElementMetricsHost::ReportAnchorElementsEnteredViewport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("elements"), in_elements,
                        "<value of type std::vector<AnchorElementEnteredViewportPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->elements)::BaseType>
      elements_fragment(params.message());
  const mojo::internal::ContainerValidateParams elements_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AnchorElementEnteredViewportDataView>>(
      in_elements, elements_fragment, &elements_validate_params);
  params->elements.Set(
      elements_fragment.is_null() ? nullptr : elements_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->elements.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null elements in AnchorElementMetricsHost.ReportAnchorElementsEnteredViewport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ReportAnchorElementsEnteredViewport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AnchorElementMetricsHostStubDispatch::Accept(
    AnchorElementMetricsHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAnchorElementMetricsHost_ReportAnchorElementClick_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::AnchorElementMetricsHost::ReportAnchorElementClick",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::AnchorElementMetricsHost::ReportAnchorElementClick");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AnchorElementMetricsHost_ReportAnchorElementClick_Params_Data* params =
          reinterpret_cast<internal::AnchorElementMetricsHost_ReportAnchorElementClick_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      AnchorElementClickPtr p_clicked{};
      AnchorElementMetricsHost_ReportAnchorElementClick_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClicked(&p_clicked))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportAnchorElementClick(
std::move(p_clicked));
      return true;
    }
    case internal::kAnchorElementMetricsHost_ReportNewAnchorElements_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::AnchorElementMetricsHost::ReportNewAnchorElements",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::AnchorElementMetricsHost::ReportNewAnchorElements");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AnchorElementMetricsHost_ReportNewAnchorElements_Params_Data* params =
          reinterpret_cast<internal::AnchorElementMetricsHost_ReportNewAnchorElements_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<AnchorElementMetricsPtr> p_metrics{};
      AnchorElementMetricsHost_ReportNewAnchorElements_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetrics(&p_metrics))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportNewAnchorElements(
std::move(p_metrics));
      return true;
    }
    case internal::kAnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::AnchorElementMetricsHost::ReportAnchorElementsEnteredViewport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::AnchorElementMetricsHost::ReportAnchorElementsEnteredViewport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params_Data* params =
          reinterpret_cast<internal::AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<AnchorElementEnteredViewportPtr> p_elements{};
      AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadElements(&p_elements))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportAnchorElementsEnteredViewport(
std::move(p_elements));
      return true;
    }
  }
  return false;
}

// static
bool AnchorElementMetricsHostStubDispatch::AcceptWithResponder(
    AnchorElementMetricsHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAnchorElementMetricsHost_ReportAnchorElementClick_Name: {
      break;
    }
    case internal::kAnchorElementMetricsHost_ReportNewAnchorElements_Name: {
      break;
    }
    case internal::kAnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kAnchorElementMetricsHostValidationInfo[] = {
    {&internal::AnchorElementMetricsHost_ReportAnchorElementClick_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::AnchorElementMetricsHost_ReportNewAnchorElements_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params_Data::Validate,
     nullptr /* no response */},
};

bool AnchorElementMetricsHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::AnchorElementMetricsHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kAnchorElementMetricsHostValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::AnchorElementMetrics::DataView, ::blink::mojom::AnchorElementMetricsPtr>::Read(
    ::blink::mojom::AnchorElementMetrics::DataView input,
    ::blink::mojom::AnchorElementMetricsPtr* output) {
  bool success = true;
  ::blink::mojom::AnchorElementMetricsPtr result(::blink::mojom::AnchorElementMetrics::New());
  
      if (success)
        result->anchor_id = input.anchor_id();
      if (success)
        result->ratio_area = input.ratio_area();
      if (success)
        result->ratio_visible_area = input.ratio_visible_area();
      if (success)
        result->ratio_distance_top_to_visible_top = input.ratio_distance_top_to_visible_top();
      if (success)
        result->ratio_distance_center_to_visible_top = input.ratio_distance_center_to_visible_top();
      if (success)
        result->ratio_distance_root_top = input.ratio_distance_root_top();
      if (success)
        result->ratio_distance_root_bottom = input.ratio_distance_root_bottom();
      if (success)
        result->is_in_iframe = input.is_in_iframe();
      if (success)
        result->contains_image = input.contains_image();
      if (success)
        result->is_same_host = input.is_same_host();
      if (success)
        result->is_url_incremented_by_one = input.is_url_incremented_by_one();
      if (success)
        result->has_text_sibling = input.has_text_sibling();
      if (success)
        result->font_size_px = input.font_size_px();
      if (success)
        result->font_weight = input.font_weight();
      if (success && !input.ReadSourceUrl(&result->source_url))
        success = false;
      if (success && !input.ReadTargetUrl(&result->target_url))
        success = false;
      if (success && !input.ReadViewportSize(&result->viewport_size))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AnchorElementClick::DataView, ::blink::mojom::AnchorElementClickPtr>::Read(
    ::blink::mojom::AnchorElementClick::DataView input,
    ::blink::mojom::AnchorElementClickPtr* output) {
  bool success = true;
  ::blink::mojom::AnchorElementClickPtr result(::blink::mojom::AnchorElementClick::New());
  
      if (success)
        result->anchor_id = input.anchor_id();
      if (success && !input.ReadTargetUrl(&result->target_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AnchorElementEnteredViewport::DataView, ::blink::mojom::AnchorElementEnteredViewportPtr>::Read(
    ::blink::mojom::AnchorElementEnteredViewport::DataView input,
    ::blink::mojom::AnchorElementEnteredViewportPtr* output) {
  bool success = true;
  ::blink::mojom::AnchorElementEnteredViewportPtr result(::blink::mojom::AnchorElementEnteredViewport::New());
  
      if (success)
        result->anchor_id = input.anchor_id();
      if (success)
        result->navigation_start_to_entered_viewport_ms = input.navigation_start_to_entered_viewport_ms();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif