// third_party/blink/public/mojom/manifest/manifest.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/manifest/manifest.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/manifest/manifest.mojom-params-data.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/manifest/manifest.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MOJOM_JUMBO_H_
#include "third_party/blink/public/common/manifest/manifest_mojom_traits.h"
#endif
namespace blink {
namespace mojom {
Manifest::Manifest()
    : name(),
      short_name(),
      description(),
      id(),
      start_url(),
      display(),
      display_override(),
      orientation(),
      icons(),
      screenshots(),
      shortcuts(),
      share_target(),
      file_handlers(),
      protocol_handlers(),
      url_handlers(),
      note_taking(),
      related_applications(),
      prefer_related_applications(),
      has_theme_color(),
      theme_color(),
      has_background_color(),
      background_color(),
      gcm_sender_id(),
      scope(),
      capture_links(),
      isolated_storage(),
      launch_handler() {}

Manifest::Manifest(
    const absl::optional<::std::u16string>& name_in,
    const absl::optional<::std::u16string>& short_name_in,
    const absl::optional<::std::u16string>& description_in,
    const absl::optional<::std::u16string>& id_in,
    const ::GURL& start_url_in,
    ::blink::mojom::DisplayMode display_in,
    std::vector<::blink::mojom::DisplayMode> display_override_in,
    ::device::mojom::ScreenOrientationLockType orientation_in,
    std::vector<::blink::Manifest::ImageResource> icons_in,
    std::vector<::blink::Manifest::ImageResource> screenshots_in,
    std::vector<::blink::Manifest::ShortcutItem> shortcuts_in,
    const absl::optional<::blink::Manifest::ShareTarget>& share_target_in,
    std::vector<ManifestFileHandlerPtr> file_handlers_in,
    std::vector<ManifestProtocolHandlerPtr> protocol_handlers_in,
    std::vector<ManifestUrlHandlerPtr> url_handlers_in,
    ManifestNoteTakingPtr note_taking_in,
    std::vector<::blink::Manifest::RelatedApplication> related_applications_in,
    bool prefer_related_applications_in,
    bool has_theme_color_in,
    uint32_t theme_color_in,
    bool has_background_color_in,
    uint32_t background_color_in,
    const absl::optional<::std::u16string>& gcm_sender_id_in,
    const ::GURL& scope_in,
    ::blink::mojom::CaptureLinks capture_links_in,
    bool isolated_storage_in,
    const absl::optional<::blink::Manifest::LaunchHandler>& launch_handler_in)
    : name(std::move(name_in)),
      short_name(std::move(short_name_in)),
      description(std::move(description_in)),
      id(std::move(id_in)),
      start_url(std::move(start_url_in)),
      display(std::move(display_in)),
      display_override(std::move(display_override_in)),
      orientation(std::move(orientation_in)),
      icons(std::move(icons_in)),
      screenshots(std::move(screenshots_in)),
      shortcuts(std::move(shortcuts_in)),
      share_target(std::move(share_target_in)),
      file_handlers(std::move(file_handlers_in)),
      protocol_handlers(std::move(protocol_handlers_in)),
      url_handlers(std::move(url_handlers_in)),
      note_taking(std::move(note_taking_in)),
      related_applications(std::move(related_applications_in)),
      prefer_related_applications(std::move(prefer_related_applications_in)),
      has_theme_color(std::move(has_theme_color_in)),
      theme_color(std::move(theme_color_in)),
      has_background_color(std::move(has_background_color_in)),
      background_color(std::move(background_color_in)),
      gcm_sender_id(std::move(gcm_sender_id_in)),
      scope(std::move(scope_in)),
      capture_links(std::move(capture_links_in)),
      isolated_storage(std::move(isolated_storage_in)),
      launch_handler(std::move(launch_handler_in)) {}

Manifest::~Manifest() = default;

void Manifest::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "short_name"), this->short_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_url"), this->start_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display"), this->display,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::DisplayMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_override"), this->display_override,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::mojom::DisplayMode>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation"), this->orientation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::ScreenOrientationLockType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icons"), this->icons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::Manifest::ImageResource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "screenshots"), this->screenshots,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::Manifest::ImageResource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shortcuts"), this->shortcuts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::Manifest::ShortcutItem>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "share_target"), this->share_target,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::blink::Manifest::ShareTarget>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_handlers"), this->file_handlers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ManifestFileHandlerPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protocol_handlers"), this->protocol_handlers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ManifestProtocolHandlerPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_handlers"), this->url_handlers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ManifestUrlHandlerPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "note_taking"), this->note_taking,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ManifestNoteTakingPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "related_applications"), this->related_applications,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::Manifest::RelatedApplication>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prefer_related_applications"), this->prefer_related_applications,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_theme_color"), this->has_theme_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "theme_color"), this->theme_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_background_color"), this->has_background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_color"), this->background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gcm_sender_id"), this->gcm_sender_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scope"), this->scope,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_links"), this->capture_links,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::CaptureLinks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "isolated_storage"), this->isolated_storage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "launch_handler"), this->launch_handler,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::blink::Manifest::LaunchHandler>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Manifest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestShortcutItem::ManifestShortcutItem()
    : name(),
      short_name(),
      description(),
      url(),
      icons() {}

ManifestShortcutItem::ManifestShortcutItem(
    const ::std::u16string& name_in,
    const absl::optional<::std::u16string>& short_name_in,
    const absl::optional<::std::u16string>& description_in,
    const ::GURL& url_in,
    std::vector<::blink::Manifest::ImageResource> icons_in)
    : name(std::move(name_in)),
      short_name(std::move(short_name_in)),
      description(std::move(description_in)),
      url(std::move(url_in)),
      icons(std::move(icons_in)) {}

ManifestShortcutItem::~ManifestShortcutItem() = default;

void ManifestShortcutItem::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "short_name"), this->short_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icons"), this->icons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::Manifest::ImageResource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestShortcutItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestImageResource::ManifestImageResource()
    : src(),
      type(),
      sizes(),
      purpose() {}

ManifestImageResource::ManifestImageResource(
    const ::GURL& src_in,
    const absl::optional<::std::u16string>& type_in,
    std::vector<::gfx::Size> sizes_in,
    std::vector<ManifestImageResource::Purpose> purpose_in)
    : src(std::move(src_in)),
      type(std::move(type_in)),
      sizes(std::move(sizes_in)),
      purpose(std::move(purpose_in)) {}

ManifestImageResource::~ManifestImageResource() = default;

void ManifestImageResource::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "src"), this->src,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sizes"), this->sizes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "purpose"), this->purpose,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<ManifestImageResource::Purpose>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestImageResource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestFileFilter::ManifestFileFilter()
    : name(),
      accept() {}

ManifestFileFilter::ManifestFileFilter(
    const absl::optional<::std::u16string>& name_in,
    std::vector<::std::u16string> accept_in)
    : name(std::move(name_in)),
      accept(std::move(accept_in)) {}

ManifestFileFilter::~ManifestFileFilter() = default;

void ManifestFileFilter::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accept"), this->accept,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestFileFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestProtocolHandler::ManifestProtocolHandler()
    : protocol(),
      url() {}

ManifestProtocolHandler::ManifestProtocolHandler(
    const ::std::u16string& protocol_in,
    const ::GURL& url_in)
    : protocol(std::move(protocol_in)),
      url(std::move(url_in)) {}

ManifestProtocolHandler::~ManifestProtocolHandler() = default;

void ManifestProtocolHandler::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protocol"), this->protocol,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestProtocolHandler::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestUrlHandler::ManifestUrlHandler()
    : origin(),
      has_origin_wildcard() {}

ManifestUrlHandler::ManifestUrlHandler(
    const ::url::Origin& origin_in,
    bool has_origin_wildcard_in)
    : origin(std::move(origin_in)),
      has_origin_wildcard(std::move(has_origin_wildcard_in)) {}

ManifestUrlHandler::~ManifestUrlHandler() = default;

void ManifestUrlHandler::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_origin_wildcard"), this->has_origin_wildcard,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestUrlHandler::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestNoteTaking::ManifestNoteTaking()
    : new_note_url() {}

ManifestNoteTaking::ManifestNoteTaking(
    const ::GURL& new_note_url_in)
    : new_note_url(std::move(new_note_url_in)) {}

ManifestNoteTaking::~ManifestNoteTaking() = default;

void ManifestNoteTaking::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "new_note_url"), this->new_note_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestNoteTaking::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestRelatedApplication::ManifestRelatedApplication()
    : platform(),
      url(),
      id() {}

ManifestRelatedApplication::ManifestRelatedApplication(
    const absl::optional<::std::u16string>& platform_in,
    const absl::optional<::GURL>& url_in,
    const absl::optional<::std::u16string>& id_in)
    : platform(std::move(platform_in)),
      url(std::move(url_in)),
      id(std::move(id_in)) {}

ManifestRelatedApplication::~ManifestRelatedApplication() = default;

void ManifestRelatedApplication::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "platform"), this->platform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestRelatedApplication::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestShareTargetParams::ManifestShareTargetParams()
    : title(),
      text(),
      url(),
      files() {}

ManifestShareTargetParams::ManifestShareTargetParams(
    const absl::optional<::std::u16string>& title_in,
    const absl::optional<::std::u16string>& text_in,
    const absl::optional<::std::u16string>& url_in,
    absl::optional<std::vector<ManifestFileFilterPtr>> files_in)
    : title(std::move(title_in)),
      text(std::move(text_in)),
      url(std::move(url_in)),
      files(std::move(files_in)) {}

ManifestShareTargetParams::~ManifestShareTargetParams() = default;

void ManifestShareTargetParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "files"), this->files,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<std::vector<ManifestFileFilterPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestShareTargetParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestShareTarget::ManifestShareTarget()
    : action(),
      method(),
      enctype(),
      params() {}

ManifestShareTarget::ManifestShareTarget(
    const ::GURL& action_in,
    ManifestShareTarget::Method method_in,
    ManifestShareTarget::Enctype enctype_in,
    ManifestShareTargetParamsPtr params_in)
    : action(std::move(action_in)),
      method(std::move(method_in)),
      enctype(std::move(enctype_in)),
      params(std::move(params_in)) {}

ManifestShareTarget::~ManifestShareTarget() = default;

void ManifestShareTarget::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action"), this->action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ManifestShareTarget::Method>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enctype"), this->enctype,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ManifestShareTarget::Enctype>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params"), this->params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ManifestShareTargetParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestShareTarget::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestFileHandler::ManifestFileHandler()
    : action(),
      name(),
      icons(),
      accept() {}

ManifestFileHandler::ManifestFileHandler(
    const ::GURL& action_in,
    const ::std::u16string& name_in,
    std::vector<::blink::Manifest::ImageResource> icons_in,
    const base::flat_map<::std::u16string, std::vector<::std::u16string>>& accept_in)
    : action(std::move(action_in)),
      name(std::move(name_in)),
      icons(std::move(icons_in)),
      accept(std::move(accept_in)) {}

ManifestFileHandler::~ManifestFileHandler() = default;

void ManifestFileHandler::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action"), this->action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icons"), this->icons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::Manifest::ImageResource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accept"), this->accept,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::std::u16string, std::vector<::std::u16string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestFileHandler::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestLaunchHandler::ManifestLaunchHandler()
    : route_to(),
      navigate_existing_client() {}

ManifestLaunchHandler::ManifestLaunchHandler(
    ManifestLaunchHandler::RouteTo route_to_in,
    ManifestLaunchHandler::NavigateExistingClient navigate_existing_client_in)
    : route_to(std::move(route_to_in)),
      navigate_existing_client(std::move(navigate_existing_client_in)) {}

ManifestLaunchHandler::~ManifestLaunchHandler() = default;

void ManifestLaunchHandler::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "route_to"), this->route_to,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ManifestLaunchHandler::RouteTo>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigate_existing_client"), this->navigate_existing_client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ManifestLaunchHandler::NavigateExistingClient>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestLaunchHandler::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestDebugInfo::ManifestDebugInfo()
    : errors(),
      raw_manifest() {}

ManifestDebugInfo::ManifestDebugInfo(
    std::vector<ManifestErrorPtr> errors_in,
    const std::string& raw_manifest_in)
    : errors(std::move(errors_in)),
      raw_manifest(std::move(raw_manifest_in)) {}

ManifestDebugInfo::~ManifestDebugInfo() = default;

void ManifestDebugInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "errors"), this->errors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ManifestErrorPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_manifest"), this->raw_manifest,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestDebugInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestError::ManifestError()
    : message(),
      critical(),
      line(),
      column() {}

ManifestError::ManifestError(
    const std::string& message_in,
    bool critical_in,
    uint32_t line_in,
    uint32_t column_in)
    : message(std::move(message_in)),
      critical(std::move(critical_in)),
      line(std::move(line_in)),
      column(std::move(column_in)) {}

ManifestError::~ManifestError() = default;
size_t ManifestError::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->message);
  seed = mojo::internal::Hash(seed, this->critical);
  seed = mojo::internal::Hash(seed, this->line);
  seed = mojo::internal::Hash(seed, this->column);
  return seed;
}

void ManifestError::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "critical"), this->critical,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "line"), this->line,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "column"), this->column,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::Manifest::DataView, ::blink::mojom::ManifestPtr>::Read(
    ::blink::mojom::Manifest::DataView input,
    ::blink::mojom::ManifestPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestPtr result(::blink::mojom::Manifest::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadShortName(&result->short_name))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadStartUrl(&result->start_url))
        success = false;
      if (success && !input.ReadDisplay(&result->display))
        success = false;
      if (success && !input.ReadDisplayOverride(&result->display_override))
        success = false;
      if (success && !input.ReadOrientation(&result->orientation))
        success = false;
      if (success && !input.ReadIcons(&result->icons))
        success = false;
      if (success && !input.ReadScreenshots(&result->screenshots))
        success = false;
      if (success && !input.ReadShortcuts(&result->shortcuts))
        success = false;
      if (success && !input.ReadShareTarget(&result->share_target))
        success = false;
      if (success && !input.ReadFileHandlers(&result->file_handlers))
        success = false;
      if (success && !input.ReadProtocolHandlers(&result->protocol_handlers))
        success = false;
      if (success && !input.ReadUrlHandlers(&result->url_handlers))
        success = false;
      if (success && !input.ReadNoteTaking(&result->note_taking))
        success = false;
      if (success && !input.ReadRelatedApplications(&result->related_applications))
        success = false;
      if (success)
        result->prefer_related_applications = input.prefer_related_applications();
      if (success)
        result->has_theme_color = input.has_theme_color();
      if (success)
        result->theme_color = input.theme_color();
      if (success)
        result->has_background_color = input.has_background_color();
      if (success)
        result->background_color = input.background_color();
      if (success && !input.ReadGcmSenderId(&result->gcm_sender_id))
        success = false;
      if (success && !input.ReadScope(&result->scope))
        success = false;
      if (success && !input.ReadCaptureLinks(&result->capture_links))
        success = false;
      if (success)
        result->isolated_storage = input.isolated_storage();
      if (success && !input.ReadLaunchHandler(&result->launch_handler))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestShortcutItem::DataView, ::blink::mojom::ManifestShortcutItemPtr>::Read(
    ::blink::mojom::ManifestShortcutItem::DataView input,
    ::blink::mojom::ManifestShortcutItemPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestShortcutItemPtr result(::blink::mojom::ManifestShortcutItem::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadShortName(&result->short_name))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadIcons(&result->icons))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestImageResource::DataView, ::blink::mojom::ManifestImageResourcePtr>::Read(
    ::blink::mojom::ManifestImageResource::DataView input,
    ::blink::mojom::ManifestImageResourcePtr* output) {
  bool success = true;
  ::blink::mojom::ManifestImageResourcePtr result(::blink::mojom::ManifestImageResource::New());
  
      if (success && !input.ReadSrc(&result->src))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadSizes(&result->sizes))
        success = false;
      if (success && !input.ReadPurpose(&result->purpose))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestFileFilter::DataView, ::blink::mojom::ManifestFileFilterPtr>::Read(
    ::blink::mojom::ManifestFileFilter::DataView input,
    ::blink::mojom::ManifestFileFilterPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestFileFilterPtr result(::blink::mojom::ManifestFileFilter::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadAccept(&result->accept))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestProtocolHandler::DataView, ::blink::mojom::ManifestProtocolHandlerPtr>::Read(
    ::blink::mojom::ManifestProtocolHandler::DataView input,
    ::blink::mojom::ManifestProtocolHandlerPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestProtocolHandlerPtr result(::blink::mojom::ManifestProtocolHandler::New());
  
      if (success && !input.ReadProtocol(&result->protocol))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestUrlHandler::DataView, ::blink::mojom::ManifestUrlHandlerPtr>::Read(
    ::blink::mojom::ManifestUrlHandler::DataView input,
    ::blink::mojom::ManifestUrlHandlerPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestUrlHandlerPtr result(::blink::mojom::ManifestUrlHandler::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success)
        result->has_origin_wildcard = input.has_origin_wildcard();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestNoteTaking::DataView, ::blink::mojom::ManifestNoteTakingPtr>::Read(
    ::blink::mojom::ManifestNoteTaking::DataView input,
    ::blink::mojom::ManifestNoteTakingPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestNoteTakingPtr result(::blink::mojom::ManifestNoteTaking::New());
  
      if (success && !input.ReadNewNoteUrl(&result->new_note_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestRelatedApplication::DataView, ::blink::mojom::ManifestRelatedApplicationPtr>::Read(
    ::blink::mojom::ManifestRelatedApplication::DataView input,
    ::blink::mojom::ManifestRelatedApplicationPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestRelatedApplicationPtr result(::blink::mojom::ManifestRelatedApplication::New());
  
      if (success && !input.ReadPlatform(&result->platform))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestShareTargetParams::DataView, ::blink::mojom::ManifestShareTargetParamsPtr>::Read(
    ::blink::mojom::ManifestShareTargetParams::DataView input,
    ::blink::mojom::ManifestShareTargetParamsPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestShareTargetParamsPtr result(::blink::mojom::ManifestShareTargetParams::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadFiles(&result->files))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestShareTarget::DataView, ::blink::mojom::ManifestShareTargetPtr>::Read(
    ::blink::mojom::ManifestShareTarget::DataView input,
    ::blink::mojom::ManifestShareTargetPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestShareTargetPtr result(::blink::mojom::ManifestShareTarget::New());
  
      if (success && !input.ReadAction(&result->action))
        success = false;
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadEnctype(&result->enctype))
        success = false;
      if (success && !input.ReadParams(&result->params))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestFileHandler::DataView, ::blink::mojom::ManifestFileHandlerPtr>::Read(
    ::blink::mojom::ManifestFileHandler::DataView input,
    ::blink::mojom::ManifestFileHandlerPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestFileHandlerPtr result(::blink::mojom::ManifestFileHandler::New());
  
      if (success && !input.ReadAction(&result->action))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadIcons(&result->icons))
        success = false;
      if (success && !input.ReadAccept(&result->accept))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestLaunchHandler::DataView, ::blink::mojom::ManifestLaunchHandlerPtr>::Read(
    ::blink::mojom::ManifestLaunchHandler::DataView input,
    ::blink::mojom::ManifestLaunchHandlerPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestLaunchHandlerPtr result(::blink::mojom::ManifestLaunchHandler::New());
  
      if (success && !input.ReadRouteTo(&result->route_to))
        success = false;
      if (success && !input.ReadNavigateExistingClient(&result->navigate_existing_client))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestDebugInfo::DataView, ::blink::mojom::ManifestDebugInfoPtr>::Read(
    ::blink::mojom::ManifestDebugInfo::DataView input,
    ::blink::mojom::ManifestDebugInfoPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestDebugInfoPtr result(::blink::mojom::ManifestDebugInfo::New());
  
      if (success && !input.ReadErrors(&result->errors))
        success = false;
      if (success && !input.ReadRawManifest(&result->raw_manifest))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ManifestError::DataView, ::blink::mojom::ManifestErrorPtr>::Read(
    ::blink::mojom::ManifestError::DataView input,
    ::blink::mojom::ManifestErrorPtr* output) {
  bool success = true;
  ::blink::mojom::ManifestErrorPtr result(::blink::mojom::ManifestError::New());
  
      if (success && !input.ReadMessage(&result->message))
        success = false;
      if (success)
        result->critical = input.critical();
      if (success)
        result->line = input.line();
      if (success)
        result->column = input.column();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif