// third_party/blink/public/mojom/mediasession/media_session.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/mediasession/media_session.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-params-data.h"
#include "third_party/blink/public/mojom/mediasession/media_session.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
MediaSessionSeekToDetails::MediaSessionSeekToDetails()
    : seek_time(),
      fast_seek() {}

MediaSessionSeekToDetails::MediaSessionSeekToDetails(
    ::base::TimeDelta seek_time_in,
    bool fast_seek_in)
    : seek_time(std::move(seek_time_in)),
      fast_seek(std::move(fast_seek_in)) {}

MediaSessionSeekToDetails::~MediaSessionSeekToDetails() = default;

void MediaSessionSeekToDetails::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seek_time"), this->seek_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fast_seek"), this->fast_seek,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaSessionSeekToDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SpecMediaMetadata::SpecMediaMetadata()
    : title(),
      artist(),
      album(),
      artwork() {}

SpecMediaMetadata::SpecMediaMetadata(
    const ::std::u16string& title_in,
    const ::std::u16string& artist_in,
    const ::std::u16string& album_in,
    std::vector<::media_session::MediaImage> artwork_in)
    : title(std::move(title_in)),
      artist(std::move(artist_in)),
      album(std::move(album_in)),
      artwork(std::move(artwork_in)) {}

SpecMediaMetadata::~SpecMediaMetadata() = default;

void SpecMediaMetadata::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "artist"), this->artist,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "album"), this->album,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "artwork"), this->artwork,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::media_session::MediaImage>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpecMediaMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaSessionActionDetails::MediaSessionActionDetails() : tag_(Tag::SEEK_TO) {
  data_.seek_to = new MediaSessionSeekToDetailsPtr;
}

MediaSessionActionDetails::~MediaSessionActionDetails() {
  DestroyActive();
}


void MediaSessionActionDetails::set_seek_to(
    MediaSessionSeekToDetailsPtr seek_to) {
  if (tag_ == Tag::SEEK_TO) {
    *(data_.seek_to) = std::move(seek_to);
  } else {
    DestroyActive();
    tag_ = Tag::SEEK_TO;
    data_.seek_to = new MediaSessionSeekToDetailsPtr(
        std::move(seek_to));
  }
}

void MediaSessionActionDetails::DestroyActive() {
  switch (tag_) {

    case Tag::SEEK_TO:

      delete data_.seek_to;
      break;
  }
}

bool MediaSessionActionDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char MediaSessionClient::Name_[] = "blink.mojom.MediaSessionClient";

MediaSessionClientProxy::MediaSessionClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaSessionClientProxy::DidReceiveAction(
    ::media_session::mojom::MediaSessionAction in_action, MediaSessionActionDetailsPtr in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionClient::DidReceiveAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type ::media_session::mojom::MediaSessionAction>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type MediaSessionActionDetailsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaSessionClient_DidReceiveAction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionClient_DidReceiveAction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media_session::mojom::MediaSessionAction>(
      in_action, &params->action);
  mojo::internal::MessageFragment<decltype(params->details)>
      details_fragment(params.message());
  details_fragment.Claim(&params->details);
  mojo::internal::Serialize<::blink::mojom::MediaSessionActionDetailsDataView>(
      in_details, details_fragment, true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionClient::Name_);
  message.set_method_name("DidReceiveAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaSessionClientStubDispatch::Accept(
    MediaSessionClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaSessionClient_DidReceiveAction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionClient::DidReceiveAction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionClient::DidReceiveAction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionClient_DidReceiveAction_Params_Data* params =
          reinterpret_cast<internal::MediaSessionClient_DidReceiveAction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media_session::mojom::MediaSessionAction p_action{};
      MediaSessionActionDetailsPtr p_details{};
      MediaSessionClient_DidReceiveAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidReceiveAction(
std::move(p_action), 
std::move(p_details));
      return true;
    }
  }
  return false;
}

// static
bool MediaSessionClientStubDispatch::AcceptWithResponder(
    MediaSessionClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaSessionClient_DidReceiveAction_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kMediaSessionClientValidationInfo[] = {
    {&internal::MediaSessionClient_DidReceiveAction_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaSessionClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::MediaSessionClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaSessionClientValidationInfo);
}

const char MediaSessionService::Name_[] = "blink.mojom.MediaSessionService";

MediaSessionServiceProxy::MediaSessionServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaSessionServiceProxy::SetClient(
    ::mojo::PendingRemote<MediaSessionClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionService::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<MediaSessionClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaSessionService_SetClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_SetClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::MediaSessionClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in MediaSessionService.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionServiceProxy::SetPlaybackState(
    MediaSessionPlaybackState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionService::SetPlaybackState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type MediaSessionPlaybackState>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaSessionService_SetPlaybackState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_SetPlaybackState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::MediaSessionPlaybackState>(
      in_state, &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetPlaybackState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionServiceProxy::SetPositionState(
    const absl::optional<::media_session::MediaPosition>& in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionService::SetPositionState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type const absl::optional<::media_session::MediaPosition>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaSessionService_SetPositionState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_SetPositionState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->position)::BaseType> position_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaPositionDataView>(
      in_position, position_fragment);
  params->position.Set(
      position_fragment.is_null() ? nullptr : position_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetPositionState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionServiceProxy::SetMetadata(
    SpecMediaMetadataPtr in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionService::SetMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type SpecMediaMetadataPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaSessionService_SetMetadata_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_SetMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::SpecMediaMetadataDataView>(
      in_metadata, metadata_fragment);
  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionServiceProxy::SetMicrophoneState(
    ::media_session::mojom::MicrophoneState in_microphone_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionService::SetMicrophoneState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("microphone_state"), in_microphone_state,
                        "<value of type ::media_session::mojom::MicrophoneState>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaSessionService_SetMicrophoneState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_SetMicrophoneState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media_session::mojom::MicrophoneState>(
      in_microphone_state, &params->microphone_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetMicrophoneState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionServiceProxy::SetCameraState(
    ::media_session::mojom::CameraState in_camera_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionService::SetCameraState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("camera_state"), in_camera_state,
                        "<value of type ::media_session::mojom::CameraState>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaSessionService_SetCameraState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_SetCameraState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media_session::mojom::CameraState>(
      in_camera_state, &params->camera_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetCameraState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionServiceProxy::EnableAction(
    ::media_session::mojom::MediaSessionAction in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionService::EnableAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type ::media_session::mojom::MediaSessionAction>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaSessionService_EnableAction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_EnableAction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media_session::mojom::MediaSessionAction>(
      in_action, &params->action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("EnableAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionServiceProxy::DisableAction(
    ::media_session::mojom::MediaSessionAction in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionService::DisableAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type ::media_session::mojom::MediaSessionAction>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaSessionService_DisableAction_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaSessionService_DisableAction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media_session::mojom::MediaSessionAction>(
      in_action, &params->action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("DisableAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaSessionServiceStubDispatch::Accept(
    MediaSessionService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaSessionService_SetClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionService::SetClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionService::SetClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetClient_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<MediaSessionClient> p_client{};
      MediaSessionService_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(
std::move(p_client));
      return true;
    }
    case internal::kMediaSessionService_SetPlaybackState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionService::SetPlaybackState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionService::SetPlaybackState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetPlaybackState_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetPlaybackState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaSessionPlaybackState p_state{};
      MediaSessionService_SetPlaybackState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPlaybackState(
std::move(p_state));
      return true;
    }
    case internal::kMediaSessionService_SetPositionState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionService::SetPositionState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionService::SetPositionState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetPositionState_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetPositionState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<::media_session::MediaPosition> p_position{};
      MediaSessionService_SetPositionState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPositionState(
std::move(p_position));
      return true;
    }
    case internal::kMediaSessionService_SetMetadata_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionService::SetMetadata",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionService::SetMetadata");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetMetadata_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetMetadata_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpecMediaMetadataPtr p_metadata{};
      MediaSessionService_SetMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMetadata(
std::move(p_metadata));
      return true;
    }
    case internal::kMediaSessionService_SetMicrophoneState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionService::SetMicrophoneState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionService::SetMicrophoneState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetMicrophoneState_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetMicrophoneState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media_session::mojom::MicrophoneState p_microphone_state{};
      MediaSessionService_SetMicrophoneState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMicrophoneState(&p_microphone_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMicrophoneState(
std::move(p_microphone_state));
      return true;
    }
    case internal::kMediaSessionService_SetCameraState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionService::SetCameraState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionService::SetCameraState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetCameraState_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetCameraState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media_session::mojom::CameraState p_camera_state{};
      MediaSessionService_SetCameraState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCameraState(&p_camera_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCameraState(
std::move(p_camera_state));
      return true;
    }
    case internal::kMediaSessionService_EnableAction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionService::EnableAction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionService::EnableAction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_EnableAction_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_EnableAction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media_session::mojom::MediaSessionAction p_action{};
      MediaSessionService_EnableAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableAction(
std::move(p_action));
      return true;
    }
    case internal::kMediaSessionService_DisableAction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionService::DisableAction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionService::DisableAction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_DisableAction_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_DisableAction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media_session::mojom::MediaSessionAction p_action{};
      MediaSessionService_DisableAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableAction(
std::move(p_action));
      return true;
    }
  }
  return false;
}

// static
bool MediaSessionServiceStubDispatch::AcceptWithResponder(
    MediaSessionService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaSessionService_SetClient_Name: {
      break;
    }
    case internal::kMediaSessionService_SetPlaybackState_Name: {
      break;
    }
    case internal::kMediaSessionService_SetPositionState_Name: {
      break;
    }
    case internal::kMediaSessionService_SetMetadata_Name: {
      break;
    }
    case internal::kMediaSessionService_SetMicrophoneState_Name: {
      break;
    }
    case internal::kMediaSessionService_SetCameraState_Name: {
      break;
    }
    case internal::kMediaSessionService_EnableAction_Name: {
      break;
    }
    case internal::kMediaSessionService_DisableAction_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kMediaSessionServiceValidationInfo[] = {
    {&internal::MediaSessionService_SetClient_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionService_SetPlaybackState_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionService_SetPositionState_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionService_SetMetadata_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionService_SetMicrophoneState_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionService_SetCameraState_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionService_EnableAction_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionService_DisableAction_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaSessionServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::MediaSessionService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaSessionServiceValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::MediaSessionSeekToDetails::DataView, ::blink::mojom::MediaSessionSeekToDetailsPtr>::Read(
    ::blink::mojom::MediaSessionSeekToDetails::DataView input,
    ::blink::mojom::MediaSessionSeekToDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::MediaSessionSeekToDetailsPtr result(::blink::mojom::MediaSessionSeekToDetails::New());
  
      if (success && !input.ReadSeekTime(&result->seek_time))
        success = false;
      if (success)
        result->fast_seek = input.fast_seek();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::SpecMediaMetadata::DataView, ::blink::mojom::SpecMediaMetadataPtr>::Read(
    ::blink::mojom::SpecMediaMetadata::DataView input,
    ::blink::mojom::SpecMediaMetadataPtr* output) {
  bool success = true;
  ::blink::mojom::SpecMediaMetadataPtr result(::blink::mojom::SpecMediaMetadata::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadArtist(&result->artist))
        success = false;
      if (success && !input.ReadAlbum(&result->album))
        success = false;
      if (success && !input.ReadArtwork(&result->artwork))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::MediaSessionActionDetails::DataView, ::blink::mojom::MediaSessionActionDetailsPtr>::Read(
    ::blink::mojom::MediaSessionActionDetails::DataView input,
    ::blink::mojom::MediaSessionActionDetailsPtr* output) {
  using UnionType = ::blink::mojom::MediaSessionActionDetails;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::SEEK_TO: {
      ::blink::mojom::MediaSessionSeekToDetailsPtr result_seek_to;
      if (!input.ReadSeekTo(&result_seek_to))
        return false;

      *output = UnionType::NewSeekTo(
          std::move(result_seek_to));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif