// third_party/blink/public/mojom/page/page.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/page/page.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/page/page.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* PagehideDispatchToStringHelper(PagehideDispatch value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PagehideDispatch::kNotDispatched:
      return "kNotDispatched";
    case PagehideDispatch::kDispatchedNotPersisted:
      return "kDispatchedNotPersisted";
    case PagehideDispatch::kDispatchedPersisted:
      return "kDispatchedPersisted";
    default:
      return nullptr;
  }
}

std::string PagehideDispatchToString(PagehideDispatch value) {
  const char *str = PagehideDispatchToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PagehideDispatch value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PagehideDispatch value) {
  return os << PagehideDispatchToString(value);
}

namespace internal {


// static
bool PageLifecycleState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PageLifecycleState_Data* object = static_cast<const PageLifecycleState_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::PageVisibilityState_Data
        ::Validate(object->visibility, validation_context))
    return false;


  if (!::blink::mojom::internal::PagehideDispatch_Data
        ::Validate(object->pagehide_dispatch, validation_context))
    return false;

  return true;
}

PageLifecycleState_Data::PageLifecycleState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageRestoreParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PageRestoreParams_Data* object = static_cast<const PageRestoreParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_start, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->navigation_start, validation_context))
    return false;

  return true;
}

PageRestoreParams_Data::PageRestoreParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageBroadcast_SetPageLifecycleState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PageBroadcast_SetPageLifecycleState_Params_Data* object = static_cast<const PageBroadcast_SetPageLifecycleState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->page_restore_params, validation_context))
    return false;

  return true;
}

PageBroadcast_SetPageLifecycleState_Params_Data::PageBroadcast_SetPageLifecycleState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageBroadcast_SetPageLifecycleState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PageBroadcast_SetPageLifecycleState_ResponseParams_Data* object = static_cast<const PageBroadcast_SetPageLifecycleState_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PageBroadcast_SetPageLifecycleState_ResponseParams_Data::PageBroadcast_SetPageLifecycleState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageBroadcast_AudioStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PageBroadcast_AudioStateChanged_Params_Data* object = static_cast<const PageBroadcast_AudioStateChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PageBroadcast_AudioStateChanged_Params_Data::PageBroadcast_AudioStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageBroadcast_ActivatePrerenderedPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PageBroadcast_ActivatePrerenderedPage_Params_Data* object = static_cast<const PageBroadcast_ActivatePrerenderedPage_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->activation_start, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->activation_start, validation_context))
    return false;

  return true;
}

PageBroadcast_ActivatePrerenderedPage_Params_Data::PageBroadcast_ActivatePrerenderedPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageBroadcast_ActivatePrerenderedPage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PageBroadcast_ActivatePrerenderedPage_ResponseParams_Data* object = static_cast<const PageBroadcast_ActivatePrerenderedPage_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PageBroadcast_ActivatePrerenderedPage_ResponseParams_Data::PageBroadcast_ActivatePrerenderedPage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageBroadcast_SetInsidePortal_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PageBroadcast_SetInsidePortal_Params_Data* object = static_cast<const PageBroadcast_SetInsidePortal_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PageBroadcast_SetInsidePortal_Params_Data::PageBroadcast_SetInsidePortal_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageBroadcast_UpdateWebPreferences_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PageBroadcast_UpdateWebPreferences_Params_Data* object = static_cast<const PageBroadcast_UpdateWebPreferences_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->preferences, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->preferences, validation_context))
    return false;

  return true;
}

PageBroadcast_UpdateWebPreferences_Params_Data::PageBroadcast_UpdateWebPreferences_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageBroadcast_UpdateRendererPreferences_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PageBroadcast_UpdateRendererPreferences_Params_Data* object = static_cast<const PageBroadcast_UpdateRendererPreferences_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->preferences, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->preferences, validation_context))
    return false;

  return true;
}

PageBroadcast_UpdateRendererPreferences_Params_Data::PageBroadcast_UpdateRendererPreferences_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageBroadcast_SetHistoryOffsetAndLength_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PageBroadcast_SetHistoryOffsetAndLength_Params_Data* object = static_cast<const PageBroadcast_SetHistoryOffsetAndLength_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PageBroadcast_SetHistoryOffsetAndLength_Params_Data::PageBroadcast_SetHistoryOffsetAndLength_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageBroadcast_SetPageBaseBackgroundColor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PageBroadcast_SetPageBaseBackgroundColor_Params_Data* object = static_cast<const PageBroadcast_SetPageBaseBackgroundColor_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->color, validation_context))
    return false;

  return true;
}

PageBroadcast_SetPageBaseBackgroundColor_Params_Data::PageBroadcast_SetPageBaseBackgroundColor_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PagehideDispatch>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::PagehideDispatch value) {
  return std::move(context).WriteString(::blink::mojom::PagehideDispatchToString(value));
}

} // namespace perfetto
