// third_party/blink/public/mojom/page/page.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/page/page.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/page/page.mojom-params-data.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/page/page.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
PageLifecycleState::PageLifecycleState()
    : is_frozen(),
      visibility(),
      is_in_back_forward_cache(),
      pagehide_dispatch(),
      eviction_enabled() {}

PageLifecycleState::PageLifecycleState(
    bool is_frozen_in,
    ::blink::mojom::PageVisibilityState visibility_in,
    bool is_in_back_forward_cache_in,
    PagehideDispatch pagehide_dispatch_in,
    bool eviction_enabled_in)
    : is_frozen(std::move(is_frozen_in)),
      visibility(std::move(visibility_in)),
      is_in_back_forward_cache(std::move(is_in_back_forward_cache_in)),
      pagehide_dispatch(std::move(pagehide_dispatch_in)),
      eviction_enabled(std::move(eviction_enabled_in)) {}

PageLifecycleState::~PageLifecycleState() = default;
size_t PageLifecycleState::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->is_frozen);
  seed = mojo::internal::Hash(seed, this->visibility);
  seed = mojo::internal::Hash(seed, this->is_in_back_forward_cache);
  seed = mojo::internal::Hash(seed, this->pagehide_dispatch);
  seed = mojo::internal::Hash(seed, this->eviction_enabled);
  return seed;
}

void PageLifecycleState::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_frozen"), this->is_frozen,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visibility"), this->visibility,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::PageVisibilityState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_in_back_forward_cache"), this->is_in_back_forward_cache,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pagehide_dispatch"), this->pagehide_dispatch,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PagehideDispatch>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "eviction_enabled"), this->eviction_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PageLifecycleState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PageRestoreParams::PageRestoreParams()
    : navigation_start(),
      pending_history_list_offset(),
      current_history_list_length() {}

PageRestoreParams::PageRestoreParams(
    ::base::TimeTicks navigation_start_in,
    int32_t pending_history_list_offset_in,
    int32_t current_history_list_length_in)
    : navigation_start(std::move(navigation_start_in)),
      pending_history_list_offset(std::move(pending_history_list_offset_in)),
      current_history_list_length(std::move(current_history_list_length_in)) {}

PageRestoreParams::~PageRestoreParams() = default;

void PageRestoreParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_start"), this->navigation_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pending_history_list_offset"), this->pending_history_list_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_history_list_length"), this->current_history_list_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PageRestoreParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PageBroadcast::Name_[] = "blink.mojom.PageBroadcast";

class PageBroadcast_SetPageLifecycleState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageBroadcast_SetPageLifecycleState_ForwardToCallback(
      PageBroadcast::SetPageLifecycleStateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PageBroadcast::SetPageLifecycleStateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PageBroadcast_SetPageLifecycleState_ForwardToCallback);
};

class PageBroadcast_ActivatePrerenderedPage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageBroadcast_ActivatePrerenderedPage_ForwardToCallback(
      PageBroadcast::ActivatePrerenderedPageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PageBroadcast::ActivatePrerenderedPageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PageBroadcast_ActivatePrerenderedPage_ForwardToCallback);
};

PageBroadcastProxy::PageBroadcastProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageBroadcastProxy::SetPageLifecycleState(
    PageLifecycleStatePtr in_state, PageRestoreParamsPtr in_page_restore_params, SetPageLifecycleStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PageBroadcast::SetPageLifecycleState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type PageLifecycleStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_restore_params"), in_page_restore_params,
                        "<value of type PageRestoreParamsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPageBroadcast_SetPageLifecycleState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_SetPageLifecycleState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PageLifecycleStateDataView>(
      in_state, state_fragment);
  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state in PageBroadcast.SetPageLifecycleState request");
  mojo::internal::MessageFragment<
      typename decltype(params->page_restore_params)::BaseType> page_restore_params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PageRestoreParamsDataView>(
      in_page_restore_params, page_restore_params_fragment);
  params->page_restore_params.Set(
      page_restore_params_fragment.is_null() ? nullptr : page_restore_params_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("SetPageLifecycleState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageBroadcast_SetPageLifecycleState_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PageBroadcastProxy::AudioStateChanged(
    bool in_is_audio_playing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PageBroadcast::AudioStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_audio_playing"), in_is_audio_playing,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPageBroadcast_AudioStateChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_AudioStateChanged_Params_Data> params(
          message);
  params.Allocate();
  params->is_audio_playing = in_is_audio_playing;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("AudioStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PageBroadcastProxy::ActivatePrerenderedPage(
    ::base::TimeTicks in_activation_start, ActivatePrerenderedPageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PageBroadcast::ActivatePrerenderedPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("activation_start"), in_activation_start,
                        "<value of type ::base::TimeTicks>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPageBroadcast_ActivatePrerenderedPage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_ActivatePrerenderedPage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->activation_start)::BaseType> activation_start_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_activation_start, activation_start_fragment);
  params->activation_start.Set(
      activation_start_fragment.is_null() ? nullptr : activation_start_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->activation_start.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null activation_start in PageBroadcast.ActivatePrerenderedPage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("ActivatePrerenderedPage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageBroadcast_ActivatePrerenderedPage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PageBroadcastProxy::SetInsidePortal(
    bool in_is_inside_portal) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PageBroadcast::SetInsidePortal", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_inside_portal"), in_is_inside_portal,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPageBroadcast_SetInsidePortal_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_SetInsidePortal_Params_Data> params(
          message);
  params.Allocate();
  params->is_inside_portal = in_is_inside_portal;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("SetInsidePortal");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PageBroadcastProxy::UpdateWebPreferences(
    const ::blink::web_pref::WebPreferences& in_preferences) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PageBroadcast::UpdateWebPreferences", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preferences"), in_preferences,
                        "<value of type const ::blink::web_pref::WebPreferences&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPageBroadcast_UpdateWebPreferences_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_UpdateWebPreferences_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->preferences)::BaseType> preferences_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::WebPreferencesDataView>(
      in_preferences, preferences_fragment);
  params->preferences.Set(
      preferences_fragment.is_null() ? nullptr : preferences_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->preferences.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null preferences in PageBroadcast.UpdateWebPreferences request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("UpdateWebPreferences");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PageBroadcastProxy::UpdateRendererPreferences(
    const ::blink::RendererPreferences& in_preferences) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PageBroadcast::UpdateRendererPreferences", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preferences"), in_preferences,
                        "<value of type const ::blink::RendererPreferences&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPageBroadcast_UpdateRendererPreferences_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_UpdateRendererPreferences_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->preferences)::BaseType> preferences_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::RendererPreferencesDataView>(
      in_preferences, preferences_fragment);
  params->preferences.Set(
      preferences_fragment.is_null() ? nullptr : preferences_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->preferences.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null preferences in PageBroadcast.UpdateRendererPreferences request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("UpdateRendererPreferences");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PageBroadcastProxy::SetHistoryOffsetAndLength(
    int32_t in_offset, int32_t in_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PageBroadcast::SetHistoryOffsetAndLength", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPageBroadcast_SetHistoryOffsetAndLength_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_SetHistoryOffsetAndLength_Params_Data> params(
          message);
  params.Allocate();
  params->offset = in_offset;
  params->length = in_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("SetHistoryOffsetAndLength");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PageBroadcastProxy::SetPageBaseBackgroundColor(
    absl::optional<::SkColor> in_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PageBroadcast::SetPageBaseBackgroundColor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color"), in_color,
                        "<value of type absl::optional<::SkColor>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPageBroadcast_SetPageBaseBackgroundColor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_SetPageBaseBackgroundColor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->color)::BaseType> color_fragment(
          params.message());
  mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_color, color_fragment);
  params->color.Set(
      color_fragment.is_null() ? nullptr : color_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("SetPageBaseBackgroundColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class PageBroadcast_SetPageLifecycleState_ProxyToResponder {
 public:
  static PageBroadcast::SetPageLifecycleStateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PageBroadcast_SetPageLifecycleState_ProxyToResponder> proxy(
        new PageBroadcast_SetPageLifecycleState_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PageBroadcast_SetPageLifecycleState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageBroadcast_SetPageLifecycleState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PageBroadcast_SetPageLifecycleState_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageBroadcast::SetPageLifecycleStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PageBroadcast_SetPageLifecycleState_ProxyToResponder);
};

bool PageBroadcast_SetPageLifecycleState_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::PageBroadcast::SetPageLifecycleStateCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PageBroadcast_SetPageLifecycleState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageBroadcast_SetPageLifecycleState_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PageBroadcast_SetPageLifecycleState_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageBroadcast::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PageBroadcast_SetPageLifecycleState_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::PageBroadcast::SetPageLifecycleStateCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPageBroadcast_SetPageLifecycleState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_SetPageLifecycleState_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::PageBroadcast::SetPageLifecycleStateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("SetPageLifecycleState");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageBroadcast_ActivatePrerenderedPage_ProxyToResponder {
 public:
  static PageBroadcast::ActivatePrerenderedPageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PageBroadcast_ActivatePrerenderedPage_ProxyToResponder> proxy(
        new PageBroadcast_ActivatePrerenderedPage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PageBroadcast_ActivatePrerenderedPage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageBroadcast_ActivatePrerenderedPage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PageBroadcast_ActivatePrerenderedPage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageBroadcast::ActivatePrerenderedPageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PageBroadcast_ActivatePrerenderedPage_ProxyToResponder);
};

bool PageBroadcast_ActivatePrerenderedPage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::PageBroadcast::ActivatePrerenderedPageCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PageBroadcast_ActivatePrerenderedPage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageBroadcast_ActivatePrerenderedPage_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PageBroadcast_ActivatePrerenderedPage_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageBroadcast::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PageBroadcast_ActivatePrerenderedPage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::PageBroadcast::ActivatePrerenderedPageCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPageBroadcast_ActivatePrerenderedPage_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PageBroadcast_ActivatePrerenderedPage_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::PageBroadcast::ActivatePrerenderedPageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("ActivatePrerenderedPage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageBroadcastStubDispatch::Accept(
    PageBroadcast* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPageBroadcast_SetPageLifecycleState_Name: {
      break;
    }
    case internal::kPageBroadcast_AudioStateChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PageBroadcast::AudioStateChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PageBroadcast::AudioStateChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PageBroadcast_AudioStateChanged_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_AudioStateChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_audio_playing{};
      PageBroadcast_AudioStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_audio_playing = input_data_view.is_audio_playing();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AudioStateChanged(
std::move(p_is_audio_playing));
      return true;
    }
    case internal::kPageBroadcast_ActivatePrerenderedPage_Name: {
      break;
    }
    case internal::kPageBroadcast_SetInsidePortal_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PageBroadcast::SetInsidePortal",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PageBroadcast::SetInsidePortal");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PageBroadcast_SetInsidePortal_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_SetInsidePortal_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_inside_portal{};
      PageBroadcast_SetInsidePortal_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_inside_portal = input_data_view.is_inside_portal();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInsidePortal(
std::move(p_is_inside_portal));
      return true;
    }
    case internal::kPageBroadcast_UpdateWebPreferences_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PageBroadcast::UpdateWebPreferences",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PageBroadcast::UpdateWebPreferences");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PageBroadcast_UpdateWebPreferences_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_UpdateWebPreferences_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::web_pref::WebPreferences p_preferences{};
      PageBroadcast_UpdateWebPreferences_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPreferences(&p_preferences))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateWebPreferences(
std::move(p_preferences));
      return true;
    }
    case internal::kPageBroadcast_UpdateRendererPreferences_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PageBroadcast::UpdateRendererPreferences",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PageBroadcast::UpdateRendererPreferences");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PageBroadcast_UpdateRendererPreferences_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_UpdateRendererPreferences_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::RendererPreferences p_preferences{};
      PageBroadcast_UpdateRendererPreferences_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPreferences(&p_preferences))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateRendererPreferences(
std::move(p_preferences));
      return true;
    }
    case internal::kPageBroadcast_SetHistoryOffsetAndLength_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PageBroadcast::SetHistoryOffsetAndLength",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PageBroadcast::SetHistoryOffsetAndLength");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PageBroadcast_SetHistoryOffsetAndLength_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_SetHistoryOffsetAndLength_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_offset{};
      int32_t p_length{};
      PageBroadcast_SetHistoryOffsetAndLength_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_length = input_data_view.length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHistoryOffsetAndLength(
std::move(p_offset), 
std::move(p_length));
      return true;
    }
    case internal::kPageBroadcast_SetPageBaseBackgroundColor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PageBroadcast::SetPageBaseBackgroundColor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PageBroadcast::SetPageBaseBackgroundColor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PageBroadcast_SetPageBaseBackgroundColor_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_SetPageBaseBackgroundColor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<::SkColor> p_color{};
      PageBroadcast_SetPageBaseBackgroundColor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadColor(&p_color))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPageBaseBackgroundColor(
std::move(p_color));
      return true;
    }
  }
  return false;
}

// static
bool PageBroadcastStubDispatch::AcceptWithResponder(
    PageBroadcast* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPageBroadcast_SetPageLifecycleState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PageBroadcast::SetPageLifecycleState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PageBroadcast::SetPageLifecycleState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PageBroadcast_SetPageLifecycleState_Params_Data* params =
          reinterpret_cast<
              internal::PageBroadcast_SetPageLifecycleState_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PageLifecycleStatePtr p_state{};
      PageRestoreParamsPtr p_page_restore_params{};
      PageBroadcast_SetPageLifecycleState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (success && !input_data_view.ReadPageRestoreParams(&p_page_restore_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 0, false);
        return false;
      }
      PageBroadcast::SetPageLifecycleStateCallback callback =
          PageBroadcast_SetPageLifecycleState_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPageLifecycleState(
std::move(p_state), 
std::move(p_page_restore_params), std::move(callback));
      return true;
    }
    case internal::kPageBroadcast_AudioStateChanged_Name: {
      break;
    }
    case internal::kPageBroadcast_ActivatePrerenderedPage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PageBroadcast::ActivatePrerenderedPage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PageBroadcast::ActivatePrerenderedPage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PageBroadcast_ActivatePrerenderedPage_Params_Data* params =
          reinterpret_cast<
              internal::PageBroadcast_ActivatePrerenderedPage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::TimeTicks p_activation_start{};
      PageBroadcast_ActivatePrerenderedPage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActivationStart(&p_activation_start))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 2, false);
        return false;
      }
      PageBroadcast::ActivatePrerenderedPageCallback callback =
          PageBroadcast_ActivatePrerenderedPage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ActivatePrerenderedPage(
std::move(p_activation_start), std::move(callback));
      return true;
    }
    case internal::kPageBroadcast_SetInsidePortal_Name: {
      break;
    }
    case internal::kPageBroadcast_UpdateWebPreferences_Name: {
      break;
    }
    case internal::kPageBroadcast_UpdateRendererPreferences_Name: {
      break;
    }
    case internal::kPageBroadcast_SetHistoryOffsetAndLength_Name: {
      break;
    }
    case internal::kPageBroadcast_SetPageBaseBackgroundColor_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPageBroadcastValidationInfo[] = {
    {&internal::PageBroadcast_SetPageLifecycleState_Params_Data::Validate,
     &internal::PageBroadcast_SetPageLifecycleState_ResponseParams_Data::Validate},
    {&internal::PageBroadcast_AudioStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PageBroadcast_ActivatePrerenderedPage_Params_Data::Validate,
     &internal::PageBroadcast_ActivatePrerenderedPage_ResponseParams_Data::Validate},
    {&internal::PageBroadcast_SetInsidePortal_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PageBroadcast_UpdateWebPreferences_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PageBroadcast_UpdateRendererPreferences_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PageBroadcast_SetHistoryOffsetAndLength_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PageBroadcast_SetPageBaseBackgroundColor_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageBroadcastRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::PageBroadcast::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPageBroadcastValidationInfo);
}

bool PageBroadcastResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::PageBroadcast::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kPageBroadcastValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::PageLifecycleState::DataView, ::blink::mojom::PageLifecycleStatePtr>::Read(
    ::blink::mojom::PageLifecycleState::DataView input,
    ::blink::mojom::PageLifecycleStatePtr* output) {
  bool success = true;
  ::blink::mojom::PageLifecycleStatePtr result(::blink::mojom::PageLifecycleState::New());
  
      if (success)
        result->is_frozen = input.is_frozen();
      if (success && !input.ReadVisibility(&result->visibility))
        success = false;
      if (success)
        result->is_in_back_forward_cache = input.is_in_back_forward_cache();
      if (success && !input.ReadPagehideDispatch(&result->pagehide_dispatch))
        success = false;
      if (success)
        result->eviction_enabled = input.eviction_enabled();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PageRestoreParams::DataView, ::blink::mojom::PageRestoreParamsPtr>::Read(
    ::blink::mojom::PageRestoreParams::DataView input,
    ::blink::mojom::PageRestoreParamsPtr* output) {
  bool success = true;
  ::blink::mojom::PageRestoreParamsPtr result(::blink::mojom::PageRestoreParams::New());
  
      if (success && !input.ReadNavigationStart(&result->navigation_start))
        success = false;
      if (success)
        result->pending_history_list_offset = input.pending_history_list_offset();
      if (success)
        result->current_history_list_length = input.current_history_list_length();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif