// third_party/blink/public/mojom/page_state/page_state.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/page_state/page_state.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/page_state/page_state.mojom-params-data.h"
#include "third_party/blink/public/mojom/page_state/page_state.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/page_state/page_state.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
DEPRECATED_FileSystemFile::DEPRECATED_FileSystemFile()
    : filesystem_url(),
      offset(),
      length(),
      modification_time() {}

DEPRECATED_FileSystemFile::DEPRECATED_FileSystemFile(
    const ::GURL& filesystem_url_in,
    uint64_t offset_in,
    uint64_t length_in,
    ::base::Time modification_time_in)
    : filesystem_url(std::move(filesystem_url_in)),
      offset(std::move(offset_in)),
      length(std::move(length_in)),
      modification_time(std::move(modification_time_in)) {}

DEPRECATED_FileSystemFile::~DEPRECATED_FileSystemFile() = default;

void DEPRECATED_FileSystemFile::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filesystem_url"), this->filesystem_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "length"), this->length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modification_time"), this->modification_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DEPRECATED_FileSystemFile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
File::File()
    : path(),
      offset(),
      length(),
      modification_time() {}

File::File(
    const ::std::u16string& path_in,
    uint64_t offset_in,
    uint64_t length_in,
    ::base::Time modification_time_in)
    : path(std::move(path_in)),
      offset(std::move(offset_in)),
      length(std::move(length_in)),
      modification_time(std::move(modification_time_in)) {}

File::~File() = default;

void File::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "length"), this->length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modification_time"), this->modification_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool File::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RequestBody::RequestBody()
    : elements(),
      identifier(),
      contains_sensitive_info() {}

RequestBody::RequestBody(
    std::vector<ElementPtr> elements_in,
    int64_t identifier_in,
    bool contains_sensitive_info_in)
    : elements(std::move(elements_in)),
      identifier(std::move(identifier_in)),
      contains_sensitive_info(std::move(contains_sensitive_info_in)) {}

RequestBody::~RequestBody() = default;

void RequestBody::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "elements"), this->elements,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ElementPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "identifier"), this->identifier,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contains_sensitive_info"), this->contains_sensitive_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RequestBody::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HttpBody::HttpBody()
    : http_content_type(),
      request_body(),
      contains_passwords(false) {}

HttpBody::HttpBody(
    const absl::optional<::std::u16string>& http_content_type_in,
    RequestBodyPtr request_body_in,
    bool contains_passwords_in)
    : http_content_type(std::move(http_content_type_in)),
      request_body(std::move(request_body_in)),
      contains_passwords(std::move(contains_passwords_in)) {}

HttpBody::~HttpBody() = default;

void HttpBody::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "http_content_type"), this->http_content_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_body"), this->request_body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RequestBodyPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contains_passwords"), this->contains_passwords,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HttpBody::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ViewState::ViewState()
    : visual_viewport_scroll_offset(),
      scroll_offset(),
      page_scale_factor(),
      scroll_anchor_selector(),
      scroll_anchor_offset(),
      scroll_anchor_simhash(0ULL) {}

ViewState::ViewState(
    const ::gfx::PointF& visual_viewport_scroll_offset_in,
    const ::gfx::Point& scroll_offset_in,
    double page_scale_factor_in)
    : visual_viewport_scroll_offset(std::move(visual_viewport_scroll_offset_in)),
      scroll_offset(std::move(scroll_offset_in)),
      page_scale_factor(std::move(page_scale_factor_in)),
      scroll_anchor_selector(),
      scroll_anchor_offset(),
      scroll_anchor_simhash(0ULL) {}

ViewState::ViewState(
    const ::gfx::PointF& visual_viewport_scroll_offset_in,
    const ::gfx::Point& scroll_offset_in,
    double page_scale_factor_in,
    const absl::optional<::std::u16string>& scroll_anchor_selector_in,
    const absl::optional<::gfx::PointF>& scroll_anchor_offset_in,
    uint64_t scroll_anchor_simhash_in)
    : visual_viewport_scroll_offset(std::move(visual_viewport_scroll_offset_in)),
      scroll_offset(std::move(scroll_offset_in)),
      page_scale_factor(std::move(page_scale_factor_in)),
      scroll_anchor_selector(std::move(scroll_anchor_selector_in)),
      scroll_anchor_offset(std::move(scroll_anchor_offset_in)),
      scroll_anchor_simhash(std::move(scroll_anchor_simhash_in)) {}

ViewState::~ViewState() = default;

void ViewState::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visual_viewport_scroll_offset"), this->visual_viewport_scroll_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_offset"), this->scroll_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_scale_factor"), this->page_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_anchor_selector"), this->scroll_anchor_selector,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_anchor_offset"), this->scroll_anchor_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::gfx::PointF>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_anchor_simhash"), this->scroll_anchor_simhash,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ViewState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FrameState::FrameState()
    : url_string(),
      referrer(),
      target(),
      state_object(),
      document_state(),
      scroll_restoration_type(),
      view_state(),
      item_sequence_number(),
      document_sequence_number(),
      referrer_policy(),
      http_body(),
      children(),
      initiator_origin(),
      app_history_key(),
      app_history_id(),
      app_history_state() {}

FrameState::FrameState(
    const absl::optional<::std::u16string>& url_string_in,
    const absl::optional<::std::u16string>& referrer_in,
    const absl::optional<::std::u16string>& target_in,
    const absl::optional<::std::u16string>& state_object_in,
    std::vector<absl::optional<::std::u16string>> document_state_in,
    ScrollRestorationType scroll_restoration_type_in,
    ViewStatePtr view_state_in,
    int64_t item_sequence_number_in,
    int64_t document_sequence_number_in,
    ::network::mojom::ReferrerPolicy referrer_policy_in,
    HttpBodyPtr http_body_in,
    std::vector<FrameStatePtr> children_in)
    : url_string(std::move(url_string_in)),
      referrer(std::move(referrer_in)),
      target(std::move(target_in)),
      state_object(std::move(state_object_in)),
      document_state(std::move(document_state_in)),
      scroll_restoration_type(std::move(scroll_restoration_type_in)),
      view_state(std::move(view_state_in)),
      item_sequence_number(std::move(item_sequence_number_in)),
      document_sequence_number(std::move(document_sequence_number_in)),
      referrer_policy(std::move(referrer_policy_in)),
      http_body(std::move(http_body_in)),
      children(std::move(children_in)),
      initiator_origin(),
      app_history_key(),
      app_history_id(),
      app_history_state() {}

FrameState::FrameState(
    const absl::optional<::std::u16string>& url_string_in,
    const absl::optional<::std::u16string>& referrer_in,
    const absl::optional<::std::u16string>& target_in,
    const absl::optional<::std::u16string>& state_object_in,
    std::vector<absl::optional<::std::u16string>> document_state_in,
    ScrollRestorationType scroll_restoration_type_in,
    ViewStatePtr view_state_in,
    int64_t item_sequence_number_in,
    int64_t document_sequence_number_in,
    ::network::mojom::ReferrerPolicy referrer_policy_in,
    HttpBodyPtr http_body_in,
    std::vector<FrameStatePtr> children_in,
    const absl::optional<std::string>& initiator_origin_in)
    : url_string(std::move(url_string_in)),
      referrer(std::move(referrer_in)),
      target(std::move(target_in)),
      state_object(std::move(state_object_in)),
      document_state(std::move(document_state_in)),
      scroll_restoration_type(std::move(scroll_restoration_type_in)),
      view_state(std::move(view_state_in)),
      item_sequence_number(std::move(item_sequence_number_in)),
      document_sequence_number(std::move(document_sequence_number_in)),
      referrer_policy(std::move(referrer_policy_in)),
      http_body(std::move(http_body_in)),
      children(std::move(children_in)),
      initiator_origin(std::move(initiator_origin_in)),
      app_history_key(),
      app_history_id(),
      app_history_state() {}

FrameState::FrameState(
    const absl::optional<::std::u16string>& url_string_in,
    const absl::optional<::std::u16string>& referrer_in,
    const absl::optional<::std::u16string>& target_in,
    const absl::optional<::std::u16string>& state_object_in,
    std::vector<absl::optional<::std::u16string>> document_state_in,
    ScrollRestorationType scroll_restoration_type_in,
    ViewStatePtr view_state_in,
    int64_t item_sequence_number_in,
    int64_t document_sequence_number_in,
    ::network::mojom::ReferrerPolicy referrer_policy_in,
    HttpBodyPtr http_body_in,
    std::vector<FrameStatePtr> children_in,
    const absl::optional<std::string>& initiator_origin_in,
    const absl::optional<::std::u16string>& app_history_key_in,
    const absl::optional<::std::u16string>& app_history_id_in)
    : url_string(std::move(url_string_in)),
      referrer(std::move(referrer_in)),
      target(std::move(target_in)),
      state_object(std::move(state_object_in)),
      document_state(std::move(document_state_in)),
      scroll_restoration_type(std::move(scroll_restoration_type_in)),
      view_state(std::move(view_state_in)),
      item_sequence_number(std::move(item_sequence_number_in)),
      document_sequence_number(std::move(document_sequence_number_in)),
      referrer_policy(std::move(referrer_policy_in)),
      http_body(std::move(http_body_in)),
      children(std::move(children_in)),
      initiator_origin(std::move(initiator_origin_in)),
      app_history_key(std::move(app_history_key_in)),
      app_history_id(std::move(app_history_id_in)),
      app_history_state() {}

FrameState::FrameState(
    const absl::optional<::std::u16string>& url_string_in,
    const absl::optional<::std::u16string>& referrer_in,
    const absl::optional<::std::u16string>& target_in,
    const absl::optional<::std::u16string>& state_object_in,
    std::vector<absl::optional<::std::u16string>> document_state_in,
    ScrollRestorationType scroll_restoration_type_in,
    ViewStatePtr view_state_in,
    int64_t item_sequence_number_in,
    int64_t document_sequence_number_in,
    ::network::mojom::ReferrerPolicy referrer_policy_in,
    HttpBodyPtr http_body_in,
    std::vector<FrameStatePtr> children_in,
    const absl::optional<std::string>& initiator_origin_in,
    const absl::optional<::std::u16string>& app_history_key_in,
    const absl::optional<::std::u16string>& app_history_id_in,
    const absl::optional<::std::u16string>& app_history_state_in)
    : url_string(std::move(url_string_in)),
      referrer(std::move(referrer_in)),
      target(std::move(target_in)),
      state_object(std::move(state_object_in)),
      document_state(std::move(document_state_in)),
      scroll_restoration_type(std::move(scroll_restoration_type_in)),
      view_state(std::move(view_state_in)),
      item_sequence_number(std::move(item_sequence_number_in)),
      document_sequence_number(std::move(document_sequence_number_in)),
      referrer_policy(std::move(referrer_policy_in)),
      http_body(std::move(http_body_in)),
      children(std::move(children_in)),
      initiator_origin(std::move(initiator_origin_in)),
      app_history_key(std::move(app_history_key_in)),
      app_history_id(std::move(app_history_id_in)),
      app_history_state(std::move(app_history_state_in)) {}

FrameState::~FrameState() = default;

void FrameState::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_string"), this->url_string,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target"), this->target,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state_object"), this->state_object,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_state"), this->document_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<absl::optional<::std::u16string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_restoration_type"), this->scroll_restoration_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScrollRestorationType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "view_state"), this->view_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ViewStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "item_sequence_number"), this->item_sequence_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_sequence_number"), this->document_sequence_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer_policy"), this->referrer_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::ReferrerPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "http_body"), this->http_body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type HttpBodyPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "children"), this->children,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<FrameStatePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_origin"), this->initiator_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_history_key"), this->app_history_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_history_id"), this->app_history_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_history_state"), this->app_history_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FrameState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PageState::PageState()
    : referenced_files(),
      top() {}

PageState::PageState(
    std::vector<absl::optional<::std::u16string>> referenced_files_in,
    FrameStatePtr top_in)
    : referenced_files(std::move(referenced_files_in)),
      top(std::move(top_in)) {}

PageState::~PageState() = default;

void PageState::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referenced_files"), this->referenced_files,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<absl::optional<::std::u16string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top"), this->top,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FrameStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PageState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Element::Element() : tag_(Tag::BLOB_UUID) {
  data_.blob_uuid = new std::string;
}

Element::~Element() {
  DestroyActive();
}


void Element::set_blob_uuid(
    const std::string& blob_uuid) {
  if (tag_ == Tag::BLOB_UUID) {
    *(data_.blob_uuid) = std::move(blob_uuid);
  } else {
    DestroyActive();
    tag_ = Tag::BLOB_UUID;
    data_.blob_uuid = new std::string(
        std::move(blob_uuid));
  }
}
void Element::set_bytes(
    std::vector<uint8_t> bytes) {
  if (tag_ == Tag::BYTES) {
    *(data_.bytes) = std::move(bytes);
  } else {
    DestroyActive();
    tag_ = Tag::BYTES;
    data_.bytes = new std::vector<uint8_t>(
        std::move(bytes));
  }
}
void Element::set_file(
    FilePtr file) {
  if (tag_ == Tag::FILE) {
    *(data_.file) = std::move(file);
  } else {
    DestroyActive();
    tag_ = Tag::FILE;
    data_.file = new FilePtr(
        std::move(file));
  }
}
void Element::set_DEPRECATED_file_system_file(
    DEPRECATED_FileSystemFilePtr DEPRECATED_file_system_file) {
  if (tag_ == Tag::DEPRECATED_FILE_SYSTEM_FILE) {
    *(data_.DEPRECATED_file_system_file) = std::move(DEPRECATED_file_system_file);
  } else {
    DestroyActive();
    tag_ = Tag::DEPRECATED_FILE_SYSTEM_FILE;
    data_.DEPRECATED_file_system_file = new DEPRECATED_FileSystemFilePtr(
        std::move(DEPRECATED_file_system_file));
  }
}

void Element::DestroyActive() {
  switch (tag_) {

    case Tag::BLOB_UUID:

      delete data_.blob_uuid;
      break;
    case Tag::BYTES:

      delete data_.bytes;
      break;
    case Tag::FILE:

      delete data_.file;
      break;
    case Tag::DEPRECATED_FILE_SYSTEM_FILE:

      delete data_.DEPRECATED_file_system_file;
      break;
  }
}

bool Element::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::DEPRECATED_FileSystemFile::DataView, ::blink::mojom::DEPRECATED_FileSystemFilePtr>::Read(
    ::blink::mojom::DEPRECATED_FileSystemFile::DataView input,
    ::blink::mojom::DEPRECATED_FileSystemFilePtr* output) {
  bool success = true;
  ::blink::mojom::DEPRECATED_FileSystemFilePtr result(::blink::mojom::DEPRECATED_FileSystemFile::New());
  
      if (success && !input.ReadFilesystemUrl(&result->filesystem_url))
        success = false;
      if (success)
        result->offset = input.offset();
      if (success)
        result->length = input.length();
      if (success && !input.ReadModificationTime(&result->modification_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::File::DataView, ::blink::mojom::FilePtr>::Read(
    ::blink::mojom::File::DataView input,
    ::blink::mojom::FilePtr* output) {
  bool success = true;
  ::blink::mojom::FilePtr result(::blink::mojom::File::New());
  
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success)
        result->offset = input.offset();
      if (success)
        result->length = input.length();
      if (success && !input.ReadModificationTime(&result->modification_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::RequestBody::DataView, ::blink::mojom::RequestBodyPtr>::Read(
    ::blink::mojom::RequestBody::DataView input,
    ::blink::mojom::RequestBodyPtr* output) {
  bool success = true;
  ::blink::mojom::RequestBodyPtr result(::blink::mojom::RequestBody::New());
  
      if (success && !input.ReadElements(&result->elements))
        success = false;
      if (success)
        result->identifier = input.identifier();
      if (success)
        result->contains_sensitive_info = input.contains_sensitive_info();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::HttpBody::DataView, ::blink::mojom::HttpBodyPtr>::Read(
    ::blink::mojom::HttpBody::DataView input,
    ::blink::mojom::HttpBodyPtr* output) {
  bool success = true;
  ::blink::mojom::HttpBodyPtr result(::blink::mojom::HttpBody::New());
  
      if (success && !input.ReadHttpContentType(&result->http_content_type))
        success = false;
      if (success && !input.ReadRequestBody(&result->request_body))
        success = false;
      if (success)
        result->contains_passwords = input.contains_passwords();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ViewState::DataView, ::blink::mojom::ViewStatePtr>::Read(
    ::blink::mojom::ViewState::DataView input,
    ::blink::mojom::ViewStatePtr* output) {
  bool success = true;
  ::blink::mojom::ViewStatePtr result(::blink::mojom::ViewState::New());
  
      if (success && !input.ReadVisualViewportScrollOffset(&result->visual_viewport_scroll_offset))
        success = false;
      if (success && !input.ReadScrollOffset(&result->scroll_offset))
        success = false;
      if (success)
        result->page_scale_factor = input.page_scale_factor();
      if (success && !input.ReadScrollAnchorSelector(&result->scroll_anchor_selector))
        success = false;
      if (success && !input.ReadScrollAnchorOffset(&result->scroll_anchor_offset))
        success = false;
      if (success)
        result->scroll_anchor_simhash = input.scroll_anchor_simhash();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FrameState::DataView, ::blink::mojom::FrameStatePtr>::Read(
    ::blink::mojom::FrameState::DataView input,
    ::blink::mojom::FrameStatePtr* output) {
  bool success = true;
  ::blink::mojom::FrameStatePtr result(::blink::mojom::FrameState::New());
  
      if (success && !input.ReadUrlString(&result->url_string))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadTarget(&result->target))
        success = false;
      if (success && !input.ReadStateObject(&result->state_object))
        success = false;
      if (success && !input.ReadDocumentState(&result->document_state))
        success = false;
      if (success && !input.ReadScrollRestorationType(&result->scroll_restoration_type))
        success = false;
      if (success && !input.ReadViewState(&result->view_state))
        success = false;
      if (success)
        result->item_sequence_number = input.item_sequence_number();
      if (success)
        result->document_sequence_number = input.document_sequence_number();
      if (success && !input.ReadReferrerPolicy(&result->referrer_policy))
        success = false;
      if (success && !input.ReadHttpBody(&result->http_body))
        success = false;
      if (success && !input.ReadChildren(&result->children))
        success = false;
      if (success && !input.ReadInitiatorOrigin(&result->initiator_origin))
        success = false;
      if (success && !input.ReadAppHistoryKey(&result->app_history_key))
        success = false;
      if (success && !input.ReadAppHistoryId(&result->app_history_id))
        success = false;
      if (success && !input.ReadAppHistoryState(&result->app_history_state))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PageState::DataView, ::blink::mojom::PageStatePtr>::Read(
    ::blink::mojom::PageState::DataView input,
    ::blink::mojom::PageStatePtr* output) {
  bool success = true;
  ::blink::mojom::PageStatePtr result(::blink::mojom::PageState::New());
  
      if (success && !input.ReadReferencedFiles(&result->referenced_files))
        success = false;
      if (success && !input.ReadTop(&result->top))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::Element::DataView, ::blink::mojom::ElementPtr>::Read(
    ::blink::mojom::Element::DataView input,
    ::blink::mojom::ElementPtr* output) {
  using UnionType = ::blink::mojom::Element;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::BLOB_UUID: {
      std::string result_blob_uuid;
      if (!input.ReadBlobUuid(&result_blob_uuid))
        return false;

      *output = UnionType::NewBlobUuid(
          std::move(result_blob_uuid));
      break;
    }
    case Tag::BYTES: {
      std::vector<uint8_t> result_bytes;
      if (!input.ReadBytes(&result_bytes))
        return false;

      *output = UnionType::NewBytes(
          std::move(result_bytes));
      break;
    }
    case Tag::FILE: {
      ::blink::mojom::FilePtr result_file;
      if (!input.ReadFile(&result_file))
        return false;

      *output = UnionType::NewFile(
          std::move(result_file));
      break;
    }
    case Tag::DEPRECATED_FILE_SYSTEM_FILE: {
      ::blink::mojom::DEPRECATED_FileSystemFilePtr result_DEPRECATED_file_system_file;
      if (!input.ReadDeprecatedFileSystemFile(&result_DEPRECATED_file_system_file))
        return false;

      *output = UnionType::NewDeprecatedFileSystemFile(
          std::move(result_DEPRECATED_file_system_file));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif