// third_party/blink/public/mojom/payments/payment_app.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/payments/payment_app.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/payments/payment_app.mojom-params-data.h"
#include "third_party/blink/public/mojom/payments/payment_app.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/payments/payment_app.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_APP_MOJOM_JUMBO_H_
#include "third_party/blink/public/common/manifest/manifest_mojom_traits.h"
#endif
namespace payments {
namespace mojom {
PaymentInstrument::PaymentInstrument()
    : name(),
      icons(),
      method(),
      stringified_capabilities(),
      supported_networks() {}

PaymentInstrument::PaymentInstrument(
    const std::string& name_in,
    std::vector<::blink::Manifest::ImageResource> icons_in,
    const std::string& method_in,
    const std::string& stringified_capabilities_in,
    std::vector<::payments::mojom::BasicCardNetwork> supported_networks_in)
    : name(std::move(name_in)),
      icons(std::move(icons_in)),
      method(std::move(method_in)),
      stringified_capabilities(std::move(stringified_capabilities_in)),
      supported_networks(std::move(supported_networks_in)) {}

PaymentInstrument::~PaymentInstrument() = default;

void PaymentInstrument::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icons"), this->icons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::Manifest::ImageResource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stringified_capabilities"), this->stringified_capabilities,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_networks"), this->supported_networks,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::payments::mojom::BasicCardNetwork>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentInstrument::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CanMakePaymentEventData::CanMakePaymentEventData()
    : top_origin(),
      payment_request_origin(),
      method_data(),
      modifiers(),
      currency() {}

CanMakePaymentEventData::CanMakePaymentEventData(
    const ::GURL& top_origin_in,
    const ::GURL& payment_request_origin_in,
    std::vector<::payments::mojom::PaymentMethodDataPtr> method_data_in,
    std::vector<::payments::mojom::PaymentDetailsModifierPtr> modifiers_in,
    const absl::optional<std::string>& currency_in)
    : top_origin(std::move(top_origin_in)),
      payment_request_origin(std::move(payment_request_origin_in)),
      method_data(std::move(method_data_in)),
      modifiers(std::move(modifiers_in)),
      currency(std::move(currency_in)) {}

CanMakePaymentEventData::~CanMakePaymentEventData() = default;

void CanMakePaymentEventData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_origin"), this->top_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payment_request_origin"), this->payment_request_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method_data"), this->method_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::payments::mojom::PaymentMethodDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modifiers"), this->modifiers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::payments::mojom::PaymentDetailsModifierPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "currency"), this->currency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CanMakePaymentEventData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentRequestEventData::PaymentRequestEventData()
    : top_origin(),
      payment_request_origin(),
      payment_request_id(),
      method_data(),
      total(),
      modifiers(),
      instrument_key(),
      payment_options(),
      shipping_options(),
      payment_handler_host() {}

PaymentRequestEventData::PaymentRequestEventData(
    const ::GURL& top_origin_in,
    const ::GURL& payment_request_origin_in,
    const std::string& payment_request_id_in,
    std::vector<::payments::mojom::PaymentMethodDataPtr> method_data_in,
    ::payments::mojom::PaymentCurrencyAmountPtr total_in,
    std::vector<::payments::mojom::PaymentDetailsModifierPtr> modifiers_in,
    const std::string& instrument_key_in,
    ::payments::mojom::PaymentOptionsPtr payment_options_in,
    absl::optional<std::vector<::payments::mojom::PaymentShippingOptionPtr>> shipping_options_in,
    ::mojo::PendingRemote<::payments::mojom::PaymentHandlerHost> payment_handler_host_in)
    : top_origin(std::move(top_origin_in)),
      payment_request_origin(std::move(payment_request_origin_in)),
      payment_request_id(std::move(payment_request_id_in)),
      method_data(std::move(method_data_in)),
      total(std::move(total_in)),
      modifiers(std::move(modifiers_in)),
      instrument_key(std::move(instrument_key_in)),
      payment_options(std::move(payment_options_in)),
      shipping_options(std::move(shipping_options_in)),
      payment_handler_host(std::move(payment_handler_host_in)) {}

PaymentRequestEventData::~PaymentRequestEventData() = default;

void PaymentRequestEventData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_origin"), this->top_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payment_request_origin"), this->payment_request_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payment_request_id"), this->payment_request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method_data"), this->method_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::payments::mojom::PaymentMethodDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total"), this->total,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::payments::mojom::PaymentCurrencyAmountPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modifiers"), this->modifiers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::payments::mojom::PaymentDetailsModifierPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instrument_key"), this->instrument_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payment_options"), this->payment_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::payments::mojom::PaymentOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_options"), this->shipping_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<std::vector<::payments::mojom::PaymentShippingOptionPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payment_handler_host"), this->payment_handler_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::payments::mojom::PaymentHandlerHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentRequestEventData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CanMakePaymentResponse::CanMakePaymentResponse()
    : response_type(),
      can_make_payment(),
      ready_for_minimal_ui(),
      account_balance() {}

CanMakePaymentResponse::CanMakePaymentResponse(
    CanMakePaymentEventResponseType response_type_in,
    bool can_make_payment_in,
    bool ready_for_minimal_ui_in,
    const absl::optional<std::string>& account_balance_in)
    : response_type(std::move(response_type_in)),
      can_make_payment(std::move(can_make_payment_in)),
      ready_for_minimal_ui(std::move(ready_for_minimal_ui_in)),
      account_balance(std::move(account_balance_in)) {}

CanMakePaymentResponse::~CanMakePaymentResponse() = default;

void CanMakePaymentResponse::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_type"), this->response_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CanMakePaymentEventResponseType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_make_payment"), this->can_make_payment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ready_for_minimal_ui"), this->ready_for_minimal_ui,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "account_balance"), this->account_balance,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CanMakePaymentResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentHandlerResponse::PaymentHandlerResponse()
    : method_name(),
      stringified_details(),
      response_type(),
      payer_name(),
      payer_email(),
      payer_phone(),
      shipping_address(),
      shipping_option() {}

PaymentHandlerResponse::PaymentHandlerResponse(
    const std::string& method_name_in,
    const std::string& stringified_details_in,
    PaymentEventResponseType response_type_in,
    const absl::optional<std::string>& payer_name_in,
    const absl::optional<std::string>& payer_email_in,
    const absl::optional<std::string>& payer_phone_in,
    ::payments::mojom::PaymentAddressPtr shipping_address_in,
    const absl::optional<std::string>& shipping_option_in)
    : method_name(std::move(method_name_in)),
      stringified_details(std::move(stringified_details_in)),
      response_type(std::move(response_type_in)),
      payer_name(std::move(payer_name_in)),
      payer_email(std::move(payer_email_in)),
      payer_phone(std::move(payer_phone_in)),
      shipping_address(std::move(shipping_address_in)),
      shipping_option(std::move(shipping_option_in)) {}

PaymentHandlerResponse::~PaymentHandlerResponse() = default;

void PaymentHandlerResponse::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method_name"), this->method_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stringified_details"), this->stringified_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_type"), this->response_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PaymentEventResponseType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payer_name"), this->payer_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payer_email"), this->payer_email,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payer_phone"), this->payer_phone,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_address"), this->shipping_address,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::payments::mojom::PaymentAddressPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shipping_option"), this->shipping_option,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentHandlerResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PaymentManager::Name_[] = "payments.mojom.PaymentManager";

class PaymentManager_DeletePaymentInstrument_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentManager_DeletePaymentInstrument_ForwardToCallback(
      PaymentManager::DeletePaymentInstrumentCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaymentManager::DeletePaymentInstrumentCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaymentManager_DeletePaymentInstrument_ForwardToCallback);
};

class PaymentManager_GetPaymentInstrument_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentManager_GetPaymentInstrument_ForwardToCallback(
      PaymentManager::GetPaymentInstrumentCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaymentManager::GetPaymentInstrumentCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaymentManager_GetPaymentInstrument_ForwardToCallback);
};

class PaymentManager_KeysOfPaymentInstruments_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentManager_KeysOfPaymentInstruments_ForwardToCallback(
      PaymentManager::KeysOfPaymentInstrumentsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaymentManager::KeysOfPaymentInstrumentsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaymentManager_KeysOfPaymentInstruments_ForwardToCallback);
};

class PaymentManager_HasPaymentInstrument_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentManager_HasPaymentInstrument_ForwardToCallback(
      PaymentManager::HasPaymentInstrumentCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaymentManager::HasPaymentInstrumentCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaymentManager_HasPaymentInstrument_ForwardToCallback);
};

class PaymentManager_SetPaymentInstrument_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentManager_SetPaymentInstrument_ForwardToCallback(
      PaymentManager::SetPaymentInstrumentCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaymentManager::SetPaymentInstrumentCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaymentManager_SetPaymentInstrument_ForwardToCallback);
};

class PaymentManager_ClearPaymentInstruments_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentManager_ClearPaymentInstruments_ForwardToCallback(
      PaymentManager::ClearPaymentInstrumentsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaymentManager::ClearPaymentInstrumentsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaymentManager_ClearPaymentInstruments_ForwardToCallback);
};

class PaymentManager_EnableDelegations_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PaymentManager_EnableDelegations_ForwardToCallback(
      PaymentManager::EnableDelegationsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PaymentManager::EnableDelegationsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PaymentManager_EnableDelegations_ForwardToCallback);
};

PaymentManagerProxy::PaymentManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaymentManagerProxy::Init(
    const ::GURL& in_context_url, const std::string& in_service_worker_scope) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentManager::Init", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context_url"), in_context_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_scope"), in_service_worker_scope,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_Init_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_Init_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->context_url)::BaseType> context_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_context_url, context_url_fragment);
  params->context_url.Set(
      context_url_fragment.is_null() ? nullptr : context_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->context_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null context_url in PaymentManager.Init request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_worker_scope)::BaseType> service_worker_scope_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_service_worker_scope, service_worker_scope_fragment);
  params->service_worker_scope.Set(
      service_worker_scope_fragment.is_null() ? nullptr : service_worker_scope_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->service_worker_scope.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null service_worker_scope in PaymentManager.Init request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("Init");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentManagerProxy::DeletePaymentInstrument(
    const std::string& in_instrument_key, DeletePaymentInstrumentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentManager::DeletePaymentInstrument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instrument_key"), in_instrument_key,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_DeletePaymentInstrument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_DeletePaymentInstrument_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->instrument_key)::BaseType> instrument_key_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_instrument_key, instrument_key_fragment);
  params->instrument_key.Set(
      instrument_key_fragment.is_null() ? nullptr : instrument_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->instrument_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instrument_key in PaymentManager.DeletePaymentInstrument request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("DeletePaymentInstrument");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentManager_DeletePaymentInstrument_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PaymentManagerProxy::GetPaymentInstrument(
    const std::string& in_instrument_key, GetPaymentInstrumentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentManager::GetPaymentInstrument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instrument_key"), in_instrument_key,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_GetPaymentInstrument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_GetPaymentInstrument_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->instrument_key)::BaseType> instrument_key_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_instrument_key, instrument_key_fragment);
  params->instrument_key.Set(
      instrument_key_fragment.is_null() ? nullptr : instrument_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->instrument_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instrument_key in PaymentManager.GetPaymentInstrument request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("GetPaymentInstrument");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentManager_GetPaymentInstrument_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PaymentManagerProxy::KeysOfPaymentInstruments(
    KeysOfPaymentInstrumentsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::PaymentManager::KeysOfPaymentInstruments");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_KeysOfPaymentInstruments_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_KeysOfPaymentInstruments_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("KeysOfPaymentInstruments");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentManager_KeysOfPaymentInstruments_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PaymentManagerProxy::HasPaymentInstrument(
    const std::string& in_instrument_key, HasPaymentInstrumentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentManager::HasPaymentInstrument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instrument_key"), in_instrument_key,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_HasPaymentInstrument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_HasPaymentInstrument_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->instrument_key)::BaseType> instrument_key_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_instrument_key, instrument_key_fragment);
  params->instrument_key.Set(
      instrument_key_fragment.is_null() ? nullptr : instrument_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->instrument_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instrument_key in PaymentManager.HasPaymentInstrument request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("HasPaymentInstrument");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentManager_HasPaymentInstrument_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PaymentManagerProxy::SetPaymentInstrument(
    const std::string& in_instrument_key, PaymentInstrumentPtr in_instrument, SetPaymentInstrumentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentManager::SetPaymentInstrument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instrument_key"), in_instrument_key,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instrument"), in_instrument,
                        "<value of type PaymentInstrumentPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_SetPaymentInstrument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_SetPaymentInstrument_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->instrument_key)::BaseType> instrument_key_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_instrument_key, instrument_key_fragment);
  params->instrument_key.Set(
      instrument_key_fragment.is_null() ? nullptr : instrument_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->instrument_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instrument_key in PaymentManager.SetPaymentInstrument request");
  mojo::internal::MessageFragment<
      typename decltype(params->instrument)::BaseType> instrument_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentInstrumentDataView>(
      in_instrument, instrument_fragment);
  params->instrument.Set(
      instrument_fragment.is_null() ? nullptr : instrument_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->instrument.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instrument in PaymentManager.SetPaymentInstrument request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("SetPaymentInstrument");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentManager_SetPaymentInstrument_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PaymentManagerProxy::ClearPaymentInstruments(
    ClearPaymentInstrumentsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::PaymentManager::ClearPaymentInstruments");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_ClearPaymentInstruments_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_ClearPaymentInstruments_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("ClearPaymentInstruments");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentManager_ClearPaymentInstruments_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PaymentManagerProxy::SetUserHint(
    const std::string& in_user_hint) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentManager::SetUserHint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_hint"), in_user_hint,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_SetUserHint_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_SetUserHint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->user_hint)::BaseType> user_hint_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_user_hint, user_hint_fragment);
  params->user_hint.Set(
      user_hint_fragment.is_null() ? nullptr : user_hint_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->user_hint.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_hint in PaymentManager.SetUserHint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("SetUserHint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentManagerProxy::EnableDelegations(
    const std::vector<PaymentDelegation>& in_delegations, EnableDelegationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentManager::EnableDelegations", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delegations"), in_delegations,
                        "<value of type const std::vector<PaymentDelegation>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_EnableDelegations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_EnableDelegations_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->delegations)::BaseType>
      delegations_fragment(params.message());
  const mojo::internal::ContainerValidateParams delegations_validate_params(
      0, ::payments::mojom::internal::PaymentDelegation_Data::Validate);
  mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentDelegation>>(
      in_delegations, delegations_fragment, &delegations_validate_params);
  params->delegations.Set(
      delegations_fragment.is_null() ? nullptr : delegations_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->delegations.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null delegations in PaymentManager.EnableDelegations request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("EnableDelegations");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PaymentManager_EnableDelegations_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PaymentManager_DeletePaymentInstrument_ProxyToResponder {
 public:
  static PaymentManager::DeletePaymentInstrumentCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaymentManager_DeletePaymentInstrument_ProxyToResponder> proxy(
        new PaymentManager_DeletePaymentInstrument_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaymentManager_DeletePaymentInstrument_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentManager_DeletePaymentInstrument_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaymentManager_DeletePaymentInstrument_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentManager::DeletePaymentInstrumentCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentHandlerStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaymentManager_DeletePaymentInstrument_ProxyToResponder);
};

bool PaymentManager_DeletePaymentInstrument_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::PaymentManager::DeletePaymentInstrumentCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PaymentManager_DeletePaymentInstrument_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentManager_DeletePaymentInstrument_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PaymentHandlerStatus p_status{};
  PaymentManager_DeletePaymentInstrument_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void PaymentManager_DeletePaymentInstrument_ProxyToResponder::Run(
    PaymentHandlerStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::PaymentManager::DeletePaymentInstrumentCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PaymentHandlerStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_DeletePaymentInstrument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_DeletePaymentInstrument_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::PaymentHandlerStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::PaymentManager::DeletePaymentInstrumentCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("DeletePaymentInstrument");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaymentManager_GetPaymentInstrument_ProxyToResponder {
 public:
  static PaymentManager::GetPaymentInstrumentCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaymentManager_GetPaymentInstrument_ProxyToResponder> proxy(
        new PaymentManager_GetPaymentInstrument_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaymentManager_GetPaymentInstrument_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentManager_GetPaymentInstrument_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaymentManager_GetPaymentInstrument_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentManager::GetPaymentInstrumentCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentInstrumentPtr in_instrument, PaymentHandlerStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaymentManager_GetPaymentInstrument_ProxyToResponder);
};

bool PaymentManager_GetPaymentInstrument_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::PaymentManager::GetPaymentInstrumentCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PaymentManager_GetPaymentInstrument_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentManager_GetPaymentInstrument_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PaymentInstrumentPtr p_instrument{};
  PaymentHandlerStatus p_status{};
  PaymentManager_GetPaymentInstrument_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInstrument(&p_instrument))
    success = false;
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_instrument), 
std::move(p_status));
  return true;
}

void PaymentManager_GetPaymentInstrument_ProxyToResponder::Run(
    PaymentInstrumentPtr in_instrument, PaymentHandlerStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::PaymentManager::GetPaymentInstrumentCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("instrument"), in_instrument,
                        "<value of type PaymentInstrumentPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PaymentHandlerStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_GetPaymentInstrument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_GetPaymentInstrument_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->instrument)::BaseType> instrument_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentInstrumentDataView>(
      in_instrument, instrument_fragment);
  params->instrument.Set(
      instrument_fragment.is_null() ? nullptr : instrument_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->instrument.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instrument in ");
  mojo::internal::Serialize<::payments::mojom::PaymentHandlerStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::PaymentManager::GetPaymentInstrumentCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("GetPaymentInstrument");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaymentManager_KeysOfPaymentInstruments_ProxyToResponder {
 public:
  static PaymentManager::KeysOfPaymentInstrumentsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaymentManager_KeysOfPaymentInstruments_ProxyToResponder> proxy(
        new PaymentManager_KeysOfPaymentInstruments_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaymentManager_KeysOfPaymentInstruments_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentManager_KeysOfPaymentInstruments_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaymentManager_KeysOfPaymentInstruments_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentManager::KeysOfPaymentInstrumentsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_keys, PaymentHandlerStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaymentManager_KeysOfPaymentInstruments_ProxyToResponder);
};

bool PaymentManager_KeysOfPaymentInstruments_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::PaymentManager::KeysOfPaymentInstrumentsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PaymentManager_KeysOfPaymentInstruments_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentManager_KeysOfPaymentInstruments_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<std::string> p_keys{};
  PaymentHandlerStatus p_status{};
  PaymentManager_KeysOfPaymentInstruments_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadKeys(&p_keys))
    success = false;
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentManager::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_keys), 
std::move(p_status));
  return true;
}

void PaymentManager_KeysOfPaymentInstruments_ProxyToResponder::Run(
    const std::vector<std::string>& in_keys, PaymentHandlerStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::PaymentManager::KeysOfPaymentInstrumentsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keys"), in_keys,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PaymentHandlerStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_KeysOfPaymentInstruments_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_KeysOfPaymentInstruments_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->keys)::BaseType>
      keys_fragment(params.message());
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_keys, keys_fragment, &keys_validate_params);
  params->keys.Set(
      keys_fragment.is_null() ? nullptr : keys_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->keys.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keys in ");
  mojo::internal::Serialize<::payments::mojom::PaymentHandlerStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::PaymentManager::KeysOfPaymentInstrumentsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("KeysOfPaymentInstruments");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaymentManager_HasPaymentInstrument_ProxyToResponder {
 public:
  static PaymentManager::HasPaymentInstrumentCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaymentManager_HasPaymentInstrument_ProxyToResponder> proxy(
        new PaymentManager_HasPaymentInstrument_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaymentManager_HasPaymentInstrument_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentManager_HasPaymentInstrument_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaymentManager_HasPaymentInstrument_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentManager::HasPaymentInstrumentCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentHandlerStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaymentManager_HasPaymentInstrument_ProxyToResponder);
};

bool PaymentManager_HasPaymentInstrument_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::PaymentManager::HasPaymentInstrumentCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PaymentManager_HasPaymentInstrument_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentManager_HasPaymentInstrument_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PaymentHandlerStatus p_status{};
  PaymentManager_HasPaymentInstrument_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentManager::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void PaymentManager_HasPaymentInstrument_ProxyToResponder::Run(
    PaymentHandlerStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::PaymentManager::HasPaymentInstrumentCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PaymentHandlerStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_HasPaymentInstrument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_HasPaymentInstrument_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::PaymentHandlerStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::PaymentManager::HasPaymentInstrumentCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("HasPaymentInstrument");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaymentManager_SetPaymentInstrument_ProxyToResponder {
 public:
  static PaymentManager::SetPaymentInstrumentCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaymentManager_SetPaymentInstrument_ProxyToResponder> proxy(
        new PaymentManager_SetPaymentInstrument_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaymentManager_SetPaymentInstrument_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentManager_SetPaymentInstrument_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaymentManager_SetPaymentInstrument_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentManager::SetPaymentInstrumentCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentHandlerStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaymentManager_SetPaymentInstrument_ProxyToResponder);
};

bool PaymentManager_SetPaymentInstrument_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::PaymentManager::SetPaymentInstrumentCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PaymentManager_SetPaymentInstrument_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentManager_SetPaymentInstrument_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PaymentHandlerStatus p_status{};
  PaymentManager_SetPaymentInstrument_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentManager::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void PaymentManager_SetPaymentInstrument_ProxyToResponder::Run(
    PaymentHandlerStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::PaymentManager::SetPaymentInstrumentCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PaymentHandlerStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_SetPaymentInstrument_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_SetPaymentInstrument_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::PaymentHandlerStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::PaymentManager::SetPaymentInstrumentCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("SetPaymentInstrument");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaymentManager_ClearPaymentInstruments_ProxyToResponder {
 public:
  static PaymentManager::ClearPaymentInstrumentsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaymentManager_ClearPaymentInstruments_ProxyToResponder> proxy(
        new PaymentManager_ClearPaymentInstruments_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaymentManager_ClearPaymentInstruments_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentManager_ClearPaymentInstruments_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaymentManager_ClearPaymentInstruments_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentManager::ClearPaymentInstrumentsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentHandlerStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaymentManager_ClearPaymentInstruments_ProxyToResponder);
};

bool PaymentManager_ClearPaymentInstruments_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::PaymentManager::ClearPaymentInstrumentsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PaymentManager_ClearPaymentInstruments_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentManager_ClearPaymentInstruments_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PaymentHandlerStatus p_status{};
  PaymentManager_ClearPaymentInstruments_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentManager::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void PaymentManager_ClearPaymentInstruments_ProxyToResponder::Run(
    PaymentHandlerStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::PaymentManager::ClearPaymentInstrumentsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PaymentHandlerStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_ClearPaymentInstruments_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_ClearPaymentInstruments_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::PaymentHandlerStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::PaymentManager::ClearPaymentInstrumentsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("ClearPaymentInstruments");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PaymentManager_EnableDelegations_ProxyToResponder {
 public:
  static PaymentManager::EnableDelegationsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PaymentManager_EnableDelegations_ProxyToResponder> proxy(
        new PaymentManager_EnableDelegations_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PaymentManager_EnableDelegations_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PaymentManager_EnableDelegations_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PaymentManager_EnableDelegations_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PaymentManager::EnableDelegationsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PaymentHandlerStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PaymentManager_EnableDelegations_ProxyToResponder);
};

bool PaymentManager_EnableDelegations_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "payments::mojom::PaymentManager::EnableDelegationsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::PaymentManager_EnableDelegations_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PaymentManager_EnableDelegations_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  PaymentHandlerStatus p_status{};
  PaymentManager_EnableDelegations_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PaymentManager::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void PaymentManager_EnableDelegations_ProxyToResponder::Run(
    PaymentHandlerStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)payments::mojom::PaymentManager::EnableDelegationsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PaymentHandlerStatus>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentManager_EnableDelegations_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentManager_EnableDelegations_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::payments::mojom::PaymentHandlerStatus>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)payments::mojom::PaymentManager::EnableDelegationsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentManager::Name_);
  message.set_method_name("EnableDelegations");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PaymentManagerStubDispatch::Accept(
    PaymentManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPaymentManager_Init_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentManager::Init",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentManager::Init");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentManager_Init_Params_Data* params =
          reinterpret_cast<internal::PaymentManager_Init_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_context_url{};
      std::string p_service_worker_scope{};
      PaymentManager_Init_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContextUrl(&p_context_url))
        success = false;
      if (success && !input_data_view.ReadServiceWorkerScope(&p_service_worker_scope))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Init(
std::move(p_context_url), 
std::move(p_service_worker_scope));
      return true;
    }
    case internal::kPaymentManager_DeletePaymentInstrument_Name: {
      break;
    }
    case internal::kPaymentManager_GetPaymentInstrument_Name: {
      break;
    }
    case internal::kPaymentManager_KeysOfPaymentInstruments_Name: {
      break;
    }
    case internal::kPaymentManager_HasPaymentInstrument_Name: {
      break;
    }
    case internal::kPaymentManager_SetPaymentInstrument_Name: {
      break;
    }
    case internal::kPaymentManager_ClearPaymentInstruments_Name: {
      break;
    }
    case internal::kPaymentManager_SetUserHint_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentManager::SetUserHint",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentManager::SetUserHint");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentManager_SetUserHint_Params_Data* params =
          reinterpret_cast<internal::PaymentManager_SetUserHint_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_user_hint{};
      PaymentManager_SetUserHint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUserHint(&p_user_hint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentManager::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUserHint(
std::move(p_user_hint));
      return true;
    }
    case internal::kPaymentManager_EnableDelegations_Name: {
      break;
    }
  }
  return false;
}

// static
bool PaymentManagerStubDispatch::AcceptWithResponder(
    PaymentManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPaymentManager_Init_Name: {
      break;
    }
    case internal::kPaymentManager_DeletePaymentInstrument_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentManager::DeletePaymentInstrument",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentManager::DeletePaymentInstrument");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaymentManager_DeletePaymentInstrument_Params_Data* params =
          reinterpret_cast<
              internal::PaymentManager_DeletePaymentInstrument_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_instrument_key{};
      PaymentManager_DeletePaymentInstrument_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInstrumentKey(&p_instrument_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentManager::Name_, 1, false);
        return false;
      }
      PaymentManager::DeletePaymentInstrumentCallback callback =
          PaymentManager_DeletePaymentInstrument_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeletePaymentInstrument(
std::move(p_instrument_key), std::move(callback));
      return true;
    }
    case internal::kPaymentManager_GetPaymentInstrument_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentManager::GetPaymentInstrument",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentManager::GetPaymentInstrument");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaymentManager_GetPaymentInstrument_Params_Data* params =
          reinterpret_cast<
              internal::PaymentManager_GetPaymentInstrument_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_instrument_key{};
      PaymentManager_GetPaymentInstrument_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInstrumentKey(&p_instrument_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentManager::Name_, 2, false);
        return false;
      }
      PaymentManager::GetPaymentInstrumentCallback callback =
          PaymentManager_GetPaymentInstrument_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPaymentInstrument(
std::move(p_instrument_key), std::move(callback));
      return true;
    }
    case internal::kPaymentManager_KeysOfPaymentInstruments_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentManager::KeysOfPaymentInstruments",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentManager::KeysOfPaymentInstruments");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaymentManager_KeysOfPaymentInstruments_Params_Data* params =
          reinterpret_cast<
              internal::PaymentManager_KeysOfPaymentInstruments_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PaymentManager_KeysOfPaymentInstruments_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentManager::Name_, 3, false);
        return false;
      }
      PaymentManager::KeysOfPaymentInstrumentsCallback callback =
          PaymentManager_KeysOfPaymentInstruments_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->KeysOfPaymentInstruments(std::move(callback));
      return true;
    }
    case internal::kPaymentManager_HasPaymentInstrument_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentManager::HasPaymentInstrument",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentManager::HasPaymentInstrument");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaymentManager_HasPaymentInstrument_Params_Data* params =
          reinterpret_cast<
              internal::PaymentManager_HasPaymentInstrument_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_instrument_key{};
      PaymentManager_HasPaymentInstrument_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInstrumentKey(&p_instrument_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentManager::Name_, 4, false);
        return false;
      }
      PaymentManager::HasPaymentInstrumentCallback callback =
          PaymentManager_HasPaymentInstrument_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasPaymentInstrument(
std::move(p_instrument_key), std::move(callback));
      return true;
    }
    case internal::kPaymentManager_SetPaymentInstrument_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentManager::SetPaymentInstrument",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentManager::SetPaymentInstrument");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaymentManager_SetPaymentInstrument_Params_Data* params =
          reinterpret_cast<
              internal::PaymentManager_SetPaymentInstrument_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_instrument_key{};
      PaymentInstrumentPtr p_instrument{};
      PaymentManager_SetPaymentInstrument_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInstrumentKey(&p_instrument_key))
        success = false;
      if (success && !input_data_view.ReadInstrument(&p_instrument))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentManager::Name_, 5, false);
        return false;
      }
      PaymentManager::SetPaymentInstrumentCallback callback =
          PaymentManager_SetPaymentInstrument_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPaymentInstrument(
std::move(p_instrument_key), 
std::move(p_instrument), std::move(callback));
      return true;
    }
    case internal::kPaymentManager_ClearPaymentInstruments_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentManager::ClearPaymentInstruments",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentManager::ClearPaymentInstruments");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaymentManager_ClearPaymentInstruments_Params_Data* params =
          reinterpret_cast<
              internal::PaymentManager_ClearPaymentInstruments_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PaymentManager_ClearPaymentInstruments_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentManager::Name_, 6, false);
        return false;
      }
      PaymentManager::ClearPaymentInstrumentsCallback callback =
          PaymentManager_ClearPaymentInstruments_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearPaymentInstruments(std::move(callback));
      return true;
    }
    case internal::kPaymentManager_SetUserHint_Name: {
      break;
    }
    case internal::kPaymentManager_EnableDelegations_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentManager::EnableDelegations",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentManager::EnableDelegations");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PaymentManager_EnableDelegations_Params_Data* params =
          reinterpret_cast<
              internal::PaymentManager_EnableDelegations_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<PaymentDelegation> p_delegations{};
      PaymentManager_EnableDelegations_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDelegations(&p_delegations))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentManager::Name_, 8, false);
        return false;
      }
      PaymentManager::EnableDelegationsCallback callback =
          PaymentManager_EnableDelegations_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableDelegations(
std::move(p_delegations), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPaymentManagerValidationInfo[] = {
    {&internal::PaymentManager_Init_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentManager_DeletePaymentInstrument_Params_Data::Validate,
     &internal::PaymentManager_DeletePaymentInstrument_ResponseParams_Data::Validate},
    {&internal::PaymentManager_GetPaymentInstrument_Params_Data::Validate,
     &internal::PaymentManager_GetPaymentInstrument_ResponseParams_Data::Validate},
    {&internal::PaymentManager_KeysOfPaymentInstruments_Params_Data::Validate,
     &internal::PaymentManager_KeysOfPaymentInstruments_ResponseParams_Data::Validate},
    {&internal::PaymentManager_HasPaymentInstrument_Params_Data::Validate,
     &internal::PaymentManager_HasPaymentInstrument_ResponseParams_Data::Validate},
    {&internal::PaymentManager_SetPaymentInstrument_Params_Data::Validate,
     &internal::PaymentManager_SetPaymentInstrument_ResponseParams_Data::Validate},
    {&internal::PaymentManager_ClearPaymentInstruments_Params_Data::Validate,
     &internal::PaymentManager_ClearPaymentInstruments_ResponseParams_Data::Validate},
    {&internal::PaymentManager_SetUserHint_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentManager_EnableDelegations_Params_Data::Validate,
     &internal::PaymentManager_EnableDelegations_ResponseParams_Data::Validate},
};

bool PaymentManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::PaymentManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPaymentManagerValidationInfo);
}

bool PaymentManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::PaymentManager::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kPaymentManagerValidationInfo);
}
const char PaymentHandlerResponseCallback::Name_[] = "payments.mojom.PaymentHandlerResponseCallback";

PaymentHandlerResponseCallbackProxy::PaymentHandlerResponseCallbackProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaymentHandlerResponseCallbackProxy::OnResponseForAbortPayment(
    bool in_payment_aborted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentHandlerResponseCallback::OnResponseForAbortPayment", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("payment_aborted"), in_payment_aborted,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentHandlerResponseCallback_OnResponseForAbortPayment_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentHandlerResponseCallback_OnResponseForAbortPayment_Params_Data> params(
          message);
  params.Allocate();
  params->payment_aborted = in_payment_aborted;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentHandlerResponseCallback::Name_);
  message.set_method_name("OnResponseForAbortPayment");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentHandlerResponseCallbackProxy::OnResponseForCanMakePayment(
    CanMakePaymentResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentHandlerResponseCallback::OnResponseForCanMakePayment", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type CanMakePaymentResponsePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentHandlerResponseCallback_OnResponseForCanMakePayment_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentHandlerResponseCallback_OnResponseForCanMakePayment_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::CanMakePaymentResponseDataView>(
      in_response, response_fragment);
  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response in PaymentHandlerResponseCallback.OnResponseForCanMakePayment request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentHandlerResponseCallback::Name_);
  message.set_method_name("OnResponseForCanMakePayment");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentHandlerResponseCallbackProxy::OnResponseForPaymentRequest(
    PaymentHandlerResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentHandlerResponseCallback::OnResponseForPaymentRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type PaymentHandlerResponsePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPaymentHandlerResponseCallback_OnResponseForPaymentRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::payments::mojom::internal::PaymentHandlerResponseCallback_OnResponseForPaymentRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  mojo::internal::Serialize<::payments::mojom::PaymentHandlerResponseDataView>(
      in_response, response_fragment);
  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response in PaymentHandlerResponseCallback.OnResponseForPaymentRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentHandlerResponseCallback::Name_);
  message.set_method_name("OnResponseForPaymentRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PaymentHandlerResponseCallbackStubDispatch::Accept(
    PaymentHandlerResponseCallback* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPaymentHandlerResponseCallback_OnResponseForAbortPayment_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentHandlerResponseCallback::OnResponseForAbortPayment",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentHandlerResponseCallback::OnResponseForAbortPayment");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentHandlerResponseCallback_OnResponseForAbortPayment_Params_Data* params =
          reinterpret_cast<internal::PaymentHandlerResponseCallback_OnResponseForAbortPayment_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_payment_aborted{};
      PaymentHandlerResponseCallback_OnResponseForAbortPayment_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_payment_aborted = input_data_view.payment_aborted();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentHandlerResponseCallback::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResponseForAbortPayment(
std::move(p_payment_aborted));
      return true;
    }
    case internal::kPaymentHandlerResponseCallback_OnResponseForCanMakePayment_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentHandlerResponseCallback::OnResponseForCanMakePayment",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentHandlerResponseCallback::OnResponseForCanMakePayment");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentHandlerResponseCallback_OnResponseForCanMakePayment_Params_Data* params =
          reinterpret_cast<internal::PaymentHandlerResponseCallback_OnResponseForCanMakePayment_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CanMakePaymentResponsePtr p_response{};
      PaymentHandlerResponseCallback_OnResponseForCanMakePayment_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentHandlerResponseCallback::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResponseForCanMakePayment(
std::move(p_response));
      return true;
    }
    case internal::kPaymentHandlerResponseCallback_OnResponseForPaymentRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentHandlerResponseCallback::OnResponseForPaymentRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentHandlerResponseCallback::OnResponseForPaymentRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentHandlerResponseCallback_OnResponseForPaymentRequest_Params_Data* params =
          reinterpret_cast<internal::PaymentHandlerResponseCallback_OnResponseForPaymentRequest_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentHandlerResponsePtr p_response{};
      PaymentHandlerResponseCallback_OnResponseForPaymentRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentHandlerResponseCallback::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResponseForPaymentRequest(
std::move(p_response));
      return true;
    }
  }
  return false;
}

// static
bool PaymentHandlerResponseCallbackStubDispatch::AcceptWithResponder(
    PaymentHandlerResponseCallback* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPaymentHandlerResponseCallback_OnResponseForAbortPayment_Name: {
      break;
    }
    case internal::kPaymentHandlerResponseCallback_OnResponseForCanMakePayment_Name: {
      break;
    }
    case internal::kPaymentHandlerResponseCallback_OnResponseForPaymentRequest_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPaymentHandlerResponseCallbackValidationInfo[] = {
    {&internal::PaymentHandlerResponseCallback_OnResponseForAbortPayment_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentHandlerResponseCallback_OnResponseForCanMakePayment_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentHandlerResponseCallback_OnResponseForPaymentRequest_Params_Data::Validate,
     nullptr /* no response */},
};

bool PaymentHandlerResponseCallbackRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::PaymentHandlerResponseCallback::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPaymentHandlerResponseCallbackValidationInfo);
}

}  // namespace mojom
}  // namespace payments

namespace mojo {


// static
bool StructTraits<::payments::mojom::PaymentInstrument::DataView, ::payments::mojom::PaymentInstrumentPtr>::Read(
    ::payments::mojom::PaymentInstrument::DataView input,
    ::payments::mojom::PaymentInstrumentPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentInstrumentPtr result(::payments::mojom::PaymentInstrument::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadIcons(&result->icons))
        success = false;
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadStringifiedCapabilities(&result->stringified_capabilities))
        success = false;
      if (success && !input.ReadSupportedNetworks(&result->supported_networks))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::CanMakePaymentEventData::DataView, ::payments::mojom::CanMakePaymentEventDataPtr>::Read(
    ::payments::mojom::CanMakePaymentEventData::DataView input,
    ::payments::mojom::CanMakePaymentEventDataPtr* output) {
  bool success = true;
  ::payments::mojom::CanMakePaymentEventDataPtr result(::payments::mojom::CanMakePaymentEventData::New());
  
      if (success && !input.ReadTopOrigin(&result->top_origin))
        success = false;
      if (success && !input.ReadPaymentRequestOrigin(&result->payment_request_origin))
        success = false;
      if (success && !input.ReadMethodData(&result->method_data))
        success = false;
      if (success && !input.ReadModifiers(&result->modifiers))
        success = false;
      if (success && !input.ReadCurrency(&result->currency))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentRequestEventData::DataView, ::payments::mojom::PaymentRequestEventDataPtr>::Read(
    ::payments::mojom::PaymentRequestEventData::DataView input,
    ::payments::mojom::PaymentRequestEventDataPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentRequestEventDataPtr result(::payments::mojom::PaymentRequestEventData::New());
  
      if (success && !input.ReadTopOrigin(&result->top_origin))
        success = false;
      if (success && !input.ReadPaymentRequestOrigin(&result->payment_request_origin))
        success = false;
      if (success && !input.ReadPaymentRequestId(&result->payment_request_id))
        success = false;
      if (success && !input.ReadMethodData(&result->method_data))
        success = false;
      if (success && !input.ReadTotal(&result->total))
        success = false;
      if (success && !input.ReadModifiers(&result->modifiers))
        success = false;
      if (success && !input.ReadInstrumentKey(&result->instrument_key))
        success = false;
      if (success && !input.ReadPaymentOptions(&result->payment_options))
        success = false;
      if (success && !input.ReadShippingOptions(&result->shipping_options))
        success = false;
      if (success) {
        result->payment_handler_host =
            input.TakePaymentHandlerHost<decltype(result->payment_handler_host)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::CanMakePaymentResponse::DataView, ::payments::mojom::CanMakePaymentResponsePtr>::Read(
    ::payments::mojom::CanMakePaymentResponse::DataView input,
    ::payments::mojom::CanMakePaymentResponsePtr* output) {
  bool success = true;
  ::payments::mojom::CanMakePaymentResponsePtr result(::payments::mojom::CanMakePaymentResponse::New());
  
      if (success && !input.ReadResponseType(&result->response_type))
        success = false;
      if (success)
        result->can_make_payment = input.can_make_payment();
      if (success)
        result->ready_for_minimal_ui = input.ready_for_minimal_ui();
      if (success && !input.ReadAccountBalance(&result->account_balance))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentHandlerResponse::DataView, ::payments::mojom::PaymentHandlerResponsePtr>::Read(
    ::payments::mojom::PaymentHandlerResponse::DataView input,
    ::payments::mojom::PaymentHandlerResponsePtr* output) {
  bool success = true;
  ::payments::mojom::PaymentHandlerResponsePtr result(::payments::mojom::PaymentHandlerResponse::New());
  
      if (success && !input.ReadMethodName(&result->method_name))
        success = false;
      if (success && !input.ReadStringifiedDetails(&result->stringified_details))
        success = false;
      if (success && !input.ReadResponseType(&result->response_type))
        success = false;
      if (success && !input.ReadPayerName(&result->payer_name))
        success = false;
      if (success && !input.ReadPayerEmail(&result->payer_email))
        success = false;
      if (success && !input.ReadPayerPhone(&result->payer_phone))
        success = false;
      if (success && !input.ReadShippingAddress(&result->shipping_address))
        success = false;
      if (success && !input.ReadShippingOption(&result->shipping_option))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif