// third_party/blink/public/mojom/quota/quota_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/quota/quota_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/quota/quota_types.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* StorageTypeToStringHelper(StorageType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case StorageType::kTemporary:
      return "kTemporary";
    case StorageType::kPersistent:
      return "kPersistent";
    case StorageType::kSyncable:
      return "kSyncable";
    case StorageType::kQuotaNotManaged:
      return "kQuotaNotManaged";
    case StorageType::kUnknown:
      return "kUnknown";
    default:
      return nullptr;
  }
}

std::string StorageTypeToString(StorageType value) {
  const char *str = StorageTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown StorageType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, StorageType value) {
  return os << StorageTypeToString(value);
}

static NOINLINE const char* QuotaStatusCodeToStringHelper(QuotaStatusCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case QuotaStatusCode::kUnknown:
      return "kUnknown";
    case QuotaStatusCode::kOk:
      return "kOk";
    case QuotaStatusCode::kErrorNotSupported:
      return "kErrorNotSupported";
    case QuotaStatusCode::kErrorInvalidModification:
      return "kErrorInvalidModification";
    case QuotaStatusCode::kErrorInvalidAccess:
      return "kErrorInvalidAccess";
    case QuotaStatusCode::kErrorAbort:
      return "kErrorAbort";
    default:
      return nullptr;
  }
}

std::string QuotaStatusCodeToString(QuotaStatusCode value) {
  const char *str = QuotaStatusCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown QuotaStatusCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, QuotaStatusCode value) {
  return os << QuotaStatusCodeToString(value);
}

namespace internal {


// static
bool UsageBreakdown_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsageBreakdown_Data* object = static_cast<const UsageBreakdown_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsageBreakdown_Data::UsageBreakdown_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::StorageType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::StorageType value) {
  return std::move(context).WriteString(::blink::mojom::StorageTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::QuotaStatusCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::QuotaStatusCode value) {
  return std::move(context).WriteString(::blink::mojom::QuotaStatusCodeToString(value));
}

} // namespace perfetto
