// third_party/blink/public/mojom/speech/speech_recognizer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/speech/speech_recognizer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/speech/speech_recognizer.mojom-params-data.h"
#include "third_party/blink/public/mojom/speech/speech_recognizer.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/speech/speech_recognizer.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_RECOGNIZER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_RECOGNIZER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
StartSpeechRecognitionRequestParams::StartSpeechRecognitionRequestParams()
    : session_receiver(),
      client(),
      language(),
      grammars(),
      max_hypotheses(),
      continuous(),
      interim_results() {}

StartSpeechRecognitionRequestParams::StartSpeechRecognitionRequestParams(
    ::mojo::PendingReceiver<SpeechRecognitionSession> session_receiver_in,
    ::mojo::PendingRemote<SpeechRecognitionSessionClient> client_in,
    const std::string& language_in,
    std::vector<::blink::mojom::SpeechRecognitionGrammarPtr> grammars_in,
    uint32_t max_hypotheses_in,
    bool continuous_in,
    bool interim_results_in)
    : session_receiver(std::move(session_receiver_in)),
      client(std::move(client_in)),
      language(std::move(language_in)),
      grammars(std::move(grammars_in)),
      max_hypotheses(std::move(max_hypotheses_in)),
      continuous(std::move(continuous_in)),
      interim_results(std::move(interim_results_in)) {}

StartSpeechRecognitionRequestParams::~StartSpeechRecognitionRequestParams() = default;

void StartSpeechRecognitionRequestParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_receiver"), this->session_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<SpeechRecognitionSession>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client"), this->client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<SpeechRecognitionSessionClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "language"), this->language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "grammars"), this->grammars,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::blink::mojom::SpeechRecognitionGrammarPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_hypotheses"), this->max_hypotheses,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "continuous"), this->continuous,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interim_results"), this->interim_results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StartSpeechRecognitionRequestParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SpeechRecognizer::Name_[] = "blink.mojom.SpeechRecognizer";

SpeechRecognizerProxy::SpeechRecognizerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognizerProxy::Start(
    StartSpeechRecognitionRequestParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SpeechRecognizer::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type StartSpeechRecognitionRequestParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognizer_Start_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechRecognizer_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::StartSpeechRecognitionRequestParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in SpeechRecognizer.Start request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognizer::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeechRecognizerStubDispatch::Accept(
    SpeechRecognizer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSpeechRecognizer_Start_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechRecognizer::Start",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechRecognizer::Start");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognizer_Start_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognizer_Start_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      StartSpeechRecognitionRequestParamsPtr p_params{};
      SpeechRecognizer_Start_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognizer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(
std::move(p_params));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognizerStubDispatch::AcceptWithResponder(
    SpeechRecognizer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechRecognizer_Start_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSpeechRecognizerValidationInfo[] = {
    {&internal::SpeechRecognizer_Start_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechRecognizerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SpeechRecognizer::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSpeechRecognizerValidationInfo);
}

const char SpeechRecognitionSession::Name_[] = "blink.mojom.SpeechRecognitionSession";

SpeechRecognitionSessionProxy::SpeechRecognitionSessionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionSessionProxy::Abort(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechRecognitionSession::Abort");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionSession_Abort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechRecognitionSession_Abort_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSession::Name_);
  message.set_method_name("Abort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionSessionProxy::StopCapture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechRecognitionSession::StopCapture");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionSession_StopCapture_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechRecognitionSession_StopCapture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSession::Name_);
  message.set_method_name("StopCapture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeechRecognitionSessionStubDispatch::Accept(
    SpeechRecognitionSession* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSpeechRecognitionSession_Abort_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechRecognitionSession::Abort",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechRecognitionSession::Abort");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSession_Abort_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSession_Abort_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechRecognitionSession_Abort_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSession::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort();
      return true;
    }
    case internal::kSpeechRecognitionSession_StopCapture_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechRecognitionSession::StopCapture",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechRecognitionSession::StopCapture");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSession_StopCapture_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSession_StopCapture_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechRecognitionSession_StopCapture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSession::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopCapture();
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionSessionStubDispatch::AcceptWithResponder(
    SpeechRecognitionSession* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionSession_Abort_Name: {
      break;
    }
    case internal::kSpeechRecognitionSession_StopCapture_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSpeechRecognitionSessionValidationInfo[] = {
    {&internal::SpeechRecognitionSession_Abort_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechRecognitionSession_StopCapture_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechRecognitionSessionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SpeechRecognitionSession::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSpeechRecognitionSessionValidationInfo);
}

const char SpeechRecognitionSessionClient::Name_[] = "blink.mojom.SpeechRecognitionSessionClient";

SpeechRecognitionSessionClientProxy::SpeechRecognitionSessionClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionSessionClientProxy::ResultRetrieved(
    std::vector<::blink::mojom::SpeechRecognitionResultPtr> in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SpeechRecognitionSessionClient::ResultRetrieved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type std::vector<::blink::mojom::SpeechRecognitionResultPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionSessionClient_ResultRetrieved_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechRecognitionSessionClient_ResultRetrieved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  const mojo::internal::ContainerValidateParams results_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SpeechRecognitionResultDataView>>(
      in_results, results_fragment, &results_validate_params);
  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->results.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null results in SpeechRecognitionSessionClient.ResultRetrieved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("ResultRetrieved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionSessionClientProxy::ErrorOccurred(
    ::blink::mojom::SpeechRecognitionErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SpeechRecognitionSessionClient::ErrorOccurred", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::SpeechRecognitionErrorPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionSessionClient_ErrorOccurred_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechRecognitionSessionClient_ErrorOccurred_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::SpeechRecognitionErrorDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in SpeechRecognitionSessionClient.ErrorOccurred request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("ErrorOccurred");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionSessionClientProxy::Started(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechRecognitionSessionClient::Started");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionSessionClient_Started_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechRecognitionSessionClient_Started_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("Started");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionSessionClientProxy::AudioStarted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechRecognitionSessionClient::AudioStarted");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionSessionClient_AudioStarted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechRecognitionSessionClient_AudioStarted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("AudioStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionSessionClientProxy::SoundStarted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechRecognitionSessionClient::SoundStarted");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionSessionClient_SoundStarted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechRecognitionSessionClient_SoundStarted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("SoundStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionSessionClientProxy::SoundEnded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechRecognitionSessionClient::SoundEnded");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionSessionClient_SoundEnded_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechRecognitionSessionClient_SoundEnded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("SoundEnded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionSessionClientProxy::AudioEnded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechRecognitionSessionClient::AudioEnded");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionSessionClient_AudioEnded_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechRecognitionSessionClient_AudioEnded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("AudioEnded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionSessionClientProxy::Ended(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SpeechRecognitionSessionClient::Ended");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kSpeechRecognitionSessionClient_Ended_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SpeechRecognitionSessionClient_Ended_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionSessionClient::Name_);
  message.set_method_name("Ended");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeechRecognitionSessionClientStubDispatch::Accept(
    SpeechRecognitionSessionClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSpeechRecognitionSessionClient_ResultRetrieved_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechRecognitionSessionClient::ResultRetrieved",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechRecognitionSessionClient::ResultRetrieved");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_ResultRetrieved_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_ResultRetrieved_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::blink::mojom::SpeechRecognitionResultPtr> p_results{};
      SpeechRecognitionSessionClient_ResultRetrieved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResults(&p_results))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResultRetrieved(
std::move(p_results));
      return true;
    }
    case internal::kSpeechRecognitionSessionClient_ErrorOccurred_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechRecognitionSessionClient::ErrorOccurred",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechRecognitionSessionClient::ErrorOccurred");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_ErrorOccurred_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_ErrorOccurred_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::SpeechRecognitionErrorPtr p_error{};
      SpeechRecognitionSessionClient_ErrorOccurred_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ErrorOccurred(
std::move(p_error));
      return true;
    }
    case internal::kSpeechRecognitionSessionClient_Started_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechRecognitionSessionClient::Started",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechRecognitionSessionClient::Started");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_Started_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_Started_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechRecognitionSessionClient_Started_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Started();
      return true;
    }
    case internal::kSpeechRecognitionSessionClient_AudioStarted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechRecognitionSessionClient::AudioStarted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechRecognitionSessionClient::AudioStarted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_AudioStarted_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_AudioStarted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechRecognitionSessionClient_AudioStarted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AudioStarted();
      return true;
    }
    case internal::kSpeechRecognitionSessionClient_SoundStarted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechRecognitionSessionClient::SoundStarted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechRecognitionSessionClient::SoundStarted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_SoundStarted_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_SoundStarted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechRecognitionSessionClient_SoundStarted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SoundStarted();
      return true;
    }
    case internal::kSpeechRecognitionSessionClient_SoundEnded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechRecognitionSessionClient::SoundEnded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechRecognitionSessionClient::SoundEnded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_SoundEnded_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_SoundEnded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechRecognitionSessionClient_SoundEnded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SoundEnded();
      return true;
    }
    case internal::kSpeechRecognitionSessionClient_AudioEnded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechRecognitionSessionClient::AudioEnded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechRecognitionSessionClient::AudioEnded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_AudioEnded_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_AudioEnded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechRecognitionSessionClient_AudioEnded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AudioEnded();
      return true;
    }
    case internal::kSpeechRecognitionSessionClient_Ended_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SpeechRecognitionSessionClient::Ended",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SpeechRecognitionSessionClient::Ended");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionSessionClient_Ended_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionSessionClient_Ended_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechRecognitionSessionClient_Ended_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionSessionClient::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Ended();
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionSessionClientStubDispatch::AcceptWithResponder(
    SpeechRecognitionSessionClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionSessionClient_ResultRetrieved_Name: {
      break;
    }
    case internal::kSpeechRecognitionSessionClient_ErrorOccurred_Name: {
      break;
    }
    case internal::kSpeechRecognitionSessionClient_Started_Name: {
      break;
    }
    case internal::kSpeechRecognitionSessionClient_AudioStarted_Name: {
      break;
    }
    case internal::kSpeechRecognitionSessionClient_SoundStarted_Name: {
      break;
    }
    case internal::kSpeechRecognitionSessionClient_SoundEnded_Name: {
      break;
    }
    case internal::kSpeechRecognitionSessionClient_AudioEnded_Name: {
      break;
    }
    case internal::kSpeechRecognitionSessionClient_Ended_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSpeechRecognitionSessionClientValidationInfo[] = {
    {&internal::SpeechRecognitionSessionClient_ResultRetrieved_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechRecognitionSessionClient_ErrorOccurred_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechRecognitionSessionClient_Started_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechRecognitionSessionClient_AudioStarted_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechRecognitionSessionClient_SoundStarted_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechRecognitionSessionClient_SoundEnded_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechRecognitionSessionClient_AudioEnded_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SpeechRecognitionSessionClient_Ended_Params_Data::Validate,
     nullptr /* no response */},
};

bool SpeechRecognitionSessionClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SpeechRecognitionSessionClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSpeechRecognitionSessionClientValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::StartSpeechRecognitionRequestParams::DataView, ::blink::mojom::StartSpeechRecognitionRequestParamsPtr>::Read(
    ::blink::mojom::StartSpeechRecognitionRequestParams::DataView input,
    ::blink::mojom::StartSpeechRecognitionRequestParamsPtr* output) {
  bool success = true;
  ::blink::mojom::StartSpeechRecognitionRequestParamsPtr result(::blink::mojom::StartSpeechRecognitionRequestParams::New());
  
      if (success) {
        result->session_receiver =
            input.TakeSessionReceiver<decltype(result->session_receiver)>();
      }
      if (success) {
        result->client =
            input.TakeClient<decltype(result->client)>();
      }
      if (success && !input.ReadLanguage(&result->language))
        success = false;
      if (success && !input.ReadGrammars(&result->grammars))
        success = false;
      if (success)
        result->max_hypotheses = input.max_hypotheses();
      if (success)
        result->continuous = input.continuous();
      if (success)
        result->interim_results = input.interim_results();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif