// third_party/blink/public/mojom/webid/federated_auth_response.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/webid/federated_auth_response.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webid/federated_auth_response.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* ProvideIdTokenStatusToStringHelper(ProvideIdTokenStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ProvideIdTokenStatus::kSuccess:
      return "kSuccess";
    case ProvideIdTokenStatus::kErrorTooManyResponses:
      return "kErrorTooManyResponses";
    case ProvideIdTokenStatus::kError:
      return "kError";
    default:
      return nullptr;
  }
}

std::string ProvideIdTokenStatusToString(ProvideIdTokenStatus value) {
  const char *str = ProvideIdTokenStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ProvideIdTokenStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ProvideIdTokenStatus value) {
  return os << ProvideIdTokenStatusToString(value);
}

namespace internal {


// static
bool FederatedAuthResponse_ProvideIdToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FederatedAuthResponse_ProvideIdToken_Params_Data* object = static_cast<const FederatedAuthResponse_ProvideIdToken_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id_token, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams id_token_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id_token, validation_context,
                                         &id_token_validate_params)) {
    return false;
  }

  return true;
}

FederatedAuthResponse_ProvideIdToken_Params_Data::FederatedAuthResponse_ProvideIdToken_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthResponse_ProvideIdToken_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const FederatedAuthResponse_ProvideIdToken_ResponseParams_Data* object = static_cast<const FederatedAuthResponse_ProvideIdToken_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::ProvideIdTokenStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

FederatedAuthResponse_ProvideIdToken_ResponseParams_Data::FederatedAuthResponse_ProvideIdToken_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ProvideIdTokenStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ProvideIdTokenStatus value) {
  return std::move(context).WriteString(::blink::mojom::ProvideIdTokenStatusToString(value));
}

} // namespace perfetto
