// third_party/blink/public/mojom/webtransport/web_transport_connector.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/webtransport/web_transport_connector.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webtransport/web_transport_connector.mojom-params-data.h"
#include "third_party/blink/public/mojom/webtransport/web_transport_connector.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/webtransport/web_transport_connector.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBTRANSPORT_WEB_TRANSPORT_CONNECTOR_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBTRANSPORT_WEB_TRANSPORT_CONNECTOR_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char WebTransportConnector::Name_[] = "blink.mojom.WebTransportConnector";

WebTransportConnectorProxy::WebTransportConnectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebTransportConnectorProxy::Connect(
    const ::GURL& in_url, std::vector<::network::mojom::WebTransportCertificateFingerprintPtr> in_fingerprints, ::mojo::PendingRemote<::network::mojom::WebTransportHandshakeClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WebTransportConnector::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fingerprints"), in_fingerprints,
                        "<value of type std::vector<::network::mojom::WebTransportCertificateFingerprintPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::network::mojom::WebTransportHandshakeClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransportConnector_Connect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebTransportConnector_Connect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in WebTransportConnector.Connect request");
  mojo::internal::MessageFragment<
      typename decltype(params->fingerprints)::BaseType>
      fingerprints_fragment(params.message());
  const mojo::internal::ContainerValidateParams fingerprints_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::WebTransportCertificateFingerprintDataView>>(
      in_fingerprints, fingerprints_fragment, &fingerprints_validate_params);
  params->fingerprints.Set(
      fingerprints_fragment.is_null() ? nullptr : fingerprints_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->fingerprints.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null fingerprints in WebTransportConnector.Connect request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::WebTransportHandshakeClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in WebTransportConnector.Connect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransportConnector::Name_);
  message.set_method_name("Connect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebTransportConnectorStubDispatch::Accept(
    WebTransportConnector* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebTransportConnector_Connect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WebTransportConnector::Connect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WebTransportConnector::Connect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebTransportConnector_Connect_Params_Data* params =
          reinterpret_cast<internal::WebTransportConnector_Connect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      std::vector<::network::mojom::WebTransportCertificateFingerprintPtr> p_fingerprints{};
      ::mojo::PendingRemote<::network::mojom::WebTransportHandshakeClient> p_client{};
      WebTransportConnector_Connect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadFingerprints(&p_fingerprints))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransportConnector::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(
std::move(p_url), 
std::move(p_fingerprints), 
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool WebTransportConnectorStubDispatch::AcceptWithResponder(
    WebTransportConnector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebTransportConnector_Connect_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kWebTransportConnectorValidationInfo[] = {
    {&internal::WebTransportConnector_Connect_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebTransportConnectorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::WebTransportConnector::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kWebTransportConnectorValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif