// third_party/blink/public/mojom/widget/device_emulation_params.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom-params-data.h"
namespace blink {
namespace mojom {

static NOINLINE const char* EmulatedScreenTypeToStringHelper(EmulatedScreenType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EmulatedScreenType::kDesktop:
      return "kDesktop";
    case EmulatedScreenType::kMobile:
      return "kMobile";
    default:
      return nullptr;
  }
}

std::string EmulatedScreenTypeToString(EmulatedScreenType value) {
  const char *str = EmulatedScreenTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EmulatedScreenType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EmulatedScreenType value) {
  return os << EmulatedScreenTypeToString(value);
}

namespace internal {


// static
bool DeviceEmulationParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceEmulationParams_Data* object = static_cast<const DeviceEmulationParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::blink::mojom::internal::EmulatedScreenType_Data
        ::Validate(object->screen_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->screen_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->screen_size, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->view_position, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->view_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->view_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->viewport_offset, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->viewport_offset, validation_context))
    return false;


  if (!::display::mojom::internal::ScreenOrientation_Data
        ::Validate(object->screen_orientation_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->window_segments, 11, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams window_segments_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->window_segments, validation_context,
                                         &window_segments_validate_params)) {
    return false;
  }

  return true;
}

DeviceEmulationParams_Data::DeviceEmulationParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::EmulatedScreenType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::EmulatedScreenType value) {
  return std::move(context).WriteString(::blink::mojom::EmulatedScreenTypeToString(value));
}

} // namespace perfetto
